/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.eas.basedata.master.cssp.AbstractSupplierInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroup;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroup;
import com.kingdee.eas.basedata.master.cssp.SupplierGroupDetailCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierGroupException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.LocaleUtils;
import java.io.Serializable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class SupplierInfo
extends AbstractSupplierInfo
implements Serializable {
    private static Logger logger = Logger.getLogger(CustomerInfo.class);

    public SupplierInfo() {
    }

    protected SupplierInfo(String pkField) {
        super(pkField);
    }

    public String getDisplayName() {
        if (this.getBrowseGroup() == null || this.getBrowseGroup().getDisplayName() == null) {
            return this.getName();
        }
        return this.getBrowseGroup().getDisplayName() + "_" + this.getName();
    }

    public String getDisplayName(Locale locale) {
        if (this.getBrowseGroup() == null || this.getBrowseGroup().getDisplayName() == null) {
            return this.getName(locale);
        }
        return this.getBrowseGroup().getDisplayName(locale) + "_" + this.getName(locale);
    }

    public static String getBosType() {
        SupplierInfo supplierInfo = new SupplierInfo();
        return supplierInfo.getBOSType().toString();
    }

    public void checkTaxRate() throws BOSException, EASBizException {
        if (this.getTaxRate() != null && this.getTaxRate().doubleValue() < 0.0) {
            throw new CustomerSupplierException(CustomerSupplierException.SUPPLIERTAXRATEINVALID);
        }
    }

    public boolean isValueChange() {
        if (this.oldValues != null) {
            Locale locale = SysContext.getSysContext().getLocale();
            if (!"l1".equals(locale.toString())) {
                this.oldValues.put("name_l1", this.getName(LocaleUtils.locale_l1));
            }
            if (!"l2".equals(locale.toString())) {
                this.oldValues.put("name_l2", this.getName(LocaleUtils.locale_l2));
            }
            if (!"l3".equals(locale.toString())) {
                this.oldValues.put("name_l3", this.getName(LocaleUtils.locale_l3));
            }
        }
        return super.isValueChange();
    }

    public void checkGroupIsLeaf(SupplierInfo supplierInfo) throws BOSException, EASBizException {
        SupplierGroupDetailCollection groupDetails = supplierInfo.getSupplierGroupDetails();
        for (int i = 0; i < groupDetails.size(); ++i) {
            CSSPGroupInfo group = supplierInfo.getBrowseGroup();
            ICSSPGroup iCssp = null;
            CSSPGroupInfo group2 = null;
            try {
                iCssp = CSSPGroupFactory.getLocalInstance(ConfigMDUtil.getContext());
                group2 = iCssp.getCSSPGroupInfo((IObjectPK)new ObjectUuidPK(group.getId()));
            }
            catch (Exception e) {
                logger.error((Object)"\u901a\u8fc7factory\u4ee5\u53caConfigMDUtil.getContext()\u51fa\u95ee\u9898  ", (Throwable)e);
                group2 = new CSSPGroup().getCSSPGroupInfo((IObjectPK)new ObjectUuidPK(group.getId()));
            }
            if (group2 == null || group2.isIsLeaf()) continue;
            throw new SupplierGroupException(SupplierGroupException.NONLEAFADDNEW4SUPP, new Object[]{" " + group2.getNumber() + " (" + group2.getName() + ") "});
        }
    }
}

