/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.master.cssp.AutoAssignSolutionCollection;
import com.kingdee.eas.basedata.master.cssp.AutoAssignSolutionEntryInfo;
import com.kingdee.eas.basedata.master.cssp.AutoAssignSolutionInfo;
import com.kingdee.eas.basedata.master.cssp.AutoAssignSolutionStatusEnum;
import com.kingdee.eas.basedata.master.cssp.BaseAutoAssignSolutionAppException;
import com.kingdee.eas.basedata.master.cssp.app.AbstractAutoAssignSolutionControllerBean;
import com.kingdee.eas.basedata.master.cssp.util.AutoAssignSolutionUtil;
import com.kingdee.eas.basedata.org.CUBDControlCollection;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.CUBDDispatchPattern;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class AutoAssignSolutionControllerBean
extends AbstractAutoAssignSolutionControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.cssp.app.AutoAssignSolutionControllerBean");
    private static final ResourceBundleHelper resHelper = new ResourceBundleHelper("com.kingdee.eas.basedata.master.cssp.CSSPAutoAssignResource");

    private void addAndUpdateCheck(Context ctx, AutoAssignSolutionInfo info) throws BOSException, EASBizException {
        String oql;
        if (info.getId() == null ? this.exists(ctx, oql = "where number = '" + info.getNumber() + "'") : this.exists(ctx, oql = "where number = '" + info.getNumber() + "' and id != '" + info.getId().toString() + "'")) {
            throw new BaseAutoAssignSolutionAppException(BaseAutoAssignSolutionAppException.NUMBER_REPEAT);
        }
    }

    @Override
    protected String _batchEnable(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        AutoAssignSolutionCollection autoAssignSolutionCollection = this.getAutoAssignSolutionCollection(ctx, pks);
        StringBuilder msg = new StringBuilder();
        if (autoAssignSolutionCollection != null && autoAssignSolutionCollection.size() > 0) {
            for (int i = 0; i < autoAssignSolutionCollection.size(); ++i) {
                AutoAssignSolutionInfo assignSolutionInfo = autoAssignSolutionCollection.get(i);
                if (AutoAssignSolutionStatusEnum.ENABLE.equals((Object)assignSolutionInfo.getStatus())) {
                    msg.append(AutoAssignSolutionUtil.convertStr(resHelper.getString("AutoAssignMsg015"), assignSolutionInfo.getNumber()));
                    msg.append("\r\n");
                    continue;
                }
                String instanceDetail = assignSolutionInfo.getNumber() + "  " + assignSolutionInfo.getName();
                IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_batchEnable", (BOSObjectType)new BOSObjectType("3B1E6747"), null, (String)instanceDetail, (String)"AutoAssign_Enable");
                assignSolutionInfo.setStatus(AutoAssignSolutionStatusEnum.ENABLE);
                this.update(ctx, (IObjectPK)new ObjectUuidPK(assignSolutionInfo.getId()), assignSolutionInfo);
                if (assignSolutionInfo.getProcessDefID() != null) {
                    JobServiceFactory.getLocalInstance((Context)ctx).enableTrigger(assignSolutionInfo.getProcessDefID().toString());
                }
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            }
        }
        return msg.toString();
    }

    @Override
    protected String _batchDisable(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        AutoAssignSolutionCollection autoAssignSolutionCollection = this.getAutoAssignSolutionCollection(ctx, pks);
        StringBuilder msg = new StringBuilder();
        if (autoAssignSolutionCollection != null && autoAssignSolutionCollection.size() > 0) {
            for (int i = 0; i < autoAssignSolutionCollection.size(); ++i) {
                AutoAssignSolutionInfo assignSolutionInfo = autoAssignSolutionCollection.get(i);
                if (AutoAssignSolutionStatusEnum.DISENABLE.equals((Object)assignSolutionInfo.getStatus())) {
                    msg.append(AutoAssignSolutionUtil.convertStr(resHelper.getString("AutoAssignMsg016"), assignSolutionInfo.getNumber()));
                    msg.append("\r\n");
                    continue;
                }
                String instanceDetail = assignSolutionInfo.getNumber() + "  " + assignSolutionInfo.getName();
                IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_batchDisable", (BOSObjectType)new BOSObjectType("3B1E6747"), null, (String)instanceDetail, (String)"AutoAssign_Disable");
                assignSolutionInfo.setStatus(AutoAssignSolutionStatusEnum.DISENABLE);
                this.update(ctx, (IObjectPK)new ObjectUuidPK(assignSolutionInfo.getId()), assignSolutionInfo);
                if (assignSolutionInfo.getProcessDefID() != null) {
                    JobServiceFactory.getLocalInstance((Context)ctx).disableTrigger(assignSolutionInfo.getProcessDefID().toString());
                }
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            }
        }
        return msg.toString();
    }

    @Override
    protected List _canBeAssignedCUs(Context ctx, BOSObjectType bosObjectType, IObjectPK ctrlUnitPK) throws BOSException, EASBizException {
        ArrayList cus = new ArrayList();
        try {
            String treeID = "00000000-0000-0000-0000-0000000000014F2827FD";
            String longNumber = this.getCULongNumber(ctx, ctrlUnitPK);
            StringBuffer sql = new StringBuffer(500);
            sql.append(" SELECT Structure.FUnitId FROM T_ORG_Structure Structure ").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = Structure.FUnitId ").append(" WHERE Structure.FTreeId = ? ").append(" AND CHARINDEX( N'").append(longNumber).append("!' , Structure.FLongNumber || N'!' ) > 0 ").append(" ORDER BY Structure.FLongNumber ASC ");
            Object[] params = new Object[]{treeID};
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            ArrayList<String> ids = new ArrayList<String>();
            while (rowSet.next()) {
                String cu = rowSet.getString("FUnitId");
                ids.add(cu);
            }
            if (!ids.isEmpty()) {
                this.canBeAssigned(ctx, bosObjectType, cus, ids);
            }
        }
        catch (SQLException e) {
            throw new DataBaseDException(DataBaseDException.GET_INFO_FAIL, (Throwable)e);
        }
        return cus;
    }

    private void canBeAssigned(Context ctx, BOSObjectType objectType, List cus, List ids) throws EASBizException, BOSException {
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        StringBuilder oql = new StringBuilder("where BDBOSType = '" + objectType.toString() + "'and CU in(");
        for (int i = 0; i < ids.size(); ++i) {
            oql.append("'");
            oql.append(ids.get(i));
            oql.append("'");
            if (i == ids.size() - 1) break;
            oql.append(",");
        }
        oql.append(")");
        CUBDControlCollection cubdControlCollection = iCUBDControl.getCUBDControlCollection(oql.toString());
        if (cubdControlCollection != null && cubdControlCollection.size() > 0) {
            for (int i = 0; i < cubdControlCollection.size(); ++i) {
                CUBDControlInfo controlInfo = cubdControlCollection.get(i);
                if (!CUBDDispatchPattern.DISPATCH.equals((Object)controlInfo.getDispatchPattern()) && !CUBDDispatchPattern.DISPATCH_REFERENCE.equals((Object)controlInfo.getDispatchPattern())) continue;
                cus.add(controlInfo.getCU().getId().toString());
            }
        }
    }

    private String getCULongNumber(Context ctx, IObjectPK orgPK) throws BOSException, SQLException {
        String longNumber = null;
        String treeID = "00000000-0000-0000-0000-0000000000014F2827FD";
        String orgID = orgPK.toString();
        Object[] params = new Object[]{treeID, orgID};
        StringBuffer sql = new StringBuffer(500);
        sql.append(" SELECT FLongNumber FROM T_ORG_Structure ").append(" WHERE\tFTreeId = ? ").append(" AND FUnitId = ? ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        if (rowSet.next()) {
            longNumber = rowSet.getString("FLongNumber");
        }
        return longNumber;
    }

    private AutoAssignSolutionCollection getAutoAssignSolutionCollection(Context ctx, IObjectPK[] pks) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet set = new HashSet();
        Collections.addAll(set, pks);
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("status"));
        viewInfo.getSelector().add(new SelectorItemInfo("processDefID"));
        viewInfo.setFilter(filter);
        AutoAssignSolutionCollection autoAssignSolutionCollection = this.getAutoAssignSolutionCollection(ctx, viewInfo);
        return autoAssignSolutionCollection;
    }

    protected String _getLogInfo(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        return null;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.dealAutoAssignSolutionInfo(ctx, (AutoAssignSolutionInfo)model);
        AutoAssignSolutionInfo assignSolutionInfo = (AutoAssignSolutionInfo)model;
        String instanceDetail = assignSolutionInfo.getNumber() + "  " + assignSolutionInfo.getName();
        IObjectPK logPK = null;
        logPK = ((AutoAssignSolutionInfo)model).getId() == null ? LogUtil.beginLog((Context)ctx, (String)"_addnew", (BOSObjectType)new BOSObjectType("3B1E6747"), null, (String)instanceDetail, (String)"AutoAssign_Add") : LogUtil.beginLog((Context)ctx, (String)"_update", (BOSObjectType)new BOSObjectType("3B1E6747"), null, (String)instanceDetail, (String)"AutoAssign_Update");
        IObjectPK pk = super._submit(ctx, model);
        if (logPK != null) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        return pk;
    }

    private void dealAutoAssignSolutionInfo(Context ctx, AutoAssignSolutionInfo model) throws BOSException, EASBizException {
        AutoAssignSolutionInfo info = model;
        this.addAndUpdateCheck(ctx, info);
        for (int i = 0; i < info.getEntries().size(); ++i) {
            AutoAssignSolutionEntryInfo autoAssignSolutionEntryInfo = info.getEntries().get(i);
            Object solutionId = autoAssignSolutionEntryInfo.get("solutionId");
            if (solutionId == null) continue;
            model.getEntries().get(i).setAssignFilterRule(solutionId.toString());
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AutoAssignSolutionInfo assignSolutionInfo = this.getAutoAssignSolutionInfo(ctx, pk);
        String instanceDetail = assignSolutionInfo.getNumber() + "  " + assignSolutionInfo.getName();
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_delete", (BOSObjectType)new BOSObjectType("3B1E6747"), null, (String)instanceDetail, (String)"AutoAssign_Delete");
        super._delete(ctx, pk);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }
}

