/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.master.cssp.AutoAssignSolutionFactory;
import com.kingdee.eas.basedata.master.cssp.AutoAssignSolutionInfo;
import com.kingdee.eas.basedata.master.cssp.AutoAssignSolutionOperationTypeEnum;
import com.kingdee.eas.basedata.master.cssp.AutoAssignSolutionStatusEnum;
import com.kingdee.eas.basedata.master.cssp.BaseAutoAssignSolutionAppException;
import com.kingdee.eas.basedata.master.cssp.app.AbstractAutoAssignSolutionRunTimeControllerBean;
import com.kingdee.eas.basedata.master.cssp.app.CustomerAutoAssignSolutionExecuteHandler;
import com.kingdee.eas.basedata.master.cssp.app.IAutoAssignSolutionExecuteHandler;
import com.kingdee.eas.basedata.master.cssp.app.MaterialAutoAssignSolutionExecuteHandler;
import com.kingdee.eas.basedata.master.cssp.app.SupplierAutoAssignSolutionExecuteHandler;
import com.kingdee.util.Uuid;
import org.apache.log4j.Logger;

public class AutoAssignSolutionRunTimeControllerBean
extends AbstractAutoAssignSolutionRunTimeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.cssp.app.AutoAssignSolutionRunTimeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _execAutoAssignSolution(Context ctx, String autoAssignSolutionID) throws BOSException, BaseAutoAssignSolutionAppException {
        logger.error((Object)("@@@\u540e\u53f0\u4e8b\u52a1\u89e6\u53d1\u8fdb\u5165@@@,autoAssignSolutionID\u4e3a:" + autoAssignSolutionID));
        boolean hasLock = false;
        MutexParameter mutexParam = null;
        IMutexServiceControl iMutex = null;
        try {
            mutexParam = this.getMutexParam(autoAssignSolutionID);
            iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            hasLock = iMutex.requestMutex2(mutexParam);
            if (hasLock) {
                AutoAssignSolutionInfo autoAssignSolutionInfo = AutoAssignSolutionFactory.getLocalInstance(ctx).getAutoAssignSolutionInfo((IObjectPK)new ObjectUuidPK(autoAssignSolutionID));
                if (autoAssignSolutionInfo == null || AutoAssignSolutionStatusEnum.DISENABLE.equals((Object)autoAssignSolutionInfo.getStatus())) {
                    logger.error((Object)("\u6839\u636eautoAssignSolutionID" + autoAssignSolutionID + "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u81ea\u52a8\u5206\u914d\u65b9\u6848\u6216\u8005\u65b9\u6848\u5df2\u88ab\u7981\u7528!"));
                    String string = "fail";
                    return string;
                }
                IAutoAssignSolutionExecuteHandler iAutoAssignSolutionExecuteHandler = null;
                iAutoAssignSolutionExecuteHandler = AutoAssignSolutionOperationTypeEnum.CUSTOMER.equals((Object)autoAssignSolutionInfo.getOperationType()) ? new CustomerAutoAssignSolutionExecuteHandler() : (AutoAssignSolutionOperationTypeEnum.SUPPLIER.equals((Object)autoAssignSolutionInfo.getOperationType()) ? new SupplierAutoAssignSolutionExecuteHandler() : new MaterialAutoAssignSolutionExecuteHandler());
                iAutoAssignSolutionExecuteHandler.execAutoAssignSolution(ctx, autoAssignSolutionInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (hasLock) {
                iMutex.releaseMutex(mutexParam.getRequestId());
                logger.info((Object)("--mobile--release Mutex success--id=" + mutexParam.getRequestId()));
            }
        }
        return "success";
    }

    private MutexParameter getMutexParam(String lockKey) {
        MutexParameter param = new MutexParameter();
        String lock = "AutoAssignSolution@" + lockKey;
        param.setMutexName(lock);
        param.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        param.setRequestId(Uuid.create());
        param.setActionName(lock);
        return param;
    }
}

