/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.cssp.AbstractDataMergeImpl;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.DataMergeEntryInfo;
import com.kingdee.eas.basedata.master.cssp.DataMergeInfo;
import com.kingdee.eas.basedata.master.cssp.DataMergeTypeEnum;
import com.kingdee.eas.basedata.master.cssp.HeadDetailException;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;

public class BDCustomerMergeImpl
extends AbstractDataMergeImpl {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String merge(Context ctx, DataMergeInfo mergeInfo) throws Exception {
        this.mergeCheck(ctx, mergeInfo);
        String[] mergeTables = new String[]{"T_BD_CustomerSaleInfo", "T_BD_CustomerSaleInfo", "T_BD_CustomerSaleInfo"};
        String[] mergeFields = new String[]{"FSettlementOrgUnitID", "FBillingOrgUnitID", "FDeliverOrgUnitID"};
        String destId = mergeInfo.getDestId();
        Object[] srcIds = mergeInfo.getSrcIds();
        Connection conn = null;
        Statement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.createStatement();
            for (int i = 0; i < mergeTables.length; ++i) {
                StringBuffer sb = new StringBuffer();
                sb.append(" update ").append(mergeTables[i]);
                sb.append(" set ").append(mergeFields[i]).append("='").append(destId).append("' ");
                sb.append(" where ").append(mergeFields[i]).append(" in ").append(StringUtil.getIdsSql(srcIds));
                sb.append(" and FCustomerID not in ").append(StringUtil.getIdsSql(srcIds));
                ps.addBatch(sb.toString());
            }
            ArrayList<String> freezeList = new ArrayList<String>();
            int size = mergeInfo.getEntries().size();
            for (int i = 0; i < size; ++i) {
                DataMergeEntryInfo entryInfo = mergeInfo.getEntries().get(i);
                if (!entryInfo.isIsFreeze()) continue;
                freezeList.add(entryInfo.getSrcId());
            }
            if (freezeList.size() > 0) {
                Object[] freezeIds = new String[freezeList.size()];
                int size2 = freezeList.size();
                for (int i = 0; i < size2; ++i) {
                    freezeIds[i] = (String)freezeList.get(i);
                }
                StringBuffer sb = new StringBuffer();
                sb.append(" update T_BD_Customer set FFreezeOrgUnitID = FControlUnitID,");
                sb.append(" FUsedStatus = ").append(String.valueOf(3));
                sb.append(" where FID in ").append(StringUtil.getIdsSql(freezeIds));
                ps.addBatch(sb.toString());
            }
            ps.executeBatch();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(ps, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < mergeTables.length; ++i) {
            msg.append(mergeTables[i]).append("/").append(mergeFields[i]).append(",");
        }
        msg.setCharAt(msg.length() - 1, '.');
        String s = ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"MergeCompleted", (Locale)ctx.getOriginLocale());
        MessageFormat mf = new MessageFormat(s);
        return mf.format(new String[]{msg.toString()});
    }

    public void mergeCheck(Context ctx, DataMergeInfo mergeInfo) throws Exception {
        CustomerSupplierException customerSupplierException;
        int i;
        CompanyOrgUnitCollection companyOrgCollection = this.getNoCustomerCompanyOrg(ctx, mergeInfo);
        SaleOrgUnitCollection saleOrgCollection = this.getNoCustomerSaleOrg(ctx, mergeInfo);
        String msgDetail = "";
        for (i = 0; i < companyOrgCollection.size(); ++i) {
            CompanyOrgUnitInfo companyOrgUnit = companyOrgCollection.get(i);
            customerSupplierException = new CustomerSupplierException(CustomerSupplierException.MERGEMISSINGYORGASSTDATA, new String[]{" [" + companyOrgUnit.getNumber() + "-" + companyOrgUnit.getName() + "] ", ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"financeAttribute", (Locale)ctx.getOriginLocale())});
            msgDetail = msgDetail + customerSupplierException.getMessage() + "\n";
        }
        for (i = 0; i < saleOrgCollection.size(); ++i) {
            SaleOrgUnitInfo saleOrgUnit = saleOrgCollection.get(i);
            customerSupplierException = new CustomerSupplierException(CustomerSupplierException.MERGEMISSINGYORGASSTDATA, new String[]{" [" + saleOrgUnit.getNumber() + "-" + saleOrgUnit.getName() + "] ", ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"saleAttribute", (Locale)ctx.getOriginLocale())});
            msgDetail = msgDetail + customerSupplierException.getMessage() + "\n";
        }
        if (msgDetail != null && msgDetail.length() > 0) {
            CustomerSupplierException headException = new CustomerSupplierException(CustomerSupplierException.MERGEMISSINGASSTDATACOLL, new Object[]{DataMergeTypeEnum.customer.getAlias()});
            throw new HeadDetailException(headException.getMessage(), msgDetail);
        }
    }

    private CompanyOrgUnitCollection getNoCustomerCompanyOrg(Context ctx, DataMergeInfo dataMergeInfo) throws Exception {
        int i;
        CompanyOrgUnitCollection result = new CompanyOrgUnitCollection();
        HashSet<String> ids = new HashSet<String>();
        ids.add(dataMergeInfo.getDestId());
        for (int i2 = 0; i2 < dataMergeInfo.getSrcIds().length; ++i2) {
            ids.add(dataMergeInfo.getSrcIds()[i2]);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("customer.id", ids, CompareType.INCLUDE));
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("companyOrgUnit.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("companyOrgUnit.name"));
        viewInfo.setFilter(filterInfo);
        CoreBaseCollection collection = CustomerCompanyInfoFactory.getLocalInstance(ctx).getCollection(viewInfo);
        CustomerCompanyInfoCollection destAsstDataCollection = new CustomerCompanyInfoCollection();
        CustomerCompanyInfoCollection srcAsstDataCollection = new CustomerCompanyInfoCollection();
        int size = collection.size();
        for (i = 0; i < size; ++i) {
            CustomerCompanyInfoInfo info = (CustomerCompanyInfoInfo)collection.get(i);
            if (info.getCustomer().getId().toString().equals(dataMergeInfo.getDestId())) {
                destAsstDataCollection.add(info);
                continue;
            }
            srcAsstDataCollection.add(info);
        }
        size = srcAsstDataCollection.size();
        for (i = 0; i < size; ++i) {
            CompanyOrgUnitInfo companyOrgUnit = srcAsstDataCollection.get(i).getCompanyOrgUnit();
            if (this.isInCollection(companyOrgUnit, destAsstDataCollection)) continue;
            result.add(companyOrgUnit);
        }
        return result;
    }

    private SaleOrgUnitCollection getNoCustomerSaleOrg(Context ctx, DataMergeInfo dataMergeInfo) throws Exception {
        int i;
        SaleOrgUnitCollection result = new SaleOrgUnitCollection();
        HashSet<String> ids = new HashSet<String>();
        ids.add(dataMergeInfo.getDestId());
        for (int i2 = 0; i2 < dataMergeInfo.getSrcIds().length; ++i2) {
            ids.add(dataMergeInfo.getSrcIds()[i2]);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("customer.id", ids, CompareType.INCLUDE));
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("saleOrgUnit.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("saleOrgUnit.name"));
        viewInfo.setFilter(filterInfo);
        CoreBaseCollection collection = CustomerSaleInfoFactory.getLocalInstance(ctx).getCollection(viewInfo);
        CustomerSaleInfoCollection destAsstDataCollection = new CustomerSaleInfoCollection();
        CustomerSaleInfoCollection srcAsstDataCollection = new CustomerSaleInfoCollection();
        int size = collection.size();
        for (i = 0; i < size; ++i) {
            CustomerSaleInfoInfo info = (CustomerSaleInfoInfo)collection.get(i);
            if (info.getCustomer().getId().toString().equals(dataMergeInfo.getDestId())) {
                destAsstDataCollection.add(info);
                continue;
            }
            srcAsstDataCollection.add(info);
        }
        size = srcAsstDataCollection.size();
        for (i = 0; i < size; ++i) {
            SaleOrgUnitInfo saleOrgUnit = srcAsstDataCollection.get(i).getSaleOrgUnit();
            if (this.isInCollection(saleOrgUnit, destAsstDataCollection)) continue;
            result.add(saleOrgUnit);
        }
        return result;
    }

    private boolean isInCollection(CompanyOrgUnitInfo companyOrgUnit, CustomerCompanyInfoCollection collection) {
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            CustomerCompanyInfoInfo customerCompanyInfo = collection.get(i);
            if (!companyOrgUnit.getId().equals((Object)customerCompanyInfo.getCompanyOrgUnit().getId())) continue;
            return true;
        }
        return false;
    }

    private boolean isInCollection(SaleOrgUnitInfo saleOrgUnit, CustomerSaleInfoCollection collection) {
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            CustomerSaleInfoInfo customerSaleInfo = collection.get(i);
            if (!saleOrgUnit.getId().equals((Object)customerSaleInfo.getSaleOrgUnit().getId())) continue;
            return true;
        }
        return false;
    }
}

