/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.cssp.BizAnalysisCodeCollection;
import com.kingdee.eas.basedata.master.cssp.BizAnalysisCodeInfo;
import com.kingdee.eas.basedata.master.cssp.CsManagerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.ICsManager;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.app.AbstractBizAnalysisCodeControllerBean;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;

public class BizAnalysisCodeControllerBean
extends AbstractBizAnalysisCodeControllerBean {
    public static final int MAPTYPE_SUPPLIER = 1;
    public static final int MAPTYPE_CUSTOMER = 2;

    protected void addnewCheck(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNumberDup(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            BizAnalysisCodeInfo bizAnalysisCodeInfo;
            String cuName = null;
            BizAnalysisCodeCollection bizAnalysisCodeCollection = super.getBizAnalysisCodeCollection(ctx, view);
            if (bizAnalysisCodeCollection.size() > 0 && (bizAnalysisCodeInfo = bizAnalysisCodeCollection.get(0)) != null && bizAnalysisCodeInfo.getCU() != null && bizAnalysisCodeInfo.getCU().getId() != null) {
                String cuId = bizAnalysisCodeInfo.getCU().getId().toString();
                CtrlUnitInfo ctrlUnitInfo = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(cuId));
                cuName = ctrlUnitInfo.toString();
            }
            throw new CustomerSupplierException(CustomerSupplierException.CUSTOMER_PROMPTCU_DEUPLICATED_ANALYSIS, new Object[]{dataBaseInfo.getNumber(), cuName});
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected void updateCheck(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        BizAnalysisCodeInfo oldModel = this.getBizAnalysisCodeInfo(ctx, pk);
        if (!((DataBaseInfo)model).getNumber().equals(oldModel.getNumber())) {
            this._checkNumberDup(ctx, model);
        }
        if (!((DataBaseInfo)model).getName().equals(oldModel.getName())) {
            this._checkNameDup(ctx, model);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateCheck(ctx, pk, model);
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ISupplier iSupplier;
        BizAnalysisCodeInfo bizCodeVO = this.getBizAnalysisCodeInfo(ctx, pk);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizAnalysisCode", (Object)bizCodeVO.getId().toString(), CompareType.EQUALS));
        ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
        IObjectPK[] pks = iCustomer.getPKList(filter, null);
        ICsManager iCsManager = CsManagerFactory.getLocalInstance(ctx);
        if (pks != null) {
            for (int i = 0; i < pks.length; ++i) {
                iCsManager.unmapCSBaseBizAnalysisCode(pks[i], 2);
            }
        }
        if ((pks = (iSupplier = SupplierFactory.getLocalInstance(ctx)).getPKList(filter, null)) != null) {
            for (int i = 0; i < pks.length; ++i) {
                iCsManager.unmapCSBaseBizAnalysisCode(pks[i], 1);
            }
        }
        super._delete(ctx, pk);
    }
}

