/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.master.cssp.BizAnalysisCodeFactory;
import com.kingdee.eas.basedata.master.cssp.BizAnalysisCodeInfo;
import com.kingdee.eas.basedata.master.cssp.CsManagerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.IBizAnalysisCode;
import com.kingdee.eas.basedata.master.cssp.ICsManager;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Hashtable;
import java.util.Locale;

public class BizAnalysisCodeDataImport
extends AbstractDataTransmission {
    public static final int MAPTYPE_SUPPLIER = 1;
    public static final int MAPTYPE_CUSTOMER = 2;
    private SupplierInfo supplierInfo = null;
    private CustomerInfo customerInfo = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return BizAnalysisCodeFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        IBizAnalysisCode iBizCode = (IBizAnalysisCode)this.getController(ctx);
        try {
            ICsManager iCsManager;
            if (coreBaseInfo.getId() == null) {
                iBizCode.addnew(coreBaseInfo);
            } else {
                iBizCode.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
            if (this.supplierInfo != null) {
                iCsManager = CsManagerFactory.getLocalInstance(ctx);
                iCsManager.mapCSBaseToBizAnalysisCode((IObjectPK)new ObjectUuidPK(this.supplierInfo.getId()), (IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), 1);
                this.supplierInfo = null;
            }
            if (this.customerInfo != null) {
                iCsManager = CsManagerFactory.getLocalInstance(ctx);
                iCsManager.mapCSBaseToBizAnalysisCode((IObjectPK)new ObjectUuidPK(this.customerInfo.getId()), (IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), 2);
                this.customerInfo = null;
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    /*
     * Unable to fully structure code
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        bizCodeInfo = new BizAnalysisCodeInfo();
        numberdata = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        str = null;
        if (numberdata != null) {
            str = numberdata.toString();
            if (str != null && str.trim().length() > 0) {
                bizCodeInfo.setNumber(str);
                if (super.isSltImportUpdate()) {
                    try {
                        iBizCode = (IBizAnalysisCode)this.getController(ctx);
                        bizCodeCollection = iBizCode.getBizAnalysisCodeCollection("where number ='" + str + "'");
                        if (bizCodeCollection == null || bizCodeCollection.size() <= 0) {
                            exception = new CustomerSupplierException(CustomerSupplierException.BIZCODE_NUMBER_NOT_EXIST, new String[]{str});
                            throw new TaskExternalException(exception.getMessage(), (Throwable)exception);
                        }
                        bizCodeInfo.setId(bizCodeCollection.get(0).getId());
                        bizCodeInfo.setAdminCU(bizCodeCollection.get(0).getAdminCU());
                        bizCodeInfo.setCU(bizCodeCollection.get(0).getCU());
                    }
                    catch (Exception e) {
                        throw new TaskExternalException(e.getMessage(), (Throwable)e);
                    }
                }
            } else if (((DataToken)hsData.get((Object)"PreviousNumber")).data != null) {
                try {
                    str = ((DataToken)hsData.get((Object)"PreviousNumber")).data.toString();
                    iBizCode = (IBizAnalysisCode)this.getController(ctx);
                    bizCodeCollection = iBizCode.getBizAnalysisCodeCollection("where number ='" + str + "'");
                    if (bizCodeCollection == null || bizCodeCollection.size() <= 0) ** GOTO lbl48
                    bizCodeInfo.setId(bizCodeCollection.get(0).getId());
                    bizCodeInfo.setAdminCU(bizCodeCollection.get(0).getAdminCU());
                    bizCodeInfo.setCU(bizCodeCollection.get(0).getCU());
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            }
        } else if (((DataToken)hsData.get((Object)"PreviousNumber")).data != null) {
            try {
                str = ((DataToken)hsData.get((Object)"PreviousNumber")).data.toString();
                iBizCode = (IBizAnalysisCode)this.getController(ctx);
                bizCodeCollection = iBizCode.getBizAnalysisCodeCollection("where number ='" + str + "'");
                if (bizCodeCollection == null || bizCodeCollection.size() <= 0) ** GOTO lbl48
                bizCodeInfo.setId(bizCodeCollection.get(0).getId());
                bizCodeInfo.setAdminCU(bizCodeCollection.get(0).getAdminCU());
                bizCodeInfo.setCU(bizCodeCollection.get(0).getCU());
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        } else {
            throw new TaskExternalException("number  not found!!!!");
        }
lbl48:
        // 7 sources

        data = null;
        multiStr = new String[]{"L1", "L2", "L3"};
        c = multiStr.length;
        for (i = 0; i < c; ++i) {
            data = ((DataToken)hsData.get((Object)new StringBuilder().append((String)"FName_").append((String)multiStr[i]).toString())).data;
            if (data != null) {
                bizCodeInfo.setName(data.toString(), new Locale(multiStr[i]));
            }
            if ((data = ((DataToken)hsData.get((Object)new StringBuilder().append((String)"FDescription_").append((String)multiStr[i]).toString())).data) == null) continue;
            bizCodeInfo.setDescription(data.toString(), new Locale(multiStr[i]));
        }
        supplierNum = ((DataToken)hsData.get((Object)"FSupplierNum")).data;
        customerNum = ((DataToken)hsData.get((Object)"FCustomerNum")).data;
        if (supplierNum != null && customerNum != null && !supplierNum.equals("") && !customerNum.equals("")) {
            this.importCustomer(customerNum, ctx);
            this.importSupplier(supplierNum, ctx);
            try {
                this.isMapRelationWithCurrentCSSP(ctx);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        } else if (supplierNum != null && !supplierNum.equals("")) {
            this.importSupplier(supplierNum, ctx);
        } else if (customerNum != null && !customerNum.equals("")) {
            this.importCustomer(customerNum, ctx);
        }
        if (bizCodeInfo.getId() != null) {
            try {
                this.isMapRelationWithBizCode(ctx, bizCodeInfo.getId().toString());
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        return bizCodeInfo;
    }

    private void importCustomer(Object customerNum, Context ctx) throws TaskExternalException {
        if (customerNum.toString() != null && customerNum.toString().trim().length() > 0) {
            try {
                ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
                CustomerCollection customerCollection = iCustomer.getCustomerCollection("where number ='" + customerNum.toString() + "'");
                if (customerCollection == null || customerCollection.size() <= 0) {
                    throw new TaskExternalException(new CustomerSupplierException(CustomerSupplierException.CUSTOMER_NUMBER_NOTEXIST, new String[]{customerNum.toString()}).getMessage(), (Throwable)((Object)new CustomerSupplierException(CustomerSupplierException.CUSTOMER_NUMBER_NOTEXIST, new String[]{customerNum.toString()})));
                }
                this.customerInfo = customerCollection.get(0);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void importSupplier(Object supplierNum, Context ctx) throws TaskExternalException {
        if (supplierNum.toString() != null && supplierNum.toString().trim().length() > 0) {
            try {
                ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
                SupplierCollection supplierCollection = iSupplier.getSupplierCollection("where number ='" + supplierNum.toString() + "'");
                if (supplierCollection == null || supplierCollection.size() <= 0) {
                    throw new TaskExternalException(new CustomerSupplierException(CustomerSupplierException.SUPPLIER_NUMBER_NOTEXIST, new String[]{supplierNum.toString()}).getMessage(), (Throwable)((Object)new CustomerSupplierException(CustomerSupplierException.SUPPLIER_NUMBER_NOTEXIST, new String[]{supplierNum.toString()})));
                }
                this.supplierInfo = supplierCollection.get(0);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void isMapRelationWithCurrentCSSP(Context ctx) throws Exception {
        if (this.customerInfo != null) {
            if (this.supplierInfo.isIsInternalCompany() != this.customerInfo.isIsInternalCompany()) {
                throw new CustomerSupplierException(CustomerSupplierException.INTERNAL_EXTERNAL_CS_CANNOT_MAPPED);
            }
            if (this.customerInfo.isIsInternalCompany() && !this.customerInfo.getInternalCompany().getId().equals((Object)this.supplierInfo.getInternalCompany().getId())) {
                throw new CustomerSupplierException(CustomerSupplierException.MAPPED_INTERNAL_COMPANY_NOT_SAME);
            }
        }
        if (this.supplierInfo != null) {
            if (this.customerInfo.isIsInternalCompany() != this.supplierInfo.isIsInternalCompany()) {
                throw new CustomerSupplierException(CustomerSupplierException.INTERNAL_EXTERNAL_CS_CANNOT_MAPPED);
            }
            if (this.supplierInfo.isIsInternalCompany() && !this.supplierInfo.getInternalCompany().getId().equals((Object)this.customerInfo.getInternalCompany().getId())) {
                throw new CustomerSupplierException(CustomerSupplierException.MAPPED_INTERNAL_COMPANY_NOT_SAME);
            }
        }
    }

    private void isMapRelationWithBizCode(Context ctx, String bizCodeId) throws Exception {
        ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
        SupplierCollection supplierCollection = iSupplier.getSupplierCollection("where bizAnalysisCode.id='" + bizCodeId + "'");
        ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
        CustomerCollection customerCollection = iCustomer.getCustomerCollection("where bizAnalysisCode.id='" + bizCodeId + "'");
        CustomerInfo mapCustomerInfo = null;
        SupplierInfo mapSupplierInfo = null;
        if (customerCollection != null && customerCollection.size() > 0) {
            mapCustomerInfo = customerCollection.get(0);
        }
        if (supplierCollection != null && supplierCollection.size() > 0) {
            mapSupplierInfo = supplierCollection.get(0);
        }
        if (this.supplierInfo != null) {
            if (mapCustomerInfo != null) {
                if (this.supplierInfo.isIsInternalCompany() != mapCustomerInfo.isIsInternalCompany()) {
                    throw new CustomerSupplierException(CustomerSupplierException.INTERNAL_EXTERNAL_CS_CANNOT_MAPPED);
                }
                if (mapCustomerInfo.isIsInternalCompany() && !mapCustomerInfo.getInternalCompany().getId().equals((Object)this.supplierInfo.getInternalCompany().getId())) {
                    throw new CustomerSupplierException(CustomerSupplierException.MAPPED_INTERNAL_COMPANY_NOT_SAME);
                }
            } else if (mapSupplierInfo != null) {
                if (this.supplierInfo.isIsInternalCompany() != mapSupplierInfo.isIsInternalCompany()) {
                    throw new CustomerSupplierException(CustomerSupplierException.INTERNAL_EXTERNAL_CS_CANNOT_MAPPED);
                }
                if (mapSupplierInfo.isIsInternalCompany() && !mapSupplierInfo.getInternalCompany().getId().equals((Object)this.supplierInfo.getInternalCompany().getId())) {
                    throw new CustomerSupplierException(CustomerSupplierException.MAPPED_INTERNAL_COMPANY_NOT_SAME);
                }
            }
        }
        if (this.customerInfo != null) {
            if (mapCustomerInfo != null) {
                if (this.customerInfo.isIsInternalCompany() != mapCustomerInfo.isIsInternalCompany()) {
                    throw new CustomerSupplierException(CustomerSupplierException.INTERNAL_EXTERNAL_CS_CANNOT_MAPPED);
                }
                if (mapCustomerInfo.isIsInternalCompany() && !mapCustomerInfo.getInternalCompany().getId().equals((Object)this.customerInfo.getInternalCompany().getId())) {
                    throw new CustomerSupplierException(CustomerSupplierException.MAPPED_INTERNAL_COMPANY_NOT_SAME);
                }
            } else if (mapSupplierInfo != null) {
                if (this.customerInfo.isIsInternalCompany() != mapSupplierInfo.isIsInternalCompany()) {
                    throw new CustomerSupplierException(CustomerSupplierException.INTERNAL_EXTERNAL_CS_CANNOT_MAPPED);
                }
                if (mapSupplierInfo.isIsInternalCompany() && !mapSupplierInfo.getInternalCompany().getId().equals((Object)this.customerInfo.getInternalCompany().getId())) {
                    throw new CustomerSupplierException(CustomerSupplierException.MAPPED_INTERNAL_COMPANY_NOT_SAME);
                }
            }
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            String multiName = "FName_" + ContextUtils.getLocaleFromEnv().toString().toUpperCase();
            String multiDescription = "FDescription_" + ContextUtils.getLocaleFromEnv().toString().toUpperCase();
            result.put("FNumber", DataImportUtils.transformValue(rs.getString("number")));
            result.put("FSupplierNum", DataImportUtils.transformValue(rs.getString("supplier.number")));
            result.put("FCustomerNum", DataImportUtils.transformValue(rs.getString("customer.number")));
            result.put(multiName, DataImportUtils.transformValue(rs.getString("name")));
            result.put(multiDescription, DataImportUtils.transformValue(rs.getString("description")));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        ObjectUuidPK pk = null;
        try {
            IBizAnalysisCode iBizCode = BizAnalysisCodeFactory.getLocalInstance(ctx);
            pk = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
            filterInfo = iBizCode.getDatabaseDFilter((IObjectPK)pk, "id", "adminCU.id");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.cssp.app.BizAnalysisCodeQuery";
    }
}

