/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.master.cssp.app.AbstractCSSPFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class CSSPFacadeControllerBean
extends AbstractCSSPFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.cssp.app.CSSPFacadeControllerBean");
    private String tempTable = null;

    @Override
    protected String _createAndFillTempTable(Context ctx, List orgList) throws BOSException {
        if (this.tempTable != null) {
            DbUtil.execute((Context)ctx, (String)("TRUNCATE TABLE " + this.tempTable));
        } else {
            this.createTempTable(ctx);
        }
        this.fillTempTable(ctx, orgList);
        return this.tempTable;
    }

    private void fillTempTable(Context ctx, List orgList) throws BOSException {
        String insertSql = "insert into " + this.tempTable + " values(?)";
        Connection cn = null;
        PreparedStatement stmt = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.prepareStatement(insertSql);
            for (Object orgid : orgList) {
                stmt.setString(1, StringUtils.cnulls(orgid));
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)stmt, (Connection)cn);
    }

    private void createTempTable(Context ctx) throws BOSException {
        String tableName = "";
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("CREATE TABLE TempOrgTable");
        createTableSql.append("\t( FORGID varchar(44))");
        try {
            tableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        this.tempTable = tableName;
    }
}

