/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerGroupException;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.app.AbstractCSSPGroupControllerBean;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CSSPGroupControllerBean
extends AbstractCSSPGroupControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.cssp.app.CSSPGroupControllerBean");
    private static final String MaterialResource = "com.kingdee.eas.basedata.master.material.MaterialResource";

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CSSPGroupInfo csspGroupInfo = (CSSPGroupInfo)model;
        Connection con = null;
        RptRowSet rs = null;
        try {
            String sql = " select csspGroup.FNumber from T_BD_CSSPGroup csspGroup inner join T_BD_CSSPGroupStandard standard on standard.fid = csspGroup.FCSSPGroupStandardID where csspGroup.FNumber = '" + csspGroupInfo.getNumber().toString().replaceAll("'", "''") + "' and standard.fid='" + csspGroupInfo.getGroupStandard().getId().toString() + "'";
            con = this.getConnection(ctx);
            rs = DBUtil.executeQuery((String)sql, (Connection)con);
            if (rs.next() && rs.getString(0) != null) {
                String number = this._getPropertyAlias(ctx, (DataBaseInfo)csspGroupInfo, "number") + csspGroupInfo.getNumber();
                throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
            }
        }
        catch (SQLException sql) {
            try {
                throw new BOSException("sql Excute Error\uff1a", (Throwable)sql);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)con);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("groupStandard.id"));
        sic.add(new SelectorItemInfo("groupStandard.type"));
        return sic;
    }

    private void checkCanEdit(Context ctx, CSSPGroupInfo info) throws BOSException, EASBizException {
        CSSPGroupInfo oldInfo = this.getCSSPGroupInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
        if (!info.getCU().getId().equals((Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId())) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
        if (!info.getGroupStandard().getId().equals((Object)oldInfo.getGroupStandard().getId())) {
            String longNumber = oldInfo.getLongNumber();
            if (longNumber.indexOf("'") >= 0) {
                longNumber = longNumber.replaceAll("'", "''");
            }
            StringBuffer sbCustomer = new StringBuffer();
            sbCustomer.append(" SELECT   a.fid ");
            sbCustomer.append("   FROM   T_BD_CustomerGroupDetail a, T_BD_CSSPGroup b ");
            sbCustomer.append("  WHERE       A.FCUSTOMERGROUPID = B.FID ");
            sbCustomer.append("          AND B.FCSSPGROUPSTANDARDID = '" + oldInfo.getGroupStandard().getId().toString() + "' ");
            sbCustomer.append("          AND (B.FLONGNUMBER = '" + longNumber + "' OR B.FLONGNUMBER LIKE '" + longNumber + "!%') ");
            IRowSet rsCustomer = DbUtil.executeQuery((Context)ctx, (String)sbCustomer.toString());
            StringBuffer sbSupplier = new StringBuffer();
            sbSupplier.append(" SELECT   a.fid ");
            sbSupplier.append("   FROM   T_BD_SupplierGroupDetail a, T_BD_CSSPGroup b ");
            sbSupplier.append("  WHERE       A.FSUPPLIERGROUPID = b.fid ");
            sbSupplier.append("          AND B.FCSSPGROUPSTANDARDID = '" + oldInfo.getGroupStandard().getId().toString() + "' ");
            sbSupplier.append("          AND (b.flongnumber = '" + longNumber + "' OR b.flongnumber LIKE '" + longNumber + "!%') ");
            IRowSet rsSupplier = DbUtil.executeQuery((Context)ctx, (String)sbSupplier.toString());
            try {
                if (rsCustomer != null && rsCustomer.next() || rsSupplier != null && rsSupplier.next()) {
                    throw new CustomerGroupException(CustomerGroupException.CSSPGROUP_HASREFER);
                }
            }
            catch (SQLException e) {
                throw new CustomerGroupException(CustomerGroupException.CSSPGROUP_HASREFER);
            }
        }
    }

    private void checkCanEdit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CSSPGroupInfo oldInfo = this.getCSSPGroupInfo(ctx, pk);
        if (!oldInfo.getCU().getId().equals((Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId())) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (((CSSPGroupInfo)model).getId() != null) {
            this.checkCanEdit(ctx, (CSSPGroupInfo)model);
        }
        this._checkNumberBlank(ctx, model);
        if (((CSSPGroupInfo)model).getName() == null || ((CSSPGroupInfo)model).getName().trim().equals("")) {
            throw new CustomerSupplierException(CustomerSupplierException.NAMENOTNULL);
        }
        CSSPGroupInfo info = (CSSPGroupInfo)model;
        CSSPGroupInfo oldInfo = null;
        if (info.getId() != null) {
            oldInfo = this.getCSSPGroupInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
        }
        IObjectPK rsPK = super._submit(ctx, model);
        if (oldInfo != null) {
            info = (CSSPGroupInfo)model;
            this.updateGroupStandard(ctx, info, oldInfo);
            this.updateGroupParent(ctx, oldInfo);
        }
        return rsPK;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CSSPGroupInfo oldGroupInfo = this.getCSSPGroupInfo(ctx, pk, this.getSelector());
        CSSPGroupInfo newGroupInfo = (CSSPGroupInfo)model;
        this._checkNumberBlank(ctx, model);
        if (((CSSPGroupInfo)model).getName() == null || ((CSSPGroupInfo)model).getName().trim().equals("")) {
            throw new CustomerSupplierException(CustomerSupplierException.NAMENOTNULL);
        }
        if (!oldGroupInfo.getNumber().equals(newGroupInfo.getNumber()) || !oldGroupInfo.getGroupStandard().getId().toString().equals(newGroupInfo.getGroupStandard().getId().toString())) {
            this._checkNumberDup(ctx, model);
        }
        newGroupInfo.verify(oldGroupInfo);
        String permissionItem = "";
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        if (oldGroupInfo.getGroupStandard().getType() == 1) {
            iPermission.checkDataPermission((IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectPK)new ObjectUuidPK(cuInfo.getId()), "Customergroup_Update", (IObjectValue)oldGroupInfo);
        } else if (oldGroupInfo.getGroupStandard().getType() == 2) {
            iPermission.checkDataPermission((IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectPK)new ObjectUuidPK(cuInfo.getId()), "Suppliergroup_Update", (IObjectValue)oldGroupInfo);
        } else if (oldGroupInfo.getGroupStandard().getType() == 0) {
            try {
                iPermission.checkDataPermission((IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectPK)new ObjectUuidPK(cuInfo.getId()), "Customergroup_Update", (IObjectValue)oldGroupInfo);
                iPermission.checkDataPermission((IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectPK)new ObjectUuidPK(cuInfo.getId()), "Suppliergroup_Update", (IObjectValue)oldGroupInfo);
            }
            catch (PermissionException e) {
                throw new CustomerSupplierException(CustomerSupplierException.COMMONGROUP, new Object[]{e.getMessage()});
            }
        } else if (oldGroupInfo.getGroupStandard().getType() == -1) {
            // empty if block
        }
        super._update(ctx, pk, model);
        boolean isNeedUpdateParent = false;
        if (newGroupInfo.getParent() != null && oldGroupInfo.getParent() == null) {
            isNeedUpdateParent = true;
        } else if (newGroupInfo.getParent() != null && !newGroupInfo.getParent().getId().toString().equals(oldGroupInfo.getParent().getId().toString())) {
            isNeedUpdateParent = true;
        }
        if (isNeedUpdateParent) {
            this.updateGroupParent(ctx, oldGroupInfo);
            TreeBaseInfo parent = this.getTreeBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(newGroupInfo.getParent().getId()));
            if (parent.isIsLeaf()) {
                parent.setIsLeaf(false);
                super._update(ctx, (IObjectPK)new ObjectUuidPK(parent.getId()), (IObjectValue)parent);
            }
        }
        ORMValueCacheService.getInstance().discardType(ctx, new CustomerInfo().getBOSType());
        ORMValueCacheService.getInstance().discardType(ctx, new SupplierInfo().getBOSType());
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkCanEdit(ctx, pk);
        super._delete(ctx, pk);
    }

    protected void checkLNForTree(Context ctx, TreeBaseInfo treeBaseInfo) throws BOSException, EASBizException, TreeBaseException {
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        StringBuffer buffer = new StringBuffer();
        String longNumber = ((CSSPGroupInfo)model).getLongNumber();
        if (longNumber.indexOf("'") >= 0) {
            longNumber = longNumber.replaceAll("'", "''");
        }
        buffer.append("update T_BD_CSSPGroup ").append(" set FDeletedStatus = 2 ").append(" where ").append(" FLongNumber like ").append("'" + longNumber + "%'");
        buffer.append(" and FCSSPGroupStandardID='").append(((CSSPGroupInfo)model).getGroupStandard().getId().toString()).append("'");
        DbUtil.execute((Context)ctx, (String)buffer.toString());
        ORMValueCacheService.getInstance().discardType(ctx, this.getBOSType());
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        String longNumber = ((CSSPGroupInfo)model).getLongNumber();
        if (longNumber.indexOf("'") >= 0) {
            longNumber = longNumber.replaceAll("'", "''");
        }
        String[] nums = longNumber.split("!");
        StringBuffer param = new StringBuffer();
        for (int i = 0; i < nums.length; ++i) {
            if (i > 0) {
                param.append(",");
            }
            param.append("'");
            param.append(nums[i]);
            param.append("'");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("update T_BD_CSSPGroup ").append(" set FDeletedStatus = 1 ").append(" where FNumber in (").append(param.toString() + ")").append(" and FDeletedStatus = 2 ");
        buffer.append(" and FCSSPGroupStandardID='").append(((CSSPGroupInfo)model).getGroupStandard().getId().toString()).append("'");
        DbUtil.execute((Context)ctx, (String)buffer.toString());
        ORMValueCacheService.getInstance().discardType(ctx, this.getBOSType());
    }

    @Override
    protected void _importUpdate(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CSSPGroupInfo oldGroupInfo = this.getCSSPGroupInfo(ctx, pk);
        CSSPGroupInfo newGroupInfo = (CSSPGroupInfo)model;
        this._checkNumberBlank(ctx, model);
        if (((CSSPGroupInfo)model).getName() == null || ((CSSPGroupInfo)model).getName().trim().equals("")) {
            throw new CustomerSupplierException(CustomerSupplierException.NAMENOTNULL);
        }
        newGroupInfo.verify(oldGroupInfo);
        super._update(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CSSPGroupInfo csspGroupInfo = (CSSPGroupInfo)model;
        csspGroupInfo.verify();
        if (csspGroupInfo.getParent() != null && csspGroupInfo.getParent().getId() == null && csspGroupInfo.getParent().innerGetParent() == null) {
            csspGroupInfo.setParent(null);
        }
        String permissionItem = "";
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        if (csspGroupInfo.getGroupStandard().getType() == 1) {
            iPermission.checkDataPermission((IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectPK)new ObjectUuidPK(cuInfo.getId()), "Customergroup_AddNew", (IObjectValue)csspGroupInfo);
        } else if (csspGroupInfo.getGroupStandard().getType() == 2) {
            iPermission.checkDataPermission((IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectPK)new ObjectUuidPK(cuInfo.getId()), "Suppliergroup_AddNew", (IObjectValue)csspGroupInfo);
        } else if (csspGroupInfo.getGroupStandard().getType() == 0) {
            try {
                iPermission.checkDataPermission((IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectPK)new ObjectUuidPK(cuInfo.getId()), "Customergroup_AddNew", (IObjectValue)csspGroupInfo);
                iPermission.checkDataPermission((IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectPK)new ObjectUuidPK(cuInfo.getId()), "Suppliergroup_AddNew", (IObjectValue)csspGroupInfo);
            }
            catch (PermissionException e) {
                throw new CustomerSupplierException(CustomerSupplierException.COMMONGROUP, new Object[]{e.getMessage()});
            }
        } else if (csspGroupInfo.getGroupStandard().getType() == -1) {
            // empty if block
        }
        return super._addnew(ctx, model);
    }

    protected int getLongNumberLen(Context ctx, TreeBaseInfo info) throws EASBizException, BOSException {
        return 512;
    }

    protected void updateGroupStandard(Context ctx, CSSPGroupInfo info, CSSPGroupInfo oldInfo) throws EASBizException, BOSException {
        if (!oldInfo.getGroupStandard().getId().toString().equals(info.getGroupStandard().getId().toString())) {
            StringBuffer sb = new StringBuffer();
            String longNumber = info.getLongNumber();
            if (longNumber.indexOf("'") >= 0) {
                longNumber = longNumber.replaceAll("'", "''");
            }
            sb.append(" UPDATE   T_BD_CSSPGroup ");
            sb.append("    SET   FCSSPGroupStandardID = '" + info.getGroupStandard().getId().toString() + "' ");
            sb.append("  WHERE   FCSSPGroupStandardID = '" + oldInfo.getGroupStandard().getId().toString() + "' ");
            sb.append("      AND flongnumber LIKE '" + longNumber + "!%' ");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
    }

    protected void updateGroupParent(Context ctx, CSSPGroupInfo tempInfo) throws EASBizException, BOSException {
        TreeBaseCollection coll;
        CSSPGroupInfo groupInfo;
        if (tempInfo.getParent() != null && tempInfo.getParent().getId() != null && tempInfo.getParent().getId().toString().trim().length() > 0 && (groupInfo = (CSSPGroupInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(tempInfo.getParent().getId().toString()))) != null && groupInfo.getId() != null && (coll = this.getAllChildren(ctx, groupInfo)).size() <= 0) {
            groupInfo.setIsLeaf(true);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(groupInfo.getId()), (IObjectValue)groupInfo);
        }
    }

    @Override
    protected void _changeStatus(Context ctx, List pkList, String flag) throws BOSException, EASBizException {
        CSSPGroupInfo info;
        ObjectUuidPK pk;
        boolean cuCheckFail = false;
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        if (flag.equals("cancel")) {
            for (Object objPk : pkList) {
                pk = new ObjectUuidPK(objPk.toString());
                info = this.getCSSPGroupInfo(ctx, (IObjectPK)pk);
                if (!info.getCU().getId().toString().equals(cuId)) {
                    cuCheckFail = true;
                    continue;
                }
                if (info.getDeletedStatus() != DeletedStatusEnum.NORMAL) continue;
                this.cancel(ctx, (IObjectPK)pk, (CoreBaseInfo)info);
            }
        }
        if (flag.equals("cancelCancel")) {
            for (Object objPk : pkList) {
                pk = new ObjectUuidPK(objPk.toString());
                info = this.getCSSPGroupInfo(ctx, (IObjectPK)pk);
                if (!info.getCU().getId().toString().equals(cuId)) {
                    cuCheckFail = true;
                    continue;
                }
                if (info.getDeletedStatus() != DeletedStatusEnum.DELETED) continue;
                this.cancelCancel(ctx, (IObjectPK)pk, (CoreBaseInfo)info);
            }
        }
        if (cuCheckFail) {
            throw new CustomerGroupException(CustomerGroupException.CANNOTUPDATE);
        }
    }

    @Override
    protected boolean _isGroupVisible(Context ctx, String CuTable, String datTab, String dataID) throws BOSException {
        return false;
    }

    @Override
    protected Map _getGroupCuInfo(Context ctx, String[] groupNumbers, String groupStandardId) throws BOSException, EASBizException {
        HashMap<String, StringBuilder> groupCuInfoMap = new HashMap<String, StringBuilder>();
        if (groupNumbers != null && groupNumbers.length > 0) {
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            String groupSql = null;
            StringBuilder cuTip = null;
            HashSet<String> fControlUnitIdSet = new HashSet<String>();
            FullOrgUnitCollection fullOrgUnitCollection = null;
            for (int i = 0; i < groupNumbers.length; ++i) {
                groupSql = "SELECT FControlUnitId FROM T_BD_CsspGroup where FLONGNUMBER like '" + groupNumbers[i] + "!%' and FCSSPGROUPSTANDARDID = '" + groupStandardId + "'";
                IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)groupSql);
                try {
                    fControlUnitIdSet.clear();
                    while (rs1.next()) {
                        String fControlUnitId = rs1.getString("FControlUnitId");
                        fControlUnitIdSet.add(fControlUnitId);
                    }
                    if (fControlUnitIdSet.size() <= 0) continue;
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", fControlUnitIdSet, CompareType.INCLUDE));
                    ev.setFilter(filter);
                    ev.getSelector().add("*");
                    fullOrgUnitCollection = iFullOrgUnit.getFullOrgUnitCollection(ev);
                    cuTip = new StringBuilder();
                    if (fullOrgUnitCollection != null && fullOrgUnitCollection.size() > 0) {
                        for (int j = 0; j < fullOrgUnitCollection.size(); ++j) {
                            FullOrgUnitInfo fullOrgUnitInfo = fullOrgUnitCollection.get(j);
                            if (fullOrgUnitInfo == null) continue;
                            cuTip.append(fullOrgUnitInfo.getName()).append("(").append(fullOrgUnitInfo.getNumber()).append(")").append(",");
                        }
                        cuTip.deleteCharAt(cuTip.length() - 1);
                    }
                    groupCuInfoMap.put(groupNumbers[i], cuTip);
                    continue;
                }
                catch (SQLException e) {
                    logger.error((Object)"CSSPGroup query error");
                    e.getMessage();
                }
            }
        }
        return groupCuInfoMap;
    }

    @Override
    protected void _upgrade(Context ctx, IObjectPK dataPk, IObjectPK subCUPk, IObjectPK superCUPk) throws BOSException, EASBizException {
        IObjectPK logPk;
        String logStr;
        CSSPGroupInfo cSSPGroupInfo;
        FullOrgUnitInfo subOu = new FullOrgUnitInfo();
        if (subCUPk != null) {
            subOu = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo(subCUPk);
        }
        FullOrgUnitInfo supOu = new FullOrgUnitInfo();
        if (superCUPk != null) {
            supOu = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo(superCUPk);
        }
        if ((cSSPGroupInfo = this.getCSSPGroupInfo(ctx, dataPk)).getGroupStandard().getType() == 1) {
            logStr = ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"CustomerGroupMsg", (Locale)ctx.getOriginLocale()) + cSSPGroupInfo.getNumber() + "    \n" + ResourceBase.getString((String)MaterialResource, (String)"SourceCu", (Locale)ctx.getOriginLocale()) + subOu.getNumber() + "    \n" + ResourceBase.getString((String)MaterialResource, (String)"AfterUpgradeCu", (Locale)ctx.getOriginLocale()) + supOu.getNumber();
            logPk = LogUtil.beginLog((Context)ctx, (String)"_upgrade", (BOSObjectType)new CustomerInfo().getBOSType(), null, (String)logStr, (String)"bd_customerGroup_upgrade", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"CustomerGroupUpgrade", (Locale)ctx.getOriginLocale()));
        } else if (cSSPGroupInfo.getGroupStandard().getType() == 2) {
            logStr = ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"SupplierGroupMsg", (Locale)ctx.getOriginLocale()) + cSSPGroupInfo.getNumber() + "    \n" + ResourceBase.getString((String)MaterialResource, (String)"SourceCu", (Locale)ctx.getOriginLocale()) + subOu.getNumber() + "    \n" + ResourceBase.getString((String)MaterialResource, (String)"AfterUpgradeCu", (Locale)ctx.getOriginLocale()) + supOu.getNumber();
            logPk = LogUtil.beginLog((Context)ctx, (String)"_upgrade", (BOSObjectType)new SupplierInfo().getBOSType(), null, (String)logStr, (String)"bd_supplierGroup_upgrade", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"SupplierGroupUpgrade", (Locale)ctx.getOriginLocale()));
        } else {
            logStr = ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"CSSPGroupMsg", (Locale)ctx.getOriginLocale()) + cSSPGroupInfo.getNumber() + "    \n" + ResourceBase.getString((String)MaterialResource, (String)"SourceCu", (Locale)ctx.getOriginLocale()) + subOu.getNumber() + "    \n" + ResourceBase.getString((String)MaterialResource, (String)"AfterUpgradeCu", (Locale)ctx.getOriginLocale()) + supOu.getNumber();
            logPk = LogUtil.beginLog((Context)ctx, (String)"_upgrade", (BOSObjectType)new CSSPGroupInfo().getBOSType(), null, (String)logStr, (String)"bd_cssp_group_upgrade", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"CSSPGroupUpgrade", (Locale)ctx.getOriginLocale()));
        }
        DataBaseInfo dataInfo = (DataBaseInfo)this._getValue(ctx, dataPk);
        CtrlUnitInfo CU = dataInfo.getCU();
        CtrlUnitInfo CUCopy = (CtrlUnitInfo)CU.clone();
        CUCopy.setId(BOSUuid.read((String)superCUPk.toString()));
        dataInfo.setCU(CUCopy);
        super._update(ctx, dataPk, (IObjectValue)dataInfo);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        CSSPGroupInfo info = (CSSPGroupInfo)model;
        if (info.getGroupStandard() != null) {
            filter.getFilterItems().add(new FilterItemInfo("groupStandard.id", (Object)info.getGroupStandard().getId()));
        }
        return filter;
    }

    protected void _moveTreeNode(Context ctx, IObjectValue sourceNode, IObjectValue targetNode) throws EASBizException, BOSException {
        CSSPGroupInfo sourceInfo = new CSSPGroupInfo();
        CSSPGroupInfo targetInfo = new CSSPGroupInfo();
        if (sourceNode != null && (TreeBaseInfo)sourceNode != null) {
            sourceInfo = this.getCSSPGroupInfo(ctx, (IObjectPK)new ObjectUuidPK(((TreeBaseInfo)sourceNode).getId()));
        }
        if (targetInfo != null && (TreeBaseInfo)targetNode != null) {
            targetInfo = this.getCSSPGroupInfo(ctx, (IObjectPK)new ObjectUuidPK(((TreeBaseInfo)targetNode).getId()));
        }
        IObjectPK logPk = sourceInfo.getGroupStandard().getType() == 1 ? LogUtil.beginLog((Context)ctx, (String)"_moveTreeNode", (BOSObjectType)new CustomerInfo().getBOSType(), null, (String)(ResourceBase.getString((String)MaterialResource, (String)"SourceNode", (Locale)ctx.getOriginLocale()) + sourceInfo.getNumber() + "    \n" + ResourceBase.getString((String)MaterialResource, (String)"TatgetNode", (Locale)ctx.getOriginLocale()) + targetInfo.getNumber()), (String)"bd_cssp_customer_moveTreeNode", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"CustomerGroupMoveNode", (Locale)ctx.getOriginLocale())) : (sourceInfo.getGroupStandard().getType() == 2 ? LogUtil.beginLog((Context)ctx, (String)"_moveTreeNode", (BOSObjectType)new SupplierInfo().getBOSType(), null, (String)(ResourceBase.getString((String)MaterialResource, (String)"SourceNode", (Locale)ctx.getOriginLocale()) + sourceInfo.getNumber() + "    \n" + ResourceBase.getString((String)MaterialResource, (String)"TatgetNode", (Locale)ctx.getOriginLocale()) + targetInfo.getNumber()), (String)"bd_cssp_supplier_moveTreeNode", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"SupplierGroupMoveNode", (Locale)ctx.getOriginLocale())) : LogUtil.beginLog((Context)ctx, (String)"_moveTreeNode", (BOSObjectType)new CSSPGroupInfo().getBOSType(), null, (String)(ResourceBase.getString((String)MaterialResource, (String)"SourceNode", (Locale)ctx.getOriginLocale()) + sourceInfo.getNumber() + "    \n" + ResourceBase.getString((String)MaterialResource, (String)"TatgetNode", (Locale)ctx.getOriginLocale()) + targetInfo.getNumber()), (String)"bd_cssp_group_moveTreeNode", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"CSSPGroupMoveNode", (Locale)ctx.getOriginLocale())));
        super._moveTreeNode(ctx, sourceNode, targetNode);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }
}

