/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.master.batch.app.AbstractBatchUpdateStrategy;
import com.kingdee.eas.basedata.master.batch.model.EntityModelInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerGroupDetailCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerGroupDetailInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.StandardTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierGroupDetailCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierGroupDetailInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CSSPGroupStandardBatchUpdateStrategy
extends AbstractBatchUpdateStrategy {
    protected List uptIdList = new ArrayList();

    public CSSPGroupStandardBatchUpdateStrategy() {
    }

    public CSSPGroupStandardBatchUpdateStrategy(EntityModelInfo et, String[] pks, String[] ps, Object vs) {
        super(et, pks, ps, vs);
    }

    protected void validateBizLogic(Context ctx, IObjectPK pk, Map params) throws BOSException {
        this.uptIdList.add(pk.toString());
    }

    private void putBaseSelectors(SelectorItemCollection selectors) {
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("cu.id"));
        selectors.add(new SelectorItemInfo("adminCU.id"));
        selectors.add(new SelectorItemInfo("effectStatus"));
        selectors.add(new SelectorItemInfo("usedStatus"));
    }

    @Override
    protected void batchUpdate(Context ctx, Map params) throws BOSException, EASBizException {
        if (this.idList != null) {
            int size = this.idList.length;
            for (int i = 0; i < size; ++i) {
                this.validateBizLogic(ctx, (IObjectPK)new ObjectStringPK(this.idList[i].toString()), params);
            }
            this.log.setRecordCount(this.idList.length);
            if (this.uptIdList != null && this.uptIdList.size() > 0) {
                this.log.setSuccessRecordCount(this.uptIdList.size());
                this.log.setFailRecordCount(this.idList.length - this.uptIdList.size());
                this.executeUpdate(ctx);
            } else {
                this.log.setFailRecordCount(this.idList.length);
            }
        }
    }

    private void constractCSSPGroupDetail(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        int j;
        CSSPGroupStandardCollection groupStandards;
        int i;
        ICSSPGroupStandard iCSSPGroupStandard = CSSPGroupStandardFactory.getLocalInstance(ctx);
        if (this.entity.getBosId().equals(CustomerInfo.getBosType()) && this.values instanceof CustomerGroupDetailCollection) {
            CustomerGroupDetailCollection customerDetailCollection = (CustomerGroupDetailCollection)((Object)((CustomerGroupDetailCollection)((Object)this.values)).clone());
            CustomerInfo customerInfo = (CustomerInfo)model;
            for (i = 0; i < customerInfo.getCustomerGroupDetails().size(); ++i) {
                CustomerGroupDetailInfo groupDetail = customerInfo.getCustomerGroupDetails().get(i);
                groupStandards = iCSSPGroupStandard.getCSSPGroupStandard("1", false);
                if (StandardTypeEnum.basicStandard == groupDetail.getCustomerGroupStandard().getIsBasic()) continue;
                for (j = 0; j < groupStandards.size(); ++j) {
                    if (!groupStandards.get(j).getNumber().equalsIgnoreCase(groupDetail.getCustomerGroupStandard().getNumber())) continue;
                    customerInfo.getCustomerGroupDetails().removeObject(i--);
                }
            }
            int c = customerDetailCollection.size();
            for (i = 0; i < c; ++i) {
                if (customerDetailCollection.get(i).getCustomerGroupStandard().getIsBasic().equals((Object)StandardTypeEnum.basicStandard)) {
                    customerDetailCollection.get(i).setId(null);
                    customerInfo.setBrowseGroup(customerDetailCollection.get(i).getCustomerGroup());
                    continue;
                }
                if (customerDetailCollection.get(i).getCustomerGroup() != null && customerDetailCollection.get(i).getCustomerGroup().get("displayname") != null) {
                    customerDetailCollection.get(i).setCustomerGroupFullName(customerDetailCollection.get(i).getCustomerGroup().get("displayname").toString());
                    continue;
                }
                customerDetailCollection.get(i).setCustomerGroupFullName(CSSPGroupFactory.getLocalInstance(ctx).getCSSPGroupInfo((IObjectPK)new ObjectUuidPK(customerDetailCollection.get(i).getCustomerGroup().getId())).getDisplayName());
            }
            customerInfo.getCustomerGroupDetails().addCollection(customerDetailCollection);
        }
        if (this.entity.getBosId().equals(SupplierInfo.getBosType()) && this.values instanceof SupplierGroupDetailCollection) {
            SupplierGroupDetailCollection supplierDetailCollection = (SupplierGroupDetailCollection)((Object)((SupplierGroupDetailCollection)((Object)this.values)).clone());
            SupplierInfo supplierInfo = (SupplierInfo)model;
            for (i = 0; i < supplierInfo.getSupplierGroupDetails().size(); ++i) {
                SupplierGroupDetailInfo groupDetail = supplierInfo.getSupplierGroupDetails().get(i);
                groupStandards = iCSSPGroupStandard.getCSSPGroupStandard("2", false);
                if (StandardTypeEnum.basicStandard == groupDetail.getSupplierGroupStandard().getIsBasic()) continue;
                for (j = 0; j < groupStandards.size(); ++j) {
                    if (!groupStandards.get(j).getNumber().equalsIgnoreCase(groupDetail.getSupplierGroupStandard().getNumber())) continue;
                    supplierInfo.getSupplierGroupDetails().removeObject(i--);
                }
            }
            int c = supplierDetailCollection.size();
            for (i = 0; i < c; ++i) {
                if (!supplierDetailCollection.get(i).getSupplierGroupStandard().getIsBasic().equals((Object)StandardTypeEnum.basicStandard)) continue;
                supplierDetailCollection.get(i).setId(null);
                supplierInfo.setBrowseGroup(supplierDetailCollection.get(i).getSupplierGroup());
            }
            supplierInfo.getSupplierGroupDetails().addCollection(supplierDetailCollection);
        }
    }

    protected void executeUpdate(Context ctx) throws BOSException, EASBizException {
        int size = this.uptIdList.size();
        CustomerInfo customerInfo = null;
        ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
        SupplierInfo supplierInfo = null;
        ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
        if (size != 0) {
            for (int i = 0; i < size; ++i) {
                if (this.entity.getBosId().equals(CustomerInfo.getBosType())) {
                    customerInfo = iCustomer.getCustomerInfo((IObjectPK)new ObjectStringPK(this.uptIdList.get(i).toString()), this.getCustomerSelectors());
                    this.constractCSSPGroupDetail(ctx, (IObjectValue)customerInfo);
                    iCustomer.update((IObjectPK)new ObjectStringPK(this.uptIdList.get(i).toString()), (CoreBaseInfo)customerInfo);
                }
                if (!this.entity.getBosId().equals(SupplierInfo.getBosType())) continue;
                supplierInfo = iSupplier.getSupplierInfo((IObjectPK)new ObjectStringPK(this.uptIdList.get(i).toString()), this.getSupplierSelectors());
                this.constractCSSPGroupDetail(ctx, (IObjectValue)supplierInfo);
                iSupplier.update((IObjectPK)new ObjectStringPK(this.uptIdList.get(i).toString()), (CoreBaseInfo)supplierInfo);
            }
        }
    }

    private void execute(Context ctx, String sql, Object[] params) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                if (params[i] != null) {
                    ps.setObject(i + 1, params[i]);
                    continue;
                }
                ps.setNull(i + 1, 12);
            }
            ps.execute();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    private void executeDelWithOutPreparement(Context ctx, String type) throws BOSException {
        Connection conn = null;
        Statement ps = null;
        StringBuffer params = new StringBuffer();
        String sql = "";
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.createStatement();
            int c = this.uptIdList.size();
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    params.append(",");
                }
                params.append("'");
                params.append(this.uptIdList.get(i).toString());
                params.append("'");
            }
            if (type.equals("customer")) {
                sql = "delete from T_BD_CustomerGroupDetail where FCustomerId in(" + params.toString() + ")";
            }
            if (type.equals("supplier")) {
                sql = "delete from T_BD_SupplierGroupDetail where FSupplierId in(" + params.toString() + ")";
            }
            ps.execute(sql);
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    private SelectorItemCollection getCustomerSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("customerGroupDetails.*"));
        sic.add(new SelectorItemInfo("customerGroupDetails.customerGroupStandard.*"));
        return sic;
    }

    private SelectorItemCollection getSupplierSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("supplierGroupDetails.*"));
        sic.add(new SelectorItemInfo("supplierGroupDetails.supplierGroupStandard.*"));
        return sic;
    }
}

