/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.StandardTypeEnum;
import com.kingdee.eas.basedata.master.cssp.app.AbstractCSSPGroupStandardControllerBean;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CSSPGroupStandardControllerBean
extends AbstractCSSPGroupStandardControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.cssp.app.CSSPGroupStandardControllerBean");
    private static final String defaultType = "0";

    @Override
    protected CSSPGroupStandardCollection _getCSSPGroupStandard(Context ctx, String type, boolean isBasic) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        ObjectUuidPK pk = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)CSSPGroupStandardControllerBean.getCUSic());
        CtrlUnitInfo cu = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)pk, sic);
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)cu.getLongNumber());
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)defaultType, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)type, CompareType.EQUALS));
        if (isBasic) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isBasic", (Object)String.valueOf(StandardTypeEnum.basicStandard.getValue()), CompareType.NOTEQUALS));
            filterInfo.setMaskString("(#0 or #1) and #2");
        } else {
            filterInfo.setMaskString("#0 or #1");
        }
        filterInfo.mergeFilter(filterInfoCU, "and");
        evi.setFilter(filterInfo);
        SorterItemInfo sorterByBasic = new SorterItemInfo("isBasic");
        sorterByBasic.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorterByBasic);
        CSSPGroupStandardCollection stds = this.getCSSPGroupStandardCollection(ctx, evi);
        return stds;
    }

    public static SelectorItemCollection getCUSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("longNumber"));
        return sic;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CSSPGroupStandardInfo standardInfo = this.getCSSPGroupStandardInfo(ctx, pk);
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (standardInfo != null && !standardInfo.getCU().getId().toString().equals(cu.getId().toString())) {
            String message = EASCommonResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"CannotDeleteStandardAtShiUnit", (Locale)ctx.getLocale());
            throw new EASBizException(new NumericExceptionSubItem("1001", message));
        }
        super._delete(ctx, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkCanBeSubmit(ctx, model);
        this._checkNumberBlank(ctx, model);
        if (((CSSPGroupStandardInfo)model).getName() == null || ((CSSPGroupStandardInfo)model).getName().trim().equals("")) {
            throw new CustomerSupplierException(CustomerSupplierException.NAMENOTNULL);
        }
        this._checkNameDup(ctx, model);
        return super._submit(ctx, model);
    }

    private void checkCanBeSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CSSPGroupStandardInfo standardInfo = (CSSPGroupStandardInfo)model;
        standardInfo.checkNumberAndName();
        standardInfo.checkType();
        if (standardInfo.getIsBasic().equals((Object)StandardTypeEnum.basicStandard)) {
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo("isBasic", (Object)"1", CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            if (String.valueOf(standardInfo.getType()).equals(defaultType)) {
                filter.getFilterItems().add(new FilterItemInfo("type", (Object)"1", CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("type", (Object)"2", CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("type", (Object)defaultType, CompareType.EQUALS));
                filter.setMaskString("#0 and (#1 or #2 or #3)");
            } else {
                filter.getFilterItems().add(new FilterItemInfo("type", (Object)defaultType, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("type", (Object)String.valueOf(standardInfo.getType()), CompareType.EQUALS));
                filter.setMaskString("#0 and (#1 or #2)");
            }
            CSSPGroupStandardInfo oldVO = null;
            if (standardInfo.getId() != null) {
                oldVO = this.getCSSPGroupStandardInfo(ctx, (IObjectPK)new ObjectUuidPK(standardInfo.getId()));
                if (String.valueOf(oldVO.getType()).equals(defaultType) && !String.valueOf(standardInfo.getType()).equals(defaultType)) {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo csspFilterInfo = new FilterInfo();
                    csspFilterInfo.getFilterItems().add(new FilterItemInfo("groupStandard", (Object)standardInfo.getId().toString(), CompareType.EQUALS));
                    view.setFilter(csspFilterInfo);
                    CSSPGroupCollection collection = CSSPGroupFactory.getLocalInstance(ctx).getCSSPGroupCollection(view);
                    if (collection.size() > 0) {
                        throw new CustomerSupplierException(CustomerSupplierException.STANDARD_DELSHARE_FAILD);
                    }
                }
                FilterInfo tempFilterInfo = new FilterInfo();
                tempFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)standardInfo.getId().toString(), CompareType.NOTEQUALS));
                filter.mergeFilter(tempFilterInfo, "and");
            }
            if (super._exists(ctx, filter)) {
                if (String.valueOf(standardInfo.getType()).equals(defaultType)) {
                    throw new CustomerSupplierException(CustomerSupplierException.STANDARD_SHARE_FAILD);
                }
                throw new CustomerSupplierException(CustomerSupplierException.CSSP_STANDARD_ONLY);
            }
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        if (((CSSPGroupStandardInfo)model).getName() == null || ((CSSPGroupStandardInfo)model).getName().trim().equals("")) {
            throw new CustomerSupplierException(CustomerSupplierException.NAMENOTNULL);
        }
        this._checkNumberDup(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CSSPGroupStandardInfo dataBaseInfo = (CSSPGroupStandardInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.getFilterItems().add(new FilterItemInfo("type", (Object)String.valueOf(dataBaseInfo.getType()), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("type", (Object)defaultType, CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and (#2 or #3)");
            if (dataBaseInfo.getType() == 0) {
                try {
                    filter = new FilterInfo("number = '" + dataBaseInfo.getNumber() + "' AND id<>'" + dataBaseInfo.getId() + "' AND (type = 2 OR type = 0 OR type=1)");
                }
                catch (ParserException e) {
                    e.printStackTrace();
                    throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)e));
                }
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("type", (Object)String.valueOf(dataBaseInfo.getType()), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("type", (Object)defaultType, CompareType.EQUALS));
            filter.setMaskString("#0 and  (#1 or #2)");
            if (dataBaseInfo.getType() == 0) {
                try {
                    filter = new FilterInfo("number = '" + dataBaseInfo.getNumber() + "' AND (type = 2 OR type = 0 OR type=1)");
                }
                catch (ParserException e) {
                    e.printStackTrace();
                    throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)e));
                }
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            view.getSelector().add(new SelectorItemInfo("cu.name"));
            DataBaseCollection dcoll = super.getDataBaseCollection(ctx, view);
            DataBaseInfo dInfo = dcoll.get(0);
            String cuName = dInfo.getCU().getName();
            String number = dataBaseInfo.getNumber();
            throw new DataBaseDException(DataBaseDException.CHECKNUMDUP, new Object[]{number, cuName});
        }
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CSSPGroupStandardInfo standardInfo = (CSSPGroupStandardInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)standardInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)String.valueOf(standardInfo.getType()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)defaultType, CompareType.EQUALS));
        filter.setMaskString("#0 and  (#1 or #2)");
        if (standardInfo.getType() == 0) {
            try {
                filter = new FilterInfo("name = '" + standardInfo.getName() + "' AND (type = 2 OR type = 0 OR type=1)");
            }
            catch (ParserException e) {
                e.printStackTrace();
                throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)e));
            }
        }
        if (standardInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)standardInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            if (standardInfo.getType() == 0) {
                try {
                    filter = new FilterInfo("name = '" + standardInfo.getName() + "' AND id<>'" + standardInfo.getId() + "' AND (type = 2 OR type = 0 OR type=1)");
                }
                catch (ParserException e) {
                    e.printStackTrace();
                    throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)e));
                }
            } else {
                filter.setMaskString("#0 and  (#1 or #2) and #3)");
            }
        }
        if (super._exists(ctx, filter)) {
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            view.getSelector().add(new SelectorItemInfo("cu.name"));
            DataBaseCollection dcoll = super.getDataBaseCollection(ctx, view);
            DataBaseInfo dInfo = dcoll.get(0);
            String cuName = dInfo.getCU().getName();
            String name = standardInfo.getName();
            throw new DataBaseDException(DataBaseDException.CHECKNAMEDUP, new Object[]{name, cuName});
        }
    }

    @Override
    protected String _getBasicStandardId(Context ctx, String type) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)type, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)defaultType, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isBasic", (Object)"1", CompareType.EQUALS));
        filterInfo.setMaskString("(#0 or #1) and #2");
        evi.setFilter(filterInfo);
        CSSPGroupStandardCollection stds = this.getCSSPGroupStandardCollection(ctx, evi);
        if (stds != null && stds.size() > 0) {
            return stds.get(0).getId().toString();
        }
        return null;
    }

    @Override
    protected void _importUpdate(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        if (((CSSPGroupStandardInfo)model).getName() == null || ((CSSPGroupStandardInfo)model).getName().trim().equals("")) {
            throw new CustomerSupplierException(CustomerSupplierException.NAMENOTNULL);
        }
        super._update(ctx, pk, model);
    }
}

