/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.framework.app.Assign2ImpBase;
import com.kingdee.eas.basedata.framework.app.ParallelSqlExecutor;
import com.kingdee.eas.basedata.master.cssp.CustomerAssitDataEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class CustomerAssign2Imp
extends Assign2ImpBase {
    private static Logger logger = Logger.getLogger(CustomerAssign2Imp.class);
    private static final String CUSTOMER_KACLASSTYPE_ID = "7ac99937-00fb-2000-e000-0002c0a81345B999CA39";

    public int batchAssign2Part(Context ctx, String srcOrgId, Set tarOrgIds, String tblBD, Set assistData, int insertBDOneTime) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        PreparedStatement pStmt = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.createStatement();
            String viewBD = "(select top " + insertBDOneTime + " fid from " + tblBD + ")";
            String userId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString();
            StringBuilder inSql = new StringBuilder(100);
            for (int i = 0; i < tarOrgIds.size(); ++i) {
                inSql.append(",'").append("?");
            }
            inSql.replace(0, 1, "");
            String tblCompanyExist = this.getCompanyInfoExistTbl(ctx, tblBD, inSql.toString(), tarOrgIds);
            String tblSaleExist = this.getSaleInfoExistTbl(ctx, tblBD, inSql.toString(), tarOrgIds);
            String orgSql = "select Fid,FisCompanyOrgUnit,FIsSaleOrgUnit,FIsPurchaseOrgUnit,FIsStorageOrgUnit,FControlUnitId from t_org_baseunit where fid in (" + inSql + ")";
            pStmt = cn.prepareStatement(orgSql);
            int n = 0;
            for (Object oTarOrgId : tarOrgIds) {
                pStmt.setString(++n, oTarOrgId.toString());
            }
            ResultSet rs = pStmt.executeQuery();
            if (this.isParallel()) {
                ExecutorService pool = Executors.newFixedThreadPool(6);
                ParallelSqlExecutor pe = new ParallelSqlExecutor(pool);
                while (rs.next()) {
                    int fIsCompanyOrgUnit = rs.getInt("FisCompanyOrgUnit");
                    int fIsSaleOrgUnit = rs.getInt("FIsSaleOrgUnit");
                    String destCuId = rs.getString("FControlUnitId");
                    String destOuId = rs.getString("FID");
                    if ((assistData == null || assistData.contains((Object)CustomerAssitDataEnum.COMPANY)) && fIsCompanyOrgUnit == 1) {
                        pe.getSqlList().add(this.getSQL4AssignCompany(ctx, userId, destCuId, destOuId, srcOrgId, viewBD));
                        pe.getSqlList().add(this.getSql4AssignCompanyBank(ctx, tblCompanyExist, destOuId, srcOrgId, viewBD));
                    }
                    if ((assistData == null || assistData.contains((Object)CustomerAssitDataEnum.SALE)) && fIsSaleOrgUnit == 1) {
                        pe.getSqlList().add(this.getSQL4AssignSale(ctx, userId, destCuId, destOuId, srcOrgId, viewBD));
                        pe.getSqlList().add(this.getSql4AssignLinkman(ctx, tblSaleExist, destOuId, srcOrgId, viewBD));
                        pe.getSqlList().add(this.getSql4AssignAddress(ctx, tblSaleExist, destOuId, srcOrgId, viewBD));
                        pe.getSqlList().add(this.getSql4AssignSaler(ctx, tblSaleExist, destOuId, srcOrgId, viewBD));
                    }
                    pe.executeUpdate(ctx);
                }
                pool.shutdown();
                if (pe.getErrorList().size() > 0) {
                    logger.error((Object)(pe.getErrorList().size() + " error occur!"));
                    logger.error((Object)((Exception)pe.getErrorList().get(0)));
                    throw new BOSException((Throwable)((Exception)pe.getErrorList().get(0)));
                }
            } else {
                while (rs.next()) {
                    int fIsCompanyOrgUnit = rs.getInt("FisCompanyOrgUnit");
                    int fIsSaleOrgUnit = rs.getInt("FIsSaleOrgUnit");
                    String destOuId = rs.getString("FID");
                    String destCuId = rs.getString("FControlUnitId");
                    Statement stmt2 = cn.createStatement();
                    if ((assistData == null || assistData.contains((Object)CustomerAssitDataEnum.COMPANY)) && fIsCompanyOrgUnit == 1) {
                        stmt2.addBatch(this.getSQL4AssignCompany(ctx, userId, destCuId, destOuId, srcOrgId, viewBD));
                        stmt2.addBatch(this.getSql4AssignCompanyBank(ctx, tblCompanyExist, destOuId, srcOrgId, viewBD));
                    }
                    if ((assistData == null || assistData.contains((Object)CustomerAssitDataEnum.SALE)) && fIsSaleOrgUnit == 1) {
                        stmt2.addBatch(this.getSQL4AssignSale(ctx, userId, destCuId, destOuId, srcOrgId, viewBD));
                        stmt2.addBatch(this.getSql4AssignLinkman(ctx, tblSaleExist, destOuId, srcOrgId, viewBD));
                        stmt2.addBatch(this.getSql4AssignAddress(ctx, tblSaleExist, destOuId, srcOrgId, viewBD));
                        stmt2.addBatch(this.getSql4AssignSaler(ctx, tblSaleExist, destOuId, srcOrgId, viewBD));
                    }
                    stmt2.executeBatch();
                }
            }
            this.deleteTop(ctx, tblBD, insertBDOneTime);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                SQLUtils.cleanup(pStmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        SQLUtils.cleanup((Statement)pStmt, (Connection)cn);
        return 0;
    }

    protected String getSQL4AssignSale(Context ctx, String cuUserId, String destCuid, String destOugUnitId, String srcOrgUnitId, String viewBD) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into t_bd_customersaleinfo ");
        sql.append(" (FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FAdminCUID,FSaleOrgID,FTransAdvDay,FDeliveryPriority,FIsFreezeOrder,FIsFreezeDelivery,FEffectedStatus,FCustomerID,FSettlementOrgUnitID,FBillingOrgUnitID,FDeliverOrgUnitID,FConsignFreezeOrgUnitID,FOrderFreezeOrgUnitID,FMonthBancanceMonth,FMonthBancanceDay,FCashDiscountID,FCashKind,FInitialDay,FMonthOrDay,FAddXMonthOrDay,FWhenXDay,FChannelTypeID )  ");
        sql.append(" select newbosid('26C00F09') FID , '" + cuUserId + "' FCreatorID, now() FCreateTime, '" + cuUserId + "' FLastUpdateUserID,  now() FLastUpdateTime, '" + destCuid + "'  FControlUnitID,null FAdminCUID,  '" + destOugUnitId + "' FSaleOrgID,FTransAdvDay,FDeliveryPriority,FIsFreezeOrder,FIsFreezeDelivery,FEffectedStatus,FCustomerID,  FSettlementOrgUnitID,  FBillingOrgUnitID, FDeliverOrgUnitID, null FConsignFreezeOrgUnitID, null FOrderFreezeOrgUnitID,FMonthBancanceMonth,FMonthBancanceDay,FCashDiscountID,FCashKind,FInitialDay,FMonthOrDay,FAddXMonthOrDay,FWhenXDay,FChannelTypeID");
        sql.append(" from t_bd_customersaleinfo mc  where 1=1 ");
        sql.append(" and mc.FCustomerID in ").append(viewBD);
        sql.append(" and mc.FSaleOrgID='" + srcOrgUnitId + "'  ");
        sql.append(" and not exists (select 1 from t_bd_customersaleinfo mc2 where mc2.FSaleOrgID='");
        sql.append(destOugUnitId).append("'");
        sql.append(" and mc.fcustomerid=mc2.fcustomerid)");
        return sql.toString();
    }

    protected String getSQL4AssignCompany(Context ctx, String cuUserId, String destCuid, String destCompanyId, String srcCompanyId, String viewBD) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into t_bd_customercompanyinfo ");
        sql.append(" (FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FAdminCUID,FComOrgID,FSettlementCurrencyID,FSettlementTypeID,FPaymentTypeID,FAccountClassID,FIsTicketFreezed,FEffectedStatus,FCustomerID,FFreezeOrgUnitID,FContactPerson,FContactPersonPost,FPhone,FMobile,FFax,FPostalcode,FEMail,  FOperationerID,FAdminOrgUnitID,FPayConditionID)  ");
        sql.append(" select newbosid('7751B8D7') FID , '" + cuUserId + "' FCreatorID, now() FCreateTime, '" + cuUserId + "' FLastUpdateUserID,  now() FLastUpdateTime, '" + destCuid + "'  FControlUnitID,'" + destCuid + "' FAdminCUID,'" + destCompanyId + "' FComOrgID,FSettlementCurrencyID,FSettlementTypeID,FPaymentTypeID," + this.getKAClassSql(ctx, destCompanyId) + " FAccountClassID,FIsTicketFreezed,2 FEffectedStatus,FCustomerID,null FFreezeOrgUnitID,FContactPerson,FContactPersonPost,FPhone,FMobile,FFax,FPostalcode,FEMail,FOperationerID, null FAdminOrgUnitID,null FPayConditionID");
        sql.append(" from t_bd_customercompanyinfo mc  where 1=1 ");
        sql.append(" and mc.FCustomerID in ").append(viewBD);
        sql.append(" and mc.FComOrgID='" + srcCompanyId + "'  ");
        sql.append(" and not exists (select 1 from t_bd_customercompanyinfo mc2 where mc2.fcomorgid='");
        sql.append(destCompanyId).append("'");
        sql.append(" and mc.fcustomerid=mc2.fcustomerid)");
        return sql.toString();
    }

    private String getKAClassSql(Context ctx, String destCompanyId) {
        String localeSuffix = ctx.getLocale().toString();
        StringBuffer kaSql = new StringBuffer();
        kaSql.append("\n ISNULL(").append("\n ISNULL(").append("\n (select TOP 1 KAClass.FID FID from T_BD_KAClassfication  as  KAClass").append("\n\t\tINNER JOIN T_BD_KAClassficationType AS KAClassType ON KAClassType.FID =  KAClass.FTypeLink ").append("\n\t\tINNER JOIN T_ORG_Company AS Company ON Company.FID =  KAClass.FCurrencyCompany ").append("\n\twhere  KAClass.FCurrencyCompany ='" + destCompanyId + "'").append("\n\t\tand KAClassType.FObjectTypeID='7ac99937-00fb-2000-e000-0002c0a81345B999CA39'").append("\n\t\tand KAClass.FAccountTableID=Company.FAccountTableID").append("\n\t\tand KAClass.FNumber=(select top 1 Fnumber from T_BD_KAClassfication where T_BD_KAClassfication.FID=mc.faccountclassid))").append("\n , ").append("\n (select TOP 1 KAClass.FID FID from T_BD_KAClassfication  as  KAClass").append("\n\t\tINNER JOIN T_BD_KAClassficationType AS KAClassType ON KAClassType.FID =  KAClass.FTypeLink ").append("\n\t\tINNER JOIN T_ORG_Company AS Company ON Company.FID =  KAClass.FCurrencyCompany ").append("\n\twhere  KAClass.FCurrencyCompany ='" + destCompanyId + "'").append("\n\t\tand KAClassType.FObjectTypeID='7ac99937-00fb-2000-e000-0002c0a81345B999CA39'").append("\n\t\tand KAClass.FAccountTableID=Company.FAccountTableID").append("\n\t\tand KAClass.FName_" + localeSuffix + "=(select top 1 FName_" + localeSuffix + " from T_BD_KAClassfication where T_BD_KAClassfication.FID=mc.faccountclassid))").append("\n  ), ").append("\n  (select TOP 1 KAClass.FID FID from T_BD_KAClassfication  as  KAClass").append("\n\t\tINNER JOIN T_BD_KAClassficationType AS KAClassType ON KAClassType.FID =  KAClass.FTypeLink ").append("\n\t\tINNER JOIN T_ORG_Company AS Company ON Company.FID =  KAClass.FCurrencyCompany ").append("\n\twhere  KAClass.FCurrencyCompany ='" + destCompanyId + "'").append("\n\t\tand KAClassType.FObjectTypeID='7ac99937-00fb-2000-e000-0002c0a81345B999CA39'").append("\n\t\tand KAClass.FAccountTableID=Company.FAccountTableID").append("\n \torder by KAClass.FLastUpdateTime desc )").append("\n )");
        return kaSql.toString();
    }

    protected String getSql4AssignCompanyBank(Context ctx, String tblCompanyExist, String destOuId, String srcOrgId, String viewBD) {
        StringBuffer sql = new StringBuffer(100);
        sql.append("insert into t_bd_customercompanybank ");
        sql.append(" (FID,FBank,FBankAccount,FBankAddress,FCustomerCompanyInfoID,FAccountName,FCurrency,FOpenArea)  ");
        sql.append(" select newbosid('18D45F6B') FID , b.FBank,b.FBankAccount,b.FBankAddress, ");
        sql.append(" c2.fid  FCustomerCompanyInfoID,b.FAccountName,b.FCurrency,b.FOpenArea");
        sql.append(" from t_bd_customercompanybank b, t_bd_customercompanyinfo c1  , t_bd_customercompanyinfo c2  ");
        sql.append(" where b.fcustomercompanyinfoid=c1.fid and c2.fcustomerid=c1.fcustomerid");
        sql.append(" and c1.FComOrgID='").append(srcOrgId).append("'");
        sql.append(" and c1.fcustomerid in ").append(viewBD);
        sql.append(" and c2.fcomorgid = '" + destOuId + "'");
        sql.append(" and not exists (select 1 from ").append(tblCompanyExist).append(" t where c2.fid=t.fid)");
        return sql.toString();
    }

    protected String getSql4AssignSaler(Context ctx, String tblSaleExist, String destOuId, String srcOrgId, String viewBD) {
        StringBuffer sql = new StringBuffer(100);
        sql.append("insert into t_bd_customersaler ");
        sql.append(" (FID,FPersonID,FCustomerSaleID)  ");
        sql.append(" select newbosid('B879AD9D') FID , b.FPersonID ,");
        sql.append(" c2.fid  FCustomerSaleID from t_bd_customersaler b, t_bd_customersaleinfo c1  , t_bd_customersaleinfo c2  ");
        sql.append(" where b.FCustomerSaleID=c1.fid and c2.fcustomerid=c1.fcustomerid");
        sql.append(" and c1.FSaleOrgID='").append(srcOrgId).append("'");
        sql.append(" and c1.fcustomerid in ").append(viewBD);
        sql.append(" and c2.FSaleOrgID = '" + destOuId + "'");
        sql.append(" and not exists (select 1 from ").append(tblSaleExist).append(" t where c2.fid=t.fid)");
        return sql.toString();
    }

    protected String getSql4AssignAddress(Context ctx, String tblSaleExist, String destOuId, String srcOrgId, String viewBD) {
        StringBuffer sql = new StringBuffer(100);
        sql.append("insert into t_bd_customerdlvaddress ");
        sql.append(" (FID,FAddress_L1,FAddress_L2,FAddress_L3,FCustomerSaleInfoID)  ");
        sql.append(" select newbosid('26C00F09') FID , b.FAddress_L1,b.FAddress_L2, b.FAddress_L3,");
        sql.append(" c2.fid  FCustomerSaleInfoID from t_bd_customerdlvaddress b, t_bd_customersaleinfo c1  , t_bd_customersaleinfo c2  ");
        sql.append(" where b.FCustomerSaleInfoID=c1.fid and c2.fcustomerid=c1.fcustomerid");
        sql.append(" and c1.FSaleOrgID='").append(srcOrgId).append("'");
        sql.append(" and c1.fcustomerid in ").append(viewBD);
        sql.append(" and c2.FSaleOrgID = '" + destOuId + "'");
        sql.append(" and not exists (select 1 from ").append(tblSaleExist).append(" t where c2.fid=t.fid)");
        return sql.toString();
    }

    protected String getSql4AssignLinkman(Context ctx, String tblSaleExist, String destOuId, String srcOrgId, String viewBD) {
        StringBuffer sql = new StringBuffer(100);
        sql.append("insert into t_bd_customerlinkman ");
        sql.append(" (FID,FPersonID,FContactPerson,FContactPersonPost,FPhone,FFax,FMobile,FPostalcode,FEmail,FAddress,FCustomerSaleID)  ");
        sql.append(" select newbosid('18D45F6B') FID , b.FPersonID,b.FContactPerson, b.FContactPersonPost,b.FPhone,b.FFax,b.FMobile,b.FPostalcode,b.FEmail,b.FAddress,");
        sql.append(" c2.fid  FCustomerSaleID from t_bd_customerlinkman b, t_bd_customersaleinfo c1  , t_bd_customersaleinfo c2  ");
        sql.append(" where b.FCustomerSaleID=c1.fid and c2.fcustomerid=c1.fcustomerid");
        sql.append(" and c1.FSaleOrgID='").append(srcOrgId).append("'");
        sql.append(" and c1.fcustomerid in ").append(viewBD);
        sql.append(" and c2.FSaleOrgID = '" + destOuId + "'");
        sql.append(" and not exists (select 1 from ").append(tblSaleExist).append(" t where c2.fid=t.fid)");
        return sql.toString();
    }

    protected String getCompanyInfoExistTbl(Context ctx, String tblBD, String destOrgSubSql, Set tarOrgIds) throws BOSException, EASBizException {
        String tbl = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName("CustomerCompanyInfo");
        this.createIdTable(ctx, tbl);
        Connection cn = null;
        PreparedStatement pStmt = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            StringBuilder sql = new StringBuilder(100);
            sql.append("insert into ").append(tbl);
            sql.append(" select fid from t_bd_customercompanyinfo ");
            sql.append("where fcustomerid in (select fid from ").append(tblBD).append(")");
            sql.append(" and FComOrgID in (").append(destOrgSubSql).append(")");
            pStmt = cn.prepareStatement(sql.toString());
            int n = 0;
            for (Object oTarOrgId : tarOrgIds) {
                pStmt.setString(++n, oTarOrgId.toString());
            }
            pStmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pStmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pStmt, (Connection)cn);
        return tbl;
    }

    protected String getSaleInfoExistTbl(Context ctx, String tblBD, String destOrgSubSql, Set tarOrgIds) throws BOSException, EASBizException {
        String tbl = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName("CustomerSaleInfo");
        this.createIdTable(ctx, tbl);
        Connection cn = null;
        PreparedStatement pStmt = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            StringBuilder sql = new StringBuilder(100);
            sql.append("insert into ").append(tbl);
            sql.append(" select fid from t_bd_customersaleinfo ");
            sql.append("where FCustomerID in (select fid from ").append(tblBD).append(")");
            sql.append(" and FSaleOrgID in (").append(destOrgSubSql).append(")");
            pStmt = cn.prepareStatement(sql.toString());
            int n = 0;
            for (Object oTarOrgId : tarOrgIds) {
                pStmt.setString(++n, oTarOrgId.toString());
            }
            pStmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pStmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pStmt, (Connection)cn);
        return tbl;
    }

    boolean isParallel() {
        return false;
    }
}

