/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.batch.app.GeneralBatchUpdateStrategy;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomerSaleInfo;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CustomerBatchUpdateStrategy
extends GeneralBatchUpdateStrategy {
    @Override
    protected void validateBizLogic(Context ctx, IObjectPK pk, Map params) throws BOSException, EASBizException {
    }

    @Override
    protected void validateBizLogic(Context ctx, Object[] pks, Map params) throws BOSException, EASBizException {
        Integer org = (Integer)params.get("orgtype");
        String unitId = null;
        if (params.get("orgvalue") != null) {
            unitId = params.get("orgvalue").toString();
        }
        if (org != null) {
            switch (org) {
                case 3: {
                    this.validateBase(ctx, pks, params);
                    break;
                }
                case 0: {
                    if (unitId == null) break;
                    this.validateCompany(ctx, pks, unitId, params);
                    break;
                }
                case 2: {
                    if (unitId == null) break;
                    this.validateSale(ctx, pks, unitId, params);
                }
            }
        }
    }

    private void validateBase(Context ctx, Object[] pks, Map params) throws BOSException, EASBizException {
        if (this.properties == null || this.properties.length == 0) {
            return;
        }
        String[] propertiesToCheck = new String[]{"artificialPerson", "barCode", "busiExequatur", "bizRegisterNo", "busiLicence", "GSPAuthentication", "taxRegisterNo", "mnemonicCode", "foreignName"};
        this.checkLength(propertiesToCheck, 80);
        String[] propertiesToCheck2 = new String[]{"address"};
        this.checkLength(propertiesToCheck2, 255);
        StringBuilder sqlParams = new StringBuilder();
        StringBuilder prepareSqlParams = new StringBuilder();
        HashMap<String, CustomerSupplierException> exceptionMap = new HashMap<String, CustomerSupplierException>();
        String currentId = null;
        ArrayList<String> currentIdList = new ArrayList<String>();
        int count = 0;
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                prepareSqlParams.append(",");
            }
            currentId = pks[i].toString();
            this.validateBase(ctx, (IObjectPK)new ObjectUuidPK(pks[i].toString()), params, exceptionMap);
            currentIdList.add(count++, currentId);
            prepareSqlParams.append("?");
        }
        ResultSet adminCUNotFitSet = null;
        ResultSet customerSet = null;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            int i;
            con = EJBFactory.getConnection((Context)ctx);
            StringBuilder adminCUNotFitBuilder = new StringBuilder();
            adminCUNotFitBuilder.append(" select fid ").append(" from ").append(" T_BD_Customer ").append(" where fid in(").append((CharSequence)prepareSqlParams).append(")").append(" and FAdminCUID <> ").append("?");
            stmt = con.prepareStatement(adminCUNotFitBuilder.toString());
            CustomerSupplierException notAdminCUException = new CustomerSupplierException(CustomerSupplierException.CSSP_ONLYDEALCURRENTCU);
            for (i = 0; i < pks.length; ++i) {
                stmt.setString(i + 1, pks[i].toString());
            }
            stmt.setString(pks.length + 1, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
            adminCUNotFitSet = stmt.executeQuery();
            while (adminCUNotFitSet.next()) {
                if (adminCUNotFitSet.getString(1) == null) continue;
                exceptionMap.put(adminCUNotFitSet.getString(1), notAdminCUException);
            }
            for (i = 0; i < currentIdList.size(); ++i) {
                if (exceptionMap.containsKey(currentIdList.get(i).toString())) continue;
                this.uptIdList.add(currentIdList.get(i).toString());
            }
            int c2 = exceptionMap.keySet().toArray().length;
            for (i = 0; i < c2; ++i) {
                if (i > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("?");
            }
            if (sqlParams.length() > 0) {
                StringBuilder customerBuilder = new StringBuilder();
                customerBuilder.append(" select FNumber ").append(" from ").append(" T_BD_Customer ").append(" where fid in(").append((CharSequence)sqlParams).append(")");
                stmt = con.prepareStatement(customerBuilder.toString());
                int c3 = exceptionMap.keySet().toArray().length;
                for (int i2 = 0; i2 < c3; ++i2) {
                    stmt.setString(i2 + 1, exceptionMap.keySet().toArray()[i2].toString());
                }
                customerSet = stmt.executeQuery();
                count = 0;
                while (customerSet.next()) {
                    CustomerSupplierException exception = new CustomerSupplierException(CustomerSupplierException.CUSTOMER_BATCH_FAILD, new String[]{customerSet.getString(1)});
                    this.log.addException(exception.getMessage(), (Exception)exceptionMap.get(exceptionMap.keySet().toArray()[count++]));
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(adminCUNotFitSet);
                SQLUtils.cleanup(customerSet);
                SQLUtils.cleanup(stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)adminCUNotFitSet);
        SQLUtils.cleanup(customerSet);
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
    }

    @Deprecated
    private void validateBase(Context ctx, IObjectPK pk, Map params) throws BOSException {
        if (this.properties == null || this.properties.length == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString(), CompareType.EQUALS));
        view.setFilter(filter);
        ICustomer ie = CustomerFactory.getLocalInstance(ctx);
        this.putBaseSelectors(view.getSelector());
        CustomerCollection ls = ie.getCustomerCollection(view);
        if (ls != null && ls.size() != 0) {
            CustomerInfo info = ls.get(0);
            String pn = null;
            if (this.values != null && this.values instanceof Map) {
                Map cv = (Map)this.values;
                int size = this.properties.length;
                for (int i = 0; i < size; ++i) {
                    pn = this.properties[i].toString();
                    Object object = info.get(pn);
                    if (object instanceof CoreBaseInfo) {
                        ((CoreBaseInfo)object).setId(BOSUuid.read((String)cv.get(pn).toString()));
                    }
                    info.put(pn, object);
                }
            }
            try {
                this.uptIdList.add(info.getId().toString());
            }
            catch (Exception ex) {
                CustomerSupplierException exception = new CustomerSupplierException(CustomerSupplierException.CUSTOMER_BATCH_FAILD, new String[]{info.getNumber()});
                this.log.addException(exception.getMessage(), ex);
            }
        }
    }

    private void validateBase(Context ctx, IObjectPK pk, Map params, Map exceptionMap) throws BOSException {
        if (this.properties == null || this.properties.length == 0) {
            return;
        }
        if (this.properties[0].equals("taxRate") && ((Map)this.values).get("taxRate") == null) {
            ((Map)this.values).put("taxRate", BigDecimal.ZERO);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString(), CompareType.EQUALS));
        view.setFilter(filter);
        ICustomer ie = CustomerFactory.getLocalInstance(ctx);
        this.putBaseSelectors(view.getSelector());
        CustomerCollection ls = ie.getCustomerCollection(view);
        if (ls != null && ls.size() != 0) {
            CustomerInfo info = ls.get(0);
            String pn = null;
            if (this.values != null && this.values instanceof Map) {
                Map pnObjects = (Map)params.get("objects");
                int size = this.properties.length;
                for (int i = 0; i < size; ++i) {
                    pn = this.properties[i].toString();
                    Object pnObject = pnObjects.get(pn);
                    info.put(pn, pnObject);
                }
            }
        }
    }

    private void putBaseSelectors(SelectorItemCollection selectors) {
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("cu.id"));
        selectors.add(new SelectorItemInfo("adminCU.id"));
        selectors.add(new SelectorItemInfo("effectStatus"));
        selectors.add(new SelectorItemInfo("usedStatus"));
        selectors.add(new SelectorItemInfo("browseGroup.id"));
        selectors.add(new SelectorItemInfo("isInternalCompany"));
        selectors.add(new SelectorItemInfo("internalCompany.id"));
    }

    private void validateCompany(Context ctx, Object[] pks, String unitId, Map params) throws BOSException, EASBizException {
        if (this.properties == null || this.properties.length == 0) {
            return;
        }
        String[] propertiesToCheck = new String[]{"email"};
        this.checkLength(propertiesToCheck, 80);
        String[] propertiesToCheck2 = new String[]{"contactPerson", "phone", "contactPersonPost"};
        this.checkLength(propertiesToCheck2, 60);
        String[] propertiesToCheck3 = new String[]{"fax", "mobile"};
        this.checkLength(propertiesToCheck3, 40);
        this.checkLength(new String[]{"postalcode"}, 10);
        HashMap<Object, CustomerSupplierException> exceptionMap = new HashMap<Object, CustomerSupplierException>();
        StringBuilder sqlParams = new StringBuilder();
        for (int i = 0; i < pks.length; ++i) {
            if (i > 0) {
                sqlParams.append(",");
            }
            sqlParams.append("?");
        }
        ResultSet comOrgNotFitSet = null;
        ResultSet statusNotFitSet = null;
        ResultSet customerSet = null;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            int i;
            int i2;
            int i3;
            con = EJBFactory.getConnection((Context)ctx);
            int customerCount = 0;
            int customerInfoCount = 0;
            int count = 0;
            ArrayList<String> customerList = new ArrayList<String>();
            ArrayList<String> companyInfoList = new ArrayList<String>();
            ArrayList currentIdList = new ArrayList();
            StringBuilder hasCustomerIdBuilder = new StringBuilder();
            hasCustomerIdBuilder.append(" select customer.fid, companyInfo.fid").append(" from T_BD_Customer customer").append(" inner join T_BD_CustomerCompanyInfo companyInfo on customer.fid = companyInfo.FCustomerId").append(" where customer.fid in(").append((CharSequence)sqlParams).append(")").append(" and companyInfo.FComOrgId = '").append(unitId).append("'");
            stmt = con.prepareStatement(hasCustomerIdBuilder.toString());
            for (int i4 = 0; i4 < pks.length; ++i4) {
                stmt.setString(i4 + 1, pks[i4].toString());
            }
            comOrgNotFitSet = stmt.executeQuery();
            CustomerSupplierException notDealCustomerException = new CustomerSupplierException(CustomerSupplierException.COMPANY_NOTDEAL_CUSTOMER, new String[]{""});
            while (comOrgNotFitSet.next()) {
                customerList.add(customerCount++, comOrgNotFitSet.getString(1));
                companyInfoList.add(customerInfoCount++, comOrgNotFitSet.getString(2));
            }
            for (i3 = 0; i3 < pks.length; ++i3) {
                if (customerList.contains(pks[i3])) continue;
                exceptionMap.put(pks[i3], notDealCustomerException);
            }
            for (i3 = 0; i3 < customerList.size(); ++i3) {
                BizCheckResult rs = BizCheckerUtil.hasDeal4Update((Context)ctx, (BOSUuid)BOSUuid.read((String)companyInfoList.get(i3).toString()));
                if (rs.isFound()) {
                    exceptionMap.put(customerList.get(i3), notDealCustomerException);
                    continue;
                }
                currentIdList.add(count++, customerList.get(i3));
            }
            StringBuilder statusBuilder = new StringBuilder();
            sqlParams.delete(0, sqlParams.length());
            int c = currentIdList.size();
            for (i2 = 0; i2 < c; ++i2) {
                if (i2 > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("?");
            }
            if (sqlParams.length() > 0) {
                statusBuilder.append(" select fid ").append(" from T_BD_Customer").append(" where fid in(").append((CharSequence)sqlParams).append(")").append(" and FUsedStatus =  2");
                stmt = con.prepareStatement(statusBuilder.toString());
                c = currentIdList.size();
                for (i2 = 0; i2 < c; ++i2) {
                    stmt.setString(i2 + 1, currentIdList.get(i2).toString());
                }
                statusNotFitSet = stmt.executeQuery();
                CustomerSupplierException freezedException = new CustomerSupplierException(CustomerSupplierException.CANNOT_UPDATE_ISFREEZED);
                while (statusNotFitSet.next()) {
                    exceptionMap.put(statusNotFitSet.getString(1), notDealCustomerException);
                }
            }
            for (i = 0; i < currentIdList.size(); ++i) {
                if (exceptionMap.containsKey(currentIdList.get(i).toString())) continue;
                this.uptIdList.add(companyInfoList.get(i).toString());
            }
            sqlParams.delete(0, sqlParams.length());
            c = exceptionMap.keySet().toArray().length;
            for (i = 0; i < c; ++i) {
                if (i > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("?");
            }
            if (sqlParams.length() > 0) {
                StringBuilder customerBuilder = new StringBuilder();
                customerBuilder.append(" select FNumber ").append(" from ").append(" T_BD_Customer ").append(" where fid in(").append((CharSequence)sqlParams).append(")");
                stmt = con.prepareStatement(customerBuilder.toString());
                int c2 = exceptionMap.keySet().toArray().length;
                for (int i5 = 0; i5 < c2; ++i5) {
                    stmt.setString(i5 + 1, exceptionMap.keySet().toArray()[i5].toString());
                }
                customerSet = stmt.executeQuery();
                count = 0;
                while (customerSet.next()) {
                    CustomerSupplierException exception = new CustomerSupplierException(CustomerSupplierException.CUSTOMER_BATCH_FAILD, new String[]{customerSet.getString(1)});
                    this.log.addException(exception.getMessage(), (Exception)exceptionMap.get(exceptionMap.keySet().toArray()[count++]));
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(comOrgNotFitSet);
                SQLUtils.cleanup(statusNotFitSet);
                SQLUtils.cleanup(customerSet);
                SQLUtils.cleanup(stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)comOrgNotFitSet);
        SQLUtils.cleanup(statusNotFitSet);
        SQLUtils.cleanup(customerSet);
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
    }

    private void validateCompany(Context ctx, IObjectPK pk, String unitId, Map params) throws BOSException {
        if (this.properties == null || this.properties.length == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)pk.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)unitId, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        view.setFilter(filter);
        ICustomerCompanyInfo ie = CustomerCompanyInfoFactory.getLocalInstance(ctx);
        this.putCompanySelectors(view.getSelector());
        CustomerCompanyInfoCollection ls = ie.getCustomerCompanyInfoCollection(view);
        if (ls != null && ls.size() != 0) {
            CustomerCompanyInfoInfo info = ls.get(0);
            String pn = null;
            if (this.values != null && this.values instanceof Map) {
                Map cv = (Map)this.values;
                int size = this.properties.length;
                for (int i = 0; i < size; ++i) {
                    pn = this.properties[i].toString();
                    Object object = info.get(pn);
                    if (object instanceof CoreBaseInfo) {
                        ((CoreBaseInfo)object).setId(BOSUuid.read((String)cv.get(pn).toString()));
                    }
                    info.put(pn, object);
                }
            }
            try {
                this.uptIdList.add(info.getId().toString());
            }
            catch (Exception ex) {
                CustomerSupplierException exception = new CustomerSupplierException(CustomerSupplierException.CUSTOMER_BATCH_FAILD, new String[]{info.getCustomer().getNumber()});
                this.log.addException(exception.getMessage(), ex);
            }
        } else {
            CustomerInfo customerInfo = null;
            try {
                customerInfo = CustomerFactory.getLocalInstance(ctx).getCustomerInfo(pk);
                throw new CustomerSupplierException(CustomerSupplierException.COMPANY_NOTDEAL_CUSTOMER, new String[]{customerInfo.getNumber()});
            }
            catch (Exception e) {
                CustomerSupplierException exception = new CustomerSupplierException(CustomerSupplierException.CUSTOMER_BATCH_FAILD, new String[]{customerInfo.getNumber()});
                this.log.addException(exception.getMessage(), e);
            }
        }
    }

    private void putCompanySelectors(SelectorItemCollection selectors) {
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("customer.id"));
        selectors.add(new SelectorItemInfo("customer.number"));
        selectors.add(new SelectorItemInfo("customer.usedStatus"));
        selectors.add(new SelectorItemInfo("companyOrgUnit.id"));
        selectors.add(new SelectorItemInfo("cu.id"));
        selectors.add(new SelectorItemInfo("effectedStatus"));
        selectors.add(new SelectorItemInfo("accountingClassfication"));
        selectors.add(new SelectorItemInfo("settlementCurrency.id"));
    }

    private void validateSale(Context ctx, Object[] pks, String unitId, Map params) throws BOSException, EASBizException {
        if (this.properties == null || this.properties.length == 0) {
            return;
        }
        HashMap<Object, CustomerSupplierException> exceptionMap = new HashMap<Object, CustomerSupplierException>();
        StringBuilder sqlParams = new StringBuilder();
        for (int i = 0; i < pks.length; ++i) {
            this.validateSale(ctx, (IObjectPK)new ObjectUuidPK(pks[i].toString()), unitId, params, exceptionMap);
            if (i > 0) {
                sqlParams.append(",");
            }
            sqlParams.append("?");
        }
        ResultSet saleOrgNotFitSet = null;
        ResultSet statusNotFitSet = null;
        ResultSet customerSet = null;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            int i;
            int i2;
            con = EJBFactory.getConnection((Context)ctx);
            int customerCount = 0;
            int customerInfoCount = 0;
            int count = 0;
            ArrayList<String> customerList = new ArrayList<String>();
            ArrayList<String> saleInfoList = new ArrayList<String>();
            ArrayList currentIdList = new ArrayList();
            StringBuilder hasCustomerIdBuilder = new StringBuilder();
            hasCustomerIdBuilder.append(" select customer.fid, saleInfo.fid").append(" from T_BD_Customer customer").append(" inner join T_BD_CustomerSaleInfo saleInfo on customer.fid = saleInfo.FCustomerId").append(" where customer.fid in(").append(sqlParams.toString()).append(")").append(" and saleInfo.FSaleOrgId = '").append(unitId).append("'");
            stmt = con.prepareStatement(hasCustomerIdBuilder.toString());
            for (int i3 = 0; i3 < pks.length; ++i3) {
                stmt.setString(i3 + 1, pks[i3].toString());
            }
            saleOrgNotFitSet = stmt.executeQuery();
            while (saleOrgNotFitSet.next()) {
                customerList.add(customerCount++, saleOrgNotFitSet.getString(1));
                saleInfoList.add(customerInfoCount++, saleOrgNotFitSet.getString(2));
            }
            CustomerSupplierException hasDealException = new CustomerSupplierException(CustomerSupplierException.CANNOT_MODIFY_HASDEAL);
            for (int i4 = 0; i4 < customerList.size(); ++i4) {
                BizCheckResult rs = BizCheckerUtil.hasDeal4Update((Context)ctx, (BOSUuid)BOSUuid.read((String)saleInfoList.get(i4).toString()));
                if (rs.isFound()) {
                    exceptionMap.put(customerList.get(i4), hasDealException);
                    continue;
                }
                currentIdList.add(count++, customerList.get(i4));
            }
            StringBuilder statusBuilder = new StringBuilder();
            sqlParams.delete(0, sqlParams.length());
            int c = currentIdList.size();
            for (i2 = 0; i2 < c; ++i2) {
                if (i2 > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("?");
            }
            if (sqlParams.length() > 0) {
                statusBuilder.append(" select fid ").append(" from T_BD_Customer").append(" where fid in(").append((CharSequence)sqlParams).append(")").append(" and FUsedStatus =  2");
                stmt = con.prepareStatement(statusBuilder.toString());
                c = currentIdList.size();
                for (i2 = 0; i2 < c; ++i2) {
                    stmt.setString(i2 + 1, currentIdList.get(i2).toString());
                }
                statusNotFitSet = stmt.executeQuery();
                CustomerSupplierException freezedException = new CustomerSupplierException(CustomerSupplierException.CANNOT_UPDATE_ISFREEZED);
                while (statusNotFitSet.next()) {
                    exceptionMap.put(statusNotFitSet.getString(1), freezedException);
                }
                for (i = 0; i < currentIdList.size(); ++i) {
                    if (exceptionMap.containsKey(currentIdList.get(i).toString())) continue;
                    this.uptIdList.add(saleInfoList.get(i).toString());
                }
            }
            sqlParams.delete(0, sqlParams.length());
            c = exceptionMap.keySet().toArray().length;
            for (int i5 = 0; i5 < c; ++i5) {
                if (i5 > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("?");
            }
            if (sqlParams.length() > 0) {
                StringBuilder customerBuilder = new StringBuilder();
                customerBuilder.append(" select FNumber ").append(" from ").append(" T_BD_Customer ").append(" where fid in(").append((CharSequence)sqlParams).append(")");
                stmt = con.prepareStatement(customerBuilder.toString());
                int c2 = exceptionMap.keySet().toArray().length;
                for (i = 0; i < c2; ++i) {
                    stmt.setString(i + 1, exceptionMap.keySet().toArray()[i].toString());
                }
                customerSet = stmt.executeQuery();
                count = 0;
                while (customerSet.next()) {
                    CustomerSupplierException exception = new CustomerSupplierException(CustomerSupplierException.CUSTOMER_BATCH_FAILD, new String[]{customerSet.getString(1)});
                    this.log.addException(exception.getMessage(), (Exception)exceptionMap.get(exceptionMap.keySet().toArray()[count++]));
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(saleOrgNotFitSet);
                SQLUtils.cleanup(statusNotFitSet);
                SQLUtils.cleanup(customerSet);
                SQLUtils.cleanup(stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)saleOrgNotFitSet);
        SQLUtils.cleanup(statusNotFitSet);
        SQLUtils.cleanup(customerSet);
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
    }

    private void validateSale(Context ctx, IObjectPK pk, String unitId, Map params, Map exceptionMap) throws BOSException {
        if (this.properties == null || this.properties.length == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)pk.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)unitId, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        view.setFilter(filter);
        ICustomerSaleInfo ie = CustomerSaleInfoFactory.getLocalInstance(ctx);
        this.putSaleSelectors(view.getSelector());
        CustomerSaleInfoCollection ls = ie.getCustomerSaleInfoCollection(view);
        if (ls != null && ls.size() != 0) {
            CustomerSaleInfoInfo info = ls.get(0);
            String pn = null;
            if (this.values != null && this.values instanceof Map) {
                int size = this.properties.length;
                for (int i = 0; i < size; ++i) {
                    pn = this.properties[i].toString();
                    info.put(pn, ((Map)this.values).get(pn));
                }
            }
            try {
                this.uptIdList.add(info.getId().toString());
            }
            catch (Exception ex) {
                exceptionMap.put(pk.toString(), ex);
            }
        } else {
            CustomerInfo customerInfo = null;
            try {
                customerInfo = CustomerFactory.getLocalInstance(ctx).getCustomerInfo(pk);
                throw new CustomerSupplierException(CustomerSupplierException.SALEORG_NOTDEAL_CUSTOMER, new String[]{customerInfo.getNumber()});
            }
            catch (Exception e) {
                CustomerSupplierException exception = new CustomerSupplierException(CustomerSupplierException.CUSTOMER_BATCH_FAILD, new String[]{customerInfo.getNumber()});
                this.log.addException(exception.getMessage(), e);
            }
        }
    }

    private void putSaleSelectors(SelectorItemCollection selectors) {
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("customer.id"));
        selectors.add(new SelectorItemInfo("customer.number"));
        selectors.add(new SelectorItemInfo("customer.usedStatus"));
        selectors.add(new SelectorItemInfo("saleOrgUnit.id"));
        selectors.add(new SelectorItemInfo("cu.id"));
        selectors.add(new SelectorItemInfo("effectedStatus"));
        selectors.add(new SelectorItemInfo("taxRate"));
    }

    @Override
    protected void executeUpdate(Context ctx) throws BOSException {
        super.executeUpdate(ctx);
        if (this.uptIdList == null || this.uptIdList.size() == 0 || this.values == null || !(this.values instanceof Map) || this.entity == null) {
            return;
        }
        ArrayList ls = new ArrayList();
        ls.addAll(((Map)this.values).values());
        ls.addAll(this.uptIdList);
        String tempSql = this.entity.createUpdateSQlCommand();
        if (tempSql.indexOf("FBrowseGroupID") != -1) {
            StringBuffer strBuffer = new StringBuffer();
            strBuffer.append(" update T_BD_CustomerGroupDetail set FCustomerGroupID = ? ");
            strBuffer.append(" where FCustomerGroupStandardID in (select FID from T_BD_CSSPGroupStandard where FIsBasic = 1 )");
            strBuffer.append(" and  FCustomerID in (");
            int size = this.uptIdList.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    strBuffer.append(",");
                }
                strBuffer.append("?");
            }
            strBuffer.append(")");
            super.execute(ctx, strBuffer.toString(), ls.toArray());
        }
    }

    protected void checkLength(String[] propertiesToCheck, int length) throws CustomerSupplierException {
        for (int i = 0; i < propertiesToCheck.length; ++i) {
            String propertiyToCheck = propertiesToCheck[i];
            if (!propertiyToCheck.equals(this.properties[0].toString()) || ((String)((Map)this.values).get(this.properties[0].toString())).length() <= length) continue;
            throw new CustomerSupplierException(CustomerSupplierException.VALUETOOLARGE);
        }
    }
}

