/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.base.core.util.EqualsUtil;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.assistant.PayConditionInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.cssp.util.CsspUtils;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CustomerCompanyDataImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.cssp.app.CustomerCompanyDataImport");
    private static final String CSSPResource = "com.kingdee.eas.basedata.master.cssp.CSSPResource";
    String[] BOOLEAN_FIELDS = new String[]{"FIsTicketFreezed"};
    String[] BOOLEAN_OBJS = new String[]{"isFreezeIssueInvoice"};
    String[] STRING_FIELDS = new String[]{"FContactPerson", "FContactPersonPost", "FPhone", "FMobile", "FFax", "FEMail", "FPostalcode"};
    String[] STRING_OBJS = new String[]{"contactPerson", "contactPersonPost", "phone", "mobile", "fax", "email", "postalcode"};
    private Set PerminsionCheckedCuIds = new HashSet();
    private boolean coverImportCompanyBank = false;
    CustomerCompanyInfoInfo oldBaseInfo;
    private Map<String, Boolean> userBizOrgRange = new HashMap<String, Boolean>();

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        boolean rs = false;
        if (firstData != null && currentData != null) {
            String firstMainField = StringUtil.cnulls(firstData.get(this.getMainField()));
            String currentMainField = StringUtil.cnulls(currentData.get(this.getMainField()));
            String firstMainFieldOrg = StringUtil.cnulls(firstData.get("FComOrgID"));
            String currentMainFieldOrg = StringUtil.cnulls(currentData.get("FComOrgID"));
            if (firstMainField.isEmpty() && currentMainField.isEmpty()) {
                rs = false;
            } else if (firstMainField.equals(currentMainField) && firstMainFieldOrg.equals(currentMainFieldOrg)) {
                rs = true;
            }
        }
        return rs;
    }

    public boolean isSameBlock(Map firstData, Map currentData) {
        return this.isSameBlock(this.convertMap(firstData), this.convertMap(currentData));
    }

    public String getMainField() {
        return "FNumber";
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CustomerCompanyInfoFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase iCustomerCompanyInfo = this.getController(ctx);
        this.oldBaseInfo = (CustomerCompanyInfoInfo)coreBaseInfo;
        coreBaseInfo.put("isImport", (Object)"true");
        try {
            if (coreBaseInfo.getId() == null || !iCustomerCompanyInfo.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                ((CustomerCompanyInfoInfo)coreBaseInfo).setCreateTime(null);
                iCustomerCompanyInfo.submit(coreBaseInfo);
            } else {
                iCustomerCompanyInfo.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable tableData, Context ctx) throws TaskExternalException {
        try {
            this.coverImportCompanyBank = DataImportUtils.getCoverImportCompanyBank(ctx);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        CustomerCompanyInfoInfo customerCompanyInfo = new CustomerCompanyInfoInfo();
        int size = tableData.size();
        Hashtable hsData = null;
        try {
            hsData = (Hashtable)tableData.get(0);
            if (hsData == null) {
                hsData = tableData;
                customerCompanyInfo = this.parseHead(ctx, hsData, customerCompanyInfo);
                customerCompanyInfo = this.parseEntry(hsData, customerCompanyInfo, ctx);
            } else {
                customerCompanyInfo = this.parseHead(ctx, hsData, customerCompanyInfo);
                for (int i = 0; i < size; ++i) {
                    customerCompanyInfo = this.parseEntry(tableData, customerCompanyInfo, ctx);
                }
            }
            return customerCompanyInfo;
        }
        catch (BOSException ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        catch (EASBizException ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    private CustomerCompanyInfoInfo parseEntry(Hashtable tableData, CustomerCompanyInfoInfo customerCompanyInfo, Context ctx) throws EASBizException, BOSException, TaskExternalException {
        CustomerCompanyBankCollection banks = customerCompanyInfo.getCustomerBank();
        if (this.coverImportCompanyBank) {
            banks.clear();
        }
        if (tableData.get(0) == null) {
            String number = (String)this.getData(tableData, "FBankAccount");
            if (number != null && number.trim().length() > 0) {
                Object data;
                CountryInfo info;
                CustomerCompanyBankInfo bankInfo = new CustomerCompanyBankInfo();
                bankInfo.setCustomerCompanyInfo(customerCompanyInfo);
                bankInfo.setBankAccount(number);
                bankInfo.setBankAddress((String)this.getData(tableData, "FBankAddress"));
                bankInfo.setBank((String)this.getData(tableData, "FBank"));
                bankInfo.setCurrency((String)this.getData(tableData, "FCurrency"));
                bankInfo.setOpenArea((String)this.getData(tableData, "FOpenArea"));
                bankInfo.setAccountName((String)this.getData(tableData, "FAccountName"));
                bankInfo.setBankEngName((String)this.getData(tableData, "FBankEngName"));
                bankInfo.setBeneficiary((String)this.getData(tableData, "FBeneficiary"));
                bankInfo.setBeneficiaryEngName((String)this.getData(tableData, "FBeneficiaryEngName"));
                bankInfo.setBeneficiaryBankCode((String)this.getData(tableData, "FBeneficiaryBankCode"));
                bankInfo.setBeneficiaryAddr((String)this.getData(tableData, "FBeneficiaryAddr"));
                bankInfo.setBeneficiaryBankCountryISO((String)this.getData(tableData, "FBeneficiaryBankCountryISO"));
                bankInfo.setBeneficiaryBankSWIFT((String)this.getData(tableData, "FBeneficiaryBankSWIFT"));
                bankInfo.setSettlementParam((String)this.getData(tableData, "FSettlementParam"));
                bankInfo.setAgencyBankAccount((String)this.getData(tableData, "FAgencyBankAccount"));
                bankInfo.setAgencyBankName((String)this.getData(tableData, "FAgencyBankName"));
                bankInfo.setAgencybankSWIFT((String)this.getData(tableData, "FAgencybankSWIFT"));
                bankInfo.setAgencyBankCountryISO((String)this.getData(tableData, "FAgencyBankCountryISO"));
                bankInfo.setAgencyBankAddr((String)this.getData(tableData, "FAgencyBankAddr"));
                if (tableData.get("FBeneficiaryBankCountryID_number") != null && (info = DataImportUtils.getCountryInfoFromNumber(ctx, (data = ((DataToken)tableData.get((Object)"FBeneficiaryBankCountryID_number")).data).toString())) != null) {
                    bankInfo.setBeneficiaryBankCountryID(info);
                }
                if (tableData.get("FAgencyBankCountryID_number") != null && (info = DataImportUtils.getCountryInfoFromNumber(ctx, (data = ((DataToken)tableData.get((Object)"FAgencyBankCountryID_number")).data).toString())) != null) {
                    bankInfo.setAgencyBankCountryID(info);
                }
                if (this.oldBaseInfo != null && EqualsUtil.equals((Object)this.oldBaseInfo.getCustomer(), (Object)customerCompanyInfo.getCustomer()) && EqualsUtil.equals((Object)this.oldBaseInfo.getCompanyOrgUnit(), (Object)customerCompanyInfo.getCompanyOrgUnit())) {
                    customerCompanyInfo = this.oldBaseInfo;
                }
                this.checkHasBeBank(ctx, bankInfo);
                if (this.coverImportCompanyBank) {
                    if (banks != null) {
                        banks.add(bankInfo);
                    }
                } else {
                    this.addBank(customerCompanyInfo, bankInfo);
                }
            }
        } else {
            for (int i = 0; i < tableData.size(); ++i) {
                Object data;
                CountryInfo info;
                Hashtable hsData = (Hashtable)tableData.get(i);
                String number = (String)this.getData(hsData, "FBankAccount");
                if (number == null || number.trim().length() <= 0) continue;
                CustomerCompanyBankInfo bankInfo = new CustomerCompanyBankInfo();
                bankInfo.setCustomerCompanyInfo(customerCompanyInfo);
                bankInfo.setBankAccount(number);
                bankInfo.setBankAddress((String)this.getData(hsData, "FBankAddress"));
                bankInfo.setBank((String)this.getData(hsData, "FBank"));
                bankInfo.setCurrency((String)this.getData(hsData, "FCurrency"));
                bankInfo.setOpenArea((String)this.getData(hsData, "FOpenArea"));
                bankInfo.setAccountName((String)this.getData(hsData, "FAccountName"));
                bankInfo.setBankEngName((String)this.getData(hsData, "FBankEngName"));
                bankInfo.setBeneficiary((String)this.getData(hsData, "FBeneficiary"));
                bankInfo.setBeneficiaryEngName((String)this.getData(hsData, "FBeneficiaryEngName"));
                bankInfo.setBeneficiaryBankCode((String)this.getData(hsData, "FBeneficiaryBankCode"));
                bankInfo.setBeneficiaryAddr((String)this.getData(hsData, "FBeneficiaryAddr"));
                bankInfo.setBeneficiaryBankCountryISO((String)this.getData(hsData, "FBeneficiaryBankCountryISO"));
                bankInfo.setBeneficiaryBankSWIFT((String)this.getData(hsData, "FBeneficiaryBankSWIFT"));
                bankInfo.setSettlementParam((String)this.getData(hsData, "FSettlementParam"));
                bankInfo.setAgencyBankAccount((String)this.getData(hsData, "FAgencyBankAccount"));
                bankInfo.setAgencyBankName((String)this.getData(hsData, "FAgencyBankName"));
                bankInfo.setAgencybankSWIFT((String)this.getData(hsData, "FAgencybankSWIFT"));
                bankInfo.setAgencyBankCountryISO((String)this.getData(hsData, "FAgencyBankCountryISO"));
                bankInfo.setAgencyBankAddr((String)this.getData(hsData, "FAgencyBankAddr"));
                if (hsData.get("FBeneficiaryBankCountryID_number") != null && (info = DataImportUtils.getCountryInfoFromNumber(ctx, (data = ((DataToken)hsData.get((Object)"FBeneficiaryBankCountryID_number")).data).toString())) != null) {
                    bankInfo.setBeneficiaryBankCountryID(info);
                }
                if (hsData.get("FAgencyBankCountryID_number") != null && (info = DataImportUtils.getCountryInfoFromNumber(ctx, (data = ((DataToken)hsData.get((Object)"FAgencyBankCountryID_number")).data).toString())) != null) {
                    bankInfo.setAgencyBankCountryID(info);
                }
                if (this.oldBaseInfo != null && EqualsUtil.equals((Object)this.oldBaseInfo.getCustomer(), (Object)customerCompanyInfo.getCustomer()) && EqualsUtil.equals((Object)this.oldBaseInfo.getCompanyOrgUnit(), (Object)customerCompanyInfo.getCompanyOrgUnit())) {
                    customerCompanyInfo = this.oldBaseInfo;
                }
                this.checkHasBeBank(ctx, bankInfo);
                if (this.coverImportCompanyBank) {
                    if (banks == null) continue;
                    banks.add(bankInfo);
                    continue;
                }
                this.addBank(customerCompanyInfo, bankInfo);
            }
        }
        return customerCompanyInfo;
    }

    private void checkHasBeBank(Context ctx, CustomerCompanyBankInfo bankInfo) throws EASBizException, BOSException, TaskExternalException {
        Boolean isAllowedEnterBank = DataImportUtils.getIsAllowedEnterBank(ctx);
        try {
            BEBankCollection beBankCollection = DataImportUtils.getBEBankCollection(ctx, bankInfo.getBank());
            if (beBankCollection != null && beBankCollection.size() > 0) {
                BEBankInfo beBankInfo = beBankCollection.get(0);
                bankInfo.setBankID(beBankInfo.getId().toString());
                bankInfo.setBeneficiaryBankCode(beBankInfo.getNumber());
            } else if (!(isAllowedEnterBank.booleanValue() || beBankCollection != null && beBankCollection.size() > 0)) {
                throw new TaskExternalException(CsspUtils.convertStr(ResourceBase.getString((String)CSSPResource, (String)"CustomerCompanyDataImportMsg001", (Locale)ctx.getOriginLocale()), bankInfo.getBank()));
            }
        }
        catch (BOSException e) {
            logger.error((Object)"\u8d22\u52a1\u8d44\u6599\u5173\u8054\u94f6\u4f01\u9519\u8bef\uff01");
            throw new TaskExternalException(e.getMessage() + ResourceBase.getString((String)CSSPResource, (String)"CustomerCompanyDataImportMsg002", (Locale)ctx.getOriginLocale()), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CustomerCompanyInfoInfo parseHead(Context ctx, Hashtable hsData, CustomerCompanyInfoInfo customerCompanyInfo) throws BOSException, TaskExternalException, EASBizException {
        PaymentTypeInfo info;
        Object data = null;
        String str = null;
        CompanyOrgUnitInfo curCompany = null;
        if (hsData.get("FComOrgID") == null) throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "getCompanyOrgUnitFailed", ctx));
        data = ((DataToken)hsData.get((Object)"FComOrgID")).data;
        str = data.toString();
        curCompany = DataImportUtils.getCompanyOrgUnitInfoFromNumber(ctx, str);
        if (curCompany == null) {
            throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "getCompanyOrgUnitFailed", ctx));
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (!PerminsionUtil.isUserBizOrgRange((Context)ctx, (String)userId, (String)curCompany.getId().toString())) {
            throw new TaskExternalException(new MaterialBaseException(MaterialBaseException.OUT_BIZ_ORG, new Object[]{curCompany.getName()}).getMessage());
        }
        String CuId = curCompany.getCU().getId().toString();
        if (!this.PerminsionCheckedCuIds.contains(CuId)) {
            try {
                PerminsionUtil.checkCUPerminsion((Context)ctx, (String)CuId, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), (String)"Customercompanyinfo_Import");
            }
            catch (EASBizException ee) {
                throw new TaskExternalException(ee.getMessage(), (Throwable)ee);
            }
            this.PerminsionCheckedCuIds.add(CuId);
        }
        customerCompanyInfo.setCompanyOrgUnit(curCompany);
        customerCompanyInfo.setCU(curCompany.getCU());
        Object numberData = ((DataToken)hsData.get((Object)"FNumber")).data;
        if (numberData != null) {
            str = numberData.toString();
            if (str == null || str.trim().length() <= 0) throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "customerNotExist", ctx));
            CustomerInfo customerInfoFromNumber = DataImportUtils.getCustomerInfoFromNumber(ctx, curCompany.getCU(), str);
            if (super.isSltImportUpdate()) {
                if (customerInfoFromNumber == null) throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "customerNotExist", ctx));
                customerCompanyInfo.setCustomer(customerInfoFromNumber);
                ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
                CustomerCompanyInfoInfo oldCustomerCompanyInfo = iCustomer.getCustomerCompanyInfo((IObjectPK)new ObjectUuidPK(customerInfoFromNumber.getId()), (IObjectPK)new ObjectUuidPK(curCompany.getId()));
                if (oldCustomerCompanyInfo != null) {
                    customerCompanyInfo = oldCustomerCompanyInfo;
                }
            } else {
                if (customerInfoFromNumber == null) throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "customerNotExist", ctx));
                customerCompanyInfo.setCustomer(customerInfoFromNumber);
            }
        }
        customerCompanyInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        CustomerCompanyDataImport.setBooleanData(hsData, this.BOOLEAN_FIELDS, (CoreBaseInfo)customerCompanyInfo, this.BOOLEAN_OBJS);
        if (hsData.get("FPostalcode") != null && ((DataToken)hsData.get((Object)"FPostalcode")).data.toString().length() > 10) {
            throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "postZipCode", ctx));
        }
        DataImportUtils.setStringData(hsData, this.STRING_FIELDS, (CoreBaseInfo)customerCompanyInfo, this.STRING_OBJS);
        if (hsData.get("FPaymentTypeID") != null && (info = DataImportUtils.getPaymentTypeInfoFromNumber(ctx, str = (data = ((DataToken)hsData.get((Object)"FPaymentTypeID")).data).toString())) != null) {
            customerCompanyInfo.setPaymentType(info);
        }
        if (hsData.get("FSettlementCurrencyID") != null) {
            data = ((DataToken)hsData.get((Object)"FSettlementCurrencyID")).data;
            str = data.toString();
            info = DataImportUtils.getCurrencyInfoFromNumber(ctx, str);
            if (info == null) throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "SupplierCurrency", ctx));
            customerCompanyInfo.setSettlementCurrency((CurrencyInfo)info);
        }
        if (hsData.get("FSettlementTypeID") != null && (info = DataImportUtils.getSettlementTypeInfoFromNumber(ctx, str = (data = ((DataToken)hsData.get((Object)"FSettlementTypeID")).data).toString())) != null) {
            customerCompanyInfo.setSettlementType((SettlementTypeInfo)info);
        }
        if (hsData.get("FReceiveConditionID") != null && (info = DataImportUtils.getPayConditionInfoByNumber(ctx, str = (data = ((DataToken)hsData.get((Object)"FReceiveConditionID")).data).toString())) != null) {
            customerCompanyInfo.setPayCondition((PayConditionInfo)info);
        }
        if (hsData.get("FAdminOrgUnitID") != null && (info = DataImportUtils.getAdminOrgUnitByNumber(ctx, str = (data = ((DataToken)hsData.get((Object)"FAdminOrgUnitID")).data).toString())) != null) {
            customerCompanyInfo.setAdminOrgUnit((AdminOrgUnitInfo)info);
        }
        if (hsData.get("FAccountClassID") != null && (info = DataImportUtils.getKAClassficationInfoFromNumber(ctx, str = (data = ((DataToken)hsData.get((Object)"FAccountClassID")).data).toString(), curCompany, "customer")) != null) {
            customerCompanyInfo.setAccountingClassfication((KAClassficationInfo)info);
        }
        if (hsData.get("FFreezeOrgUnitID") != null && (info = DataImportUtils.getFullOrgUnitInfoFromNumber(ctx, str = (data = ((DataToken)hsData.get((Object)"FFreezeOrgUnitID")).data).toString())) != null) {
            customerCompanyInfo.setFreezeOrgUnit((FullOrgUnitInfo)info);
        }
        if (hsData.get("FOperationerID") != null && (info = DataImportUtils.getPersonInfoFromNumber(ctx, str = (data = ((DataToken)hsData.get((Object)"FOperationerID")).data).toString())) != null) {
            customerCompanyInfo.setOperationer((PersonInfo)info);
        }
        if ((data = ((DataToken)hsData.get((Object)"FStatus")).data) == null) return customerCompanyInfo;
        String value = data.toString();
        customerCompanyInfo.setUsingStatus(DataImportUtils.getCSSPAsstStatusValue(value));
        return customerCompanyInfo;
    }

    private void addBank(CustomerCompanyInfoInfo CustomerCompanyInfo2, CustomerCompanyBankInfo bankInfo) {
        CustomerCompanyBankCollection banks = CustomerCompanyInfo2.getCustomerBank();
        int exsistPos = -1;
        for (int i = 0; i < banks.size(); ++i) {
            CustomerCompanyBankInfo tempBank = banks.get(i);
            if (tempBank.getBankAccount() == null || bankInfo.getBankAccount() == null || !tempBank.getBankAccount().equals(bankInfo.getBankAccount())) continue;
            exsistPos = i;
        }
        if (exsistPos >= 0) {
            banks.set(exsistPos, bankInfo);
        } else {
            banks.add(bankInfo);
        }
    }

    public Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            String mutilName_BE = "FBeneficiaryBankCountryID_name_" + ContextUtils.getLocaleFromEnv().toString().toLowerCase();
            String mutilName_agency = "FAgencyBankCountryID_name_" + ContextUtils.getLocaleFromEnv().toString().toLowerCase();
            result.put("FNumber", DataImportUtils.transformValue(rs.getString("number")));
            result.put("FComOrgID", DataImportUtils.transformValue(rs.getString("orgUnit.number")));
            result.put("FIsTicketFreezed", DataImportUtils.transformValue(rs.getBoolean("customerCompany.isFreInvoice")));
            result.put("FPaymentTypeID", DataImportUtils.transformValue(rs.getString("paymentType.number")));
            result.put("FSettlementTypeID", DataImportUtils.transformValue(rs.getString("settlementType.number")));
            result.put("FSettlementCurrencyID", DataImportUtils.transformValue(rs.getString("currency.number")));
            result.put("FReceiveConditionID", DataImportUtils.transformValue(rs.getString("payCondition.number")));
            result.put("FAccountClassID", DataImportUtils.transformValue(rs.getString("kaClassfication.number")));
            result.put("FContactPerson", DataImportUtils.transformValue(rs.getString("customerCompany.contactPerson")));
            result.put("FContactPersonPost", DataImportUtils.transformValue(rs.getString("customerCompany.contactPerPost")));
            result.put("FPhone", DataImportUtils.transformValue(rs.getString("customerCompany.phone")));
            result.put("FFax", DataImportUtils.transformValue(rs.getString("customerCompany.fax")));
            result.put("FEMail", DataImportUtils.transformValue(rs.getString("customerCompany.email")));
            result.put("FPostalcode", DataImportUtils.transformValue(rs.getString("customerCompany.postalcode")));
            result.put("FBank", DataImportUtils.transformValue(rs.getString("CustomerC.bank")));
            result.put("FBankAccount", DataImportUtils.transformValue(rs.getString("CustomerC.bankAccount")));
            result.put("FBankAddress", DataImportUtils.transformValue(rs.getString("CustomerC.bankAddress")));
            result.put("FCurrency", DataImportUtils.transformValue(rs.getString("CustomerC.currency")));
            result.put("FOpenArea", DataImportUtils.transformValue(rs.getString("CustomerC.openArea")));
            result.put("FAccountName", DataImportUtils.transformValue(rs.getString("CustomerC.accountName")));
            result.put("FMobile", DataImportUtils.transformValue(rs.getString("customerCompany.mobile")));
            result.put("FCreatorNumber", DataImportUtils.transformValue(rs.getString("creator.number")));
            result.put("FCreateTime", DataImportUtils.getDateStrByLocale(ctx, rs.getDate("customerCompany.createTime")));
            result.put("FOperationerID", DataImportUtils.transformValue(rs.getString("operator.number")));
            result.put("FAdminOrgUnitID", DataImportUtils.transformValue(rs.getString("adminOrgUnit.number")));
            result.put("FStatus", DataImportUtils.transformValue(rs.getString("customerCompany.usingStatus")));
            result.put("FBankEngName", DataImportUtils.transformValue(rs.getString("CustomerC.bankEngName")));
            result.put("FBeneficiary", DataImportUtils.transformValue(rs.getString("CustomerC.beneficiary")));
            result.put("FBeneficiaryEngName", DataImportUtils.transformValue(rs.getString("CustomerC.beneficiaryEngName")));
            result.put("FBeneficiaryBankCode", DataImportUtils.transformValue(rs.getString("CustomerC.beneficiaryBankCode")));
            result.put("FBeneficiaryAddr", DataImportUtils.transformValue(rs.getString("CustomerC.beneficiaryAddr")));
            result.put("FBeneficiaryBankCountryID_number", DataImportUtils.transformValue(rs.getString("benBankCountry.number")));
            result.put("FBeneficiaryBankCountryISO", DataImportUtils.transformValue(rs.getString("CustomerC.beneficiaryBankCountryISO")));
            result.put("FBeneficiaryBankSWIFT", DataImportUtils.transformValue(rs.getString("CustomerC.beneficiaryBankSWIFT")));
            result.put(mutilName_BE, DataImportUtils.transformValue(rs.getString("benBankCountry.name")));
            result.put("FSettlementParam", DataImportUtils.transformValue(rs.getString("CustomerC.settlementParam")));
            result.put("FAgencyBankAccount", DataImportUtils.transformValue(rs.getString("CustomerC.agencyBankAccount")));
            result.put("FAgencyBankName", DataImportUtils.transformValue(rs.getString("CustomerC.agencyBankName")));
            result.put("FAgencybankSWIFT", DataImportUtils.transformValue(rs.getString("CustomerC.agencybankSWIFT")));
            result.put("FAgencyBankCountryID_number", DataImportUtils.transformValue(rs.getString("agencyBankCountry.number")));
            result.put(mutilName_agency, DataImportUtils.transformValue(rs.getString("agencyBankCountry.name")));
            result.put("FAgencyBankCountryISO", DataImportUtils.transformValue(rs.getString("CustomerC.agencyBankCountryISO")));
            result.put("FAgencyBankAddr", DataImportUtils.transformValue(rs.getString("CustomerC.agencyBankAddr")));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        ObjectUuidPK pk = null;
        try {
            ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
            pk = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
            filterInfo = iCustomer.getDatabaseDFilter((IObjectPK)pk, "id", "adminCU.id");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.cssp.app.CustomerExportCompanyQuery";
    }

    public static CoreBaseInfo setBooleanData(Hashtable hsData, String[] hsFieldNames, CoreBaseInfo info, String[] infoFieldNames) throws TaskExternalException {
        if (info == null) {
            return null;
        }
        Object o = null;
        String value = null;
        for (int i = 0; i < hsFieldNames.length; ++i) {
            o = ((DataToken)hsData.get((Object)hsFieldNames[i])).data;
            if (o != null && o.toString().trim().length() > 0) {
                value = o.toString();
                if (value == null) continue;
                info.setBoolean(infoFieldNames[i], DataImportUtils.getBooleanValue(value));
                continue;
            }
            if (!hsFieldNames[i].equals("FIsTicketFreezed")) continue;
            info.setBoolean(infoFieldNames[i], false);
        }
        return info;
    }
}

