/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.framework.util.FMQuerySqlBuilder;
import com.kingdee.eas.basedata.master.cssp.CSSPUtils;
import com.kingdee.eas.basedata.master.cssp.CustomerDeliveryAddressCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerDeliveryAddressInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ICustomerSaleInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.cssp.UsingStatusEnum;
import com.kingdee.eas.basedata.master.cssp.app.AbstractCustomerSaleInfoControllerBean;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Locale;

public class CustomerSaleInfoControllerBean
extends AbstractCustomerSaleInfoControllerBean {
    public static final int FREEZED_ORDER = 1;
    public static final int FREEZED_DELIVERY = 2;

    protected void checkIntegrity(Context ctx, CustomerSaleInfoInfo model) throws BOSException, EASBizException {
        if (model.getCU() == null) {
            throw new CustomerSupplierException(CustomerSupplierException.CU_IS_NULL);
        }
        if (model.getCustomer() == null) {
            throw new CustomerSupplierException(CustomerSupplierException.CUSTOMER_SALE_INFO_REF_NULL_CSBASE);
        }
        if (model.getSaleOrgUnit() == null) {
            throw new CustomerSupplierException(CustomerSupplierException.CUSTOMER_SALE_INFO_REF_NULL_SALE_ORG);
        }
    }

    protected void checkDuplicate(Context ctx, CustomerSaleInfoInfo model) throws BOSException, EASBizException {
        if (model.getCustomer().isIsMultiCopy()) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().clear();
        filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)model.getCustomer().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)model.getSaleOrgUnit().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        IObjectPK[] pks = this.getPKList(ctx, filter, null);
        if (pks.length > 0) {
            throw new CustomerSupplierException(CustomerSupplierException.CUSTOMER_SALEINFO_DUPLICATED, new Object[]{model.getCustomer().getName(), model.getSaleOrgUnit().getName(), ""});
        }
    }

    protected void addnewCheck(Context ctx, CustomerSaleInfoInfo model) throws BOSException, EASBizException {
        this.checkIntegrity(ctx, model);
        model.validate();
        if (model.getCustomer().getId() != null) {
            this.checkDuplicate(ctx, model);
        }
    }

    protected void afterAddnew(Context ctx, CustomerSaleInfoInfo model) throws BOSException, EASBizException {
    }

    private void handleOrderDeliveryFreeze(Context ctx, CustomerSaleInfoInfo model) throws BOSException, EASBizException {
        if (model.isIsFreezeOrder()) {
            this.changeCustomerSaleStatusNoUpdate(ctx, model, 1, true);
        }
        if (model.isIsFreezeDelivery()) {
            this.changeCustomerSaleStatusNoUpdate(ctx, model, 2, true);
        }
        if (!model.isIsFreezeOrder()) {
            this.checkUnFreezed2(ctx, model, 1, true);
            this.changeCustomerSaleStatusNoUpdate(ctx, model, 1, false);
        }
        if (!model.isIsFreezeDelivery()) {
            this.checkUnFreezed2(ctx, model, 2, true);
            this.changeCustomerSaleStatusNoUpdate(ctx, model, 2, false);
        }
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ((CustomerSaleInfoInfo)model).setEffectedStatus(EffectedStatusEnum.EFFECTED);
        this.addnewCheck(ctx, (CustomerSaleInfoInfo)model);
        this.handleOrderDeliveryFreeze(ctx, (CustomerSaleInfoInfo)model);
        super._submit(ctx, pk, model);
        CustomerSaleInfoInfo info = this.getCustomerSaleInfoInfo(ctx, pk, this.getSelector());
        model.put("logRecord", (Object)(((CustomerSaleInfoInfo)model).getCustomer().getName() + "  " + info.getSaleOrgUnit().getName()));
        this.afterAddnew(ctx, (CustomerSaleInfoInfo)model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ((CustomerSaleInfoInfo)model).setEffectedStatus(EffectedStatusEnum.EFFECTED);
        this.addnewCheck(ctx, (CustomerSaleInfoInfo)model);
        this.handleOrderDeliveryFreeze(ctx, (CustomerSaleInfoInfo)model);
        IObjectPK pk = super._submit(ctx, model);
        CustomerSaleInfoInfo info = this.getCustomerSaleInfoInfo(ctx, pk, this.getSelector());
        model.put("logRecord", (Object)(((CustomerSaleInfoInfo)model).getCustomer().getName() + "  " + info.getSaleOrgUnit().getName()));
        this.afterAddnew(ctx, (CustomerSaleInfoInfo)model);
        return pk;
    }

    @Override
    protected void _updateCheck(Context ctx, IObjectPK pk, IObjectValue value) throws BOSException, EASBizException {
        CustomerSaleInfoInfo model = (CustomerSaleInfoInfo)value;
        BizCheckResult rs = BizCheckerUtil.hasDeal4Update((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        if (rs.isFound()) {
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_MODIFY_HASDEAL);
        }
        if (model.getCustomer().getUsedStatus().equals((Object)UsedStatusEnum.FREEZED)) {
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_UPDATE_ISFREEZED);
        }
        this.checkIntegrity(ctx, model);
        model.validate();
        CustomerSaleInfoInfo old = this.getCustomerSaleInfoInfo(ctx, pk);
        if (!old.getCustomer().getId().toString().equals(model.getCustomer().getId().toString()) || !old.getSaleOrgUnit().getId().toString().equals(model.getSaleOrgUnit().getId().toString())) {
            this.checkDuplicate(ctx, model);
        }
        CustomerDeliveryAddressCollection deliveryAddressCollection = model.getDeliveryAddresses();
        for (int i = 0; i < deliveryAddressCollection.size(); ++i) {
            String address = deliveryAddressCollection.get(i).getAddress();
            if (StringUtils.isEmpty((String)address) || address.length() <= 500) continue;
            throw new CustomerSupplierException(CustomerSupplierException.ADDRESS_OUT_OF_RANGE);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CustomerSaleInfoInfo customerSaleInfoInfo = this.getCustomerSaleInfoInfo(ctx, pk);
        CustomerDeliveryAddressCollection collection = customerSaleInfoInfo.getDeliveryAddresses();
        int len = collection.size();
        for (int i = 0; i < len; ++i) {
            CustomerDeliveryAddressInfo address = collection.get(i);
            if (address == null || address.getId() == null) continue;
            ObjectUuidPK pkAddress = new ObjectUuidPK(address.getId());
            this._isReferenced(ctx, (IObjectPK)pkAddress);
        }
        BizCheckResult rs = BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        if (rs.isFound()) {
            throw rs.getException();
        }
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CustomerSaleInfoInfo info = (CustomerSaleInfoInfo)model;
        if (info.getSaleOrgUnit() != null && info.getSaleOrgUnit().getCU() != null) {
            info.setCU(info.getSaleOrgUnit().getCU());
        }
        ICustomerSaleInfo iCustomerSaleInfo = CustomerSaleInfoFactory.getLocalInstance(ctx);
        CustomerSaleInfoInfo oldInfo = iCustomerSaleInfo.getCustomerSaleInfoInfo(pk, this.getSelectors());
        info.setCreateTime(oldInfo.getCreateTime());
        info.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        this._updateCheck(ctx, pk, (IObjectValue)info);
        this.handleOrderDeliveryFreeze(ctx, (CustomerSaleInfoInfo)model);
        super._update(ctx, pk, model);
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("customer.number"));
        return sic;
    }

    protected void changeCustomerSaleStatus(Context ctx, IObjectPK customerPK, int freezedType, boolean isFreezed) throws EASBizException, BOSException {
        ICustomerSaleInfo iCustomerSaleInfo = CustomerSaleInfoFactory.getLocalInstance(ctx);
        CustomerSaleInfoInfo customerSaleInfoInfo = iCustomerSaleInfo.getCustomerSaleInfoInfo(customerPK);
        if (customerSaleInfoInfo == null) {
            return;
        }
        if (freezedType == 1) {
            customerSaleInfoInfo.setIsFreezeOrder(isFreezed);
            if (isFreezed) {
                customerSaleInfoInfo.setOrderFreezeOrgUnit(ContextUtil.getCurrentSaleUnit((Context)ctx).castToFullOrgUnitInfo());
            } else {
                customerSaleInfoInfo.setOrderFreezeOrgUnit(null);
            }
        } else if (freezedType == 2) {
            customerSaleInfoInfo.setIsFreezeDelivery(isFreezed);
            if (isFreezed) {
                customerSaleInfoInfo.setConsignFreezeOrgUnit(ContextUtil.getCurrentSaleUnit((Context)ctx).castToFullOrgUnitInfo());
            } else {
                customerSaleInfoInfo.setConsignFreezeOrgUnit(null);
            }
        }
        iCustomerSaleInfo.update(customerPK, (CoreBaseInfo)customerSaleInfoInfo);
    }

    protected void checkFreezed(Context ctx, IObjectPK customerPK, int freezedType, boolean isForceFreezed) throws BOSException, EASBizException {
        if (!isForceFreezed) {
            // empty if block
        }
    }

    protected void checkUnFreezed(Context ctx, IObjectPK customerPK, int freezedType, boolean isForceUnFreeze) throws BOSException, EASBizException {
        ICustomerSaleInfo iCustomerSaleInfo = CustomerSaleInfoFactory.getLocalInstance(ctx);
        CustomerSaleInfoInfo customerSaleInfoInfo = iCustomerSaleInfo.getCustomerSaleInfoInfo(customerPK, this.getSelector());
        if (customerSaleInfoInfo == null) {
            return;
        }
        ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
        CustomerInfo customerInfo = iCustomer.getCustomerInfo((IObjectPK)new ObjectUuidPK(customerSaleInfoInfo.getCustomer().getId()));
        if (customerInfo.getUsedStatus().getValue() == 2) {
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_UNFREE_BASEINFOIAFREEZED);
        }
        if (!isForceUnFreeze) {
            FullOrgUnitInfo freezedOrg = null;
            if (freezedType == 1) {
                freezedOrg = customerSaleInfoInfo.getOrderFreezeOrgUnit();
            } else if (freezedType == 2) {
                freezedOrg = customerSaleInfoInfo.getConsignFreezeOrgUnit();
            }
            if (customerInfo.getUsedStatus().getValue() == 1 && null != freezedOrg && !freezedOrg.equalsPK((IObjectValue)ContextUtil.getCurrentOrgUnit((Context)ctx))) {
                throw new CustomerSupplierException(CustomerSupplierException.CANNOT_ORDER_UNFREEZED);
            }
        }
    }

    @Override
    protected void _freezedOrder(Context ctx, IObjectPK pk, boolean isForceFreezed) throws BOSException, EASBizException {
        this.checkFreezed(ctx, pk, 1, isForceFreezed);
        this.changeCustomerSaleStatus(ctx, pk, 1, true);
    }

    @Override
    protected void _unFreezedOrder(Context ctx, IObjectPK pk, boolean isUnFreezed) throws BOSException, EASBizException {
        this.checkUnFreezed(ctx, pk, 1, isUnFreezed);
        this.changeCustomerSaleStatus(ctx, pk, 1, false);
    }

    @Override
    protected void _freezedSend(Context ctx, IObjectPK pk, boolean isForceFreezed) throws BOSException, EASBizException {
        this.checkFreezed(ctx, pk, 2, isForceFreezed);
        this.changeCustomerSaleStatus(ctx, pk, 2, true);
    }

    @Override
    protected void _unFreezedSend(Context ctx, IObjectPK pk, boolean isForceUnFree) throws BOSException, EASBizException {
        this.checkUnFreezed(ctx, pk, 2, isForceUnFree);
        this.changeCustomerSaleStatus(ctx, pk, 2, false);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selectorItems = new SelectorItemCollection();
        selectorItems.add(new SelectorItemInfo("*"));
        selectorItems.add(new SelectorItemInfo("saleOrgUnit.id"));
        selectorItems.add(new SelectorItemInfo("saleOrgUnit.name"));
        selectorItems.add(new SelectorItemInfo("saleOrgUnit.number"));
        selectorItems.add(new SelectorItemInfo("customer.id"));
        selectorItems.add(new SelectorItemInfo("customer.name"));
        selectorItems.add(new SelectorItemInfo("customer.number"));
        selectorItems.add(new SelectorItemInfo("orderFreezeOrgUnit.id"));
        selectorItems.add(new SelectorItemInfo("orderFreezeOrgUnit.name"));
        selectorItems.add(new SelectorItemInfo("orderFreezeOrgUnit.number"));
        selectorItems.add(new SelectorItemInfo("consignFreezeOrgUnit.id"));
        selectorItems.add(new SelectorItemInfo("consignFreezeOrgUnit.name"));
        selectorItems.add(new SelectorItemInfo("consignFreezeOrgUnit.number"));
        selectorItems.add(new SelectorItemInfo("CU.id"));
        selectorItems.add(new SelectorItemInfo("CU.number"));
        selectorItems.add(new SelectorItemInfo("CU.name"));
        return selectorItems;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CustomerSaleInfoInfo info = this.getCustomerSaleInfoInfo(ctx, pk, this.getSelector());
        return info.getCustomer().getName() + "  " + info.getSaleOrgUnit().getName();
    }

    protected void _checkNameBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _checkNumberBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.changeStatus(ctx, new Object[]{((CustomerSaleInfoInfo)model).getId()}, UsingStatusEnum.FREEZED);
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.changeStatus(ctx, pks, UsingStatusEnum.FREEZED);
    }

    @Override
    protected void _cancelCancel(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.changeStatus(ctx, pks, UsingStatusEnum.USING);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.changeStatus(ctx, new Object[]{((CustomerSaleInfoInfo)model).getId()}, UsingStatusEnum.USING);
    }

    private void changeStatus(Context ctx, Object[] pks, UsingStatusEnum status) throws BOSException, EASBizException {
        String resName;
        String logItem;
        if (pks == null) {
            return;
        }
        String oql = " select id,customer.number,saleOrgUnit.name,cu,UsingStatus where id in " + CSSPUtils.getIdsSql(pks);
        CustomerSaleInfoCollection collection = this.getCustomerSaleInfoCollection(ctx, oql);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < collection.size(); ++i) {
            CustomerSaleInfoInfo info = collection.get(i);
            list.add(info.getCustomer() == null ? "" : info.getCustomer().getNumber());
            if (info.getCU().getId().equals((Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId())) continue;
            throw new CustomerSupplierException(CustomerSupplierException.UPDATE_OTHER_CU, new Object[]{info.getCustomer().getNumber() + " - " + info.getSaleOrgUnit().getName()});
        }
        if (UsingStatusEnum.USING.equals((Object)status)) {
            logItem = "bd_cssp_customer_sale_cancelCancel";
            resName = "CustomerSaleCancelCancel";
        } else {
            logItem = "bd_cssp_customer_sale_cancel";
            resName = "CustomerSaleCancel";
        }
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"changeStatus", (BOSObjectType)new CustomerSaleInfoInfo().getBOSType(), null, (String)Arrays.toString((Object[])list.toArray()), (String)logItem, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)resName, (Locale)ctx.getOriginLocale()));
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" update T_BD_CustomerSaleInfo ");
        sb.appendSql(" set FUsingStatus = ").appendSql(String.valueOf(status.getValue()));
        sb.appendSql(" ,flastupdateuserid='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',flastupdatetime=getdate() where fid in ").appendSql(CSSPUtils.getIdsSql(pks));
        sb.execute(ctx);
        ORMValueCacheService.getInstance().discardType(ctx, BOSObjectType.create((String)"26C00F09"));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    protected void _freezed(Context ctx, CustomerSaleInfoInfo info) throws BOSException, EASBizException {
        this.changeFreeze(ctx, new Object[]{info.getId()}, 1);
    }

    protected void _freezed(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.changeFreeze(ctx, pks, 1);
    }

    protected void _unFreezed(Context ctx, CustomerSaleInfoInfo info) throws BOSException, EASBizException {
        this.changeFreeze(ctx, new Object[]{info.getId()}, 0);
    }

    protected void _unFreezed(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.changeFreeze(ctx, pks, 0);
    }

    private void changeFreeze(Context ctx, Object[] pks, int isFreeze) throws BOSException, EASBizException {
        if (pks == null) {
            return;
        }
        String oql = " select id,customer.number,saleOrgUnit.name,cu,UsingStatus where id in " + CSSPUtils.getIdsSql(pks);
        CustomerSaleInfoCollection collection = this.getCustomerSaleInfoCollection(ctx, oql);
        for (int i = 0; i < collection.size(); ++i) {
            CustomerSaleInfoInfo info = collection.get(i);
            if (info.getCU().getId().equals((Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId())) continue;
            throw new CustomerSupplierException(CustomerSupplierException.UPDATE_OTHER_CU, new Object[]{info.getCustomer().getNumber() + " - " + info.getSaleOrgUnit().getName()});
        }
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" update T_BD_CustomerSaleInfo ");
        sb.appendSql(" set FIsFreezeOrder = ").appendSql(String.valueOf(isFreeze));
        sb.appendSql(" ,FIsFreezeDelivery = ").appendSql(String.valueOf(isFreeze));
        sb.appendSql(" where fid in ").appendSql(CSSPUtils.getIdsSql(pks));
        sb.execute(ctx);
    }

    protected void changeCustomerSaleStatusNoUpdate(Context ctx, CustomerSaleInfoInfo customerSaleInfoInfo, int freezedType, boolean isFreezed) throws EASBizException, BOSException {
        if (customerSaleInfoInfo == null) {
            return;
        }
        if (freezedType == 1) {
            customerSaleInfoInfo.setIsFreezeOrder(isFreezed);
            if (isFreezed) {
                customerSaleInfoInfo.setOrderFreezeOrgUnit(ContextUtil.getCurrentSaleUnit((Context)ctx).castToFullOrgUnitInfo());
            } else {
                customerSaleInfoInfo.setOrderFreezeOrgUnit(null);
            }
        } else if (freezedType == 2) {
            customerSaleInfoInfo.setIsFreezeDelivery(isFreezed);
            if (isFreezed) {
                customerSaleInfoInfo.setConsignFreezeOrgUnit(ContextUtil.getCurrentSaleUnit((Context)ctx).castToFullOrgUnitInfo());
            } else {
                customerSaleInfoInfo.setConsignFreezeOrgUnit(null);
            }
        }
    }

    private void checkUnFreezed2(Context ctx, CustomerSaleInfoInfo customerSaleInfoInfo, int freezedType, boolean isForceUnFreeze) throws BOSException, EASBizException {
        if (customerSaleInfoInfo == null) {
            return;
        }
        ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
        CustomerInfo customerInfo = iCustomer.getCustomerInfo((IObjectPK)new ObjectUuidPK(customerSaleInfoInfo.getCustomer().getId()));
        if (customerInfo.getUsedStatus().getValue() == 2) {
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_UNFREE_BASEINFOIAFREEZED);
        }
        if (!isForceUnFreeze) {
            FullOrgUnitInfo freezedOrg = null;
            if (freezedType == 1) {
                freezedOrg = customerSaleInfoInfo.getOrderFreezeOrgUnit();
            } else if (freezedType == 2) {
                freezedOrg = customerSaleInfoInfo.getConsignFreezeOrgUnit();
            }
            if (customerInfo.getUsedStatus().getValue() == 1 && null != freezedOrg && !freezedOrg.equalsPK((IObjectValue)ContextUtil.getCurrentOrgUnit((Context)ctx))) {
                throw new CustomerSupplierException(CustomerSupplierException.CANNOT_ORDER_UNFREEZED);
            }
        }
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        boolean isImport = "true".equals(model.getString("isImport"));
        if (!isImport) {
            return super.submit(ctx, model);
        }
        try {
            IObjectPK retValue = this._submit4Import(ctx, model);
            return retValue;
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
        catch (EASBizException ex0) {
            this.setRollbackOnly();
            throw ex0;
        }
    }

    public IObjectPK _submit4Import(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        ((CustomerSaleInfoInfo)model).setEffectedStatus(EffectedStatusEnum.EFFECTED);
        this.addnewCheck(ctx, (CustomerSaleInfoInfo)model);
        this.handleOrderDeliveryFreeze(ctx, (CustomerSaleInfoInfo)model);
        IObjectPK pk = null;
        if (model.getId() == null) {
            pk = this._addnew(ctx, (IObjectValue)model);
        } else {
            pk = new ObjectUuidPK(model.getId());
            this._update(ctx, pk, (IObjectValue)model);
        }
        this.afterAddnew(ctx, (CustomerSaleInfoInfo)model);
        return pk;
    }

    public IObjectPK addnew(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        ((CustomerSaleInfoInfo)model).setCreateTime(null);
        boolean isImport = "true".equals(model.getString("isImport"));
        if (!isImport) {
            return super.addnew(ctx, model);
        }
        try {
            return this._addnew(ctx, (IObjectValue)model);
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
        catch (EASBizException ex0) {
            this.setRollbackOnly();
            throw ex0;
        }
    }

    public void update(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        boolean isImport = "true".equals(model.getString("isImport"));
        if (!isImport) {
            super.update(ctx, pk, model);
            return;
        }
        try {
            this._update(ctx, pk, (IObjectValue)model);
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
        catch (EASBizException ex0) {
            this.setRollbackOnly();
            throw ex0;
        }
    }
}

