/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.batch.app.GeneralBatchUpdateStrategy;
import com.kingdee.eas.basedata.master.cssp.AbstractCustomerLinkManInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerDeliveryAddressCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerDeliveryAddressFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerDeliveryAddressInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerLinkManCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerLinkManFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerLinkManInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSalerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerSalerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSalerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomerSaleInfo;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CustomerSyncAssistStrategy
extends GeneralBatchUpdateStrategy {
    @Override
    protected void validateBizLogic(Context ctx, IObjectPK pk, Map params) throws BOSException, EASBizException {
    }

    @Override
    protected void validateBizLogic(Context ctx, Object[] pks, Map params) throws BOSException, EASBizException {
        Integer org = (Integer)params.get("orgtype");
        String unitId = null;
        if (params.get("orgvalue") != null) {
            unitId = params.get("orgvalue").toString();
        }
        List orgIdList = (List)params.get("orgIdList");
        if (org != null) {
            switch (org) {
                case 0: {
                    if (unitId == null) break;
                    this.validateCompany(ctx, orgIdList.toArray(), pks[0].toString(), params);
                    break;
                }
                case 2: {
                    if (unitId == null) break;
                    this.validateSale(ctx, orgIdList.toArray(), pks[0].toString(), params);
                }
            }
        }
    }

    private void validateCompany(Context ctx, Object[] orgIds, String customerId, Map params) throws BOSException, EASBizException {
        if (this.properties == null || this.properties.length == 0) {
            return;
        }
        String[] propertiesToCheck = new String[]{"email"};
        this.checkLength(propertiesToCheck, 80);
        String[] propertiesToCheck2 = new String[]{"contactPerson", "phone", "contactPersonPost"};
        this.checkLength(propertiesToCheck2, 60);
        String[] propertiesToCheck3 = new String[]{"fax", "mobile"};
        this.checkLength(propertiesToCheck3, 40);
        this.checkLength(new String[]{"postalcode"}, 10);
        HashMap<String, CustomerSupplierException> exceptionMap = new HashMap<String, CustomerSupplierException>();
        StringBuilder sqlParams = new StringBuilder();
        for (int i = 0; i < orgIds.length; ++i) {
            if (i > 0) {
                sqlParams.append(",");
            }
            sqlParams.append("?");
        }
        ResultSet comOrgNotFitSet = null;
        ResultSet statusNotFitSet = null;
        ResultSet customerSet = null;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            int i;
            int i2;
            con = EJBFactory.getConnection((Context)ctx);
            int customerCount = 0;
            int customerInfoCount = 0;
            int count = 0;
            ArrayList<String> customerList = new ArrayList<String>();
            ArrayList<String> companyInfoList = new ArrayList<String>();
            ArrayList currentIdList = new ArrayList();
            StringBuilder hasCustomerIdBuilder = new StringBuilder();
            hasCustomerIdBuilder.append(" select customer.fid, companyInfo.fid").append(" from T_BD_Customer customer").append(" inner join T_BD_CustomerCompanyInfo companyInfo on customer.fid = companyInfo.FCustomerId").append(" where companyInfo.FComOrgId in(").append(sqlParams.toString()).append(")").append(" and customer.fid = '").append(customerId).append("'");
            stmt = con.prepareStatement(hasCustomerIdBuilder.toString());
            for (int i3 = 0; i3 < orgIds.length; ++i3) {
                stmt.setString(i3 + 1, orgIds[i3].toString());
            }
            comOrgNotFitSet = stmt.executeQuery();
            CustomerSupplierException notDealCustomerException = new CustomerSupplierException(CustomerSupplierException.COMPANY_NOTDEAL_CUSTOMER, new String[]{""});
            while (comOrgNotFitSet.next()) {
                customerList.add(customerCount++, comOrgNotFitSet.getString(1));
                companyInfoList.add(customerInfoCount++, comOrgNotFitSet.getString(2));
            }
            if (!customerList.contains(customerId)) {
                exceptionMap.put(customerId, notDealCustomerException);
            }
            for (int i4 = 0; i4 < customerList.size(); ++i4) {
                BizCheckResult rs = BizCheckerUtil.hasDeal4Update((Context)ctx, (BOSUuid)BOSUuid.read((String)companyInfoList.get(i4).toString()));
                if (rs.isFound()) {
                    exceptionMap.put((String)customerList.get(i4), notDealCustomerException);
                    continue;
                }
                currentIdList.add(count++, customerList.get(i4));
            }
            StringBuilder statusBuilder = new StringBuilder();
            sqlParams.delete(0, sqlParams.length());
            int c = currentIdList.size();
            for (i2 = 0; i2 < c; ++i2) {
                if (i2 > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("?");
            }
            if (sqlParams.length() > 0) {
                statusBuilder.append(" select fid ").append(" from T_BD_Customer").append(" where fid in(").append(sqlParams.toString()).append(")").append(" and FUsedStatus =  2");
                stmt = con.prepareStatement(statusBuilder.toString());
                c = currentIdList.size();
                for (i2 = 0; i2 < c; ++i2) {
                    stmt.setString(i2 + 1, currentIdList.get(i2).toString());
                }
                statusNotFitSet = stmt.executeQuery();
                CustomerSupplierException freezedException = new CustomerSupplierException(CustomerSupplierException.CANNOT_UPDATE_ISFREEZED);
                while (statusNotFitSet.next()) {
                    exceptionMap.put(statusNotFitSet.getString(1), notDealCustomerException);
                }
            }
            for (i = 0; i < currentIdList.size(); ++i) {
                if (exceptionMap.containsKey(currentIdList.get(i).toString())) continue;
                this.uptIdList.add(companyInfoList.get(i).toString());
            }
            sqlParams.delete(0, sqlParams.length());
            c = exceptionMap.keySet().toArray().length;
            for (i = 0; i < c; ++i) {
                if (i > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("?");
            }
            if (sqlParams.length() > 0) {
                StringBuilder customerBuilder = new StringBuilder();
                customerBuilder.append(" select FNumber ").append(" from ").append(" T_BD_Customer ").append(" where fid in(").append(sqlParams.toString()).append(")");
                stmt = con.prepareStatement(customerBuilder.toString());
                int c2 = exceptionMap.keySet().toArray().length;
                for (int i5 = 0; i5 < c2; ++i5) {
                    stmt.setString(i5 + 1, exceptionMap.keySet().toArray()[i5].toString());
                }
                customerSet = stmt.executeQuery();
                count = 0;
                while (customerSet.next()) {
                    CustomerSupplierException exception = new CustomerSupplierException(CustomerSupplierException.CUSTOMER_BATCH_FAILD, new String[]{customerSet.getString(1)});
                    this.log.addException(exception.getMessage(), (Exception)exceptionMap.get(exceptionMap.keySet().toArray()[count++]));
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(comOrgNotFitSet);
                SQLUtils.cleanup(statusNotFitSet);
                SQLUtils.cleanup(customerSet);
                SQLUtils.cleanup(stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)comOrgNotFitSet);
        SQLUtils.cleanup(statusNotFitSet);
        SQLUtils.cleanup(customerSet);
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
    }

    private void validateCompany(Context ctx, IObjectPK pk, String unitId, Map params) throws BOSException {
        if (this.properties == null || this.properties.length == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)pk.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)unitId, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        view.setFilter(filter);
        ICustomerCompanyInfo ie = CustomerCompanyInfoFactory.getLocalInstance(ctx);
        this.putCompanySelectors(view.getSelector());
        CustomerCompanyInfoCollection ls = ie.getCustomerCompanyInfoCollection(view);
        if (ls != null && ls.size() != 0) {
            CustomerCompanyInfoInfo info = ls.get(0);
            String pn = null;
            if (this.values != null && this.values instanceof Map) {
                Map cv = (Map)this.values;
                int size = this.properties.length;
                for (int i = 0; i < size; ++i) {
                    pn = this.properties[i].toString();
                    Object object = info.get(pn);
                    if (object instanceof CoreBaseInfo) {
                        ((CoreBaseInfo)object).setId(BOSUuid.read((String)cv.get(pn).toString()));
                    }
                    info.put(pn, object);
                }
            }
            try {
                ie.updateCheck((IObjectPK)new ObjectStringPK(info.getId().toString()), (IObjectValue)info);
                this.uptIdList.add(info.getId().toString());
            }
            catch (Exception ex) {
                CustomerSupplierException exception = new CustomerSupplierException(CustomerSupplierException.CUSTOMER_BATCH_FAILD, new String[]{info.getCustomer().getNumber()});
                this.log.addException(exception.getMessage(), ex);
            }
        } else {
            CustomerInfo customerInfo = null;
            try {
                customerInfo = CustomerFactory.getLocalInstance(ctx).getCustomerInfo(pk);
                throw new CustomerSupplierException(CustomerSupplierException.COMPANY_NOTDEAL_CUSTOMER, new String[]{customerInfo.getNumber()});
            }
            catch (Exception e) {
                CustomerSupplierException exception = new CustomerSupplierException(CustomerSupplierException.CUSTOMER_BATCH_FAILD, new String[]{customerInfo.getNumber()});
                this.log.addException(exception.getMessage(), e);
            }
        }
    }

    private void putCompanySelectors(SelectorItemCollection selectors) {
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("customer.id"));
        selectors.add(new SelectorItemInfo("customer.number"));
        selectors.add(new SelectorItemInfo("customer.usedStatus"));
        selectors.add(new SelectorItemInfo("companyOrgUnit.id"));
        selectors.add(new SelectorItemInfo("cu.id"));
        selectors.add(new SelectorItemInfo("effectedStatus"));
        selectors.add(new SelectorItemInfo("accountingClassfication"));
        selectors.add(new SelectorItemInfo("settlementCurrency.id"));
    }

    private void validateSale(Context ctx, Object[] orgIds, String customerId, Map params) throws BOSException, EASBizException {
        if (this.properties == null || this.properties.length == 0) {
            return;
        }
        HashMap<Object, CustomerSupplierException> exceptionMap = new HashMap<Object, CustomerSupplierException>();
        StringBuilder sqlParams = new StringBuilder();
        for (int i = 0; i < orgIds.length; ++i) {
            if (i > 0) {
                sqlParams.append(",");
            }
            sqlParams.append("?");
        }
        ResultSet saleOrgNotFitSet = null;
        ResultSet statusNotFitSet = null;
        ResultSet customerSet = null;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            int i;
            int i2;
            con = EJBFactory.getConnection((Context)ctx);
            int customerCount = 0;
            int customerInfoCount = 0;
            int count = 0;
            ArrayList<String> customerList = new ArrayList<String>();
            ArrayList<String> saleInfoList = new ArrayList<String>();
            ArrayList currentIdList = new ArrayList();
            StringBuilder hasCustomerIdBuilder = new StringBuilder();
            hasCustomerIdBuilder.append(" select customer.fid, saleInfo.fid").append(" from T_BD_Customer customer").append(" inner join T_BD_CustomerSaleInfo saleInfo on customer.fid = saleInfo.FCustomerId").append(" where saleInfo.FSaleOrgId in(").append((CharSequence)sqlParams).append(")").append(" and  customer.fid = '").append(customerId).append("'");
            stmt = con.prepareStatement(hasCustomerIdBuilder.toString());
            for (int i3 = 0; i3 < orgIds.length; ++i3) {
                stmt.setString(i3 + 1, orgIds[i3].toString());
            }
            saleOrgNotFitSet = stmt.executeQuery();
            while (saleOrgNotFitSet.next()) {
                customerList.add(customerCount++, saleOrgNotFitSet.getString(1));
                saleInfoList.add(customerInfoCount++, saleOrgNotFitSet.getString(2));
            }
            CustomerSupplierException hasDealException = new CustomerSupplierException(CustomerSupplierException.CANNOT_MODIFY_HASDEAL);
            for (int i4 = 0; i4 < customerList.size(); ++i4) {
                BizCheckResult rs = BizCheckerUtil.hasDeal4Update((Context)ctx, (BOSUuid)BOSUuid.read((String)saleInfoList.get(i4).toString()));
                if (rs.isFound()) {
                    exceptionMap.put(customerList.get(i4), hasDealException);
                    continue;
                }
                currentIdList.add(count++, customerList.get(i4));
            }
            StringBuilder statusBuilder = new StringBuilder();
            sqlParams.delete(0, sqlParams.length());
            int c = currentIdList.size();
            for (i2 = 0; i2 < c; ++i2) {
                if (i2 > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("?");
            }
            if (sqlParams.length() > 0) {
                statusBuilder.append(" select fid ").append(" from T_BD_Customer").append(" where fid in(").append((CharSequence)sqlParams).append(")").append(" and FUsedStatus =  2");
                stmt = con.prepareStatement(statusBuilder.toString());
                c = currentIdList.size();
                for (i2 = 0; i2 < c; ++i2) {
                    stmt.setString(i2 + 1, currentIdList.get(i2).toString());
                }
                statusNotFitSet = stmt.executeQuery();
                CustomerSupplierException freezedException = new CustomerSupplierException(CustomerSupplierException.CANNOT_UPDATE_ISFREEZED);
                while (statusNotFitSet.next()) {
                    exceptionMap.put(statusNotFitSet.getString(1), freezedException);
                }
                for (i = 0; i < currentIdList.size(); ++i) {
                    if (exceptionMap.containsKey(currentIdList.get(i).toString())) continue;
                    this.uptIdList.add(saleInfoList.get(i).toString());
                }
            }
            sqlParams.delete(0, sqlParams.length());
            c = exceptionMap.keySet().toArray().length;
            for (int i5 = 0; i5 < c; ++i5) {
                if (i5 > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("?");
            }
            if (sqlParams.length() > 0) {
                StringBuilder customerBuilder = new StringBuilder();
                customerBuilder.append(" select FNumber ").append(" from ").append(" T_BD_Customer ").append(" where fid in(").append((CharSequence)sqlParams).append(")");
                stmt = con.prepareStatement(customerBuilder.toString());
                int c2 = exceptionMap.keySet().toArray().length;
                for (i = 0; i < c2; ++i) {
                    stmt.setString(i + 1, exceptionMap.keySet().toArray()[i].toString());
                }
                customerSet = stmt.executeQuery();
                count = 0;
                while (customerSet.next()) {
                    CustomerSupplierException exception = new CustomerSupplierException(CustomerSupplierException.CUSTOMER_BATCH_FAILD, new String[]{customerSet.getString(1)});
                    this.log.addException(exception.getMessage(), (Exception)exceptionMap.get(exceptionMap.keySet().toArray()[count++]));
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(saleOrgNotFitSet);
                SQLUtils.cleanup(statusNotFitSet);
                SQLUtils.cleanup(customerSet);
                SQLUtils.cleanup(stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)saleOrgNotFitSet);
        SQLUtils.cleanup(statusNotFitSet);
        SQLUtils.cleanup(customerSet);
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
    }

    private void validateSale(Context ctx, IObjectPK pk, String unitId, Map params, Map exceptionMap) throws BOSException {
        if (this.properties == null || this.properties.length == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)pk.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)unitId, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        view.setFilter(filter);
        ICustomerSaleInfo ie = CustomerSaleInfoFactory.getLocalInstance(ctx);
        this.putSaleSelectors(view.getSelector());
        CustomerSaleInfoCollection ls = ie.getCustomerSaleInfoCollection(view);
        if (ls != null && ls.size() != 0) {
            CustomerSaleInfoInfo info = ls.get(0);
            String pn = null;
            if (this.values != null && this.values instanceof Map) {
                int size = this.properties.length;
                for (int i = 0; i < size; ++i) {
                    pn = this.properties[i].toString();
                    info.put(pn, ((Map)this.values).get(pn));
                }
            }
            try {
                ie.updateCheck((IObjectPK)new ObjectStringPK(info.getId().toString()), (IObjectValue)info);
                this.uptIdList.add(info.getId().toString());
            }
            catch (Exception ex) {
                exceptionMap.put(pk.toString(), ex);
            }
        } else {
            CustomerInfo customerInfo = null;
            try {
                customerInfo = CustomerFactory.getLocalInstance(ctx).getCustomerInfo(pk);
                throw new CustomerSupplierException(CustomerSupplierException.SALEORG_NOTDEAL_CUSTOMER, new String[]{customerInfo.getNumber()});
            }
            catch (Exception e) {
                CustomerSupplierException exception = new CustomerSupplierException(CustomerSupplierException.CUSTOMER_BATCH_FAILD, new String[]{customerInfo.getNumber()});
                this.log.addException(exception.getMessage(), e);
            }
        }
    }

    private void putSaleSelectors(SelectorItemCollection selectors) {
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("customer.id"));
        selectors.add(new SelectorItemInfo("customer.number"));
        selectors.add(new SelectorItemInfo("customer.usedStatus"));
        selectors.add(new SelectorItemInfo("saleOrgUnit.id"));
        selectors.add(new SelectorItemInfo("cu.id"));
        selectors.add(new SelectorItemInfo("effectedStatus"));
        selectors.add(new SelectorItemInfo("taxRate"));
    }

    @Override
    protected void executeUpdate(Context ctx) throws BOSException {
        boolean isEntry = false;
        boolean isCompanyInfoEntryFlag = false;
        boolean isSaleInfoEntryFlag = false;
        if (this.values != null && this.values instanceof Map) {
            CoreBaseCollection addressCollection;
            Serializable address;
            CustomerSaleInfoInfo customerSaleInfo;
            CoreBaseCollection customerSaleCollection;
            String linkManSql;
            int j;
            int i;
            String oql;
            Serializable bank;
            AbstractObjectCollection collection;
            Set set = ((Map)this.values).keySet();
            StringBuffer ids = new StringBuffer();
            for (Object obj : this.uptIdList) {
                ids.append("'" + obj + "'");
                ids.append(",");
            }
            if (ids.lastIndexOf(",") != -1) {
                ids.deleteCharAt(ids.lastIndexOf(","));
            }
            if (set.contains("customerBank")) {
                collection = (CustomerCompanyBankCollection)((Object)((Map)this.values).get("customerBank"));
                StringBuffer bankIds = new StringBuffer();
                for (int i2 = 0; i2 < collection.size(); ++i2) {
                    bank = collection.get(i2);
                    bankIds.append("'" + bank.getId().toString() + "'");
                    bankIds.append(",");
                }
                if (bankIds.lastIndexOf(",") != -1) {
                    bankIds.deleteCharAt(bankIds.lastIndexOf(","));
                }
                String bankSql = "select * where id in (" + bankIds + ") order by seq";
                CoreBaseCollection bankCollection = CustomerCompanyBankFactory.getLocalInstance(ctx).getCollection(bankSql);
                oql = "select *,customerBank.* where id in (" + ids + ")";
                CoreBaseCollection customerCompanyCollection = CustomerCompanyInfoFactory.getLocalInstance(ctx).getCollection(oql);
                try {
                    for (i = 0; i < customerCompanyCollection.size(); ++i) {
                        CustomerCompanyInfoInfo customerCompany = (CustomerCompanyInfoInfo)customerCompanyCollection.get(i);
                        customerCompany.getCustomerBank().clear();
                        for (j = 0; j < bankCollection.size(); ++j) {
                            CustomerCompanyBankInfo bank2 = (CustomerCompanyBankInfo)bankCollection.get(j);
                            bank2.setId(null);
                            customerCompany.getCustomerBank().add((CustomerCompanyBankInfo)bank2.clone());
                        }
                    }
                    CustomerCompanyInfoFactory.getLocalInstance(ctx).updateBatchData(customerCompanyCollection);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    throw new BOSException(e.getMessage());
                }
                isEntry = true;
                isCompanyInfoEntryFlag = true;
            } else if (set.contains("customerLinkMan")) {
                collection = (CustomerLinkManCollection)((Object)((Map)this.values).get("customerLinkMan"));
                StringBuffer linkManIds = new StringBuffer();
                for (int i3 = 0; i3 < collection.size(); ++i3) {
                    bank = collection.get(i3);
                    linkManIds.append("'" + ((AbstractCustomerLinkManInfo)bank).getId().toString() + "'");
                    linkManIds.append(",");
                }
                if (linkManIds.lastIndexOf(",") != -1) {
                    linkManIds.deleteCharAt(linkManIds.lastIndexOf(","));
                }
                linkManSql = "select * where id in (" + linkManIds + ")";
                CustomerLinkManCollection linkManCollection = CustomerLinkManFactory.getLocalInstance(ctx).getCollection(linkManSql);
                oql = "select *,customerLinkMan.* where id in (" + ids + ")";
                customerSaleCollection = CustomerSaleInfoFactory.getLocalInstance(ctx).getCollection(oql);
                try {
                    for (i = 0; i < customerSaleCollection.size(); ++i) {
                        customerSaleInfo = (CustomerSaleInfoInfo)customerSaleCollection.get(i);
                        customerSaleInfo.getCustomerLinkMan().clear();
                        for (j = 0; j < linkManCollection.size(); ++j) {
                            CustomerLinkManInfo linkMan = linkManCollection.get(j);
                            linkMan.setId(null);
                            linkMan.setCustomerSale(customerSaleInfo);
                            customerSaleInfo.getCustomerLinkMan().add((CustomerLinkManInfo)linkMan.clone());
                        }
                    }
                    CustomerSaleInfoFactory.getLocalInstance(ctx).updateBatchData(customerSaleCollection);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    throw new BOSException(e.getMessage());
                }
                isEntry = true;
                isSaleInfoEntryFlag = true;
            } else if (set.contains("deliveryAddresses")) {
                collection = (CustomerDeliveryAddressCollection)((Object)((Map)this.values).get("deliveryAddresses"));
                StringBuffer addressIds = new StringBuffer();
                for (int i4 = 0; i4 < collection.size(); ++i4) {
                    address = collection.get(i4);
                    addressIds.append("'" + address.getId().toString() + "'");
                    addressIds.append(",");
                }
                if (addressIds.lastIndexOf(",") != -1) {
                    addressIds.deleteCharAt(addressIds.lastIndexOf(","));
                }
                linkManSql = "select * where id in (" + addressIds + ")";
                addressCollection = CustomerDeliveryAddressFactory.getLocalInstance(ctx).getCollection(linkManSql);
                oql = "select *,deliveryAddresses.* where id in (" + ids + ")";
                customerSaleCollection = CustomerSaleInfoFactory.getLocalInstance(ctx).getCollection(oql);
                try {
                    for (i = 0; i < customerSaleCollection.size(); ++i) {
                        customerSaleInfo = (CustomerSaleInfoInfo)customerSaleCollection.get(i);
                        customerSaleInfo.getDeliveryAddresses().clear();
                        for (j = 0; j < addressCollection.size(); ++j) {
                            CustomerDeliveryAddressInfo addressInfo = (CustomerDeliveryAddressInfo)addressCollection.get(j);
                            addressInfo.setId(null);
                            addressInfo.setCustomerSaleInfo(customerSaleInfo);
                            customerSaleInfo.getDeliveryAddresses().add((CustomerDeliveryAddressInfo)addressInfo.clone());
                        }
                    }
                    CustomerSaleInfoFactory.getLocalInstance(ctx).updateBatchData(customerSaleCollection);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    throw new BOSException(e.getMessage());
                }
                isEntry = true;
                isSaleInfoEntryFlag = true;
            } else if (set.contains("customerSaler")) {
                collection = (CustomerSalerCollection)((Object)((Map)this.values).get("customerSaler"));
                StringBuffer salerIds = new StringBuffer();
                for (int i5 = 0; i5 < collection.size(); ++i5) {
                    address = collection.get(i5);
                    salerIds.append("'" + address.getId().toString() + "'");
                    salerIds.append(",");
                }
                if (salerIds.lastIndexOf(",") != -1) {
                    salerIds.deleteCharAt(salerIds.lastIndexOf(","));
                }
                String salerSql = "select * where id in (" + salerIds + ")";
                addressCollection = CustomerSalerFactory.getLocalInstance(ctx).getCollection(salerSql);
                oql = "select *,customerSaler.* where id in (" + ids + ")";
                customerSaleCollection = CustomerSaleInfoFactory.getLocalInstance(ctx).getCollection(oql);
                try {
                    for (i = 0; i < customerSaleCollection.size(); ++i) {
                        customerSaleInfo = (CustomerSaleInfoInfo)customerSaleCollection.get(i);
                        customerSaleInfo.getCustomerSaler().clear();
                        for (j = 0; j < addressCollection.size(); ++j) {
                            CustomerSalerInfo salerInfo = (CustomerSalerInfo)addressCollection.get(j);
                            salerInfo.setId(null);
                            salerInfo.setCustomerSale(customerSaleInfo);
                            customerSaleInfo.getCustomerSaler().add((CustomerSalerInfo)salerInfo.clone());
                        }
                    }
                    CustomerSaleInfoFactory.getLocalInstance(ctx).updateBatchData(customerSaleCollection);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    throw new BOSException(e.getMessage());
                }
                isEntry = true;
                isSaleInfoEntryFlag = true;
            }
        }
        if (!isEntry) {
            super.executeUpdate(ctx);
        }
        if (this.uptIdList == null || this.uptIdList.size() == 0 || this.values == null || !(this.values instanceof Map) || this.entity == null) {
            return;
        }
        ArrayList ls = new ArrayList();
        ls.addAll(((Map)this.values).values());
        ls.addAll(this.uptIdList);
        String tempSql = this.entity.createUpdateSQlCommand();
        if (tempSql.indexOf("FBrowseGroupID") != -1) {
            StringBuffer strBuffer = new StringBuffer();
            strBuffer.append(" update T_BD_CustomerGroupDetail set FCustomerGroupID = ? ");
            strBuffer.append(" where FCustomerGroupStandardID in (select FID from T_BD_CSSPGroupStandard where FIsBasic = 1 )");
            strBuffer.append(" and  FCustomerID in (");
            int size = this.uptIdList.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    strBuffer.append(",");
                }
                strBuffer.append("?");
            }
            strBuffer.append(")");
            super.execute(ctx, strBuffer.toString(), ls.toArray());
        }
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (isCompanyInfoEntryFlag && this.uptIdList.size() > 0) {
            StringBuilder sql = new StringBuilder("Update T_BD_CustomerCompanyInfo Set flastupdatetime = getdate(),flastupdateuserid = '" + currentUserId + "' Where FID In(");
            for (int i = 0; i < this.uptIdList.size(); ++i) {
                sql.append("?");
                if (i >= this.uptIdList.size() - 1) continue;
                sql.append(",");
            }
            sql.append(")");
            super.execute(ctx, sql.toString(), this.uptIdList.toArray());
        }
        if (isSaleInfoEntryFlag && this.uptIdList.size() > 0) {
            StringBuilder sql = new StringBuilder("Update T_BD_CustomerSaleInfo Set flastupdatetime = getdate(),flastupdateuserid = '" + currentUserId + "' Where FID In(");
            for (int i = 0; i < this.uptIdList.size(); ++i) {
                sql.append("?");
                if (i >= this.uptIdList.size() - 1) continue;
                sql.append(",");
            }
            sql.append(")");
            super.execute(ctx, sql.toString(), this.uptIdList.toArray());
        }
    }

    protected void checkLength(String[] propertiesToCheck, int length) throws CustomerSupplierException {
        for (int i = 0; i < propertiesToCheck.length; ++i) {
            String value;
            String propertiyToCheck = propertiesToCheck[i];
            if (!propertiyToCheck.equals(this.properties[0].toString()) || (value = (String)((Map)this.values).get(this.properties[0].toString())) == null || value.length() <= length) continue;
            throw new CustomerSupplierException(CustomerSupplierException.VALUETOOLARGE);
        }
    }
}

