/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.base.core.util.EqualsUtil;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.assistant.PayConditionInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.cssp.util.CsspUtils;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SupplierCompanyDataImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.cssp.app.SupplierCompanyDataImport");
    private static final String CSSPResource = "com.kingdee.eas.basedata.master.cssp.CSSPResource";
    String[] BOOLEAN_FIELDS = new String[]{"FIsFreezePayment"};
    String[] BOOLEAN_OBJS = new String[]{"isFreezePayment"};
    String[] STRING_FIELDS = new String[]{"FContactPerson", "FContactPersonPost", "FPhone", "FEMail", "FPostalcode", "FMobile", "FFax"};
    String[] STRING_OBJS = new String[]{"contactPerson", "contactPersonPost", "phone", "email", "postalcode", "mobile", "fax"};
    private Set PerminsionCheckedCuIds = new HashSet();
    private Boolean coverImportCompanyBank = false;
    private Map<String, Boolean> userBizOrgRange = new HashMap<String, Boolean>();
    SupplierCompanyInfoInfo oldBaseInfo;

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        boolean rs = false;
        if (firstData != null && currentData != null) {
            String firstMainField = StringUtil.cnulls(firstData.get(this.getMainField()));
            String currentMainField = StringUtil.cnulls(currentData.get(this.getMainField()));
            String firstMainFieldOrg = StringUtil.cnulls(firstData.get("FComOrgID"));
            String currentMainFieldOrg = StringUtil.cnulls(currentData.get("FComOrgID"));
            if (firstMainField.isEmpty() && currentMainField.isEmpty()) {
                rs = false;
            } else if (firstMainField.equals(currentMainField) && firstMainFieldOrg.equals(currentMainFieldOrg)) {
                rs = true;
            }
        }
        return rs;
    }

    public boolean isSameBlock(Map firstData, Map currentData) {
        return this.isSameBlock(this.convertMap(firstData), this.convertMap(currentData));
    }

    public String getMainField() {
        return "FNumber";
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return SupplierCompanyInfoFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), (Throwable)bex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase iSupplierCompanyInfo = this.getController(ctx);
        this.oldBaseInfo = (SupplierCompanyInfoInfo)coreBaseInfo;
        coreBaseInfo.put("isImport", (Object)"true");
        try {
            if (coreBaseInfo.getId() == null || !iSupplierCompanyInfo.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iSupplierCompanyInfo.submit(coreBaseInfo);
            } else {
                iSupplierCompanyInfo.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable tableData, Context ctx) throws TaskExternalException {
        try {
            this.coverImportCompanyBank = DataImportUtils.getCoverImportCompanyBank(ctx);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        SupplierCompanyInfoInfo supplierCompanyInfo = new SupplierCompanyInfoInfo();
        int size = tableData.size();
        Hashtable hsData = null;
        try {
            hsData = (Hashtable)tableData.get(0);
            if (hsData == null) {
                hsData = tableData;
                supplierCompanyInfo = this.parseHead(ctx, hsData, supplierCompanyInfo);
                supplierCompanyInfo = this.parseEntry(hsData, supplierCompanyInfo, ctx);
            } else {
                supplierCompanyInfo = this.parseHead(ctx, hsData, supplierCompanyInfo);
                for (int i = 0; i < size; ++i) {
                    supplierCompanyInfo = this.parseEntry(tableData, supplierCompanyInfo, ctx);
                }
            }
        }
        catch (BOSException ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        catch (EASBizException ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        return supplierCompanyInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SupplierCompanyInfoInfo parseHead(Context ctx, Hashtable hsData, SupplierCompanyInfoInfo supplierCompanyInfo) throws BOSException, TaskExternalException, EASBizException {
        PaymentTypeInfo info;
        String str = null;
        Object data = null;
        CompanyOrgUnitInfo curCompany = null;
        data = ((DataToken)hsData.get((Object)"FComOrgID")).data;
        if (data == null) throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "getCompanyOrgUnitFailed", ctx));
        str = data.toString();
        curCompany = DataImportUtils.getCompanyOrgUnitInfoFromNumber(ctx, str);
        if (curCompany == null) {
            throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "getCompanyOrgUnitFailed", ctx));
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (!PerminsionUtil.isUserBizOrgRange((Context)ctx, (String)userId, (String)curCompany.getId().toString())) {
            throw new TaskExternalException(new MaterialBaseException(MaterialBaseException.OUT_BIZ_ORG, new Object[]{curCompany.getName()}).getMessage());
        }
        String CuId = curCompany.getCU().getId().toString();
        if (!this.PerminsionCheckedCuIds.contains(CuId)) {
            try {
                PerminsionUtil.checkCUPerminsion((Context)ctx, (String)CuId, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), (String)"Suppliercompanyinfo_Import");
            }
            catch (EASBizException ee) {
                throw new TaskExternalException(ee.getMessage(), (Throwable)ee);
            }
            this.PerminsionCheckedCuIds.add(CuId);
        }
        supplierCompanyInfo.setCompanyOrgUnit(curCompany);
        supplierCompanyInfo.setCU(curCompany.getCU());
        Object numberdata = ((DataToken)hsData.get((Object)"FNumber")).data;
        if (numberdata != null) {
            SupplierInfo supplierInfo;
            str = numberdata.toString();
            if (str == null || str.trim().length() <= 0) throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "supplierNotExist", ctx));
            if (super.isSltImportUpdate()) {
                supplierInfo = DataImportUtils.getSupplierInfoFromNumber(ctx, curCompany.getCU(), str);
                if (supplierInfo == null) throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "supplierNotExist", ctx));
                supplierCompanyInfo.setSupplier(supplierInfo);
                ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
                SupplierCompanyInfoInfo oldSupplierCompanyInfo = iSupplier.getCompanyInfo((IObjectPK)new ObjectUuidPK(supplierCompanyInfo.getSupplier().getId()), (IObjectPK)new ObjectUuidPK(curCompany.getId()));
                if (oldSupplierCompanyInfo != null) {
                    supplierCompanyInfo = oldSupplierCompanyInfo;
                }
            } else {
                supplierInfo = DataImportUtils.getSupplierInfoFromNumber(ctx, curCompany.getCU(), str);
                if (supplierInfo == null) throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "supplierNotExist", ctx));
                supplierCompanyInfo.setSupplier(supplierInfo);
            }
        }
        supplierCompanyInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        DataImportUtils.setBooleanData(hsData, this.BOOLEAN_FIELDS, (CoreBaseInfo)supplierCompanyInfo, this.BOOLEAN_OBJS);
        if (hsData.get("FPostalcode") != null && ((DataToken)hsData.get((Object)"FPostalcode")).data.toString().length() > 10) {
            throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "postZipCode", ctx));
        }
        DataImportUtils.setStringData(hsData, this.STRING_FIELDS, (CoreBaseInfo)supplierCompanyInfo, this.STRING_OBJS);
        if (hsData.get("FPaymentTypeID") != null && (info = DataImportUtils.getPaymentTypeInfoFromNumber(ctx, str = (data = ((DataToken)hsData.get((Object)"FPaymentTypeID")).data).toString())) != null) {
            supplierCompanyInfo.setPaymentType(info);
        }
        if (hsData.get("FSettlementTypeID") != null && (info = DataImportUtils.getSettlementTypeInfoFromNumber(ctx, str = (data = ((DataToken)hsData.get((Object)"FSettlementTypeID")).data).toString())) != null) {
            supplierCompanyInfo.setSettlementType((SettlementTypeInfo)info);
        }
        if (hsData.get("FSettlementCurrencyID") != null) {
            data = ((DataToken)hsData.get((Object)"FSettlementCurrencyID")).data;
            str = data.toString();
            info = DataImportUtils.getCurrencyInfoFromNumber(ctx, str);
            if (info == null) throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "SupplierCurrency", ctx));
            supplierCompanyInfo.setSettlementCurrency((CurrencyInfo)info);
        }
        if (hsData.get("FPayConditionID") != null && (info = DataImportUtils.getPayConditionInfoByNumber(ctx, str = (data = ((DataToken)hsData.get((Object)"FPayConditionID")).data).toString())) != null) {
            supplierCompanyInfo.setPayCondition((PayConditionInfo)info);
        }
        if (hsData.get("FAccountClassID") != null && (info = DataImportUtils.getKAClassficationInfoFromNumber(ctx, str = (data = ((DataToken)hsData.get((Object)"FAccountClassID")).data).toString(), curCompany, "supplier")) != null) {
            supplierCompanyInfo.setAccountingClassification((KAClassficationInfo)info);
        }
        if (hsData.get("FFreezeOrgUnitID") != null && (info = DataImportUtils.getFullOrgUnitInfoFromNumber(ctx, str = (data = ((DataToken)hsData.get((Object)"FFreezeOrgUnitID")).data).toString())) != null) {
            supplierCompanyInfo.setFreezeOrgUnit((FullOrgUnitInfo)info);
        }
        if ((data = ((DataToken)hsData.get((Object)"FStatus")).data) == null) return supplierCompanyInfo;
        String value = data.toString();
        supplierCompanyInfo.setUsingStatus(DataImportUtils.getCSSPAsstStatusValue(value));
        return supplierCompanyInfo;
    }

    private SupplierCompanyInfoInfo parseEntry(Hashtable tableData, SupplierCompanyInfoInfo supplierCompanyInfo, Context ctx) throws EASBizException, TaskExternalException, BOSException {
        SupplierCompanyBankCollection banks = supplierCompanyInfo.getSupplierBank();
        if (this.coverImportCompanyBank.booleanValue()) {
            banks.clear();
        }
        if (tableData.get(0) == null) {
            String number = (String)this.getData(tableData, "FBankAccount");
            if (number != null && number.trim().length() > 0) {
                Object data;
                CountryInfo info;
                SupplierCompanyBankInfo bankInfo = new SupplierCompanyBankInfo();
                bankInfo.setSupplierCompanyInfo(supplierCompanyInfo);
                bankInfo.setBankAccount(number);
                bankInfo.setBankAddress((String)this.getData(tableData, "FBankAddress"));
                bankInfo.setBank((String)this.getData(tableData, "FBankName"));
                bankInfo.setBankEngName((String)this.getData(tableData, "FBankEngName"));
                bankInfo.setBeneficiary((String)this.getData(tableData, "FBeneficiary"));
                bankInfo.setBeneficiaryEngName((String)this.getData(tableData, "FBeneficiaryEngName"));
                bankInfo.setBeneficiaryBankCode((String)this.getData(tableData, "FBeneficiaryBankCode"));
                bankInfo.setBeneficiaryAddr((String)this.getData(tableData, "FBeneficiaryAddr"));
                bankInfo.setBeneficiaryBankCountryISO((String)this.getData(tableData, "FBeneficiaryBankCountryISO"));
                bankInfo.setBeneficiaryBankSWIFT((String)this.getData(tableData, "FBeneficiaryBankSWIFT"));
                bankInfo.setSettlementParam((String)this.getData(tableData, "FSettlementParam"));
                bankInfo.setAgencyBankAccount((String)this.getData(tableData, "FAgencyBankAccount"));
                bankInfo.setAgencyBankName((String)this.getData(tableData, "FAgencyBankName"));
                bankInfo.setAgencyBankSWIFT((String)this.getData(tableData, "FAgencyBankSWIFT"));
                bankInfo.setAgencyBankCountryISO((String)this.getData(tableData, "FAgencyBankCountryISO"));
                bankInfo.setAgencyBankAddr((String)this.getData(tableData, "FAgencyBankAddr"));
                if (tableData.get("FBeneficiaryBankCountryID_number") != null && (info = DataImportUtils.getCountryInfoFromNumber(ctx, (data = ((DataToken)tableData.get((Object)"FBeneficiaryBankCountryID_number")).data).toString())) != null) {
                    bankInfo.setBeneficiaryBankCountryID(info);
                }
                if (tableData.get("FAgencyBankCountryID_number") != null && (info = DataImportUtils.getCountryInfoFromNumber(ctx, (data = ((DataToken)tableData.get((Object)"FAgencyBankCountryID_number")).data).toString())) != null) {
                    bankInfo.setAgencyBankCountryID(info);
                }
                if (this.oldBaseInfo != null && EqualsUtil.equals((Object)this.oldBaseInfo.getSupplier(), (Object)supplierCompanyInfo.getSupplier()) && EqualsUtil.equals((Object)this.oldBaseInfo.getCompanyOrgUnit(), (Object)supplierCompanyInfo.getCompanyOrgUnit())) {
                    supplierCompanyInfo = this.oldBaseInfo;
                }
                this.checkHasBeBank(ctx, bankInfo);
                this.addBank(supplierCompanyInfo, bankInfo);
            }
        } else {
            for (int i = 0; i < tableData.size(); ++i) {
                Object data;
                CountryInfo info;
                Hashtable hsData = (Hashtable)tableData.get(i);
                String number = (String)this.getData(hsData, "FBankAccount");
                if (number == null || number.trim().length() <= 0) continue;
                SupplierCompanyBankInfo bankInfo = new SupplierCompanyBankInfo();
                bankInfo.setSupplierCompanyInfo(supplierCompanyInfo);
                bankInfo.setBankAccount(number);
                bankInfo.setBankAddress((String)this.getData(hsData, "FBankAddress"));
                bankInfo.setBank((String)this.getData(hsData, "FBankName"));
                bankInfo.setBankEngName((String)this.getData(hsData, "FBankEngName"));
                bankInfo.setBeneficiary((String)this.getData(hsData, "FBeneficiary"));
                bankInfo.setBeneficiaryEngName((String)this.getData(hsData, "FBeneficiaryEngName"));
                bankInfo.setBeneficiaryBankCode((String)this.getData(hsData, "FBeneficiaryBankCode"));
                bankInfo.setBeneficiaryAddr((String)this.getData(hsData, "FBeneficiaryAddr"));
                bankInfo.setBeneficiaryBankCountryISO((String)this.getData(hsData, "FBeneficiaryBankCountryISO"));
                bankInfo.setBeneficiaryBankSWIFT((String)this.getData(hsData, "FBeneficiaryBankSWIFT"));
                bankInfo.setSettlementParam((String)this.getData(hsData, "FSettlementParam"));
                bankInfo.setAgencyBankAccount((String)this.getData(hsData, "FAgencyBankAccount"));
                bankInfo.setAgencyBankName((String)this.getData(hsData, "FAgencyBankName"));
                bankInfo.setAgencyBankSWIFT((String)this.getData(hsData, "FAgencyBankSWIFT"));
                bankInfo.setAgencyBankCountryISO((String)this.getData(hsData, "FAgencyBankCountryISO"));
                bankInfo.setAgencyBankAddr((String)this.getData(hsData, "FAgencyBankAddr"));
                if (hsData.get("FBeneficiaryBankCountryID_number") != null && (info = DataImportUtils.getCountryInfoFromNumber(ctx, (data = ((DataToken)hsData.get((Object)"FBeneficiaryBankCountryID_number")).data).toString())) != null) {
                    bankInfo.setBeneficiaryBankCountryID(info);
                }
                if (hsData.get("FAgencyBankCountryID_number") != null && (info = DataImportUtils.getCountryInfoFromNumber(ctx, (data = ((DataToken)hsData.get((Object)"FAgencyBankCountryID_number")).data).toString())) != null) {
                    bankInfo.setAgencyBankCountryID(info);
                }
                if (this.oldBaseInfo != null && EqualsUtil.equals((Object)this.oldBaseInfo.getSupplier(), (Object)supplierCompanyInfo.getSupplier()) && EqualsUtil.equals((Object)this.oldBaseInfo.getCompanyOrgUnit(), (Object)supplierCompanyInfo.getCompanyOrgUnit())) {
                    supplierCompanyInfo = this.oldBaseInfo;
                }
                this.checkHasBeBank(ctx, bankInfo);
                if (this.coverImportCompanyBank.booleanValue()) {
                    if (banks == null) continue;
                    banks.add(bankInfo);
                    continue;
                }
                this.addBank(supplierCompanyInfo, bankInfo);
            }
        }
        return supplierCompanyInfo;
    }

    private void checkHasBeBank(Context ctx, SupplierCompanyBankInfo bankInfo) throws EASBizException, BOSException, TaskExternalException {
        Boolean isAllowedEnterBank = DataImportUtils.getIsAllowedEnterBank(ctx);
        try {
            BEBankCollection beBankCollection = DataImportUtils.getBEBankCollection(ctx, bankInfo.getBank());
            if (beBankCollection != null && beBankCollection.size() > 0) {
                BEBankInfo beBankInfo = beBankCollection.get(0);
                bankInfo.setBankID(beBankInfo.getId().toString());
                bankInfo.setBeneficiaryBankCode(beBankInfo.getNumber());
            } else if (!(isAllowedEnterBank.booleanValue() || beBankCollection != null && beBankCollection.size() > 0)) {
                throw new TaskExternalException(CsspUtils.convertStr(ResourceBase.getString((String)CSSPResource, (String)"SupplierCompanyDataImportMsg001", (Locale)ctx.getOriginLocale()), bankInfo.getBank()));
            }
        }
        catch (BOSException e) {
            logger.error((Object)"\u8d22\u52a1\u8d44\u6599\u5173\u8054\u94f6\u4f01\u9519\u8bef\uff01");
            throw new TaskExternalException(e.getMessage() + ResourceBase.getString((String)CSSPResource, (String)"SupplierCompanyDataImportMsg002", (Locale)ctx.getOriginLocale()), (Throwable)e);
        }
    }

    private void addBank(SupplierCompanyInfoInfo supplierCompanyInfo, SupplierCompanyBankInfo bankInfo) {
        SupplierCompanyBankCollection banks = supplierCompanyInfo.getSupplierBank();
        int exsistPos = -1;
        for (int i = 0; i < banks.size(); ++i) {
            SupplierCompanyBankInfo tempBank = banks.get(i);
            if (tempBank.getBankAccount() == null || bankInfo.getBankAccount() == null || !tempBank.getBankAccount().equals(bankInfo.getBankAccount())) continue;
            exsistPos = i;
        }
        if (exsistPos >= 0) {
            banks.set(exsistPos, bankInfo);
        } else {
            banks.add(bankInfo);
        }
    }

    public Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            String mutilName_BE = "FBeneficiaryBankCountryID_name_" + ContextUtils.getLocaleFromEnv().toString().toLowerCase();
            String mutilName_agency = "FAgencyBankCountryID_name_" + ContextUtils.getLocaleFromEnv().toString().toLowerCase();
            result.put("FNumber", DataImportUtils.transformValue(rs.getString("number")));
            result.put("FComOrgID", DataImportUtils.transformValue(rs.getString("orgUnit.number")));
            result.put("FIsFreezePayment", DataImportUtils.transformValue(rs.getBoolean("supplierCompany.isPayment")));
            result.put("FPaymentTypeID", DataImportUtils.transformValue(rs.getString("paymentType.number")));
            result.put("FSettlementTypeID", DataImportUtils.transformValue(rs.getString("settlementType.number")));
            result.put("FPayConditionID", DataImportUtils.transformValue(rs.getString("payCondition.number")));
            result.put("FBankName", DataImportUtils.transformValue(rs.getString("SupplierC.bank")));
            result.put("FBankAccount", DataImportUtils.transformValue(rs.getString("SupplierC.bankAccount")));
            result.put("FBankAddress", DataImportUtils.transformValue(rs.getString("SupplierC.bankAddress")));
            result.put("FBankEngName", DataImportUtils.transformValue(rs.getString("SupplierC.bankEngName")));
            result.put("FBeneficiary", DataImportUtils.transformValue(rs.getString("SupplierC.beneficiary")));
            result.put("FBeneficiaryEngName", DataImportUtils.transformValue(rs.getString("SupplierC.beneficiaryEngName")));
            result.put("FBeneficiaryBankCode", DataImportUtils.transformValue(rs.getString("SupplierC.beneficiaryBankCode")));
            result.put("FBeneficiaryAddr", DataImportUtils.transformValue(rs.getString("SupplierC.beneficiaryAddr")));
            result.put("FBeneficiaryBankCountryID_number", DataImportUtils.transformValue(rs.getString("benBankCountry.number")));
            result.put("FBeneficiaryBankCountryISO", DataImportUtils.transformValue(rs.getString("SupplierC.beneficiaryBankCountryISO")));
            result.put("FBeneficiaryBankSWIFT", DataImportUtils.transformValue(rs.getString("SupplierC.beneficiaryBankSWIFT")));
            result.put(mutilName_BE, DataImportUtils.transformValue(rs.getString("benBankCountry.name")));
            result.put("FSettlementParam", DataImportUtils.transformValue(rs.getString("SupplierC.settlementParam")));
            result.put("FAgencyBankAccount", DataImportUtils.transformValue(rs.getString("SupplierC.agencyBankAccount")));
            result.put("FAgencyBankName", DataImportUtils.transformValue(rs.getString("SupplierC.agencyBankName")));
            result.put("FAgencyBankSWIFT", DataImportUtils.transformValue(rs.getString("SupplierC.agencyBankSWIFT")));
            result.put("FAgencyBankCountryID_number", DataImportUtils.transformValue(rs.getString("agencyBankCountry.number")));
            result.put(mutilName_agency, DataImportUtils.transformValue(rs.getString("agencyBankCountry.name")));
            result.put("FAgencyBankCountryISO", DataImportUtils.transformValue(rs.getString("SupplierC.agencyBankCountryISO")));
            result.put("FAgencyBankAddr", DataImportUtils.transformValue(rs.getString("SupplierC.agencyBankAddr")));
            result.put("FSettlementCurrencyID", DataImportUtils.transformValue(rs.getString("currency.number")));
            result.put("FAccountClassID", DataImportUtils.transformValue(rs.getString("kaClassfication.number")));
            result.put("FContactPerson", DataImportUtils.transformValue(rs.getString("supplierCompany.contactPerson")));
            result.put("FContactPersonPost", DataImportUtils.transformValue(rs.getString("supplierCompany.contactPerPost")));
            result.put("FPhone", DataImportUtils.transformValue(rs.getString("supplierCompany.phone")));
            result.put("FFax", DataImportUtils.transformValue(rs.getString("supplierCompany.fax")));
            result.put("FEMail", DataImportUtils.transformValue(rs.getString("supplierCompany.email")));
            result.put("FPostalcode", DataImportUtils.transformValue(rs.getString("supplierCompany.postalcode")));
            result.put("FMobile", DataImportUtils.transformValue(rs.getString("supplierCompany.mobile")));
            result.put("FCreatorNumber", DataImportUtils.transformValue(rs.getString("creator.number")));
            result.put("FCreateTime", DataImportUtils.getDateStrByLocale(ctx, rs.getDate("supplierCompany.createTime")));
            result.put("FStatus", DataImportUtils.transformValue(rs.getString("supplierCompany.usingStatus")));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        ObjectUuidPK pk = null;
        try {
            ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
            pk = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
            filterInfo = iSupplier.getDatabaseDFilter((IObjectPK)pk, "id", "adminCU.id");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.cssp.app.SupplierExportCompanyQuery";
    }
}

