/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.batch.app.GeneralBatchUpdateStrategy;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.ISupplierCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierLinkManCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierLinkManFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierLinkManInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoInfo;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SupplierSyncAssistStrategy
extends GeneralBatchUpdateStrategy {
    @Override
    protected void validateBizLogic(Context ctx, IObjectPK pk, Map params) throws BOSException, EASBizException {
    }

    @Override
    protected void validateBizLogic(Context ctx, Object[] pks, Map params) throws BOSException, EASBizException {
        Integer org = (Integer)params.get("orgtype");
        String unitId = null;
        if (params.get("orgvalue") != null) {
            unitId = params.get("orgvalue").toString();
        }
        List orgIdList = (List)params.get("orgIdList");
        if (org != null) {
            switch (org) {
                case 0: {
                    if (unitId == null) break;
                    this.validateCompany(ctx, orgIdList.toArray(), pks[0].toString(), params);
                    break;
                }
                case 1: {
                    if (unitId == null) break;
                    this.validatePurchase(ctx, orgIdList.toArray(), pks[0].toString(), params);
                }
            }
        }
    }

    private void validateCompany(Context ctx, Object[] orgIds, String supplierId, Map params) throws BOSException, EASBizException {
        if (this.properties == null || this.properties.length == 0) {
            return;
        }
        String[] propertiesToCheck = new String[]{"settlementAccount", "email"};
        this.checkLength(propertiesToCheck, 80);
        String[] propertiesToCheck2 = new String[]{"contactPerson", "phone", "contactPersonPost"};
        this.checkLength(propertiesToCheck2, 60);
        String[] propertiesToCheck3 = new String[]{"fax", "mobile"};
        this.checkLength(propertiesToCheck3, 40);
        this.checkLength(new String[]{"postalcode"}, 10);
        HashMap<String, CustomerSupplierException> exceptionMap = new HashMap<String, CustomerSupplierException>();
        StringBuilder sqlParams = new StringBuilder();
        for (int i = 0; i < orgIds.length; ++i) {
            if (i > 0) {
                sqlParams.append(",");
            }
            sqlParams.append("?");
        }
        ResultSet comOrgNotFitSet = null;
        ResultSet statusNotFitSet = null;
        ResultSet supplierSet = null;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            int i;
            int i2;
            con = EJBFactory.getConnection((Context)ctx);
            int customerCount = 0;
            int customerInfoCount = 0;
            int count = 0;
            ArrayList<String> customerList = new ArrayList<String>();
            ArrayList<String> companyInfoList = new ArrayList<String>();
            ArrayList currentIdList = new ArrayList();
            StringBuilder hasSupplierIdBuilder = new StringBuilder();
            hasSupplierIdBuilder.append(" select supplier.fid, companyInfo.fid").append(" from T_BD_Supplier supplier").append(" inner join T_BD_SupplierCompanyInfo companyInfo on supplier.fid = companyInfo.FSupplierId").append(" where companyInfo.FComOrgId in(").append(sqlParams.toString()).append(")").append(" and  supplier.fid = '").append(supplierId).append("'");
            stmt = con.prepareStatement(hasSupplierIdBuilder.toString());
            for (int i3 = 0; i3 < orgIds.length; ++i3) {
                stmt.setString(i3 + 1, orgIds[i3].toString());
            }
            comOrgNotFitSet = stmt.executeQuery();
            CustomerSupplierException notDealCustomerException = new CustomerSupplierException(CustomerSupplierException.COMPANY_NOTDEAL_SUPPLIER, new String[]{""});
            while (comOrgNotFitSet.next()) {
                customerList.add(customerCount++, comOrgNotFitSet.getString(1));
                companyInfoList.add(customerInfoCount++, comOrgNotFitSet.getString(2));
            }
            if (!customerList.contains(supplierId)) {
                exceptionMap.put(supplierId, notDealCustomerException);
            }
            for (int i4 = 0; i4 < customerList.size(); ++i4) {
                BizCheckResult rs = BizCheckerUtil.hasDeal4Update((Context)ctx, (BOSUuid)BOSUuid.read((String)companyInfoList.get(i4).toString()));
                if (rs.isFound()) {
                    exceptionMap.put((String)customerList.get(i4), notDealCustomerException);
                    continue;
                }
                currentIdList.add(count++, customerList.get(i4));
            }
            StringBuilder statusBuilder = new StringBuilder();
            sqlParams.delete(0, sqlParams.length());
            int c = currentIdList.size();
            for (i2 = 0; i2 < c; ++i2) {
                if (i2 > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("?");
            }
            if (sqlParams.length() > 0) {
                statusBuilder.append(" select fid ").append(" from T_BD_Supplier").append(" where fid in(").append(sqlParams.toString()).append(")").append(" and FUsedStatus =  2");
                stmt = con.prepareStatement(statusBuilder.toString());
                c = currentIdList.size();
                for (i2 = 0; i2 < c; ++i2) {
                    stmt.setString(i2 + 1, currentIdList.get(i2).toString());
                }
                statusNotFitSet = stmt.executeQuery();
                CustomerSupplierException freezedException = new CustomerSupplierException(CustomerSupplierException.CANNOT_UPDATE_ISFREEZED);
                while (statusNotFitSet.next()) {
                    exceptionMap.put(statusNotFitSet.getString(1), notDealCustomerException);
                }
            }
            for (i = 0; i < currentIdList.size(); ++i) {
                if (exceptionMap.containsKey(currentIdList.get(i).toString())) continue;
                this.uptIdList.add(companyInfoList.get(i).toString());
            }
            sqlParams.delete(0, sqlParams.length());
            c = exceptionMap.keySet().toArray().length;
            for (i = 0; i < c; ++i) {
                if (i > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("?");
            }
            if (sqlParams.length() > 0) {
                StringBuilder supplierBuilder = new StringBuilder();
                supplierBuilder.append(" select FNumber ").append(" from ").append(" T_BD_Supplier ").append(" where fid in(").append((CharSequence)sqlParams).append(")");
                stmt = con.prepareStatement(supplierBuilder.toString());
                int c2 = exceptionMap.keySet().toArray().length;
                for (int i5 = 0; i5 < c2; ++i5) {
                    stmt.setString(i5 + 1, exceptionMap.keySet().toArray()[i5].toString());
                }
                supplierSet = stmt.executeQuery();
                count = 0;
                while (supplierSet.next()) {
                    CustomerSupplierException exception = new CustomerSupplierException(CustomerSupplierException.SUPPLIER_BATCH_FAILD, new String[]{supplierSet.getString(1)});
                    this.log.addException(exception.getMessage(), (Exception)exceptionMap.get(exceptionMap.keySet().toArray()[count++]));
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(comOrgNotFitSet);
                SQLUtils.cleanup(statusNotFitSet);
                SQLUtils.cleanup(supplierSet);
                SQLUtils.cleanup(stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)comOrgNotFitSet);
        SQLUtils.cleanup(statusNotFitSet);
        SQLUtils.cleanup(supplierSet);
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
    }

    private void validateCompany(Context ctx, IObjectPK pk, String unitId, Map params) throws BOSException {
        if (this.properties == null || this.properties.length == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)pk.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)unitId, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        view.setFilter(filter);
        ISupplierCompanyInfo ie = SupplierCompanyInfoFactory.getLocalInstance(ctx);
        this.putCompanySelectors(view.getSelector());
        SupplierCompanyInfoCollection ls = ie.getSupplierCompanyInfoCollection(view);
        if (ls != null && ls.size() != 0) {
            SupplierCompanyInfoInfo info = ls.get(0);
            info.getAccountingClassification();
            String pn = null;
            if (this.values != null && this.values instanceof Map) {
                Map cv = (Map)this.values;
                int size = this.properties.length;
                for (int i = 0; i < size; ++i) {
                    pn = this.properties[i].toString();
                    Object object = info.get(pn);
                    if (object instanceof CoreBaseInfo) {
                        ((CoreBaseInfo)object).setId(BOSUuid.read((String)cv.get(pn).toString()));
                    }
                    info.put(pn, object);
                }
            }
            try {
                ie.updateCheck((IObjectPK)new ObjectStringPK(info.getId().toString()), info);
                this.uptIdList.add(info.getId().toString());
            }
            catch (Exception ex) {
                CustomerSupplierException exception = new CustomerSupplierException(CustomerSupplierException.SUPPLIER_BATCH_FAILD, new String[]{info.getSupplier().getNumber()});
                this.log.addException(exception.getMessage(), ex);
            }
        } else {
            SupplierInfo supplierInfo = null;
            try {
                supplierInfo = SupplierFactory.getLocalInstance(ctx).getSupplierInfo(pk);
                throw new CustomerSupplierException(CustomerSupplierException.COMPANY_NOTDEAL_SUPPLIER, new String[]{supplierInfo.getNumber()});
            }
            catch (Exception e) {
                CustomerSupplierException exception = new CustomerSupplierException(CustomerSupplierException.SUPPLIER_BATCH_FAILD, new String[]{supplierInfo.getNumber()});
                this.log.addException(exception.getMessage(), e);
            }
        }
    }

    private void putCompanySelectors(SelectorItemCollection selectors) {
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("supplier.id"));
        selectors.add(new SelectorItemInfo("supplier.usedStatus"));
        selectors.add(new SelectorItemInfo("supplier.number"));
        selectors.add(new SelectorItemInfo("companyOrgUnit.id"));
        selectors.add(new SelectorItemInfo("cu.id"));
        selectors.add(new SelectorItemInfo("effectedStatus"));
        selectors.add(new SelectorItemInfo("accountingClassification"));
        selectors.add(new SelectorItemInfo("settlementCurrency.id"));
    }

    private void validatePurchase(Context ctx, Object[] orgIds, String supplierId, Map params) throws BOSException, EASBizException {
        if (this.properties == null || this.properties.length == 0) {
            return;
        }
        HashMap<Object, CustomerSupplierException> exceptionMap = new HashMap<Object, CustomerSupplierException>();
        StringBuilder sqlParams = new StringBuilder();
        for (int i = 0; i < orgIds.length; ++i) {
            if (i > 0) {
                sqlParams.append(",");
            }
            sqlParams.append("?");
        }
        ResultSet saleOrgNotFitSet = null;
        ResultSet statusNotFitSet = null;
        ResultSet customerSet = null;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            int i;
            int i2;
            int i3;
            con = EJBFactory.getConnection((Context)ctx);
            int customerCount = 0;
            int customerInfoCount = 0;
            int count = 0;
            ArrayList<String> customerList = new ArrayList<String>();
            ArrayList<String> saleInfoList = new ArrayList<String>();
            ArrayList currentIdList = new ArrayList();
            StringBuilder hasSupplierBuilder = new StringBuilder();
            hasSupplierBuilder.append(" select supplier.fid, purchaseInfo.fid").append(" from T_BD_Supplier supplier").append(" inner join T_BD_SupplierPurchaseInfo purchaseInfo on supplier.fid = purchaseInfo.FSupplierId").append(" where purchaseInfo.FPurchaseOrgID in(").append((CharSequence)sqlParams).append(")").append(" and  supplier.fid = '").append(supplierId).append("'");
            stmt = con.prepareStatement(hasSupplierBuilder.toString());
            for (int i4 = 0; i4 < orgIds.length; ++i4) {
                stmt.setString(i4 + 1, orgIds[i4].toString());
            }
            saleOrgNotFitSet = stmt.executeQuery();
            CustomerSupplierException notDealCustomerException = new CustomerSupplierException(CustomerSupplierException.PURORG_NOTDEAL_SUPPLIER, new String[]{""});
            while (saleOrgNotFitSet.next()) {
                customerList.add(customerCount++, saleOrgNotFitSet.getString(1));
                saleInfoList.add(customerInfoCount++, saleOrgNotFitSet.getString(2));
            }
            for (i3 = 0; i3 < orgIds.length; ++i3) {
                if (customerList.contains(orgIds[i3])) continue;
                exceptionMap.put(orgIds[i3], notDealCustomerException);
            }
            for (i3 = 0; i3 < customerList.size(); ++i3) {
                BizCheckResult rs = BizCheckerUtil.hasDeal4Update((Context)ctx, (BOSUuid)BOSUuid.read((String)saleInfoList.get(i3).toString()));
                if (rs.isFound()) {
                    exceptionMap.put(customerList.get(i3), notDealCustomerException);
                    continue;
                }
                currentIdList.add(count++, customerList.get(i3));
            }
            StringBuilder statusBuilder = new StringBuilder();
            sqlParams.delete(0, sqlParams.length());
            int c = currentIdList.size();
            for (i2 = 0; i2 < c; ++i2) {
                if (i2 > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("?");
            }
            if (sqlParams.length() > 0) {
                statusBuilder.append(" select fid ").append(" from T_BD_Supplier").append(" where fid in(").append(sqlParams.toString()).append(")").append(" and FUsedStatus =  2");
                stmt = con.prepareStatement(statusBuilder.toString());
                c = currentIdList.size();
                for (i2 = 0; i2 < c; ++i2) {
                    stmt.setString(i2 + 1, currentIdList.get(i2).toString());
                }
                statusNotFitSet = stmt.executeQuery();
                CustomerSupplierException freezedException = new CustomerSupplierException(CustomerSupplierException.CANNOT_UPDATE_ISFREEZED);
                while (statusNotFitSet.next()) {
                    exceptionMap.put(statusNotFitSet.getString(1), notDealCustomerException);
                }
                for (i = 0; i < currentIdList.size(); ++i) {
                    if (exceptionMap.containsKey(currentIdList.get(i).toString())) continue;
                    this.uptIdList.add(saleInfoList.get(i).toString());
                }
            }
            sqlParams.delete(0, sqlParams.length());
            c = exceptionMap.keySet().toArray().length;
            for (int i5 = 0; i5 < c; ++i5) {
                if (i5 > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("?");
            }
            if (sqlParams.length() > 0) {
                StringBuilder supplierBuilder = new StringBuilder();
                supplierBuilder.append(" select FNumber ").append(" from ").append(" T_BD_Supplier ").append(" where fid in(").append(sqlParams.toString()).append(")");
                stmt = con.prepareStatement(supplierBuilder.toString());
                int c2 = exceptionMap.keySet().toArray().length;
                for (i = 0; i < c2; ++i) {
                    stmt.setString(i + 1, exceptionMap.keySet().toArray()[i].toString());
                }
                customerSet = stmt.executeQuery();
                count = 0;
                while (customerSet.next()) {
                    CustomerSupplierException exception = new CustomerSupplierException(CustomerSupplierException.SUPPLIER_BATCH_FAILD, new String[]{customerSet.getString(1)});
                    this.log.addException(exception.getMessage(), (Exception)exceptionMap.get(exceptionMap.keySet().toArray()[count++]));
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(saleOrgNotFitSet);
                SQLUtils.cleanup(statusNotFitSet);
                SQLUtils.cleanup(customerSet);
                SQLUtils.cleanup(stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)saleOrgNotFitSet);
        SQLUtils.cleanup(statusNotFitSet);
        SQLUtils.cleanup(customerSet);
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
    }

    private void putSaleSelectors(SelectorItemCollection selectors) {
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("supplier.id"));
        selectors.add(new SelectorItemInfo("supplier.usedStatus"));
        selectors.add(new SelectorItemInfo("supplier.number"));
        selectors.add(new SelectorItemInfo("purchaseOrgUnit.id"));
        selectors.add(new SelectorItemInfo("cu.id"));
        selectors.add(new SelectorItemInfo("effectedStatus"));
    }

    @Override
    protected void executeUpdate(Context ctx) throws BOSException {
        StringBuilder sql;
        boolean isBank = false;
        boolean isCompanyInfoEntryFlag = false;
        boolean isPurchaseInfoEntryFlag = false;
        if (this.values != null && this.values instanceof Map) {
            int j;
            int i;
            String oql;
            AbstractObjectCollection collection;
            Set set = ((Map)this.values).keySet();
            StringBuffer ids = new StringBuffer();
            for (Object obj : this.uptIdList) {
                ids.append("'" + obj + "'");
                ids.append(",");
            }
            if (ids.lastIndexOf(",") != -1) {
                ids.deleteCharAt(ids.lastIndexOf(","));
            }
            if (set.contains("supplierBank")) {
                collection = (SupplierCompanyBankCollection)((Object)((Map)this.values).get("supplierBank"));
                StringBuffer bankIds = new StringBuffer();
                for (int i2 = 0; i2 < collection.size(); ++i2) {
                    SupplierCompanyBankInfo bank = collection.get(i2);
                    bankIds.append("'" + bank.getId().toString() + "'");
                    bankIds.append(",");
                }
                if (bankIds.lastIndexOf(",") != -1) {
                    bankIds.deleteCharAt(bankIds.lastIndexOf(","));
                }
                String bankSql = "select * where id in (" + bankIds + ") order by seq";
                CoreBaseCollection bankCollection = SupplierCompanyBankFactory.getLocalInstance(ctx).getCollection(bankSql);
                oql = "select *,supplierBank.* where id in (" + ids + ")";
                CoreBaseCollection supplierCompanyCollection = SupplierCompanyInfoFactory.getLocalInstance(ctx).getCollection(oql);
                try {
                    for (i = 0; i < supplierCompanyCollection.size(); ++i) {
                        SupplierCompanyInfoInfo supplierCompany = (SupplierCompanyInfoInfo)supplierCompanyCollection.get(i);
                        supplierCompany.getSupplierBank().clear();
                        for (j = 0; j < bankCollection.size(); ++j) {
                            SupplierCompanyBankInfo bank = (SupplierCompanyBankInfo)bankCollection.get(j);
                            bank.setId(null);
                            supplierCompany.getSupplierBank().add((SupplierCompanyBankInfo)bank.clone());
                        }
                    }
                    SupplierCompanyInfoFactory.getLocalInstance(ctx).updateBatchData(supplierCompanyCollection);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    throw new BOSException(e.getMessage());
                }
                isBank = true;
                isCompanyInfoEntryFlag = true;
            } else if (set.contains("supplierLinkMan")) {
                collection = (SupplierLinkManCollection)((Object)((Map)this.values).get("supplierLinkMan"));
                StringBuffer linkManIds = new StringBuffer();
                for (int i3 = 0; i3 < collection.size(); ++i3) {
                    SupplierLinkManInfo linkMan = collection.get(i3);
                    linkManIds.append("'" + linkMan.getId().toString() + "'");
                    linkManIds.append(",");
                }
                if (linkManIds.lastIndexOf(",") != -1) {
                    linkManIds.deleteCharAt(linkManIds.lastIndexOf(","));
                }
                String linkManSql = "select * where id in (" + linkManIds + ")";
                SupplierLinkManCollection linkManCollection = SupplierLinkManFactory.getLocalInstance(ctx).getCollection(linkManSql);
                oql = "select *,supplierLinkMan.* where id in (" + ids + ")";
                CoreBaseCollection supplierPurchaseCollection = SupplierPurchaseInfoFactory.getLocalInstance((Context)ctx).getCollection(oql);
                try {
                    for (i = 0; i < supplierPurchaseCollection.size(); ++i) {
                        SupplierPurchaseInfoInfo supplierPurchase = (SupplierPurchaseInfoInfo)supplierPurchaseCollection.get(i);
                        supplierPurchase.getSupplierLinkMan().clear();
                        for (j = 0; j < linkManCollection.size(); ++j) {
                            SupplierLinkManInfo linkMan = linkManCollection.get(j);
                            linkMan.setId(null);
                            linkMan.setSupplierPurchase(supplierPurchase);
                            supplierPurchase.getSupplierLinkMan().add((SupplierLinkManInfo)linkMan.clone());
                        }
                    }
                    SupplierPurchaseInfoFactory.getLocalInstance((Context)ctx).updateBatchData(supplierPurchaseCollection);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    throw new BOSException(e.getMessage());
                }
                isBank = true;
                isPurchaseInfoEntryFlag = true;
            }
        }
        if (!isBank) {
            super.executeUpdate(ctx);
        }
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (isCompanyInfoEntryFlag && this.uptIdList.size() > 0) {
            sql = new StringBuilder("Update T_BD_SupplierCompanyInfo Set flastupdatetime = getdate(),flastupdateuserid = '" + currentUserId + "' Where FID In(");
            for (int i = 0; i < this.uptIdList.size(); ++i) {
                sql.append("?");
                if (i >= this.uptIdList.size() - 1) continue;
                sql.append(",");
            }
            sql.append(")");
            super.execute(ctx, sql.toString(), this.uptIdList.toArray());
        }
        if (isPurchaseInfoEntryFlag && this.uptIdList.size() > 0) {
            sql = new StringBuilder("Update T_BD_SupplierPurchaseInfo Set flastupdatetime = getdate(),flastupdateuserid = '" + currentUserId + "' Where FID In(");
            for (int i = 0; i < this.uptIdList.size(); ++i) {
                sql.append("?");
                if (i >= this.uptIdList.size() - 1) continue;
                sql.append(",");
            }
            sql.append(")");
            super.execute(ctx, sql.toString(), this.uptIdList.toArray());
        }
        if (this.uptIdList == null || this.uptIdList.size() == 0 || this.values == null || !(this.values instanceof Map) || this.entity == null) {
            return;
        }
        ArrayList ls = new ArrayList();
        ls.addAll(((Map)this.values).values());
        ls.addAll(this.uptIdList);
        String tempSql = this.entity.createUpdateSQlCommand();
        if (tempSql.indexOf("FBrowseGroupID") != -1) {
            StringBuffer strBuffer = new StringBuffer();
            strBuffer.append(" update T_BD_SupplierGroupDetail set FSupplierGroupID = ? ");
            strBuffer.append(" where FSupplierGroupStandardID in (select FID from T_BD_CSSPGroupStandard where FIsBasic = 1 )");
            strBuffer.append(" and  FSupplierID in (");
            int size = this.uptIdList.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    strBuffer.append(",");
                }
                strBuffer.append("?");
            }
            strBuffer.append(")");
            super.execute(ctx, strBuffer.toString(), ls.toArray());
        }
        if (this.values instanceof Map && ((Map)this.values).get("isPurColl") != null) {
            String ids = "";
            int size = this.uptIdList.size();
            for (int i = 0; i < size; ++i) {
                ids = ids + ",'" + this.uptIdList.get(i) + "'";
            }
            ids = ids.substring(1);
            StringBuffer sql2 = new StringBuffer();
            sql2.append("update t_bd_supplierpurchaseinfo ");
            sql2.append("set FResponseTime=0,FConfirmNum=0,FNoticeAdvance=0,FIsAutoAudit=0,FIsConfirmPartial=1,FIsDeliverPlanCollaboration=1,FIsStoreDirect=1 where FIsPurCollaboration=0 and fid in (").append(ids).append(")");
            super.execute(ctx, sql2.toString(), new Object[0]);
        }
    }

    protected void checkLength(String[] propertiesToCheck, int length) throws CustomerSupplierException {
        for (int i = 0; i < propertiesToCheck.length; ++i) {
            String value;
            String propertiyToCheck = propertiesToCheck[i];
            if (!propertiyToCheck.equals(this.properties[0].toString()) || (value = (String)((Map)this.values).get(this.properties[0].toString())) == null || value.length() <= length) continue;
            throw new CustomerSupplierException(CustomerSupplierException.VALUETOOLARGE);
        }
    }
}

