/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.assistant.PayConditionInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.cssp.app.SupplierCompanyDataImport;
import com.kingdee.eas.basedata.master.cssp.app.SyncDataUtils;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class SyncSupplierCompanyData
extends SupplierCompanyDataImport {
    private static final String CSSPResource = "com.kingdee.eas.basedata.master.cssp.CSSPResource";
    String[] BOOLEAN_FIELDS = new String[]{"FIsFreezePayment"};
    String[] BOOLEAN_OBJS = new String[]{"isFreezePayment"};
    String[] STRING_FIELDS = new String[]{"FContactPerson", "FContactPersonPost", "FPhone", "FEMail", "FPostalcode", "FMobile", "FFax"};
    String[] STRING_OBJS = new String[]{"contactPerson", "contactPersonPost", "phone", "email", "postalcode", "mobile", "fax"};
    private Set PerminsionCheckedCuIds = new HashSet();
    SupplierCompanyInfoInfo oldBaseInfo;
    private Map<String, Boolean> userBizOrgRange = new HashMap<String, Boolean>();

    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return SupplierCompanyInfoFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), (Throwable)bex);
        }
    }

    @Override
    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase iSupplierCompanyInfo = this.getController(ctx);
        this.oldBaseInfo = (SupplierCompanyInfoInfo)coreBaseInfo;
        try {
            if (coreBaseInfo.getId() == null || !iSupplierCompanyInfo.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iSupplierCompanyInfo.submit(coreBaseInfo);
            } else {
                iSupplierCompanyInfo.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        SupplierCompanyInfoInfo supplierCompanyInfo = new SupplierCompanyInfoInfo();
        String str = null;
        Object data = null;
        CompanyOrgUnitInfo curCompany = null;
        Boolean updateFlag = false;
        try {
            String value;
            PaymentTypeInfo info;
            data = hsData.get("FComOrgID");
            if (data != null) {
                str = data.toString();
                curCompany = DataImportUtils.getCompanyOrgUnitInfoFromNumber(ctx, str);
                if (curCompany == null) {
                    throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "getCompanyOrgUnitFailed", ctx));
                }
                String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                boolean hasBizOrgRange = false;
                if (this.userBizOrgRange.containsKey(userId + curCompany.getId().toString())) {
                    hasBizOrgRange = this.userBizOrgRange.get(userId + curCompany.getId().toString());
                } else {
                    hasBizOrgRange = PerminsionUtil.isUserBizOrgRange((Context)ctx, (String)userId, (String)curCompany.getId().toString());
                    this.userBizOrgRange.put(userId + curCompany.getId().toString(), hasBizOrgRange);
                }
                if (!hasBizOrgRange) {
                    throw new TaskExternalException(new MaterialBaseException(MaterialBaseException.OUT_BIZ_ORG, new Object[]{curCompany.getName()}).getMessage());
                }
                String CuId = curCompany.getCU().getId().toString();
                if (!this.PerminsionCheckedCuIds.contains(CuId)) {
                    try {
                        PerminsionUtil.checkCUPerminsion((Context)ctx, (String)CuId, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), (String)"Suppliercompanyinfo_Import");
                    }
                    catch (EASBizException ee) {
                        throw new TaskExternalException(ee.getMessage(), (Throwable)ee);
                    }
                    this.PerminsionCheckedCuIds.add(CuId);
                }
            } else {
                throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "getCompanyOrgUnitFailed", ctx));
            }
            supplierCompanyInfo.setCompanyOrgUnit(curCompany);
            supplierCompanyInfo.setCU(curCompany.getCU());
            String numberdata = (String)hsData.get("FNumber");
            String comOrgNum = (String)hsData.get("FComOrgID");
            if (numberdata != null) {
                str = numberdata.toString();
                SupplierInfo supplierInfo = DataImportUtils.getSupplierInfoFromNumber(ctx, str);
                if (supplierInfo != null) {
                    supplierCompanyInfo.setSupplier(supplierInfo);
                    ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
                    SupplierCompanyInfoInfo oldSupplierCompanyInfo = iSupplier.getCompanyInfo((IObjectPK)new ObjectUuidPK(supplierCompanyInfo.getSupplier().getId()), (IObjectPK)new ObjectUuidPK(curCompany.getId()));
                    if (str != null && str.trim().length() > 0) {
                        if (oldSupplierCompanyInfo != null) {
                            supplierCompanyInfo = oldSupplierCompanyInfo;
                        }
                    } else if (supplierInfo != null) {
                        supplierCompanyInfo.setSupplier(supplierInfo);
                    }
                } else {
                    throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "supplierNotExist", ctx));
                }
            }
            supplierCompanyInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
            SyncDataUtils.setBooleanData(hsData, this.BOOLEAN_FIELDS, (CoreBaseInfo)supplierCompanyInfo, this.BOOLEAN_OBJS);
            if (hsData.get("FPostalcode") != null && hsData.get("FPostalcode").toString().length() > 10) {
                throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "postZipCode", ctx));
            }
            SyncDataUtils.setStringData(hsData, this.STRING_FIELDS, (CoreBaseInfo)supplierCompanyInfo, this.STRING_OBJS);
            if (hsData.get("FPaymentTypeID") != null && (info = DataImportUtils.getPaymentTypeInfoFromNumber(ctx, str = (data = hsData.get("FPaymentTypeID")).toString())) != null) {
                supplierCompanyInfo.setPaymentType(info);
            }
            if (hsData.get("FSettlementTypeID") != null && (info = DataImportUtils.getSettlementTypeInfoFromNumber(ctx, str = (data = hsData.get("FSettlementTypeID")).toString())) != null) {
                supplierCompanyInfo.setSettlementType((SettlementTypeInfo)info);
            }
            if (hsData.get("FSettlementCurrencyID") != null) {
                data = hsData.get("FSettlementCurrencyID");
                str = data.toString();
                info = DataImportUtils.getCurrencyInfoFromNumber(ctx, str);
                if (info != null) {
                    supplierCompanyInfo.setSettlementCurrency((CurrencyInfo)info);
                } else {
                    throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "SupplierCurrency", ctx));
                }
            }
            if (hsData.get("FPayConditionID") != null && (info = DataImportUtils.getPayConditionInfoByNumber(ctx, str = (data = hsData.get("FPayConditionID")).toString())) != null) {
                supplierCompanyInfo.setPayCondition((PayConditionInfo)info);
            }
            if (hsData.get("FAccountClassID") != null && (info = DataImportUtils.getKAClassficationInfoFromNumber(ctx, str = (data = hsData.get("FAccountClassID")).toString(), curCompany, "supplier")) != null) {
                supplierCompanyInfo.setAccountingClassification((KAClassficationInfo)info);
            }
            if (hsData.get("FFreezeOrgUnitID") != null && (info = DataImportUtils.getFullOrgUnitInfoFromNumber(ctx, str = (data = hsData.get("FFreezeOrgUnitID")).toString())) != null) {
                supplierCompanyInfo.setFreezeOrgUnit((FullOrgUnitInfo)info);
            }
            if ((data = hsData.get("FStatus")) != null) {
                value = data.toString();
                supplierCompanyInfo.setUsingStatus(DataImportUtils.getCSSPAsstStatusValue(value));
            }
            if ((data = hsData.get("FMobile")) != null) {
                value = data.toString();
                supplierCompanyInfo.setMobile(value);
            }
            SupplierCompanyBankCollection oldBanks = supplierCompanyInfo.getSupplierBank();
            List bankDataList = (List)this.getData(hsData, "FSupplierBank");
            HashMap<String, SupplierCompanyBankInfo> bankKeyValue = new HashMap<String, SupplierCompanyBankInfo>();
            for (int i = 0; i < oldBanks.size(); ++i) {
                SupplierCompanyBankInfo bank = oldBanks.get(i);
                bankKeyValue.put(bank.getBankAccount(), bank);
            }
            int countDefault = 0;
            for (int i = 0; i < bankDataList.size(); ++i) {
                Map bankData = (Map)bankDataList.get(i);
                String number = (String)bankData.get("FBankAccount");
                SupplierCompanyBankInfo addOrUpdateBankInfo = (SupplierCompanyBankInfo)bankKeyValue.remove(number);
                SupplierCompanyBankInfo bankAdd = new SupplierCompanyBankInfo();
                Boolean isDefault = (Boolean)this.getData(bankData, "FIsDefault");
                if (isDefault.booleanValue()) {
                    bankAdd.setIsDefault(isDefault);
                    ++countDefault;
                }
                if (countDefault > 1) {
                    throw new TaskExternalException(ResourceBase.getString((String)CSSPResource, (String)"SyncSupplierCompanyDataMsg001", (Locale)ctx.getOriginLocale()));
                }
                if (addOrUpdateBankInfo == null) {
                    if (number == null || number.trim().length() <= 0) continue;
                    bankAdd.setSupplierCompanyInfo(supplierCompanyInfo);
                    bankAdd.setBankAccount(number);
                    this.setBank(bankAdd, bankData);
                    oldBanks.add(bankAdd);
                    continue;
                }
                this.setBank(addOrUpdateBankInfo, bankData);
                oldBanks.set(i, addOrUpdateBankInfo);
            }
            for (SupplierCompanyBankInfo bank : bankKeyValue.values()) {
                oldBanks.remove(bank);
            }
        }
        catch (BOSException ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        catch (EASBizException ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        return supplierCompanyInfo;
    }

    private void addBank(SupplierCompanyInfoInfo supplierCompanyInfo, SupplierCompanyBankInfo bankInfo) {
        SupplierCompanyBankCollection banks = supplierCompanyInfo.getSupplierBank();
        int exsistPos = -1;
        for (int i = 0; i < banks.size(); ++i) {
            SupplierCompanyBankInfo tempBank = banks.get(i);
            if (tempBank.getBankAccount() == null || bankInfo.getBankAccount() == null || !tempBank.getBankAccount().equals(bankInfo.getBankAccount())) continue;
            exsistPos = i;
        }
        if (exsistPos >= 0) {
            banks.set(exsistPos, bankInfo);
        } else {
            banks.add(bankInfo);
        }
    }

    public Object getData(Map hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = hsData.get(fieldName);
        }
        return data;
    }

    public void setBank(SupplierCompanyBankInfo addOrUpdateBankInfo, Map bankData) {
        addOrUpdateBankInfo.setBankAddress((String)this.getData(bankData, "FBankAddress"));
        addOrUpdateBankInfo.setBank((String)this.getData(bankData, "FBankName"));
        addOrUpdateBankInfo.setBankEngName((String)this.getData(bankData, "FBankEngName"));
        addOrUpdateBankInfo.setBeneficiary((String)this.getData(bankData, "FBeneficiary"));
        addOrUpdateBankInfo.setBeneficiaryEngName((String)this.getData(bankData, "FBeneficiaryEngName"));
        addOrUpdateBankInfo.setBeneficiaryBankCode((String)this.getData(bankData, "FBeneficiaryBankCode"));
        addOrUpdateBankInfo.setBeneficiaryAddr((String)this.getData(bankData, "FBeneficiaryAddr"));
        addOrUpdateBankInfo.setBeneficiaryBankCountryISO((String)this.getData(bankData, "FBeneficiaryBankCountryISO"));
        addOrUpdateBankInfo.setBeneficiaryBankSWIFT((String)this.getData(bankData, "FBeneficiaryBankSWIFT"));
        addOrUpdateBankInfo.setSettlementParam((String)this.getData(bankData, "FSettlementParam"));
        addOrUpdateBankInfo.setAgencyBankAccount((String)this.getData(bankData, "FAgencyBankAccount"));
        addOrUpdateBankInfo.setAgencyBankName((String)this.getData(bankData, "FAgencyBankName"));
        addOrUpdateBankInfo.setAgencyBankSWIFT((String)this.getData(bankData, "FAgencyBankCountry"));
        addOrUpdateBankInfo.setAgencyBankCountryISO((String)this.getData(bankData, "FAgencyBankCountryISO"));
        addOrUpdateBankInfo.setAgencyBankAddr((String)this.getData(bankData, "FAgencyBankAddr"));
    }
}

