/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.assistant.IndustryInfo;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.assistant.RegionInfo;
import com.kingdee.eas.basedata.assistant.TaxDataInfo;
import com.kingdee.eas.basedata.master.cssp.BizAnalysisCodeInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.StandardTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierGroupDetailCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierGroupDetailInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.cssp.app.SupplierDataImport;
import com.kingdee.eas.basedata.master.cssp.app.SyncDataUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SyncSupplierData
extends SupplierDataImport {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.cssp.app.SupplierDataImport");
    private static final String CSSPResource = "com.kingdee.eas.basedata.master.cssp.CSSPResource";

    protected void delete(Context ctx, SupplierInfo supplierInfo) throws BOSException, EASBizException {
        ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
        iSupplier.delete((IObjectPK)new ObjectUuidPK(supplierInfo.getId()));
    }

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        try {
            CoreBaseInfo head = null;
            for (int i = 0; i < hsData.size(); ++i) {
                if (i == 0 && (head = this.createHead(hsData, ctx)) == null) {
                    return null;
                }
                this.createEntry(head, hsData, ctx);
            }
            return head;
        }
        catch (TaskExternalException te) {
            throw te;
        }
        catch (EASBizException ee) {
            logger.info((Object)ExceptionUtil.getExcLinkStackTrace((Throwable)ee));
            throw new TaskExternalException(ee.getMessage());
        }
        catch (Exception e) {
            String excLinkStackTrace = ExceptionUtil.getExcLinkStackTrace((Throwable)e);
            logger.error((Object)excLinkStackTrace);
            throw new TaskExternalException(excLinkStackTrace);
        }
    }

    public CoreBaseInfo createHead(Map hsData, Context ctx) throws TaskExternalException, EASBizException, BOSException {
        SupplierInfo supplierInfo = new SupplierInfo();
        supplierInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        supplierInfo.setCU(cu);
        String numberdata = (String)hsData.get("FNumber");
        SupplierInfo oldInfo = DataImportUtils.getSupplierInfoFromNumber(ctx, numberdata);
        String str = null;
        if (numberdata != null && numberdata.length() > 0 && (str = numberdata.toString()) != null && str.trim().length() > 0) {
            supplierInfo.setNumber(str);
            if (oldInfo != null) {
                try {
                    supplierInfo = (SupplierInfo)oldInfo.clone();
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            }
        }
        SyncDataUtils.setStringData(hsData, this.STRING_FIELDS, (CoreBaseInfo)supplierInfo, this.STRING_OBJS);
        SyncDataUtils.setBooleanData(hsData, this.BOOLEAN_FIELDS, (CoreBaseInfo)supplierInfo, this.BOOLEAN_OBJS);
        SyncDataUtils.setIntegerData(hsData, this.INTEGER_FIELDS, (CoreBaseInfo)supplierInfo, this.INTEGER_OBJS);
        Object data = null;
        String value = null;
        String[] multiStr = new String[]{"L1", "L2", "L3"};
        int c = multiStr.length;
        for (int i = 0; i < c; ++i) {
            data = hsData.get("FName_" + multiStr[i]);
            if (data == null) continue;
            supplierInfo.setName(data.toString(), new Locale(multiStr[i]));
        }
        data = hsData.get("FUsedStatus");
        if (data != null) {
            value = data.toString();
            UsedStatusEnum cs = DataImportUtils.getCustomerStatusValue(value);
            supplierInfo.setUsedStatus(cs);
            Object obj = hsData.get("FFreezeOrgUnit");
            if (UsedStatusEnum.FREEZED.equals((Object)cs) && (obj == null || obj.toString().trim().length() <= 0)) {
                CustomerSupplierException exception = new CustomerSupplierException(CustomerSupplierException.FREEZED_ORG_NULL);
                throw new TaskExternalException(exception.getMessage(), (Throwable)((Object)exception));
            }
        } else {
            throw new TaskExternalException(ResourceBase.getString((String)CSSPResource, (String)"SyncSupplierDataMsg001", (Locale)ctx.getOriginLocale()));
        }
        for (int i = 0; i < this.BIGDECIMAL_FIELDS.length; ++i) {
            try {
                BigDecimal bigDecimalValue;
                Object o = hsData.get(this.BIGDECIMAL_FIELDS[i]);
                if (o == null || o.toString().trim().length() <= 0 || (bigDecimalValue = new BigDecimal(o.toString())) == null) continue;
                supplierInfo.setBigDecimal(this.BIGDECIMAL_OBJ[i], bigDecimalValue);
                continue;
            }
            catch (NumberFormatException nex) {
                nex.printStackTrace();
                throw new TaskExternalException(this.BIGDECIMAL_OBJ[i] + DataImportUtils.getResource(CSSPResource, "FormmaterError", ctx));
            }
        }
        try {
            if (hsData.get("FBizAnalysisCodeID") != null) {
                BizAnalysisCodeInfo info;
                data = hsData.get("FBizAnalysisCodeID");
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getBizAnalysisCodeInfoFromNumber(ctx, str)) != null) {
                    supplierInfo.setBizAnalysisCode(info);
                }
            }
            if (hsData.get("FParentID") != null) {
                SupplierInfo info;
                ISupplier iSupplier;
                SupplierCollection collection;
                data = hsData.get("FParentID");
                if (data != null) {
                    str = data.toString();
                }
                if (str != null && str.trim().length() > 0 && (collection = (iSupplier = (ISupplier)this.getController(ctx)).getSupplierCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    supplierInfo.setParent(info);
                }
            }
            if (((data = hsData.get("FInternalSupplierType")) == null || "".equals(data)) && supplierInfo.isIsInternalCompany()) {
                CustomerSupplierException e = new CustomerSupplierException(CustomerSupplierException.INTERNALCUSTTYPENULL);
                throw new TaskExternalException(e.getMessage(), (Throwable)((Object)e));
            }
            value = data.toString();
            supplierInfo.setInternalSupplierType(DataImportUtils.getInternalCSSPType(value));
            if (hsData.get("FInternalCompanyID") != null) {
                CompanyOrgUnitInfo info;
                data = hsData.get("FInternalCompanyID");
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getCompanyOrgUnitInfoFromNumber(ctx, str)) != null) {
                    supplierInfo.setInternalCompany(info);
                }
            }
            if (hsData.get("FInternalProfitCenter") != null) {
                ProfitCenterOrgUnitInfo info;
                data = hsData.get("FInternalProfitCenter");
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getProfitCenter(ctx, str)) != null) {
                    supplierInfo.setInternalProfitCenter(info);
                }
            }
            if (hsData.get("FTaxDataID") != null) {
                TaxDataInfo info;
                data = hsData.get("FTaxDataID");
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getTaxDataInfoFromNumber(ctx, str)) != null) {
                    supplierInfo.setTaxData(info);
                }
            }
            if (hsData.get("FIndustryID") != null) {
                IndustryInfo info;
                data = hsData.get("FIndustryID");
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getIndustryInfoFromNumber(ctx, str)) != null) {
                    supplierInfo.setIndustry(info);
                }
            }
            if (hsData.get("FCountryID") != null) {
                CountryInfo info;
                data = hsData.get("FCountryID");
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getCountryInfoFromNumber(ctx, str)) != null) {
                    supplierInfo.setCountry(info);
                }
            }
            if (hsData.get("FProvinceID") != null) {
                ProvinceInfo info;
                data = hsData.get("FProvinceID");
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getProvinceInfoFromNumber(ctx, str)) != null) {
                    supplierInfo.setProvince(info);
                }
            }
            if (hsData.get("FCityID") != null) {
                CityInfo info;
                data = hsData.get("FCityID");
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getCityInfoFromNumber(ctx, str)) != null) {
                    supplierInfo.setCity(info);
                }
            }
            if (hsData.get("FRegionID") != null) {
                RegionInfo info;
                data = hsData.get("FRegionID");
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getRegionInfoFromNumber(ctx, str)) != null) {
                    supplierInfo.setRegion(info);
                }
            }
            if (hsData.get("FFreezeOrgUnit") != null) {
                FullOrgUnitInfo info;
                data = hsData.get("FFreezeOrgUnit");
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getFullOrgUnitInfoFromNumber(ctx, str)) != null) {
                    supplierInfo.setFreezeOrgUnit(info);
                }
            }
        }
        catch (BOSException ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        return supplierInfo;
    }

    protected void createEntry(CoreBaseInfo head, Map hsData, Context ctx) throws Exception {
        int pos;
        SupplierInfo supplierInfo = (SupplierInfo)head;
        Object data = null;
        CSSPGroupStandardInfo groupStandardInfo = null;
        SupplierGroupDetailInfo detailInfo = new SupplierGroupDetailInfo();
        data = hsData.get("FSupplierGroupStandardID");
        if (data == null || data.toString().length() == 0) {
            throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "standardNotExist", ctx));
        }
        String str = data.toString();
        groupStandardInfo = DataImportUtils.getGroupStandardInfoByNumber(ctx, str, "supplier");
        if (groupStandardInfo == null) {
            throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "standardNotExist", ctx));
        }
        detailInfo.setSupplierGroupStandard(groupStandardInfo);
        data = hsData.get("FSupplierGroupID");
        if (data == null || data.toString().length() == 0) {
            throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "groupNotExist", ctx));
        }
        str = data.toString();
        CSSPGroupInfo groupInfo = DataImportUtils.getGroupInfoByNumber(ctx, str, hsData.get("FSupplierGroupStandardID").toString(), "supplier");
        if (groupInfo == null) {
            throw new TaskExternalException(DataImportUtils.getResource(CSSPResource, "groupNotExist", ctx));
        }
        detailInfo.setSupplierGroup(groupInfo);
        if (groupStandardInfo.getIsBasic() == StandardTypeEnum.basicStandard) {
            supplierInfo.setBrowseGroup(groupInfo);
        }
        if ((pos = this.isInCollection(detailInfo, supplierInfo.getSupplierGroupDetails())) < 0) {
            supplierInfo.getSupplierGroupDetails().add(detailInfo);
        } else {
            supplierInfo.getSupplierGroupDetails().set(pos, detailInfo);
        }
    }

    private int isInCollection(SupplierGroupDetailInfo info, SupplierGroupDetailCollection collection) {
        if (collection == null) {
            return -1;
        }
        for (int i = 0; i < collection.size(); ++i) {
            SupplierGroupDetailInfo tempInfo = collection.get(i);
            if (!tempInfo.getSupplierGroupStandard().getId().equals((Object)info.getSupplierGroupStandard().getId())) continue;
            return i;
        }
        return -1;
    }
}

