/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierPurchaseInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoInfo;
import com.kingdee.eas.basedata.master.cssp.app.AbstractSyncSupplierFacadeControllerBean;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.cssp.app.SyncSupplierCompanyData;
import com.kingdee.eas.basedata.master.cssp.app.SyncSupplierData;
import com.kingdee.eas.basedata.master.material.JSONUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.ws.common.WsCommonUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.TimeStampUtility;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SyncSupplierFacadeControllerBean
extends AbstractSyncSupplierFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.cssp.app.SyncSupplierFacadeControllerBean");
    private static final String CSSPResource = "com.kingdee.eas.basedata.master.cssp.CSSPResource";
    private String billNumber = "";
    private String retstatus = "0";
    private String errorMessage = "";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return SupplierFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), (Throwable)bex);
        }
    }

    @Override
    protected Map _syncSupplier(Context ctx, Map mapData) throws BOSException, EASBizException {
        logger.info((Object)"=====\u8c03\u7528\u540c\u6b65\u4f9b\u5e94\u5546\u63a5\u53e3");
        Map<String, Object> message = null;
        String operate = "";
        SupplierInfo supplierBaseInfo = null;
        try {
            Map supplierMap = (Map)mapData.get("supplierInfo");
            List supplierCompanyList = (List)mapData.get("supplierCompanyInfo");
            SyncSupplierData syncBaseData = new SyncSupplierData();
            SyncSupplierCompanyData syncCompany = new SyncSupplierCompanyData();
            if (supplierMap != null) {
                supplierBaseInfo = (SupplierInfo)syncBaseData.transmit(supplierMap, ctx);
                if ("1".equals(mapData.get("deleteFlag"))) {
                    operate = "delete";
                    syncBaseData.delete(ctx, supplierBaseInfo);
                    message = this.messageResult(200, "number:" + mapData.get("FNumber"), operate);
                    return message;
                }
                operate = supplierBaseInfo.getId() != null ? "update" : "addNew";
                syncBaseData.submit((CoreBaseInfo)supplierBaseInfo, ctx);
                if (supplierCompanyList != null) {
                    for (Map supplierCompanyMap : supplierCompanyList) {
                        SupplierCompanyInfoInfo companyInfo = (SupplierCompanyInfoInfo)syncCompany.transmit(supplierCompanyMap, ctx);
                        syncCompany.submit((CoreBaseInfo)companyInfo, ctx);
                    }
                }
                message = this.messageResult(200, "number:" + mapData.get("FNumber"), operate);
            } else {
                message = this.messageResult(500, ResourceBase.getString((String)CSSPResource, (String)"SyncSupplierFacadeMsg001", (Locale)ctx.getOriginLocale()), operate);
            }
        }
        catch (TaskExternalException e) {
            message = this.messageResult(500, "number:" + mapData.get("FNumber") + "," + e.getMessage(), operate);
            logger.error((Object)("=====\u8c03\u7528\u540c\u6b65\u4f9b\u5e94\u5546\u63a5\u53e3\u9519\u8bef\uff01" + message));
        }
        catch (Exception e) {
            message = this.messageResult(500, "number:" + supplierBaseInfo.getNumber() + "," + e.getMessage(), operate);
            logger.error((Object)("=====\u8c03\u7528\u540c\u6b65\u4f9b\u5e94\u5546\u63a5\u53e3\u9519\u8bef\uff01" + message));
        }
        return message;
    }

    public Map<String, Object> messageResult(Integer code, String message, String operate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", code);
        map.put("message", message);
        map.put("operate", operate);
        return map;
    }

    protected String syncSupplierBase(Context ctx, Map baseMap) throws BOSException, EASBizException {
        try {
            this.billNumber = (String)baseMap.get("number");
            CtrlUnitInfo cuInfo = WsCommonUtil.getCuInfo((Context)ctx, (String)((String)baseMap.get("CU")));
            if (cuInfo == null) {
                throw new Exception(DataImportUtils.getResource("com.kingdee.eas.basedata.ws.common.WebSericeResource", "CUNOTFOUND", ctx));
            }
            ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)cuInfo);
            String bostype = (String)baseMap.get("bostype");
            SupplierInfo supplierInfo = new SupplierInfo();
            EntityObjectInfo entityObjectInfo = WsCommonUtil.getEntityObjectInfo((Context)ctx, (String)bostype);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private void saveCompanyAndPurchase(Context ctx, SupplierInfo supplierInfo) throws Exception {
        try {
            ISupplierCompanyInfo isupplierCompanyInfo = SupplierCompanyInfoFactory.getLocalInstance(ctx);
            ISupplierPurchaseInfo iSupplierPurchaseInfo = SupplierPurchaseInfoFactory.getLocalInstance((Context)ctx);
            if (null != supplierInfo.getCU()) {
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(supplierInfo.getCU().getId()));
                SupplierCompanyInfoInfo companyInfoVo = new SupplierCompanyInfoInfo();
                companyInfoVo.setCompanyOrgUnit(company);
                companyInfoVo.setSupplier(supplierInfo);
                companyInfoVo.setCU(company.getCU());
                companyInfoVo.setIsFreezePayment(false);
                companyInfoVo.setCreateTime(TimeStampUtility.getTime());
                companyInfoVo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
                companyInfoVo.setLastUpdateTime(null);
                companyInfoVo.setLastUpdateUser(null);
                String accountTableId = null;
                if (company != null) {
                    if (company.getAccountTable() != null) {
                        accountTableId = company.getAccountTable().getId().toString();
                        String companyOrgId = company.getId().toString();
                        KAClassficationInfo kaClassficationInfo = WsCommonUtil.getDefaultAccountClass((String)"supplier", (String)companyOrgId, (String)accountTableId, (Context)ctx);
                        companyInfoVo.setAccountingClassification(kaClassficationInfo);
                    } else {
                        companyInfoVo.setAccountingClassification(null);
                    }
                }
                companyInfoVo.setSettlementCurrency(company.getBaseCurrency());
                isupplierCompanyInfo.submit((CoreBaseInfo)companyInfoVo);
                PurchaseOrgUnitInfo purOrg = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx).getPurchaseOrgUnitInfo((IObjectPK)new ObjectUuidPK(supplierInfo.getCU().getId()));
                SupplierPurchaseInfoInfo purchaseInfo = new SupplierPurchaseInfoInfo();
                purchaseInfo.setPurchaseOrgUnit(purOrg);
                purchaseInfo.setDeliverOrgUnit(supplierInfo);
                purchaseInfo.setBillingOrgUnit(supplierInfo);
                purchaseInfo.setSupplier(supplierInfo);
                purchaseInfo.setGrade("0");
                purchaseInfo.setCU(purOrg.getCU());
                purchaseInfo.setIsFreezeMakeOrder(false);
                purchaseInfo.setCreateTime(TimeStampUtility.getTime());
                purchaseInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
                purchaseInfo.setLastUpdateTime(null);
                purchaseInfo.setLastUpdateUser(null);
                iSupplierPurchaseInfo.submit((CoreBaseInfo)purchaseInfo);
            }
        }
        catch (Exception e) {
            String msg = EASCommonResource.getString((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"AddSup_PurChase_Error", (Locale)ctx.getLocale());
            throw new Exception(msg);
        }
    }

    public static void main(String[] args) throws BOSException {
        String data = "{\n\t\"deleteFlag\":false,\n\t\"supplierInfo\":{\n\t\t\"FIsInternalCompany\":false,\n\t\t\"FUsedStatus\":\"0\",\n\t\t\"FName_L3\":\"ggh\",\n\t\t\"FName_L2\":\"ggh\",\n\t\t\"FSupplierGroupID\":\"whc-test\",\n\t\t\"FSupplierGroupStandardID\":\"supplierGroupStandard\",\n\t\t\"FNumber\":\"Sup-000001\"\n\t},\n\t\"supplierCompanyInfo\":[\n\t\t{\n\t\t\t\"FComOrgID\":\"Q6HEpQEREADgAj6QwKg9A8znrtQ=\",\n\t\t\t\"FIsFreezePayment\":false,\n\t\t\t\"FNumber\":\"Sup-000001\",\n\t\t\t\"FSupplierBank\":[]\n\t\t}\n\t]\n}";
        HashMap mapData = JSONUtils.convertJsonToObject((String)data);
        Map supplierInfo = (Map)mapData.get("supplierInfo");
        String str = JSONObject.toJSONString((Object)supplierInfo);
        List supplierCompanyInfo = (List)mapData.get("supplierCompanyInfo");
        Map supplierPurchaseInfo = (Map)mapData.get("supplierPurchaseInfo");
    }
}

