/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class BaseDataAssignLogUtil {
    private static final ResourceBundleHelper resHelperCustomer = new ResourceBundleHelper("com.kingdee.eas.basedata.master.cssp.CSSPResource");
    private static final String MaterialResource = "com.kingdee.eas.basedata.master.material.MaterialResource";

    public static IObjectPK doAssignLogSupplier(Context ctx, Object[] orgIds, String dataSql, Object[] notInDataIds, Object[] dataIds, String logItem, String logOperation) {
        Object[] customerNumbers = null;
        IObjectPK logPk = null;
        try {
            if (dataSql != null) {
                IRowSet dataRS = DbUtil.executeQuery((Context)ctx, (String)dataSql);
                HashMap<String, String> dataMap = new HashMap<String, String>();
                try {
                    while (dataRS.next()) {
                        dataMap.put(dataRS.getString("ID"), dataRS.getString("NUMBER"));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new BOSException((Throwable)e);
                }
                if (notInDataIds != null && notInDataIds.length > 0) {
                    for (Object notInDataId : notInDataIds) {
                        dataMap.remove(notInDataId);
                    }
                }
                customerNumbers = dataMap.values().toArray();
            }
            if (dataIds != null) {
                SupplierCollection customerCol = BaseDataAssignLogUtil.getSupplierCollectionForLog(ctx, Arrays.asList((Object[])dataIds));
                customerNumbers = new Object[customerCol.size()];
                for (int i = 0; i < customerCol.size(); ++i) {
                    customerNumbers[i] = customerCol.get(i).getNumber();
                }
            }
            StringBuilder ids = new StringBuilder();
            for (int i = 0; i < orgIds.length; ++i) {
                ids.append(" '").append(orgIds[i]).append("'");
                if (i == orgIds.length - 1) continue;
                ids.append(",");
            }
            CoreBaseCollection ouCol = FullOrgUnitFactory.getLocalInstance((Context)ctx).getCollection("select id,number where id in (" + ids + ")");
            Object[] ouArrNumber = new String[ouCol.size()];
            for (int i = 0; i < ouCol.size(); ++i) {
                ouArrNumber[i] = (String)ouCol.get(i).get("number");
            }
            String logStr = "\u76ee\u6807\u4e1a\u52a1\u7ec4\u7ec7\uff1a" + Arrays.toString((Object[])ouArrNumber) + "    \n\u4f9b\u5e94\u5546\uff1a" + Arrays.toString((Object[])customerNumbers);
            logPk = LogUtil.beginLog((Context)ctx, (String)"getLogMsg", (BOSObjectType)new SupplierInfo().getBOSType(), null, (String)logStr, (String)logItem, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)logOperation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return logPk;
    }

    private static SupplierCollection getSupplierCollectionForLog(Context ctx, List list) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", new HashSet(list), CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("name"));
        viewInfo.setSelector(selectors);
        return SupplierFactory.getLocalInstance(ctx).getSupplierCollection(viewInfo);
    }

    public static IObjectPK doAssignLogCustomer(Context ctx, Object[] orgIds, String dataSql, Object[] notInDataIds, Object[] dataIds, String logItem, String logOperation) throws BOSException {
        Object[] customerNumbers = null;
        IObjectPK logPk = null;
        try {
            if (dataSql != null) {
                IRowSet dataRS = DbUtil.executeQuery((Context)ctx, (String)dataSql);
                HashMap<String, String> dataMap = new HashMap<String, String>();
                try {
                    while (dataRS.next()) {
                        dataMap.put(dataRS.getString("ID"), dataRS.getString("NUMBER"));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new BOSException((Throwable)e);
                }
                if (notInDataIds != null && notInDataIds.length > 0) {
                    for (Object notInDataId : notInDataIds) {
                        dataMap.remove(notInDataId);
                    }
                }
                customerNumbers = dataMap.values().toArray();
            }
            if (dataIds != null) {
                CustomerCollection customerCol = BaseDataAssignLogUtil.getCustomerCollectionForLog(ctx, Arrays.asList((Object[])dataIds));
                customerNumbers = new Object[customerCol.size()];
                for (int i = 0; i < customerCol.size(); ++i) {
                    customerNumbers[i] = customerCol.get(i).getNumber();
                }
            }
            StringBuilder ids = new StringBuilder();
            for (int i = 0; i < orgIds.length; ++i) {
                ids.append(" '").append(orgIds[i]).append("'");
                if (i == orgIds.length - 1) continue;
                ids.append(",");
            }
            CoreBaseCollection ouCol = FullOrgUnitFactory.getLocalInstance((Context)ctx).getCollection("select id,number where id in (" + ids + ")");
            Object[] ouArrNumber = new String[ouCol.size()];
            for (int i = 0; i < ouCol.size(); ++i) {
                ouArrNumber[i] = (String)ouCol.get(i).get("number");
            }
            String logStr = resHelperCustomer.getString("AsyncAssignLogMsg001") + Arrays.toString((Object[])ouArrNumber) + "    \n" + resHelperCustomer.getString("AsyncAssignLogMsg002") + Arrays.toString((Object[])customerNumbers);
            logPk = LogUtil.beginLog((Context)ctx, (String)"getLogMsg", (BOSObjectType)new CustomerInfo().getBOSType(), null, (String)logStr, (String)logItem, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)logOperation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return logPk;
    }

    private static CustomerCollection getCustomerCollectionForLog(Context ctx, List list) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", new HashSet(list), CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("name"));
        viewInfo.setSelector(selectors);
        return CustomerFactory.getLocalInstance(ctx).getCustomerCollection(viewInfo);
    }

    public static IObjectPK doAssignLogMaterial(Context ctx, Object[] orgIds, String dataSql, Object[] notInDataIds, Object[] dataIds, String logItem, String logOpertion) throws BOSException {
        Object[] materialNumbsers = null;
        IObjectPK logPk = null;
        try {
            if (dataSql != null) {
                IRowSet dataRS = DbUtil.executeQuery((Context)ctx, (String)dataSql);
                HashMap<String, String> dataMap = new HashMap<String, String>();
                try {
                    while (dataRS.next()) {
                        dataMap.put(dataRS.getString("ID"), dataRS.getString("NUMBER"));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new BOSException((Throwable)e);
                }
                if (notInDataIds != null && notInDataIds.length > 0) {
                    for (int i = 0; i < notInDataIds.length; ++i) {
                        if (!dataMap.containsKey(notInDataIds[i])) continue;
                        dataMap.remove(notInDataIds[i]);
                    }
                }
                String[] arrNumber = new String[dataMap.size()];
                materialNumbsers = dataMap.values().toArray();
            }
            if (dataIds != null) {
                MaterialCollection materialCol = BaseDataAssignLogUtil.getMaterialCollectionForLog(ctx, Arrays.asList((Object[])dataIds));
                materialNumbsers = new Object[materialCol.size()];
                for (int i = 0; i < materialCol.size(); ++i) {
                    materialNumbsers[i] = materialCol.get(i).getNumber();
                }
            }
            StringBuilder ids = new StringBuilder();
            for (int i = 0; i < orgIds.length; ++i) {
                ids.append(" '").append(orgIds[i]).append("'");
                if (i == orgIds.length - 1) continue;
                ids.append(",");
            }
            CoreBaseCollection ouCol = FullOrgUnitFactory.getLocalInstance((Context)ctx).getCollection("select id,number where id in (" + ids + ")");
            Object[] ouArrNumber = new String[ouCol.size()];
            for (int i = 0; i < ouCol.size(); ++i) {
                ouArrNumber[i] = (String)ouCol.get(i).get("number");
            }
            String logStr = EASCommonResource.getString((String)MaterialResource, (String)"AsyncAssignLogMaterialMsg01", (Locale)ctx.getOriginLocale()) + Arrays.toString((Object[])ouArrNumber) + "    \n" + EASCommonResource.getString((String)MaterialResource, (String)"AsyncAssignLogMaterialMsg02", (Locale)ctx.getOriginLocale()) + Arrays.toString((Object[])materialNumbsers);
            logPk = LogUtil.beginLog((Context)ctx, (String)"getLogMsg", (BOSObjectType)new MaterialInfo().getBOSType(), null, (String)logStr, (String)logItem, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)logOpertion);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return logPk;
    }

    private static MaterialCollection getMaterialCollectionForLog(Context ctx, List list) throws BOSException {
        MaterialCollection resultCollection = new MaterialCollection();
        if (list == null || list.isEmpty()) {
            return resultCollection;
        }
        int perNum = 1000;
        int total = (list.size() + perNum - 1) / perNum;
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("name"));
        viewInfo.setSelector(selectors);
        for (int i = 1; i <= total; ++i) {
            List currentIds = list.stream().skip(perNum * (i - 1)).limit(perNum).collect(Collectors.toList());
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", new HashSet(currentIds), CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            MaterialCollection collection = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(viewInfo);
            if (collection == null || collection.size() <= 0) continue;
            resultCollection.addCollection(collection);
        }
        return resultCollection;
    }
}

