/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CsspUtils {
    private static final Logger logger = Logger.getLogger((String)CsspUtils.class.getSimpleName());

    public static String trim(String str) {
        Pattern trimPatt = Pattern.compile("^[\\u3000\\u0020\\u0009]*(.*?)[\\u3000\\u0020\\u0009]*$");
        if (str == null) {
            return str;
        }
        if (str.trim().length() <= 0) {
            return str.trim();
        }
        Matcher m = trimPatt.matcher(str);
        if (m.find()) {
            return m.group(1);
        }
        return str;
    }

    public static String getRandomNumber(int count) {
        StringBuffer sb = new StringBuffer();
        String str = "0123456789";
        SecureRandom r = new SecureRandom();
        for (int i = 0; i < count; ++i) {
            int num = r.nextInt(str.length());
            sb.append(str.charAt(num));
        }
        return sb.toString();
    }

    public static void afterApproveSyncCustomerTax(Context ctx, CtrlUnitInfo cuInfo, OrgUnitInfo orgInfo, List<String> idList) {
        try {
            String serviceName = "com.kingdee.eas.tm.im.util.invoice.CustomerTaxSyncService";
            String methodName = "syncCustomerTax";
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("idList", idList);
            if (null != cuInfo) {
                param.put("cuid", cuInfo.getId().toString());
                if (null != orgInfo) {
                    param.put("companyID", orgInfo.getId().toString());
                } else {
                    logger.error((Object)"customer syncCustomerTax current org info is null");
                    param.put("companyID", cuInfo.getId().toString());
                }
            } else {
                logger.error((Object)"customer syncCustomerTax current cu info is null");
            }
            try {
                Class<?> c = Class.forName(serviceName);
                Object obj = c.newInstance();
                Method method = c.getMethod(methodName, Context.class, Map.class);
                method.invoke(obj, ctx, param);
                logger.error((Object)("tax sync customer task:" + methodName));
            }
            catch (Exception e) {
                logger.error((Object)("tax sync customer reflect failed:" + e.getMessage()), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)("tax sync customer failed:" + e.getMessage()), (Throwable)e);
        }
    }

    public static boolean strEquals(CharSequence str1, CharSequence str2, boolean ignoreCase) {
        if (null == str1) {
            return str2 == null;
        }
        if (null == str2) {
            return false;
        }
        if (ignoreCase) {
            return str1.toString().equalsIgnoreCase(str2.toString());
        }
        return str1.toString().contentEquals(str2);
    }

    public static String convertStr(String mutiResourceStr, String ... param) {
        MessageFormat mf = new MessageFormat(mutiResourceStr);
        String[] arrStr = null;
        if (param != null && param.length > 0) {
            arrStr = new String[param.length];
            for (int i = 0; i < param.length; ++i) {
                arrStr[i] = param[i];
            }
            String formatStr = mf.format(arrStr);
            return formatStr;
        }
        return mutiResourceStr;
    }
}

