/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.framework.DataBaseDAssignFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class CsspMaterialUtils {
    public static final String IS_CHECKED = "isChecked";
    public static final String MaterialResource = "com.kingdee.eas.basedata.master.material.MaterialResource";
    public static final String SYNC_ASSIST_ERRORMSG = "SyncAssistErrorMsg";

    public static String[] findAssignIds(IObjectPK[] dataIds, IObjectPK[] unAssignPks) {
        HashSet<IObjectPK> set = new HashSet<IObjectPK>();
        for (int i = 0; i < unAssignPks.length; ++i) {
            set.add(unAssignPks[i]);
        }
        String[] assignIds = new String[dataIds.length - unAssignPks.length];
        int index = 0;
        for (int i = 0; i < dataIds.length; ++i) {
            if (!set.add(dataIds[i])) continue;
            assignIds[index++] = dataIds[i].toString();
        }
        return assignIds;
    }

    public static String checkAssignBaseData(Context ctx, FullOrgUnitInfo sourceOrgUnitInfo, String[] diddata, FullOrgUnitCollection targetOrgUnitColl, Map<String, Object> assignData, String bosType) throws EASBizException, BOSException {
        HashSet<String> repeteCuSet = new HashSet<String>();
        StringBuffer detialMsg = new StringBuffer();
        for (int i = 0; i < targetOrgUnitColl.size(); ++i) {
            FullOrgUnitInfo targetOrgUnit = targetOrgUnitColl.get(i);
            String destCuid = targetOrgUnit.getCU().getId().toString();
            if (destCuid.equals(sourceOrgUnitInfo.getCU().getId().toString())) continue;
            if (assignData.size() == 0) {
                assignData.put(IS_CHECKED, true);
            }
            if (!repeteCuSet.add(destCuid)) continue;
            repeteCuSet.add(targetOrgUnit.getCU().getId().toString());
            IObjectPK[] dataIds = new IObjectPK[diddata.length];
            for (int j = 0; j < diddata.length; ++j) {
                dataIds[j] = new ObjectUuidPK(diddata[j]);
            }
            IObjectPK[] unAssignPks = CsspMaterialUtils.getUnAssignPks(ctx, (IObjectPK)new ObjectUuidPK(destCuid), dataIds);
            if (unAssignPks != null && unAssignPks.length > 0) {
                String[] assignPks;
                int j;
                HashSet<IObjectPK> setPk = new HashSet<IObjectPK>();
                for (IObjectPK pk : unAssignPks) {
                    setPk.add(pk);
                }
                CtrlUnitInfo cu = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(targetOrgUnit.getCU().getId()));
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterIds = new FilterInfo();
                filterIds.getFilterItems().add(new FilterItemInfo("id", setPk, CompareType.INCLUDE));
                view.setFilter(filterIds);
                if ("BF0C040E".equals(bosType)) {
                    CustomerCollection customerCol = CustomerFactory.getLocalInstance(ctx).getCustomerCollection(view);
                    detialMsg.append("\n" + cu.getName() + "[" + cu.getNumber() + "]  :  ");
                    for (j = 0; j < customerCol.size(); ++j) {
                        detialMsg.append(customerCol.get(j).getName() + "  ");
                    }
                } else if ("37C67DFC".equals(bosType)) {
                    SupplierCollection supplierCol = SupplierFactory.getLocalInstance(ctx).getSupplierCollection(view);
                    detialMsg.append("\n" + cu.getName() + "[" + cu.getNumber() + "]  :  ");
                    for (j = 0; j < supplierCol.size(); ++j) {
                        detialMsg.append(supplierCol.get(j).getName() + "  ");
                    }
                } else if ("4409E7F0".equals(bosType)) {
                    MaterialCollection materialCol = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
                    detialMsg.append("\n" + cu.getName() + "[" + cu.getNumber() + "]  :  ");
                    for (j = 0; j < materialCol.size(); ++j) {
                        detialMsg.append(materialCol.get(j).getName() + "  ");
                    }
                }
                if ((assignPks = CsspMaterialUtils.findAssignIds(dataIds, unAssignPks)) == null) continue;
                assignData.put(destCuid, assignPks);
                continue;
            }
            String[] assignIds = new String[dataIds.length];
            int index = 0;
            for (IObjectPK pk : dataIds) {
                assignIds[index++] = pk.toString();
            }
            assignData.put(destCuid, assignIds);
        }
        return detialMsg.toString();
    }

    private static IObjectPK[] getUnAssignPks(Context ctx, IObjectPK cuPk, IObjectPK[] dataIds) throws EASBizException, BOSException {
        return DataBaseDAssignFactory.getLocalInstance((Context)ctx).getUnAssignedPKs(cuPk, dataIds);
    }

    public static void getMsg(boolean firstFlag, Map<String, String> returnMap, Map<String, String> result, String resource, String type) {
        if (firstFlag && returnMap.get("detailsMsg") != null) {
            String head = EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)SYNC_ASSIST_ERRORMSG, (Object[])new Object[]{EASResource.getString((String)resource, (String)type)});
            result.put("detailsMsg", head + returnMap.get("detailsMsg"));
            String mainMsg = EASResource.getString((String)resource, (String)"assign2Fail");
            result.put("mainMsg", mainMsg);
        } else if (returnMap.get("detailsMsg") != null) {
            result.put("detailsMsg", result.get("detailsMsg") + returnMap.get("detailsMsg"));
        }
    }

    public static boolean isNotEmptyCollection(Collection col) {
        if (col == null) {
            return false;
        }
        return col.size() >= 1;
    }
}

