/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.master.auxacct.app.AssistUtil;
import com.kingdee.eas.basedata.master.cssp.AbstractDataMergeImpl;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.DataMergeEntryInfo;
import com.kingdee.eas.basedata.master.cssp.DataMergeInfo;
import com.kingdee.eas.basedata.master.cssp.DataMergeTypeEnum;
import com.kingdee.eas.basedata.master.cssp.HeadDetailException;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoInfo;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;

public class BDSupplierMergeImpl
extends AbstractDataMergeImpl {
    protected String[] getMergeTables() {
        return new String[]{"T_BD_MaterialPurchasing"};
    }

    protected String[] getMergeFields() {
        return new String[]{"FSupplier"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String merge(Context ctx, DataMergeInfo mergeInfo) throws Exception {
        this.mergeCheck(ctx, mergeInfo);
        String[] mergeTables = new String[]{"T_BD_SupplierPurchaseInfo", "T_BD_SupplierPurchaseInfo"};
        String[] mergeFields = new String[]{"FDeliverOrgUnitID", "FBillingOrgUnitID"};
        String destId = mergeInfo.getDestId();
        Object[] srcIds = mergeInfo.getSrcIds();
        Connection conn = null;
        Statement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.createStatement();
            for (int i = 0; i < mergeTables.length; ++i) {
                StringBuffer sb = new StringBuffer();
                sb.append(" update ").append(mergeTables[i]);
                sb.append(" set ").append(mergeFields[i]).append("='").append(destId).append("' ");
                sb.append(" where ").append(mergeFields[i]).append(" in ").append(StringUtil.getIdsSql((Object[])srcIds));
                sb.append(" and FSupplierID not in ").append(StringUtil.getIdsSql((Object[])srcIds));
                ps.addBatch(sb.toString());
            }
            ArrayList<String> freezeList = new ArrayList<String>();
            int size = mergeInfo.getEntries().size();
            for (int i = 0; i < size; ++i) {
                DataMergeEntryInfo entryInfo = mergeInfo.getEntries().get(i);
                if (!entryInfo.isIsFreeze()) continue;
                freezeList.add(entryInfo.getSrcId());
            }
            if (freezeList.size() > 0) {
                Object[] freezeIds = new String[freezeList.size()];
                int size2 = freezeList.size();
                for (int i = 0; i < size2; ++i) {
                    freezeIds[i] = (String)freezeList.get(i);
                }
                StringBuffer sb = new StringBuffer();
                sb.append(" update T_BD_Supplier set FFreezeOrgUnit = FControlUnitID,");
                sb.append(" FUsedStatus = ").append(String.valueOf(3));
                sb.append(" where FID in ").append(StringUtil.getIdsSql((Object[])freezeIds));
                ps.addBatch(sb.toString());
            }
            ps.executeBatch();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(ps, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < mergeTables.length; ++i) {
            msg.append(mergeTables[i]).append("/").append(mergeFields[i]).append(",");
        }
        msg.setCharAt(msg.length() - 1, '.');
        String superMsg = super.merge(ctx, mergeInfo);
        SupplierInfo supplierInfo = new SupplierInfo();
        AssistUtil.updateAssist((Context)ctx, (String)mergeInfo.getDestId(), (BOSObjectType)supplierInfo.getBOSType());
        String s = ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"MergeCompleted2", (Locale)ctx.getOriginLocale());
        MessageFormat mf = new MessageFormat(s);
        return mf.format(new String[]{superMsg, msg.toString()});
    }

    public void mergeCheck(Context ctx, DataMergeInfo mergeInfo) throws Exception {
        CustomerSupplierException customerSupplierException;
        int i;
        CompanyOrgUnitCollection companyOrgCollection = this.getNoSupplierCompanyOrg(ctx, mergeInfo);
        PurchaseOrgUnitCollection purchasrOrgCollection = this.getNoSupplierPurOrg(ctx, mergeInfo);
        String msgDetail = "";
        for (i = 0; i < companyOrgCollection.size(); ++i) {
            CompanyOrgUnitInfo companyOrgUnit = companyOrgCollection.get(i);
            customerSupplierException = new CustomerSupplierException(CustomerSupplierException.MERGEMISSINGYORGASSTDATA2, (Object[])new String[]{" [" + companyOrgUnit.getNumber() + "-" + companyOrgUnit.getName() + "] ", ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"financeAttribute", (Locale)ctx.getOriginLocale())});
            msgDetail = msgDetail + customerSupplierException.getMessage() + "\n";
        }
        for (i = 0; i < purchasrOrgCollection.size(); ++i) {
            PurchaseOrgUnitInfo purchaseOrgUnit = purchasrOrgCollection.get(i);
            customerSupplierException = new CustomerSupplierException(CustomerSupplierException.MERGEMISSINGYORGASSTDATA2, (Object[])new String[]{" [" + purchaseOrgUnit.getNumber() + "-" + purchaseOrgUnit.getName() + "] ", ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"purchaseAttribute", (Locale)ctx.getOriginLocale())});
            msgDetail = msgDetail + customerSupplierException.getMessage() + "\n";
        }
        if (msgDetail != null && msgDetail.length() > 0) {
            CustomerSupplierException headException = new CustomerSupplierException(CustomerSupplierException.MERGEMISSINGASSTDATACOLL, new Object[]{DataMergeTypeEnum.supplier.getAlias()});
            throw new HeadDetailException(headException.getMessage(), msgDetail);
        }
    }

    private CompanyOrgUnitCollection getNoSupplierCompanyOrg(Context ctx, DataMergeInfo dataMergeInfo) throws Exception {
        int i;
        CompanyOrgUnitCollection result = new CompanyOrgUnitCollection();
        HashSet<String> ids = new HashSet<String>();
        ids.add(dataMergeInfo.getDestId());
        for (int i2 = 0; i2 < dataMergeInfo.getSrcIds().length; ++i2) {
            ids.add(dataMergeInfo.getSrcIds()[i2]);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("supplier.id", ids, CompareType.INCLUDE));
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("companyOrgUnit.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("companyOrgUnit.name"));
        viewInfo.setFilter(filterInfo);
        CoreBaseCollection collection = SupplierCompanyInfoFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        SupplierCompanyInfoCollection destAsstDataCollection = new SupplierCompanyInfoCollection();
        SupplierCompanyInfoCollection srcAsstDataCollection = new SupplierCompanyInfoCollection();
        int size = collection.size();
        for (i = 0; i < size; ++i) {
            SupplierCompanyInfoInfo info = (SupplierCompanyInfoInfo)collection.get(i);
            if (info.getSupplier().getId().toString().equals(dataMergeInfo.getDestId())) {
                destAsstDataCollection.add(info);
                continue;
            }
            srcAsstDataCollection.add(info);
        }
        size = srcAsstDataCollection.size();
        for (i = 0; i < size; ++i) {
            CompanyOrgUnitInfo companyOrgUnit = srcAsstDataCollection.get(i).getCompanyOrgUnit();
            if (this.isInCollection(companyOrgUnit, destAsstDataCollection)) continue;
            result.add(companyOrgUnit);
        }
        return result;
    }

    private boolean isInCollection(CompanyOrgUnitInfo companyOrgUnit, SupplierCompanyInfoCollection collection) {
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            SupplierCompanyInfoInfo supplierCompanyInfo = collection.get(i);
            if (supplierCompanyInfo == null || companyOrgUnit == null || supplierCompanyInfo.getCompanyOrgUnit() == null || !companyOrgUnit.getId().equals((Object)supplierCompanyInfo.getCompanyOrgUnit().getId())) continue;
            return true;
        }
        return false;
    }

    private PurchaseOrgUnitCollection getNoSupplierPurOrg(Context ctx, DataMergeInfo dataMergeInfo) throws Exception {
        int i;
        PurchaseOrgUnitCollection result = new PurchaseOrgUnitCollection();
        HashSet<String> ids = new HashSet<String>();
        ids.add(dataMergeInfo.getDestId());
        for (int i2 = 0; i2 < dataMergeInfo.getSrcIds().length; ++i2) {
            ids.add(dataMergeInfo.getSrcIds()[i2]);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("supplier.id", ids, CompareType.INCLUDE));
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("purchaseOrgUnit.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("purchaseOrgUnit.name"));
        viewInfo.setFilter(filterInfo);
        CoreBaseCollection collection = SupplierPurchaseInfoFactory.getLocalInstance(ctx).getCollection(viewInfo);
        SupplierPurchaseInfoCollection destAsstDataCollection = new SupplierPurchaseInfoCollection();
        SupplierPurchaseInfoCollection srcAsstDataCollection = new SupplierPurchaseInfoCollection();
        int size = collection.size();
        for (i = 0; i < size; ++i) {
            SupplierPurchaseInfoInfo info = (SupplierPurchaseInfoInfo)collection.get(i);
            if (info.getSupplier().getId().toString().equals(dataMergeInfo.getDestId())) {
                destAsstDataCollection.add(info);
                continue;
            }
            srcAsstDataCollection.add(info);
        }
        size = srcAsstDataCollection.size();
        for (i = 0; i < size; ++i) {
            PurchaseOrgUnitInfo purchaseOrgUnit = srcAsstDataCollection.get(i).getPurchaseOrgUnit();
            if (this.isInCollection(purchaseOrgUnit, destAsstDataCollection)) continue;
            result.add(purchaseOrgUnit);
        }
        return result;
    }

    private boolean isInCollection(PurchaseOrgUnitInfo purchaseOrgUnit, SupplierPurchaseInfoCollection collection) {
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            SupplierPurchaseInfoInfo supplierPurchaseInfo = collection.get(i);
            if (supplierPurchaseInfo == null || purchaseOrgUnit == null || supplierPurchaseInfo.getPurchaseOrgUnit() == null || !purchaseOrgUnit.getId().equals((Object)supplierPurchaseInfo.getPurchaseOrgUnit().getId())) continue;
            return true;
        }
        return false;
    }
}

