/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CashDiscountInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierPurchaseInfo;
import com.kingdee.eas.basedata.master.cssp.PaymentItemTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierLinkManInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoInfo;
import com.kingdee.eas.basedata.master.cssp.app.AbstractImportCSSPPurchaseManagerFacadeControllerBean;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.cssp.app.SupplierPurDataImport;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ImportCSSPPurchaseManagerFacadeControllerBean
extends AbstractImportCSSPPurchaseManagerFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.cssp.app.ImportCSSPPurchaseManagerFacadeControllerBean");

    @Override
    protected String[][] _importSupplierPurchaseInfo(Context ctx, Hashtable hsData) throws BOSException, EASBizException {
        String[][] result = new String[1][2];
        SupplierPurDataImport im = new SupplierPurDataImport();
        ISupplierPurchaseInfo iSupplierPurchase = SupplierPurchaseInfoFactory.getLocalInstance(ctx);
        try {
            SupplierPurchaseInfoInfo info = (SupplierPurchaseInfoInfo)im.transmit(hsData, ctx);
            iSupplierPurchase.submit((CoreBaseInfo)info);
            result[0][0] = "0000";
            result[0][1] = info.getNumber();
        }
        catch (TaskExternalException e) {
            result[0][0] = "1111";
            result[0][1] = e.getMessage();
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String[][] _importSupplierPurchaseInfo(Context ctx, String number, String orgNumber, boolean isFreezeOrder, int grade, String billingOrgNum, String deliverOrgNum, String cashDiscountNum, int type, int day, int month, String freezeOrgUnitNum, String[] contactPerson, String[] contactPersonPost, String[] phone, String[] fax, String[] mobile, String[] email, String[] postalCode, String[] address) throws BOSException, EASBizException {
        boolean[] BOOLEAN_FIELDS = new boolean[]{isFreezeOrder};
        String[] BOOLEAN_OBJS = new String[]{"IsFreezeMakeOrder"};
        int[] STRING_FIELDS = new int[]{grade};
        String[] STRING_OBJS = new String[]{"grade"};
        String[][] result = new String[1][2];
        SupplierPurchaseInfoInfo supplierPurchaseInfo = new SupplierPurchaseInfoInfo();
        supplierPurchaseInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        supplierPurchaseInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        try {
            PaymentItemTypeEnum paymentTypeEnum;
            SupplierInfo info;
            DataImportUtils.setBooleanData((boolean[])BOOLEAN_FIELDS, (DataBaseInfo)supplierPurchaseInfo, (String[])BOOLEAN_OBJS);
            DataImportUtils.setIntData((int[])STRING_FIELDS, (DataBaseInfo)supplierPurchaseInfo, (String[])STRING_OBJS);
            PurchaseOrgUnitInfo curCompany = DataImportUtils.getPurchaseUnitInfoFromNumber((Context)ctx, (String)orgNumber);
            if (curCompany == null) {
                curCompany = ContextUtil.getCurrentPurchaseUnit((Context)ctx);
            }
            if (curCompany == null) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"getPurOrgUnitFailed", (Locale)ctx.getOriginLocale()));
            }
            supplierPurchaseInfo.setPurchaseOrgUnit(curCompany);
            if (number == null || number.length() <= 0) throw new BOSException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"supplierNotExist", (Context)ctx));
            if (DataImportUtils.getSupplierInfoFromNumber((Context)ctx, (String)number) == null) throw new BOSException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"supplierNotExist", (Context)ctx));
            SupplierInfo supplierInfo = DataImportUtils.getSupplierInfoFromNumber((Context)ctx, (String)number);
            supplierPurchaseInfo.setSupplier(supplierInfo);
            supplierPurchaseInfo.setBillingOrgUnit(supplierInfo);
            supplierPurchaseInfo.setDeliverOrgUnit(supplierInfo);
            ISupplierPurchaseInfo iSupplierPurchaseInfo = SupplierPurchaseInfoFactory.getLocalInstance(ctx);
            SupplierPurchaseInfoInfo oldSupplierCompanyInfo = iSupplierPurchaseInfo.getPurChaseInfo((IObjectPK)new ObjectUuidPK(supplierInfo.getId()), (IObjectPK)new ObjectUuidPK(curCompany.getId()));
            if (oldSupplierCompanyInfo != null) {
                supplierPurchaseInfo.setId(oldSupplierCompanyInfo.getId());
            }
            if (billingOrgNum != null && billingOrgNum.length() > 0 && (info = DataImportUtils.getSupplierInfoFromNumber((Context)ctx, (String)billingOrgNum)) != null) {
                supplierPurchaseInfo.setBillingOrgUnit(info);
            }
            if (deliverOrgNum != null && deliverOrgNum.length() > 0 && (info = DataImportUtils.getSupplierInfoFromNumber((Context)ctx, (String)deliverOrgNum)) != null) {
                supplierPurchaseInfo.setDeliverOrgUnit(info);
            }
            if (freezeOrgUnitNum != null && freezeOrgUnitNum.length() > 0 && (info = DataImportUtils.getFullOrgUnitInfoFromNumber((Context)ctx, (String)freezeOrgUnitNum)) != null) {
                supplierPurchaseInfo.setFreezeOrgUnit((FullOrgUnitInfo)info);
            }
            if (cashDiscountNum != null && cashDiscountNum.length() > 0 && (info = DataImportUtils.getCashDiscountInfoByNumber((Context)ctx, (String)cashDiscountNum)) != null) {
                supplierPurchaseInfo.setCashDiscount((CashDiscountInfo)info);
            }
            if (type > 2 || type < 0) {
                type = 0;
            }
            if ((paymentTypeEnum = DataImportUtils.getPaymentItemEnum((String)String.valueOf(type))) != null) {
                supplierPurchaseInfo.setType(paymentTypeEnum);
                if (day < 0) {
                    day = 0;
                }
                if (month < 0) {
                    month = 0;
                }
                if (paymentTypeEnum.equals((Object)PaymentItemTypeEnum.BALANCE)) {
                    supplierPurchaseInfo.setMonth(month);
                    supplierPurchaseInfo.setDay(day);
                } else if (paymentTypeEnum.equals((Object)PaymentItemTypeEnum.DELIVERY)) {
                    supplierPurchaseInfo.setDay(day);
                }
            }
            int[] len = new int[]{contactPerson.length, contactPersonPost.length, phone.length, fax.length, mobile.length, email.length, postalCode.length, address.length};
            int max = this.getMaxOfArrary(len);
            String[] linkManTemp = new String[max];
            String[] contactPersonPostTemp = new String[max];
            String[] phoneTemp = new String[max];
            String[] faxTemp = new String[max];
            String[] mobileTemp = new String[max];
            String[] emailTemp = new String[max];
            String[] postalcodeTemp = new String[max];
            String[] postAddressTemp = new String[max];
            this.reConstructLinkArray(linkManTemp, contactPerson);
            this.reConstructLinkArray(contactPersonPostTemp, contactPersonPost);
            this.reConstructLinkArray(phoneTemp, phone);
            this.reConstructLinkArray(faxTemp, fax);
            this.reConstructLinkArray(mobileTemp, mobile);
            this.reConstructLinkArray(postalcodeTemp, postalCode);
            this.reConstructLinkArray(postAddressTemp, address);
            this.reConstructLinkArray(emailTemp, email);
            for (int i = 0; i < max; ++i) {
                try {
                    this.handleSupplierLinkMan(supplierPurchaseInfo, linkManTemp[i], contactPersonPostTemp[i], phoneTemp[i], faxTemp[i], mobileTemp[i], emailTemp[i], postalcodeTemp[i], postAddressTemp[i], ctx);
                    continue;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            ISupplierPurchaseInfo iSupplierPurchaseInfo2 = SupplierPurchaseInfoFactory.getLocalInstance(ctx);
            if (supplierPurchaseInfo.getId() == null) {
                iSupplierPurchaseInfo2.submit((CoreBaseInfo)supplierPurchaseInfo);
            } else {
                iSupplierPurchaseInfo2.update((IObjectPK)new ObjectUuidPK(supplierPurchaseInfo.getId()), (CoreBaseInfo)supplierPurchaseInfo);
            }
            result[0][0] = "0000";
            result[0][1] = number;
            return result;
        }
        catch (Exception e) {
            result[0][0] = "1111";
            result[0][1] = e.getMessage();
        }
        return result;
    }

    private void reConstructLinkArray(String[] newLink, String[] oldLink) {
        for (int i = 0; i < newLink.length; ++i) {
            newLink[i] = oldLink.length > i ? oldLink[i] : "";
        }
    }

    private int getMaxOfArrary(int[] len) {
        int max = 0;
        int c = len.length;
        for (int i = 0; i < c; ++i) {
            max = Math.max(len[i], max);
        }
        return max;
    }

    private void handleSupplierLinkMan(SupplierPurchaseInfoInfo supplierPurchaseInfo, String linkMan, String personPost, String phone, String fax, String mobile, String email, String postalCode, String address, Context ctx) throws Exception {
        String[] STRING_FIELDS = new String[]{linkMan, personPost, phone, fax, email, mobile, postalCode, address};
        String[] STRING_OBJS = new String[]{"contactPerson", "contactPersonPost", "phone", "fax", "mobile", "email", "postalcode", "address"};
        if (postalCode != null && postalCode.toString().length() > 10) {
            throw new BOSException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"postZipCode", (Context)ctx));
        }
        if (supplierPurchaseInfo.getId() != null) {
            SupplierPurchaseInfoInfo oldPurchaseInfo = SupplierPurchaseInfoFactory.getLocalInstance(ctx).getSupplierPurchaseInfoInfo((IObjectPK)new ObjectUuidPK(supplierPurchaseInfo.getId()), this.getSupplierSelector());
            supplierPurchaseInfo.getSupplierLinkMan().addCollection(oldPurchaseInfo.getSupplierLinkMan());
        }
        SupplierLinkManInfo linkManInfo = new SupplierLinkManInfo();
        for (int i = 0; i < STRING_FIELDS.length; ++i) {
            linkManInfo.setString(STRING_OBJS[i], STRING_FIELDS[i]);
        }
        supplierPurchaseInfo.getSupplierLinkMan().add(linkManInfo);
    }

    private SelectorItemCollection getSupplierSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("fid"));
        sic.add(new SelectorItemInfo("supplierGroupDetails.id"));
        sic.add(new SelectorItemInfo("supplierGroupDetails.supplierGroupStandard.*"));
        sic.add(new SelectorItemInfo("supplierGroupDetails.supplierGroup.*"));
        sic.add(new SelectorItemInfo("supplierGroupDetails.supplier.*"));
        return sic;
    }
}

