/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.framework.util.FMQuerySqlBuilder;
import com.kingdee.eas.basedata.master.cssp.CSSPUtils;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.ISupplierPurchaseInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.cssp.UsingStatusEnum;
import com.kingdee.eas.basedata.master.cssp.app.AbstractSupplierPurchaseInfoControllerBean;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.log4j.Logger;

public class SupplierPurchaseInfoControllerBean
extends AbstractSupplierPurchaseInfoControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.cssp.app.SupplierPurchaseInfoControllerBean");

    protected void checkIntegrity(Context ctx, SupplierPurchaseInfoInfo model) throws BOSException, EASBizException {
        if (model.getCU() == null) {
            throw new CustomerSupplierException(CustomerSupplierException.CU_IS_NULL);
        }
        if (model.getSupplier() == null) {
            throw new CustomerSupplierException(CustomerSupplierException.SUPPLIER_PURCHASE_INFO_REF_NULL_CSBASE);
        }
        if (model.getPurchaseOrgUnit() == null) {
            throw new CustomerSupplierException(CustomerSupplierException.SUPPLIER_PURCHASE_INFO_REF_NULL_PURCHASE_ORG);
        }
        model.verify();
    }

    protected void checkDuplicate(Context ctx, SupplierPurchaseInfoInfo model) throws BOSException, EASBizException {
        if (model.getSupplier().isIsMultiCopy()) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().clear();
        filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)model.getSupplier().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit.id", (Object)model.getPurchaseOrgUnit().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        IObjectPK[] pks = this.getPKList(ctx, filter, null);
        if (pks.length > 0) {
            throw new CustomerSupplierException(CustomerSupplierException.SUPPLIER_PURCHASEINFO_DEUPLICATED, new Object[]{model.getSupplier().getName(), model.getPurchaseOrgUnit().getName(), ""});
        }
    }

    protected void addnewCheck(Context ctx, SupplierPurchaseInfoInfo model) throws BOSException, EASBizException {
        this.checkIntegrity(ctx, model);
        if (model != null && model.getSupplier() != null && UsedStatusEnum.FREEZED == model.getSupplier().getUsedStatus()) {
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_UPDATE_ISFREEZED);
        }
        if (model != null && model.getSupplier() != null && model.getSupplier().getId() != null) {
            this.checkDuplicate(ctx, model);
        }
        this.checkGrade(ctx, model);
        this.checkInt(ctx, model);
    }

    protected void afterAddnew(Context ctx, SupplierPurchaseInfoInfo model) throws BOSException, EASBizException {
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ((SupplierPurchaseInfoInfo)model).setEffectedStatus(EffectedStatusEnum.EFFECTED);
        this.addnewCheck(ctx, (SupplierPurchaseInfoInfo)model);
        super._submit(ctx, pk, model);
        SupplierPurchaseInfoInfo info = this.getSupplierPurchaseInfoInfo(ctx, pk, this.getSelector());
        model.put("logRecord", (Object)(((SupplierPurchaseInfoInfo)model).getSupplier().getName() + "  " + info.getPurchaseOrgUnit().getName()));
        this.afterAddnew(ctx, (SupplierPurchaseInfoInfo)model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ((SupplierPurchaseInfoInfo)model).setEffectedStatus(EffectedStatusEnum.EFFECTED);
        this.addnewCheck(ctx, (SupplierPurchaseInfoInfo)model);
        IObjectPK pk = super._submit(ctx, model);
        SupplierPurchaseInfoInfo info = this.getSupplierPurchaseInfoInfo(ctx, pk, this.getSelector());
        model.put("logRecord", (Object)(((SupplierPurchaseInfoInfo)model).getSupplier().getName() + "  " + info.getPurchaseOrgUnit().getName()));
        this.afterAddnew(ctx, (SupplierPurchaseInfoInfo)model);
        return pk;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkDefaultPurchaser(ctx, (SupplierPurchaseInfoInfo)model);
        return super._addnew(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SupplierPurchaseInfoInfo info = this.getSupplierPurchaseInfoInfo(ctx, pk);
        CtrlUnitInfo curCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (!curCU.getId().toString().equals(info.getCU().getId().toString())) {
            throw new MaterialBaseException(MaterialBaseException.CANNOT_DELETE_OTHERCUASSIST);
        }
        BizCheckResult rs = BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        if (rs.isFound()) {
            throw rs.getException();
        }
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SupplierPurchaseInfoInfo info = (SupplierPurchaseInfoInfo)model;
        info.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        if (info.getPurchaseOrgUnit() != null && info.getPurchaseOrgUnit().getCU() != null) {
            info.setCU(info.getPurchaseOrgUnit().getCU());
        }
        this.updateCheck(ctx, pk, (IObjectValue)info);
        super._update(ctx, pk, model);
    }

    protected void checkFreezed(Context ctx, IObjectPK supplierPK, boolean isForceFreezed) throws BOSException, EASBizException {
        if (!isForceFreezed) {
            // empty if block
        }
    }

    protected void checkUnFreezed(Context ctx, IObjectPK supplierPK, boolean isForceUnFreeze) throws BOSException, EASBizException {
        ISupplierPurchaseInfo iSupplierPurchaseInfo = SupplierPurchaseInfoFactory.getLocalInstance(ctx);
        SupplierPurchaseInfoInfo supplierPurchaseInfoInfo = iSupplierPurchaseInfo.getSupplierPurchaseInfoInfo(supplierPK, this.getSelector());
        if (supplierPurchaseInfoInfo == null) {
            return;
        }
        ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
        SupplierInfo supplierInfo = iSupplier.getSupplierInfo((IObjectPK)new ObjectUuidPK(supplierPurchaseInfoInfo.getSupplier().getId()));
        if (supplierInfo.getUsedStatus().getValue() == 2) {
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_UNFREE_BASEINFOIAFREEZED);
        }
        if (!isForceUnFreeze && supplierInfo.getUsedStatus().getValue() == 1 && !supplierPurchaseInfoInfo.getFreezeOrgUnit().equalsPK((IObjectValue)ContextUtil.getCurrentOrgUnit((Context)ctx))) {
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_ORDER_UNFREEZED);
        }
    }

    protected void changeSupplierPurchaseStatus(Context ctx, IObjectPK supplierPK, boolean isFreezed) throws EASBizException, BOSException {
        ISupplierPurchaseInfo iSupplierPurchaseInfo = SupplierPurchaseInfoFactory.getLocalInstance(ctx);
        SupplierPurchaseInfoInfo supplierPurchaseInfoInfo = iSupplierPurchaseInfo.getSupplierPurchaseInfoInfo(supplierPK);
        if (supplierPurchaseInfoInfo == null) {
            return;
        }
        supplierPurchaseInfoInfo.setIsFreezeMakeOrder(isFreezed);
        if (isFreezed) {
            supplierPurchaseInfoInfo.setFreezeOrgUnit(ContextUtil.getCurrentPurchaseUnit((Context)ctx).castToFullOrgUnitInfo());
        } else {
            supplierPurchaseInfoInfo.setFreezeOrgUnit(null);
        }
        iSupplierPurchaseInfo.update(supplierPK, (CoreBaseInfo)supplierPurchaseInfoInfo);
    }

    @Override
    protected void _freezed(Context ctx, IObjectPK pk, boolean isForceFreezed) throws BOSException, EASBizException {
        this.checkFreezed(ctx, pk, isForceFreezed);
        this.changeSupplierPurchaseStatus(ctx, pk, true);
    }

    @Override
    protected void _unFreezed(Context ctx, IObjectPK pk, boolean isForceUnFreezed) throws BOSException, EASBizException {
        this.checkUnFreezed(ctx, pk, isForceUnFreezed);
        this.changeSupplierPurchaseStatus(ctx, pk, false);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selectorItems = new SelectorItemCollection();
        selectorItems.add(new SelectorItemInfo("*"));
        selectorItems.add(new SelectorItemInfo("supplier.id"));
        selectorItems.add(new SelectorItemInfo("supplier.name"));
        selectorItems.add(new SelectorItemInfo("supplier.number"));
        selectorItems.add(new SelectorItemInfo("freezeOrgUnit.id"));
        selectorItems.add(new SelectorItemInfo("freezeOrgUnit.number"));
        selectorItems.add(new SelectorItemInfo("freezeOrgUnit.name"));
        selectorItems.add(new SelectorItemInfo("purchaseOrgUnit.id"));
        selectorItems.add(new SelectorItemInfo("purchaseOrgUnit.number"));
        selectorItems.add(new SelectorItemInfo("purchaseOrgUnit.name"));
        selectorItems.add(new SelectorItemInfo("CU.id"));
        selectorItems.add(new SelectorItemInfo("CU.number"));
        selectorItems.add(new SelectorItemInfo("CU.name"));
        return selectorItems;
    }

    @Override
    protected void _updateCheck(Context ctx, IObjectPK pk, IObjectValue value) throws BOSException, EASBizException {
        SupplierPurchaseInfoInfo model = (SupplierPurchaseInfoInfo)value;
        if (model.getSupplier().getUsedStatus().equals((Object)UsedStatusEnum.FREEZED)) {
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_UPDATE_ISFREEZED);
        }
        this.checkDefaultPurchaser(ctx, model);
        BizCheckResult rs = BizCheckerUtil.hasDeal4Update((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        if (rs.isFound()) {
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_MODIFY_HASDEAL);
        }
        if (model.getSupplier().getUsedStatus().equals((Object)UsedStatusEnum.FREEZED)) {
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_UPDATE_ISFREEZED);
        }
        this.checkIntegrity(ctx, model);
        SupplierPurchaseInfoInfo old = this.getSupplierPurchaseInfoInfo(ctx, pk);
        if (!old.getSupplier().getId().toString().equals(model.getSupplier().getId().toString()) || !old.getPurchaseOrgUnit().getId().toString().equals(model.getPurchaseOrgUnit().getId().toString())) {
            this.checkDuplicate(ctx, model);
        }
        this.checkGrade(ctx, model);
        this.checkInt(ctx, model);
    }

    private void checkDefaultPurchaser(Context ctx, SupplierPurchaseInfoInfo model) throws SQLDataException, CustomerSupplierException, BOSException {
        if (model.getPurchaseGroup() != null && model.getDefaultPurchaser() != null) {
            Connection cn = null;
            Statement stmt = null;
            try {
                cn = this.getConnection(ctx);
                stmt = cn.createStatement();
                StringBuffer sb = new StringBuffer();
                sb.append("select 1 from T_BD_PurchasePerson where FPersonID='").append(model.getDefaultPurchaser().getId().toString()).append("'");
                sb.append(" and FPurGroupID = '").append(model.getPurchaseGroup().getId().toString()).append("'");
                ResultSet rs = stmt.executeQuery(sb.toString());
                if (!rs.next()) {
                    throw new CustomerSupplierException(CustomerSupplierException.PURCHASER_INVALID);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)cn);
            }
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SupplierPurchaseInfoInfo info = this.getSupplierPurchaseInfoInfo(ctx, pk, this.getSelector());
        return info.getSupplier().getName() + "  " + info.getPurchaseOrgUnit().getName();
    }

    protected void _checkNameBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _checkNumberBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.changeStatus(ctx, new Object[]{((SupplierPurchaseInfoInfo)model).getId()}, UsingStatusEnum.FREEZED);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.changeStatus(ctx, new Object[]{((SupplierPurchaseInfoInfo)model).getId()}, UsingStatusEnum.USING);
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.changeStatus(ctx, pks, UsingStatusEnum.FREEZED);
    }

    @Override
    protected void _cancelCancel(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.changeStatus(ctx, pks, UsingStatusEnum.USING);
    }

    private void changeStatus(Context ctx, Object[] pks, UsingStatusEnum status) throws BOSException, EASBizException {
        String resName;
        String logItem;
        if (pks == null) {
            return;
        }
        String oql = " select id,supplier.number,purchaseOrgUnit.name,cu,usedStatus where id in " + CSSPUtils.getIdsSql((Object[])pks);
        SupplierPurchaseInfoCollection collection = this.getSupplierPurchaseInfoCollection(ctx, oql);
        logger.error((Object)("BASE_DATA_SERVICE_SP_INFO---,quit is: " + ctx.get((Object)"quit")));
        boolean srmQuitFlag = ctx.get((Object)"quit") != null;
        ArrayList<String> list = new ArrayList<String>();
        int c = collection.size();
        for (int i = 0; i < c; ++i) {
            SupplierPurchaseInfoInfo info = collection.get(i);
            list.add(info.getSupplier() == null ? "" : info.getSupplier().getNumber());
            if (srmQuitFlag || info.getCU().getId().equals((Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId())) continue;
            throw new CustomerSupplierException(CustomerSupplierException.UPDATE_OTHER_CU, new Object[]{info.getSupplier().getNumber() + " - " + info.getPurchaseOrgUnit().getName()});
        }
        if (UsingStatusEnum.USING.equals((Object)status)) {
            logItem = "bd_cssp_supplier_purchase_cancelCancel";
            resName = "SupplierPurchaseCancelCancel";
        } else {
            logItem = "bd_cssp_supplier_purchase_cancel";
            resName = "SupplierPurchaseCancel";
        }
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"changeStatus", (BOSObjectType)new CustomerSaleInfoInfo().getBOSType(), null, (String)Arrays.toString((Object[])list.toArray()), (String)logItem, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)resName, (Locale)ctx.getOriginLocale()));
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" update T_BD_SupplierPurchaseInfo ");
        sb.appendSql(" set FUsingStatus = ").appendSql(String.valueOf(status.getValue()));
        sb.appendSql(" ,flastupdateuserid='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',flastupdatetime=getdate() where fid in ").appendSql(CSSPUtils.getIdsSql((Object[])pks));
        sb.execute(ctx);
        ORMValueCacheService.getInstance().discardType(ctx, this.getBOSType());
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    protected void _freezed(Context ctx, SupplierPurchaseInfoInfo info) throws BOSException, EASBizException {
        this.changeFreeze(ctx, new Object[]{info.getId()}, 1);
    }

    protected void _freezed(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.changeFreeze(ctx, pks, 1);
    }

    protected void _unFreezed(Context ctx, SupplierPurchaseInfoInfo info) throws BOSException, EASBizException {
        this.changeFreeze(ctx, new Object[]{info.getId()}, 0);
    }

    protected void _unFreezed(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.changeFreeze(ctx, pks, 0);
    }

    private void changeFreeze(Context ctx, Object[] pks, int isFreeze) throws BOSException, EASBizException {
        if (pks == null) {
            return;
        }
        String oql = " select id,supplier.number,purchaseOrgUnit.name,cu,UsingStatus where id in " + CSSPUtils.getIdsSql((Object[])pks);
        SupplierPurchaseInfoCollection collection = this.getSupplierPurchaseInfoCollection(ctx, oql);
        for (int i = 0; i < collection.size(); ++i) {
            SupplierPurchaseInfoInfo info = collection.get(i);
            if (info.getCU().getId().equals((Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId())) continue;
            throw new CustomerSupplierException(CustomerSupplierException.UPDATE_OTHER_CU, new Object[]{info.getSupplier().getNumber() + " - " + info.getPurchaseOrgUnit().getName()});
        }
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" update T_BD_SupplierPurchaseInfo ");
        sb.appendSql(" set FIsFreezeOrder = ").appendSql(String.valueOf(isFreeze));
        sb.appendSql(" where fid in ").appendSql(CSSPUtils.getIdsSql((Object[])pks));
        sb.execute(ctx);
    }

    private void checkGrade(Context ctx, SupplierPurchaseInfoInfo info) throws BOSException, EASBizException {
        try {
            if (info.getGrade() == null || info.getGrade().length() == 0) {
                info.setGrade("0");
            }
            if (Integer.parseInt(info.getGrade()) < 0) {
                throw new CustomerSupplierException(CustomerSupplierException.SUPPLIERGRADEINVALID);
            }
        }
        catch (NumberFormatException e) {
            throw new CustomerSupplierException(CustomerSupplierException.SUPPGRADEINVALID);
        }
    }

    private void checkInt(Context ctx, SupplierPurchaseInfoInfo model) throws BOSException, EASBizException {
        int responseTime = model.getResponsTime();
        int confirmNum = model.getConfirmNum();
        int noticeAdvance = model.getNoteAdvance();
        if (responseTime < 0 || confirmNum < 0 || noticeAdvance < 0) {
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_BE_MINUS);
        }
    }

    @Override
    protected IObjectValue _getPurChaseInfo(Context ctx, IObjectPK csBasePK, IObjectPK purchaseOrgPK) throws BOSException, EASBizException {
        SupplierPurchaseInfoInfo supplierPurchaseInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)csBasePK.toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit.id", (Object)purchaseOrgPK.toString(), CompareType.INCLUDE));
        view.setFilter(filterInfo);
        SupplierPurchaseInfoCollection collection = SupplierPurchaseInfoFactory.getLocalInstance(ctx).getSupplierPurchaseInfoCollection(view);
        if (collection.size() > 0) {
            supplierPurchaseInfo = collection.get(0);
        }
        return supplierPurchaseInfo;
    }

    private IObjectPK getSupplierPurchaseInfoPK(Context ctx, IObjectPK csBasePK, IObjectPK purchaseOrgPK) throws BOSException, EASBizException {
        ICoreBase iPurchaseInfo = (ICoreBase)BusinessProcessUtil.getLocBizInteface(null, (BOSObjectType)BOSObjectType.create((String)"9920F4D3"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)csBasePK.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit.id", (Object)purchaseOrgPK.toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        IObjectPK[] pks = iPurchaseInfo.getPKList(filter, null);
        if (pks == null || pks.length == 0) {
            return null;
        }
        if (pks.length > 1) {
            // empty if block
        }
        return pks[0];
    }

    @Override
    protected IObjectValue _getPurChaseInfo(Context ctx, IObjectPK csBasePK, IObjectPK purchaseOrgPK, SelectorItemCollection selector) throws BOSException, EASBizException {
        SupplierPurchaseInfoInfo supplierPurchaseInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)csBasePK.toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit.id", (Object)purchaseOrgPK.toString(), CompareType.INCLUDE));
        view.setFilter(filterInfo);
        view.getSelector().addObjectCollection((IObjectCollection)selector);
        SupplierPurchaseInfoCollection collection = SupplierPurchaseInfoFactory.getLocalInstance(ctx).getSupplierPurchaseInfoCollection(view);
        if (collection.size() > 0) {
            supplierPurchaseInfo = collection.get(0);
        }
        return supplierPurchaseInfo;
    }

    @Override
    protected IObjectValue _getPurChaseInfo(Context ctx, String csBaseNumber, String purchaseOrgNumber) throws EASBizException, BOSException {
        SupplierPurchaseInfoInfo supplierPurchaseInfo = null;
        IPurchaseOrgUnit iPurchaseOrgUnit = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)purchaseOrgNumber, CompareType.EQUALS));
        IObjectPK[] pks = iPurchaseOrgUnit.getPKList(filter, null);
        if (pks == null || pks.length == 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("supplier.number", (Object)csBaseNumber, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit.id", (Object)pks[0].toString(), CompareType.INCLUDE));
        view.setFilter(filterInfo);
        SupplierPurchaseInfoCollection collection = SupplierPurchaseInfoFactory.getLocalInstance(ctx).getSupplierPurchaseInfoCollection(view);
        if (collection.size() > 0) {
            supplierPurchaseInfo = collection.get(0);
        }
        return supplierPurchaseInfo;
    }

    @Override
    public void cancel(Context ctx, IObjectPK pks) throws BOSException, EASBizException {
        Object[] ipks = new IObjectPK[]{pks};
        this.changeStatus(ctx, ipks, UsingStatusEnum.FREEZED);
    }

    @Override
    public void cancelCancel(Context ctx, IObjectPK pks) throws BOSException, EASBizException {
        Object[] ipks = new IObjectPK[]{pks};
        this.changeStatus(ctx, ipks, UsingStatusEnum.USING);
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK pks) throws BOSException, EASBizException {
        Object[] ipks = new IObjectPK[]{pks};
        this.changeStatus(ctx, ipks, UsingStatusEnum.FREEZED);
    }

    @Override
    protected void _cancelCancel(Context ctx, IObjectPK pks) throws BOSException, EASBizException {
        Object[] ipks = new IObjectPK[]{pks};
        this.changeStatus(ctx, ipks, UsingStatusEnum.USING);
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        boolean isImport = "true".equals(model.getString("isImport"));
        if (!isImport) {
            return super.submit(ctx, model);
        }
        try {
            IObjectPK retValue = this._submit4Import(ctx, model);
            return retValue;
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
        catch (EASBizException ex0) {
            this.setRollbackOnly();
            throw ex0;
        }
    }

    public IObjectPK _submit4Import(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        ((SupplierPurchaseInfoInfo)model).setEffectedStatus(EffectedStatusEnum.EFFECTED);
        this.addnewCheck(ctx, (SupplierPurchaseInfoInfo)model);
        IObjectPK pk = null;
        if (model.getId() == null) {
            pk = this._addnew(ctx, (IObjectValue)model);
        } else {
            pk = new ObjectUuidPK(model.getId());
            this._update(ctx, pk, (IObjectValue)model);
        }
        this.afterAddnew(ctx, (SupplierPurchaseInfoInfo)model);
        return pk;
    }

    public IObjectPK addnew(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        boolean isImport = "true".equals(model.getString("isImport"));
        if (!isImport) {
            return super.addnew(ctx, model);
        }
        try {
            return this._addnew(ctx, (IObjectValue)model);
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
        catch (EASBizException ex0) {
            this.setRollbackOnly();
            throw ex0;
        }
    }

    public void update(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        boolean isImport = "true".equals(model.getString("isImport"));
        if (!isImport) {
            super.update(ctx, pk, model);
            return;
        }
        try {
            this._update(ctx, pk, (IObjectValue)model);
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
        catch (EASBizException ex0) {
            this.setRollbackOnly();
            throw ex0;
        }
    }
}

