/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.DataBaseDUtil;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;

public class OrgDataBaseDService {
    private Context ctx = null;
    private BOSObjectType objectType = null;

    public OrgDataBaseDService(Context ctx, BOSObjectType objectType) {
        this.ctx = ctx;
        this.objectType = objectType;
    }

    public OrgDataBaseDService(BOSObjectType objectType) {
        this.objectType = objectType;
    }

    private IDynamicObject getDynamicObjectInterface() throws BOSException {
        if (this.ctx == null) {
            return DynamicObjectFactory.getRemoteInstance();
        }
        return DynamicObjectFactory.getLocalInstance((Context)this.ctx);
    }

    private IMetaDataLoader getMetaDataLoader() throws BOSException {
        if (this.ctx == null) {
            return MetaDataLoaderFactory.getRemoteMetaDataLoader();
        }
        return MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx);
    }

    private IFullOrgUnit getlOrgUnitInterface() throws BOSException {
        if (this.ctx == null) {
            return FullOrgUnitFactory.getRemoteInstance();
        }
        return FullOrgUnitFactory.getLocalInstance((Context)this.ctx);
    }

    public IObjectValue getOrgDataBaseDInfo(SelectorItemCollection sic, IObjectPK bizOrgPK) throws EASBizException, BOSException {
        assert (bizOrgPK != null);
        ObjectUuidPK ctrlUnitPK = this.getCtrlUnitPK(bizOrgPK);
        String orgID = ctrlUnitPK.toString();
        EntityObjectInfo entity = this.getMetaDataLoader().getEntity(this.objectType);
        String orgPropertyName = DataBaseDUtil.getOrgPropertyName(entity);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().addObjectCollection((IObjectCollection)sic);
        if (this.hasAddPolicy((IObjectPK)ctrlUnitPK, this.objectType)) {
            orgID = bizOrgPK.toString();
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(orgPropertyName + ".id", (Object)bizOrgPK.toString()));
        entityViewInfo.setFilter(filterInfo);
        IDynamicObject iOrgDataBaseD = this.getDynamicObjectInterface();
        if (iOrgDataBaseD.exists(this.objectType, filterInfo.toString())) {
            return iOrgDataBaseD.getValue(this.objectType, entityViewInfo.toString());
        }
        return null;
    }

    private ICUBDControl getICUBDControl() throws BOSException {
        if (this.ctx == null) {
            return CUBDControlFactory.getRemoteInstance();
        }
        return CUBDControlFactory.getLocalInstance((Context)this.ctx);
    }

    private boolean hasAddPolicy(IObjectPK ctrlUnitPK, BOSObjectType objectType) throws BOSException, EASBizException {
        ICUBDControl iCUBDControl = this.getICUBDControl();
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), ctrlUnitPK.toString());
        return controlInfo == null ? false : controlInfo.isIsSubordinateAddnewable();
    }

    private boolean hasUpdatePolicy(IObjectPK ctrlUnitPK, BOSObjectType objectType) throws BOSException, EASBizException {
        ICUBDControl iCUBDControl = this.getICUBDControl();
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), ctrlUnitPK.toString());
        return controlInfo == null ? false : controlInfo.isIsSubordinateEditable();
    }

    private ObjectUuidPK getCtrlUnitPK(IObjectPK bizOrgPK) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("CU.id"));
        IFullOrgUnit iFullOrgUnit = this.getlOrgUnitInterface();
        FullOrgUnitInfo bizOrgInfo = iFullOrgUnit.getFullOrgUnitInfo(bizOrgPK, sic);
        return new ObjectUuidPK(bizOrgInfo.getId());
    }

    public IObjectPK submitOrgDataBaseDInfo(IObjectValue model) throws BOSException, EASBizException {
        CoreBaseInfo dataBaseInfo = (CoreBaseInfo)model;
        ServiceStateManager.getInstance().enableNextCallServices();
        EntityObjectInfo entity = this.getMetaDataLoader().getEntity(this.objectType);
        String orgPropertyName = DataBaseDUtil.getOrgPropertyName(entity);
        OrgUnitInfo newOrg = (OrgUnitInfo)dataBaseInfo.get(orgPropertyName);
        ObjectUuidPK newOrgCUPK = this.getCtrlUnitPK((IObjectPK)new ObjectUuidPK(newOrg.getId()));
        IDynamicObject iOrgDataBaseD = this.getDynamicObjectInterface();
        if (dataBaseInfo.getId() != null && iOrgDataBaseD.exists(this.objectType, (IObjectPK)new ObjectUuidPK(dataBaseInfo.getId()))) {
            ObjectUuidPK retValue = new ObjectUuidPK(dataBaseInfo.getId());
            CoreBaseInfo old = (CoreBaseInfo)iOrgDataBaseD.getValue(this.objectType, (IObjectPK)retValue);
            OrgUnitInfo oldOrg = (OrgUnitInfo)old.get(orgPropertyName);
            if (oldOrg.getId().equals((Object)newOrg.getId())) {
                this.checkUpdatePolicy((IObjectPK)newOrgCUPK, this.objectType);
                iOrgDataBaseD.update(this.objectType, (IObjectPK)retValue, (IObjectValue)dataBaseInfo);
                return retValue;
            }
            ObjectUuidPK bizOrgPK = new ObjectUuidPK(newOrg.getId());
            IObjectPK objectPK = this.getOrgDataBaseDInfoPK((IObjectPK)bizOrgPK);
            if (objectPK == null) {
                this.checkAddPolicy((IObjectPK)newOrgCUPK, this.objectType);
                iOrgDataBaseD.addnew(this.objectType, (IObjectPK)retValue, (IObjectValue)dataBaseInfo);
                return retValue;
            }
            this.checkUpdatePolicy((IObjectPK)newOrgCUPK, this.objectType);
            dataBaseInfo.setId(BOSUuid.read((String)objectPK.toString()));
            iOrgDataBaseD.update(this.objectType, objectPK, (IObjectValue)dataBaseInfo);
            return objectPK;
        }
        ObjectUuidPK bizOrgPK = new ObjectUuidPK(newOrg.getId());
        IObjectPK objectPK = this.getOrgDataBaseDInfoPK((IObjectPK)bizOrgPK);
        if (objectPK == null) {
            this.checkAddPolicy((IObjectPK)newOrgCUPK, this.objectType);
            return iOrgDataBaseD.addnew(this.objectType, (IObjectValue)dataBaseInfo);
        }
        this.checkUpdatePolicy((IObjectPK)newOrgCUPK, this.objectType);
        dataBaseInfo.setId(BOSUuid.read((String)objectPK.toString()));
        iOrgDataBaseD.update(this.objectType, objectPK, (IObjectValue)dataBaseInfo);
        return objectPK;
    }

    private void checkAddPolicy(IObjectPK ctrlUnitPK, BOSObjectType objectType) throws EASBizException, BOSException {
        boolean flag = this.hasAddPolicy(ctrlUnitPK, objectType);
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADD);
        }
    }

    private void checkUpdatePolicy(IObjectPK ctrlUnitPK, BOSObjectType objectType) throws EASBizException, BOSException {
        boolean flag = this.hasUpdatePolicy(ctrlUnitPK, objectType);
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
    }

    private IObjectPK getOrgDataBaseDInfoPK(IObjectPK bizOrgPK) throws EASBizException, BOSException {
        EntityObjectInfo entity = this.getMetaDataLoader().getEntity(this.objectType);
        String orgPropertyName = DataBaseDUtil.getOrgPropertyName(entity);
        IDynamicObject iOrgDataBaseD = this.getDynamicObjectInterface();
        StringBuffer oql = new StringBuffer();
        oql.append(" WHERE ").append(orgPropertyName).append(".id = '").append(bizOrgPK.toString()).append("'");
        if (iOrgDataBaseD.exists(this.objectType, oql.toString())) {
            return new ObjectUuidPK(((CoreBaseInfo)iOrgDataBaseD.getValue(this.objectType, bizOrgPK)).getId());
        }
        return null;
    }
}

