/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.framework.BDRefCheckInfo;
import com.kingdee.eas.basedata.framework.BDReferenceObject;
import com.kingdee.eas.basedata.framework.app.BDReferenceCheckSqlBuilder;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.RefChkFilterSet;
import com.kingdee.eas.common.app.dao.ReferenceCheckSqlBuilder;
import com.kingdee.eas.util.Collection2StrSuper;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class BDReferenceDAO {
    private Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.framework.app.BDReferenceDAO");

    public Set isReferenced(Context ctx, List bizObjList, RefChkFilterSet refCheckFilterSet, boolean flag, int returnRefCount) throws BizReferenceException, BOSException {
        HashSet retSet = new HashSet();
        if (bizObjList == null || bizObjList.isEmpty()) {
            return retSet;
        }
        BOSObjectType bizObjType = BOSUuid.read((String)((String)bizObjList.get(0))).getType();
        List refList = this.isRefenceInRefTable(ctx, bizObjType, refCheckFilterSet);
        if (refList == null || refList.isEmpty()) {
            return retSet;
        }
        int size = refList.size();
        for (int i = 0; i < size; ++i) {
            BDRefCheckInfo refCheckInfo = (BDRefCheckInfo)((Object)refList.get(i));
            Set alreadySet = flag ? this.addDetailRefInfoNoLimits(ctx, refCheckInfo, bizObjList, refCheckFilterSet, returnRefCount) : this.addRefInfoNoLimits(ctx, refCheckInfo.getTableName(), refCheckInfo.getFieldName(), bizObjList, refCheckFilterSet, returnRefCount);
            if (alreadySet == null || alreadySet.isEmpty()) continue;
            retSet.addAll(alreadySet);
        }
        return retSet;
    }

    private List isRefenceInRefTable(Context ctx, BOSObjectType bizObjType, RefChkFilterSet refCheckFilterSet) {
        ArrayList<BDRefCheckInfo> retList = new ArrayList<BDRefCheckInfo>();
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        String matched = "select FRefTableName,FRefFieldName,FREFENTITYALIAS_" + ctx.getLocale().toString() + " from T_SYS_EntityRef  where FIsBosFK=1 and FBosType=? ";
        if (refCheckFilterSet != null) {
            matched = matched + refCheckFilterSet.getSQL4RefTableName();
        }
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(matched);
            ps.setString(1, bizObjType.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                BDRefCheckInfo refCheckInfo = new BDRefCheckInfo();
                refCheckInfo.setTableName(rs.getString("FRefTableName"));
                refCheckInfo.setFieldName(rs.getString("FRefFieldName"));
                refCheckInfo.setRefEntityAlias(rs.getString("FREFENTITYALIAS_" + ctx.getLocale().toString()));
                retList.add(refCheckInfo);
            }
        }
        catch (SQLException e1) {
            try {
                this.logger.error((Object)"BizReferenceException", (Throwable)new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e1));
                throw new RuntimeException((Throwable)new BizReferenceException(BizReferenceException.REFERENCE_DATA_ERROR, (Throwable)e1));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return retList;
    }

    protected Connection getConnection(Context ctx) throws SQLException {
        return EJBFactory.getConnection((Context)ctx);
    }

    private Set addDetailRefInfoNoLimits(Context ctx, BDRefCheckInfo refCheckInfo, List bizObjList, RefChkFilterSet refCheckFilterSet, int returnRefCount) throws BOSException, BizReferenceException {
        HashSet retSet = new HashSet();
        Collection2StrSuper superCol = new Collection2StrSuper((Collection)bizObjList);
        while (superCol.hasNext()) {
            Set partSet = this.addDetailRefInfo(ctx, refCheckInfo, ToolUtils.trans2List((Collection)superCol.next()), refCheckFilterSet, returnRefCount);
            retSet.addAll(partSet);
        }
        return retSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set addDetailRefInfo(Context ctx, BDRefCheckInfo refCheckInfo, List bizObjList, RefChkFilterSet refCheckFilterSet, int returnRefCount) throws BOSException {
        HashSet<BDReferenceObject> retSet = new HashSet<BDReferenceObject>();
        String sqlStr = "";
        IRowSet rowSet = null;
        try {
            sqlStr = this.formDetailSql4Ref(ctx, refCheckInfo.getTableName(), refCheckInfo.getFieldName(), ToolUtils.aryToStr((List)bizObjList, (boolean)true), refCheckFilterSet, returnRefCount);
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
        }
        catch (Exception se) {
            this.logger.error((Object)("check obj ref, sql of form is error,but it's not mind! sql is:" + sqlStr), (Throwable)se);
        }
        BDReferenceObject ob = null;
        try {
            while (rowSet != null && rowSet.next()) {
                ob = new BDReferenceObject();
                try {
                    ob.setRefEntityAlias(refCheckInfo.getRefEntityAlias());
                    ob.setFownerid(rowSet.getString("fid"));
                    ob.setFTableName(refCheckInfo.getTableName());
                    ob.setFkeyid(rowSet.getString(refCheckInfo.getFieldName()));
                    ob.setFnumber(rowSet.getString("Fnumber"));
                    if (ctx.getLocale() == Locale.SIMPLIFIED_CHINESE) {
                        ob.setFname(rowSet.getString("Fname_l2"));
                        continue;
                    }
                    if (ctx.getLocale() != Locale.TRADITIONAL_CHINESE) continue;
                    ob.setFname(rowSet.getString("Fname_l3"));
                }
                finally {
                    retSet.add(ob);
                }
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)("check obj ref, sql of form is error,but it's not mind! sql is:" + sqlStr), (Throwable)e);
        }
        return retSet;
    }

    private String formDetailSql4Ref(Context ctx, String table, String fieldName, String idParamInfoStr, RefChkFilterSet refCheckFilterSet, int returnRefCount) {
        String sql4CU = null;
        if (refCheckFilterSet != null && refCheckFilterSet.getSQL4CU() != null) {
            sql4CU = refCheckFilterSet.getSQL4CU();
        }
        return BDReferenceCheckSqlBuilder.getCheckSqlWithInCU(ctx, table, fieldName, sql4CU, idParamInfoStr, true, returnRefCount);
    }

    private Set addRefInfoNoLimits(Context ctx, String table, String fieldName, List bizObjList, RefChkFilterSet refCheckFilterSet, int returnRefCount) throws BOSException, BizReferenceException {
        HashSet retSet = new HashSet();
        Collection2StrSuper superCol = new Collection2StrSuper((Collection)bizObjList);
        while (superCol.hasNext()) {
            Set partSet = this.addRefInfo(ctx, table, fieldName, ToolUtils.trans2List((Collection)superCol.next()), refCheckFilterSet);
            retSet.addAll(partSet);
        }
        return retSet;
    }

    private Set addRefInfo(Context ctx, String table, String fieldName, List bizObjList, RefChkFilterSet refCheckFilterSet) throws BOSException {
        HashSet<String> retSet = new HashSet<String>();
        String sqlStr = "";
        try {
            sqlStr = this.formSql4Ref(ctx, table, fieldName, ToolUtils.aryToStr((List)bizObjList, (boolean)true), refCheckFilterSet);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            while (rowSet.next()) {
                retSet.add(rowSet.getString(1));
            }
        }
        catch (Exception se) {
            this.logger.error((Object)("check obj ref, sql of form is error,but it's not mind! sql is:" + sqlStr), (Throwable)se);
        }
        return retSet;
    }

    private String formSql4Ref(Context ctx, String table, String fieldName, String idParamInfoStr, RefChkFilterSet refCheckFilterSet) {
        String sql4CU = null;
        if (refCheckFilterSet != null && refCheckFilterSet.getSQL4CU() != null) {
            sql4CU = refCheckFilterSet.getSQL4CU();
        }
        return ReferenceCheckSqlBuilder.getCheckSqlWithInCU((Context)ctx, (String)table, (String)fieldName, (String)sql4CU, (String)idParamInfoStr, (boolean)false);
    }
}

