/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.framework.DataBaseDAssignFactory;
import com.kingdee.eas.basedata.framework.DataBaseDAssignInfo;
import com.kingdee.eas.basedata.framework.DataBaseDCollection;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.framework.DatabaseDCanInfo;
import com.kingdee.eas.basedata.framework.DisplayInfo;
import com.kingdee.eas.basedata.framework.FailInfo;
import com.kingdee.eas.basedata.framework.IDataBaseDAssign;
import com.kingdee.eas.basedata.framework.app.AbstractDataBaseDControllerBean;
import com.kingdee.eas.basedata.framework.app.AssignImp;
import com.kingdee.eas.basedata.framework.app.BDReferenceDAO;
import com.kingdee.eas.basedata.framework.app.DataBaseDNewImpl;
import com.kingdee.eas.basedata.framework.util.BDUtil;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.CUBDDispatchPattern;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.RefChkFilter;
import com.kingdee.eas.common.RefChkFilterItemEnum;
import com.kingdee.eas.common.RefChkFilterSet;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public abstract class DataBaseDControllerBean
extends AbstractDataBaseDControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.framework.app.DataBaseDControllerBean");

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        DataBaseDInfo dataBaseDInfo = (DataBaseDInfo)model;
        if (dataBaseDInfo != null && (dataBaseDInfo.getAdminCU() == null || dataBaseDInfo.getAdminCU().getId() == null)) {
            dataBaseDInfo.setAdminCU(this.getDefaultCU(ctx));
        }
        if (dataBaseDInfo != null && (dataBaseDInfo.getCU() == null || dataBaseDInfo.getCU().getId() == null)) {
            dataBaseDInfo.setCU(this.getDefaultCU(ctx));
        }
        dataBaseDInfo.setId(BOSUuid.read((String)pk.toString()));
        this.checkAddPolicy(ctx, (IObjectPK)new ObjectUuidPK(dataBaseDInfo.getCU().getId()), dataBaseDInfo.getBOSType());
        super._addnew(ctx, (IObjectValue)dataBaseDInfo);
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        if (super._exists(ctx, filter)) {
            view.getSelector().add(new SelectorItemInfo("cu.name"));
            DataBaseCollection dcoll = super.getDataBaseCollection(ctx, view);
            DataBaseInfo dInfo = dcoll.get(0);
            String cuName = dInfo.getCU().getName();
            String name = dataBaseInfo.getName();
            throw new DataBaseDException(DataBaseDException.CHECKNAMEDUP, new Object[]{name, cuName});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        if (super._exists(ctx, filter)) {
            view.getSelector().add(new SelectorItemInfo("cu.name"));
            DataBaseCollection dcoll = super.getDataBaseCollection(ctx, view);
            DataBaseInfo dInfo = dcoll.get(0);
            String cuName = dInfo.getCU().getName();
            String number = dataBaseInfo.getNumber();
            throw new DataBaseDException(DataBaseDException.CHECKNUMDUP, new Object[]{number, cuName});
        }
    }

    private static SimpleEntity getEntity(Context ctx, BOSObjectType type) throws BOSException {
        EntitySelect select = new EntitySelect(type);
        select.selectAttribute("alias").extendPropertySelect().select(new String[]{"OrgType"});
        if (ctx != null) {
            return MetaDataAccessFactory.getLocalInstance((Context)ctx).select(select);
        }
        return MetaDataAccessFactory.getRemoteInstance().select(select);
    }

    private static String getAliasName(SimpleEntity entity, BOSObjectType objectType) {
        String name = "";
        if (entity == null || entity.getAlias() == null) {
            IMetaDataPK pk = MDContextFactory.getInstance().entityMapping.getProperty(objectType);
            if (pk != null) {
                name = pk.getFullName();
            }
        } else {
            name = entity.getAlias();
        }
        return name;
    }

    private void checkAddPolicy(Context ctx, IObjectPK ctrlUnitPK, BOSObjectType objectType) throws EASBizException, BOSException {
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), ctrlUnitPK.toString());
        boolean flag = controlInfo == null ? false : controlInfo.isIsSubordinateAddnewable();
        SimpleEntity entity = DataBaseDControllerBean.getEntity(ctx, objectType);
        String name = DataBaseDControllerBean.getAliasName(entity, objectType);
        if (!flag && ("37C67DFC".equals(objectType.toString()) || "4409E7F0".equals(objectType.toString()) || "BF0C040E".equals(objectType.toString()))) {
            throw new DataBaseDException(DataBaseDException.CANNOTADDFORSOMESTRATEGY, new String[]{name});
        }
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADD);
        }
    }

    protected void checkUpdatePolicy(Context ctx, IObjectPK ctrlUnitPK, BOSObjectType objectType) throws EASBizException, BOSException {
        boolean flag;
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), ctrlUnitPK.toString());
        boolean bl = flag = controlInfo == null ? true : controlInfo.isIsSubordinateEditable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
    }

    private void checkDelPolicy(Context ctx, IObjectPK ctrlUnitPK, BOSObjectType objectType, IObjectPK dataPK) throws EASBizException, BOSException {
        boolean flag;
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), ctrlUnitPK.toString());
        boolean bl = flag = controlInfo == null ? true : controlInfo.isIsSubordinateDeletable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE);
        }
        boolean isReferencedInCU = false;
        HashSet<String> filterValues = new HashSet<String>();
        filterValues.add(ctrlUnitPK.toString());
        RefChkFilterSet filters = new RefChkFilterSet();
        filters.add(new RefChkFilter(RefChkFilterItemEnum.IncludedCUIDList, filterValues));
        BOSUuid dataID = BOSUuid.read((String)dataPK.toString());
        isReferencedInCU = ReferenceDAO.isReferenced((Context)ctx, (BOSUuid)dataID, (RefChkFilterSet)filters);
        if (isReferencedInCU) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_IN_THIS_CU);
        }
    }

    private IObjectPK getDefaultCUPK(Context ctx) {
        return new ObjectUuidPK(this.getDefaultCU(ctx).getId());
    }

    private CtrlUnitInfo getDefaultCU(Context ctx) {
        return ContextUtil.getCurrentCtrlUnit((Context)ctx);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseDInfo dataBaseDInfo = (DataBaseDInfo)model;
        if (dataBaseDInfo != null && (dataBaseDInfo.getAdminCU() == null || dataBaseDInfo.getAdminCU().getId() == null)) {
            dataBaseDInfo.setAdminCU(this.getDefaultCU(ctx));
        }
        if (dataBaseDInfo != null && (dataBaseDInfo.getCU() == null || dataBaseDInfo.getCU().getId() == null)) {
            dataBaseDInfo.setCU(this.getDefaultCU(ctx));
        }
        this.checkAddPolicy(ctx, (IObjectPK)new ObjectUuidPK(dataBaseDInfo.getCU().getId()), dataBaseDInfo.getBOSType());
        return super._addnew(ctx, (IObjectValue)dataBaseDInfo);
    }

    protected void _update(Context ctx, IObjectPK dataBaseDPK, IObjectValue model) throws BOSException, EASBizException {
        DataBaseDInfo value = (DataBaseDInfo)model;
        IObjectPK ctrlUnitPK = this.getDefaultCUPK(ctx);
        boolean hasAdminRight = ctrlUnitPK.toString().equals(value.getCU().getId().toString());
        if (hasAdminRight) {
            super._update(ctx, dataBaseDPK, (IObjectValue)value);
        } else {
            IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
            boolean isDataBaseDAssigned = iDataBaseDAssign.checkAssignment(ctrlUnitPK, dataBaseDPK);
            if (isDataBaseDAssigned) {
                this.checkUpdatePolicy(ctx, ctrlUnitPK, value.getBOSType());
                super._update(ctx, dataBaseDPK, (IObjectValue)value);
            } else {
                throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE_UNASSIGNED_DATABASED);
            }
        }
    }

    protected void _isReferenced(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
        boolean isAssigned = iDataBaseDAssign.existAssignment(pk);
        if (isAssigned) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_ASSIGNED_DATABASED);
        }
        super._isReferenced(ctx, pk);
    }

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        DataBaseDInfo dataBaseDInfo = (DataBaseDInfo)model;
        super._save(ctx, pk, model);
    }

    protected void _submit(Context ctx, IObjectPK dataBaseDPK, IObjectValue model) throws BOSException, EASBizException {
        DataBaseDInfo dataBaseDInfo = (DataBaseDInfo)model;
        IObjectPK ctrlUnitPK = this.getDefaultCUPK(ctx);
        if (this._isExistPropertyName(ctx, (CoreBaseInfo)dataBaseDInfo, "effectedStatus")) {
            dataBaseDInfo.setInt("effectedStatus", 2);
        }
        ServiceStateManager.getInstance().enableNextCallServices();
        if (dataBaseDInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(dataBaseDInfo.getId()))) {
            this._updateDataBaseDInfo(ctx, ctrlUnitPK, dataBaseDPK, dataBaseDInfo);
        } else {
            this._addnew(ctx, (IObjectValue)dataBaseDInfo);
        }
    }

    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        IObjectPK[] arrayPK = this.getPKList(ctx, filter, null);
        IObjectPK ctrlUnitPK = this.getDefaultCUPK(ctx);
        int length = arrayPK.length;
        for (int i = 0; i < length; ++i) {
            boolean isAssigned;
            IObjectPK dataBaseDPK = arrayPK[i];
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("CU.id"));
            DataBaseDInfo dataBaseDInfo = (DataBaseDInfo)super._getValue(ctx, dataBaseDPK, sic);
            boolean hasAdminRight = ctrlUnitPK.toString().equals(dataBaseDInfo.getCU().getId().toString());
            IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
            if (hasAdminRight) {
                isAssigned = iDataBaseDAssign.existAssignment(dataBaseDPK);
                if (isAssigned) {
                    throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_ASSIGNED_DATABASED);
                }
                super._delete(ctx, dataBaseDPK);
                continue;
            }
            isAssigned = iDataBaseDAssign.existAssignment(dataBaseDPK);
            if (isAssigned) {
                this.checkDelPolicy(ctx, ctrlUnitPK, dataBaseDInfo.getBOSType(), dataBaseDPK);
                iDataBaseDAssign.delete(ctrlUnitPK, dataBaseDPK);
                this.unassignBizOrgRelatedInfosOfTypeD3(ctx, dataBaseDPK, (IObjectPK)new ObjectUuidPK(dataBaseDInfo.getCU().getId().toString()), ctrlUnitPK);
                continue;
            }
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_UNASSIGNED_DATABASED);
        }
        return arrayPK;
    }

    protected void _delete(Context ctx, IObjectPK dataBaseDPK) throws BOSException, EASBizException {
        IObjectPK ctrlUnitPK = this.getDefaultCUPK(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("CU.id"));
        DataBaseDInfo dataBaseDInfo = (DataBaseDInfo)super._getValue(ctx, dataBaseDPK, sic);
        boolean hasAdminRight = ctrlUnitPK.toString().equals(dataBaseDInfo.getCU().getId().toString());
        IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
        if (hasAdminRight) {
            boolean isAssigned = iDataBaseDAssign.existAssignment(dataBaseDPK);
            if (isAssigned) {
                throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_ASSIGNED_DATABASED);
            }
            super._delete(ctx, dataBaseDPK);
        } else {
            boolean isAssigned = iDataBaseDAssign.existAssignment(dataBaseDPK);
            if (isAssigned) {
                this.checkDelPolicy(ctx, ctrlUnitPK, dataBaseDInfo.getBOSType(), dataBaseDPK);
                iDataBaseDAssign.delete(ctrlUnitPK, dataBaseDPK);
                this.unassignBizOrgRelatedInfosOfTypeD3(ctx, dataBaseDPK, (IObjectPK)new ObjectUuidPK(dataBaseDInfo.getCU().getId().toString()), ctrlUnitPK);
            } else {
                throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_UNASSIGNED_DATABASED);
            }
        }
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        IObjectPK ctrlUnitPK = this.getDefaultCUPK(ctx);
        for (IObjectPK dataBaseDPK : arrayPK) {
            boolean isAssigned;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("CU.id"));
            DataBaseDInfo dataBaseDInfo = (DataBaseDInfo)super._getValue(ctx, dataBaseDPK, sic);
            boolean hasAdminRight = ctrlUnitPK.toString().equals(dataBaseDInfo.getCU().getId().toString());
            IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
            if (hasAdminRight) {
                isAssigned = iDataBaseDAssign.existAssignment(dataBaseDPK);
                if (isAssigned) {
                    throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_ASSIGNED_DATABASED);
                }
                super._delete(ctx, dataBaseDPK);
                continue;
            }
            isAssigned = iDataBaseDAssign.existAssignment(dataBaseDPK);
            if (isAssigned) {
                this.checkDelPolicy(ctx, ctrlUnitPK, dataBaseDInfo.getBOSType(), dataBaseDPK);
                iDataBaseDAssign.delete(ctrlUnitPK, dataBaseDPK);
                this.unassignBizOrgRelatedInfosOfTypeD3(ctx, dataBaseDPK, (IObjectPK)new ObjectUuidPK(dataBaseDInfo.getCU().getId().toString()), ctrlUnitPK);
                continue;
            }
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_UNASSIGNED_DATABASED);
        }
    }

    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        IObjectPK[] arrayPK = this.getPKList(ctx, oql);
        IObjectPK ctrlUnitPK = this.getDefaultCUPK(ctx);
        int length = arrayPK.length;
        for (int i = 0; i < length; ++i) {
            boolean isAssigned;
            IObjectPK dataBaseDPK = arrayPK[i];
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("CU.id"));
            DataBaseDInfo dataBaseDInfo = (DataBaseDInfo)super._getValue(ctx, dataBaseDPK, sic);
            boolean hasAdminRight = ctrlUnitPK.toString().equals(dataBaseDInfo.getCU().getId().toString());
            IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
            if (hasAdminRight) {
                isAssigned = iDataBaseDAssign.existAssignment(dataBaseDPK);
                if (isAssigned) {
                    throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_ASSIGNED_DATABASED);
                }
                super._delete(ctx, dataBaseDPK);
                continue;
            }
            isAssigned = iDataBaseDAssign.existAssignment(dataBaseDPK);
            if (isAssigned) {
                this.checkDelPolicy(ctx, ctrlUnitPK, dataBaseDInfo.getBOSType(), dataBaseDPK);
                iDataBaseDAssign.delete(ctrlUnitPK, dataBaseDPK);
                this.unassignBizOrgRelatedInfosOfTypeD3(ctx, dataBaseDPK, (IObjectPK)new ObjectUuidPK(dataBaseDInfo.getCU().getId().toString()), ctrlUnitPK);
                continue;
            }
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_UNASSIGNED_DATABASED);
        }
        return arrayPK;
    }

    @Override
    protected void _deleteDataBaseDInfo(Context ctx, IObjectPK ctrlUnitPK, IObjectPK dataBaseDPK) throws BOSException, EASBizException {
        assert (ctrlUnitPK != null);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("CU.id"));
        DataBaseDInfo dataBaseDInfo = (DataBaseDInfo)super._getValue(ctx, dataBaseDPK, sic);
        boolean hasAdminRight = ctrlUnitPK.toString().equals(dataBaseDInfo.getCU().getId().toString());
        IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
        if (hasAdminRight) {
            boolean isAssigned = iDataBaseDAssign.existAssignment(dataBaseDPK);
            if (isAssigned) {
                throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_ASSIGNED_DATABASED);
            }
            super._delete(ctx, dataBaseDPK);
        } else {
            boolean isAssigned = iDataBaseDAssign.existAssignment(dataBaseDPK);
            if (isAssigned) {
                this.checkDelPolicy(ctx, ctrlUnitPK, dataBaseDInfo.getBOSType(), dataBaseDPK);
                iDataBaseDAssign.delete(ctrlUnitPK, dataBaseDPK);
                this.unassignBizOrgRelatedInfosOfTypeD3(ctx, dataBaseDPK, (IObjectPK)new ObjectUuidPK(dataBaseDInfo.getCU().getId().toString()), ctrlUnitPK);
            }
        }
    }

    protected void _updateDataBaseDInfo(Context ctx, IObjectPK ctrlUnitPK, IObjectPK dataBaseDPK, DataBaseDInfo value) throws BOSException, EASBizException {
        assert (ctrlUnitPK != null);
        assert (value != null && value.getCU() != null && value.getCU().getId() != null);
        boolean hasAdminRight = ctrlUnitPK.toString().equals(value.getCU().getId().toString());
        if (hasAdminRight) {
            super._update(ctx, dataBaseDPK, (IObjectValue)value);
        } else {
            IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
            boolean isDataBaseDAssigned = iDataBaseDAssign.checkAssignment(ctrlUnitPK, dataBaseDPK);
            if (isDataBaseDAssigned) {
                this.checkUpdatePolicy(ctx, ctrlUnitPK, value.getBOSType());
                super._update(ctx, dataBaseDPK, (IObjectValue)value);
            } else {
                throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE_UNASSIGNED_DATABASED);
            }
        }
    }

    protected boolean _exists(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        return super._exists(ctx, filter);
    }

    protected boolean _exists(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return super._exists(ctx, pk);
    }

    protected boolean _exists(Context ctx, String oql) throws BOSException, EASBizException {
        return super._exists(ctx, oql);
    }

    protected IObjectPK[] getRefDataBaseDPKs(Context ctx, IObjectPK dataBaseDPK) throws BOSException, EASBizException {
        return null;
    }

    private void checkCanBeAssigned(Context ctx, IObjectPK[] refDataBaseDPKs, IObjectPK assignCUPK) throws BOSException, EASBizException {
        if (refDataBaseDPKs != null && refDataBaseDPKs.length > 0) {
            IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
            IObjectPK[] unAssignedPKs = iDataBaseDAssign.getUnAssignedPKs(assignCUPK, refDataBaseDPKs);
            if (unAssignedPKs == null || unAssignedPKs.length == 0) {
                return;
            }
            DataBaseDAssignInfo assignInfo = null;
            CtrlUnitInfo assignCU = null;
            int n = unAssignedPKs.length;
            for (int i = 0; i < n; ++i) {
                assignInfo = new DataBaseDAssignInfo();
                assignCU = new CtrlUnitInfo();
                assignCU.setId(BOSUuid.read((String)assignCUPK.toString()));
                assignInfo.setAssignCU(assignCU);
                assignInfo.setDataBaseDID(BOSUuid.read((String)unAssignedPKs[i].toString()));
                assignInfo.setBosObjectType(((ObjectUuidPK)unAssignedPKs[i]).getObjectType().toString());
                iDataBaseDAssign.addnew((CoreBaseInfo)assignInfo);
            }
        }
    }

    protected void checkCanBeAssignedByExtraBizRules(Context ctx, IObjectPK fromCUPK, IObjectPK dataPK, IObjectPK toCUPK) throws BOSException, EASBizException {
    }

    @Override
    protected void _assign(Context ctx, IObjectPK ctrlUnitPK, IObjectPK dataBaseDPK, IObjectPK assignCUPK) throws BOSException, EASBizException {
        CUBDControlInfo ctrlInfo;
        this.checkCanBeAssignedByExtraBizRules(ctx, ctrlUnitPK, dataBaseDPK, assignCUPK);
        IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
        if (iDataBaseDAssign.checkAssignment(assignCUPK, dataBaseDPK)) {
            return;
        }
        String bosType = null;
        boolean isSubordinateAssign = false;
        bosType = BOSUuid.read((String)dataBaseDPK.toString()).getType().toString();
        String currentCU = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        if (currentCU != null && bosType != null && (ctrlInfo = CUBDControlFactory.getLocalInstance((Context)ctx).getBDCtrlInfo(bosType, currentCU)) != null) {
            isSubordinateAssign = ctrlInfo.isIsSubordinateAssign();
        }
        SelectorItemCollection tempSIC = new SelectorItemCollection();
        tempSIC.add(new SelectorItemInfo("CU.id"));
        DataBaseDInfo tempDataBaseDInfo = (DataBaseDInfo)super._getValue(ctx, dataBaseDPK, tempSIC);
        boolean hasAdminRight = ctrlUnitPK.toString().equals(tempDataBaseDInfo.getCU().getId().toString());
        if (!hasAdminRight && !isSubordinateAssign) {
            throw new DataBaseDException(DataBaseDException.ASSIGN_OR_REFER_DATABASED_NOT_RGIHT);
        }
        this.checkCanBeAssigned(ctx, this.getRefDataBaseDPKs(ctx, dataBaseDPK), assignCUPK);
        if ("t_bd_databasedassign".equals(this.getAssignTableName().trim().toLowerCase())) {
            DataBaseDAssignInfo dataBaseDAssignInfo = new DataBaseDAssignInfo();
            dataBaseDAssignInfo.setDataBaseDID(BOSUuid.read((String)dataBaseDPK.toString()));
            CtrlUnitInfo assignCU = new CtrlUnitInfo();
            assignCU.setId(BOSUuid.read((String)assignCUPK.toString()));
            dataBaseDAssignInfo.setAssignCU(assignCU);
            dataBaseDAssignInfo.setBosObjectType(((ObjectUuidPK)dataBaseDPK).getObjectType().toString());
            iDataBaseDAssign.addnew((CoreBaseInfo)dataBaseDAssignInfo);
        } else {
            this.addAssignInfo(ctx, assignCUPK.toString(), dataBaseDPK.toString());
        }
        this.assignBizOrgRelatedInfosOfTypeD3(ctx, dataBaseDPK, ctrlUnitPK, assignCUPK);
    }

    protected void assignBizOrgRelatedInfosOfTypeD3(Context ctx, IObjectPK dataID, IObjectPK sourceCUID, IObjectPK targetCUID) throws BOSException, EASBizException {
    }

    protected void unassignBizOrgRelatedInfosOfTypeD3(Context ctx, IObjectPK dataID, IObjectPK sourceCUID, IObjectPK targetCUID) throws BOSException, EASBizException {
    }

    @Override
    protected void _refer(Context ctx, IObjectPK ctrlUnitPK, IObjectPK dataBaseDPK, IObjectPK assignCUPK) throws BOSException, EASBizException {
        IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
        if (iDataBaseDAssign.checkAssignment(assignCUPK, dataBaseDPK)) {
            return;
        }
        SelectorItemCollection tempSIC = new SelectorItemCollection();
        tempSIC.add(new SelectorItemInfo("CU.id"));
        this.checkCanBeAssigned(ctx, this.getRefDataBaseDPKs(ctx, dataBaseDPK), assignCUPK);
        if ("t_bd_databasedassign".equals(this.getAssignTableName().trim().toLowerCase())) {
            DataBaseDAssignInfo dataBaseDAssignInfo = new DataBaseDAssignInfo();
            dataBaseDAssignInfo.setDataBaseDID(BOSUuid.read((String)dataBaseDPK.toString()));
            CtrlUnitInfo assignCU = new CtrlUnitInfo();
            assignCU.setId(BOSUuid.read((String)assignCUPK.toString()));
            dataBaseDAssignInfo.setAssignCU(assignCU);
            dataBaseDAssignInfo.setBosObjectType(((ObjectUuidPK)dataBaseDPK).getObjectType().toString());
            iDataBaseDAssign.addnew((CoreBaseInfo)dataBaseDAssignInfo);
        } else {
            this.addAssignInfo(ctx, assignCUPK.toString(), dataBaseDPK.toString());
        }
        this.assignBizOrgRelatedInfosOfTypeD3(ctx, dataBaseDPK, ctrlUnitPK, assignCUPK);
    }

    @Override
    protected DataBaseDCollection _getDataBaseDCollection(Context ctx, IObjectPK ctrlUnitPK, String oql) throws BOSException, EASBizException {
        EntityViewInfo viewInfo;
        assert (!StringUtils.isEmpty((String)oql));
        try {
            viewInfo = new EntityViewInfo(oql);
        }
        catch (ParserException e) {
            throw new DataBaseDException(DataBaseDException.GET_FILTER_FAIL, e);
        }
        FilterInfo filterInfo = this.getDatabaseDFilter(ctx, ctrlUnitPK, "id", "CU.id");
        if (filterInfo != null && filterInfo.getFilterItems().size() > 0) {
            if (viewInfo.getFilter() != null && viewInfo.getFilter().getFilterItems().size() > 0) {
                viewInfo.getFilter().mergeFilter(filterInfo, "AND");
            } else {
                viewInfo.setFilter(filterInfo);
            }
        }
        return super.getDataBaseDCollection(ctx, viewInfo);
    }

    @Override
    protected DataBaseDInfo _getDataBaseDInfo(Context ctx, IObjectPK ctrlUnitPK, IObjectPK dataBaseDPK, SelectorItemCollection sic) throws BOSException, EASBizException {
        Set set;
        IDataBaseDAssign iDataBaseDAssign;
        assert (ctrlUnitPK != null && dataBaseDPK != null);
        SelectorItemCollection tempSIC = new SelectorItemCollection();
        tempSIC.add(new SelectorItemInfo("CU.id"));
        DataBaseDInfo tempDataBaseDInfo = (DataBaseDInfo)super._getValue(ctx, dataBaseDPK, tempSIC);
        boolean hasAdminRight = ctrlUnitPK.toString().equals(tempDataBaseDInfo.getCU().getId().toString());
        if (!(hasAdminRight || (iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx)).checkAssignment(ctrlUnitPK, dataBaseDPK) || (set = this.getVisibleOrgIDs(ctx, ((ObjectUuidPK)dataBaseDPK).getObjectType(), ctrlUnitPK)).contains(tempDataBaseDInfo.getCU().getId().toString()))) {
            return null;
        }
        return (DataBaseDInfo)super._getValue(ctx, dataBaseDPK, sic);
    }

    @Override
    protected IObjectPK _submitDataBaseDInfo(Context ctx, IObjectPK ctrlUnitPK, IObjectPK dataBaseDPK, DataBaseDInfo dataBaseDInfo) throws BOSException, EASBizException {
        if (this._isExistPropertyName(ctx, (CoreBaseInfo)dataBaseDInfo, "effectedStatus")) {
            dataBaseDInfo.setInt("effectedStatus", 2);
        }
        ServiceStateManager.getInstance().enableNextCallServices();
        if (dataBaseDInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(dataBaseDInfo.getId()))) {
            this._updateDataBaseDInfo(ctx, ctrlUnitPK, dataBaseDPK, dataBaseDInfo);
            return dataBaseDPK;
        }
        return this._addnew(ctx, (IObjectValue)dataBaseDInfo);
    }

    @Override
    protected FilterInfo _getDatabaseDFilter(Context ctx, IObjectPK ctrlUnitPK, String idFieldName, String CUFieldame) throws EASBizException, BOSException {
        if (CUFieldame != null && !CUFieldame.equalsIgnoreCase("cu.id")) {
            logger.error((Object)("pleas use cu.id" + this.getBOSType()));
        }
        String bdTableName = BDUtil.getTableName(ctx, this.getBOSType().toString());
        FilterInfo filterInfo = new FilterInfo();
        if ("00000000-0000-0000-0000-000000000000CCE7AED4".endsWith(ctrlUnitPK.toString())) {
            filterInfo.getFilterItems().add(new FilterItemInfo(CUFieldame, (Object)ctrlUnitPK.toString()));
            Set visibleOrgIDs = this.getVisibleOrgIDs(ctx, this.getBOSType(), ctrlUnitPK);
            if (visibleOrgIDs != null && visibleOrgIDs.size() != 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo(CUFieldame, (Object)visibleOrgIDs, CompareType.INCLUDE));
                filterInfo.setMaskString(" #0 OR #1 ");
            }
            return filterInfo;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FDataBaseDID FROM ").append(this.getAssignTableName()).append(" WHERE ");
        if ("t_bd_databasedassign".equals(this.getAssignTableName().trim().toLowerCase())) {
            sql.append("FBOSObjectType = '").append(this.getBOSType()).append("' ").append(" AND ");
        }
        sql.append("FAssignCUID = '").append(ctrlUnitPK.toString()).append("' ");
        sql.append(" union all(");
        sql.append("select fid from ").append(bdTableName);
        sql.append(" where fcontrolunitid ='").append(ctrlUnitPK.toString()).append("'");
        sql.append(")");
        filterInfo.getFilterItems().add(new FilterItemInfo(idFieldName, (Object)sql.toString(), CompareType.INNER));
        Set visibleOrgIDs = this.getVisibleOrgIDs(ctx, this.getBOSType(), ctrlUnitPK);
        if (visibleOrgIDs != null && visibleOrgIDs.size() != 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo(CUFieldame, (Object)visibleOrgIDs, CompareType.INCLUDE));
            filterInfo.setMaskString(" #0 OR #1");
        }
        return filterInfo;
    }

    @Override
    public FilterInfo _getDatabaseDFilter(Context ctx, IObjectPK[] ctrlUnitPKs, String idFieldName, String CUFieldame) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        if (ctrlUnitPKs == null || ctrlUnitPKs.length == 0) {
            return filterInfo;
        }
        if (CUFieldame != null && !CUFieldame.equalsIgnoreCase("cu.id")) {
            logger.error((Object)("pleas use cu.id" + this.getBOSType()));
        }
        for (int i = 0; i < ctrlUnitPKs.length; ++i) {
            if (!"00000000-0000-0000-0000-000000000000CCE7AED4".endsWith(ctrlUnitPKs[i].toString())) continue;
            filterInfo.getFilterItems().add(new FilterItemInfo(CUFieldame, (Object)ctrlUnitPKs[i].toString()));
            Set visibleOrgIDs = this.getVisibleOrgIDs(ctx, this.getBOSType(), ctrlUnitPKs[i]);
            if (visibleOrgIDs != null && visibleOrgIDs.size() != 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo(CUFieldame, (Object)visibleOrgIDs, CompareType.INCLUDE));
                filterInfo.setMaskString(" #0 OR #1 ");
            }
            return filterInfo;
        }
        StringBuffer cuPkSet = new StringBuffer();
        cuPkSet.append("''");
        for (int i = 0; i < ctrlUnitPKs.length; ++i) {
            cuPkSet.append(",'").append(ctrlUnitPKs[i].toString()).append("'");
        }
        String bdTableName = BDUtil.getTableName(ctx, this.getBOSType().toString());
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FDataBaseDID FROM ").append(this.getAssignTableName()).append(" WHERE ");
        if ("t_bd_databasedassign".equals(this.getAssignTableName().trim().toLowerCase())) {
            sql.append("FBOSObjectType = '").append(this.getBOSType()).append("' ").append(" AND ");
        }
        sql.append("FAssignCUID in( ").append(cuPkSet).append(") ");
        sql.append(" union all(");
        sql.append("select fid from ").append(bdTableName);
        sql.append(" where fcontrolunitid in(").append(cuPkSet).append(")");
        sql.append(")");
        filterInfo.getFilterItems().add(new FilterItemInfo(idFieldName, (Object)sql.toString(), CompareType.INNER));
        HashSet visibleOrgIDs = new HashSet();
        for (int i = 0; i < ctrlUnitPKs.length; ++i) {
            Set temp = this.getVisibleOrgIDs(ctx, this.getBOSType(), ctrlUnitPKs[i]);
            visibleOrgIDs.addAll(temp);
        }
        if (visibleOrgIDs != null && visibleOrgIDs.size() != 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo(CUFieldame, visibleOrgIDs, CompareType.INCLUDE));
            filterInfo.setMaskString(" #0 OR #1");
        }
        return filterInfo;
    }

    @Override
    protected FilterInfo _getDatabaseDFilter(Context ctx, IObjectPK ctrlUnitPK, String idFieldName, String CUFieldame, String mainObjName) throws EASBizException, BOSException {
        if (CUFieldame != null && !CUFieldame.equalsIgnoreCase("cu.id")) {
            logger.error((Object)("pleas use cu.id" + this.getBOSType()));
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(CUFieldame, (Object)ctrlUnitPK.toString()));
        if ("00000000-0000-0000-0000-000000000000CCE7AED4".endsWith(ctrlUnitPK.toString())) {
            Set visibleOrgIDs = this.getVisibleOrgIDs(ctx, this.getBOSType(), ctrlUnitPK);
            if (visibleOrgIDs != null && visibleOrgIDs.size() != 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo(CUFieldame, (Object)visibleOrgIDs, CompareType.INCLUDE));
                filterInfo.setMaskString(" #0 OR #1 ");
            }
            return filterInfo;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FDataBaseDID FROM ").append(this.getAssignTableName()).append(" WHERE FBOSObjectType = '").append(this.getBOSType()).append("' ").append(" AND FAssignCUID = '").append(ctrlUnitPK.toString()).append("' ").append(" AND FDataBaseDID = ").append(mainObjName).append(".F").append(idFieldName);
        filterInfo.getFilterItems().add(new FilterItemInfo(idFieldName, (Object)sql.toString(), CompareType.EXISTS));
        Set visibleOrgIDs = this.getVisibleOrgIDs(ctx, this.getBOSType(), ctrlUnitPK);
        if (visibleOrgIDs == null || visibleOrgIDs.size() == 0) {
            filterInfo.setMaskString(" #0 OR #1");
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo(CUFieldame, (Object)visibleOrgIDs, CompareType.INCLUDE));
            filterInfo.setMaskString(" #0 OR #1 OR #2 ");
        }
        return filterInfo;
    }

    protected Set getVisibleOrgIDs(Context ctx, BOSObjectType objectType, IObjectPK ctrlUnitPK) throws EASBizException, BOSException {
        HashSet<String> set = new HashSet<String>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("level"));
        CtrlUnitInfo cui = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo(ctrlUnitPK, sic);
        String longNumber = cui.getLongNumber();
        int level = cui.getLevel();
        StringBuffer sql = new StringBuffer(500);
        sql.append("select cu.FID,cu.FLevel,cu.FParentID from T_ORG_CtrlUnit cu inner join T_ORG_CUBDControl bd ").append("on bd.FControlUnitID=cu.FID ").append("where bd.FIsSuperiorViewable=1 and cu.FLongNumber like ? and bd.FBDBOSType=? ").append("order by cu.FLevel asc");
        Object[] params = new String[]{longNumber + "!%", objectType.toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        int baselevel = -1;
        int currentlevel = -1;
        String ctrlUnitID = "";
        String parentCtrlUnitID = "";
        try {
            while (rs.next()) {
                currentlevel = rs.getInt("FLevel");
                ctrlUnitID = rs.getString("FID").trim();
                parentCtrlUnitID = rs.getString("FParentID");
                if (baselevel == -1) {
                    if (currentlevel != level + 1) break;
                    baselevel = currentlevel;
                }
                if (currentlevel == baselevel) {
                    set.add(ctrlUnitID);
                    continue;
                }
                assert (currentlevel > baselevel);
                if (StringUtils.isEmpty((String)parentCtrlUnitID) || !set.contains(parentCtrlUnitID.trim())) continue;
                set.add(ctrlUnitID);
            }
        }
        catch (SQLException e) {
            throw new DataBaseDException(DataBaseDException.GET_FILTER_FAIL, e);
        }
        StringBuffer debuginfo = new StringBuffer();
        Object[] array = set.toArray();
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            debuginfo.append(array[i].toString() + ",");
        }
        logger.debug((Object)("CUBDControl visible CU list : " + debuginfo.toString()));
        return set;
    }

    private String getCULongNumber(Context ctx, IObjectPK orgPK) throws BOSException, SQLException {
        String longNumber = null;
        String treeID = "00000000-0000-0000-0000-0000000000014F2827FD";
        String orgID = orgPK.toString();
        Object[] params = new Object[]{treeID, orgID};
        StringBuffer sql = new StringBuffer(500);
        sql.append(" SELECT FLongNumber FROM T_ORG_Structure ").append(" WHERE\tFTreeId = ? ").append(" AND FUnitId = ? ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        if (rowSet.next()) {
            longNumber = rowSet.getString("FLongNumber");
        }
        return longNumber;
    }

    @Override
    protected void _cancelAssign(Context ctx, IObjectPK ctrlUnitPK, IObjectPK dataBaseDPK, IObjectPK cancelAssignCUPK) throws BOSException, EASBizException {
        SelectorItemCollection tempSIC = new SelectorItemCollection();
        tempSIC.add(new SelectorItemInfo("CU.id"));
        DataBaseDInfo tempDataBaseDInfo = (DataBaseDInfo)super._getValue(ctx, dataBaseDPK, tempSIC);
        boolean hasAdminRight = ctrlUnitPK.toString().equals(tempDataBaseDInfo.getCU().getId().toString());
        if (!hasAdminRight) {
            throw new DataBaseDException(DataBaseDException.ASSIGN_OR_REFER_DATABASED_NOT_RGIHT);
        }
        this.checkBizReference(ctx, dataBaseDPK, cancelAssignCUPK);
        IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
        iDataBaseDAssign.delete(ctrlUnitPK, dataBaseDPK);
        this.unassignBizOrgRelatedInfosOfTypeD3(ctx, dataBaseDPK, ctrlUnitPK, cancelAssignCUPK);
    }

    @Override
    protected boolean _canBeAssigned(Context ctx, BOSObjectType bosObjectType, IObjectPK ctrlUnitPK) throws BOSException, EASBizException {
        try {
            String treeID = "00000000-0000-0000-0000-0000000000014F2827FD";
            String longNumber = this.getCULongNumber(ctx, ctrlUnitPK);
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            String ctrlUnitID = iFullOrgUnit.getFullOrgUnitInfo(ctrlUnitPK).getCU().getId().toString();
            StringBuffer sql = new StringBuffer(500);
            sql.append(" SELECT Structure.FUnitId FROM T_ORG_Structure Structure ").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = Structure.FUnitId ").append(" WHERE Structure.FTreeId = ? ").append(" AND CHARINDEX( N'").append(longNumber).append("!' , Structure.FLongNumber || N'!' ) > 0 ").append(" AND BaseUnit.FControlUnitID = ? ").append(" ORDER BY Structure.FLongNumber ASC ");
            Object[] params = new Object[]{treeID, ctrlUnitID};
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            while (rowSet.next()) {
                if (!this.canBeAssigned(ctx, bosObjectType, ctrlUnitID)) continue;
                return true;
            }
        }
        catch (SQLException e) {
            throw new DataBaseDException(DataBaseDException.GET_INFO_FAIL, e);
        }
        return false;
    }

    private boolean canBeAssigned(Context ctx, BOSObjectType objectType, String ctrlUnitID) throws EASBizException, BOSException {
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), ctrlUnitID);
        return controlInfo == null ? false : controlInfo.getDispatchPattern().equals((Object)CUBDDispatchPattern.DISPATCH) || controlInfo.getDispatchPattern().equals((Object)CUBDDispatchPattern.DISPATCH_REFERENCE);
    }

    @Override
    protected boolean _canBeUpgraded(Context ctx, BOSObjectType bosType, IObjectPK ctrUnitPK) throws BOSException, EASBizException {
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(bosType.toString(), ctrUnitPK.toString());
        return controlInfo == null ? false : controlInfo.isIsSubordinateUpgradable();
    }

    @Override
    protected boolean _canRefer(Context ctx, BOSObjectType bosObjectType, IObjectPK ctrlUnitPK) throws EASBizException, BOSException {
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(bosObjectType.toString(), ctrlUnitPK.toString());
        return controlInfo == null ? false : controlInfo.getDispatchPattern().equals((Object)CUBDDispatchPattern.REFERENCE);
    }

    @Override
    protected void _cancelRefer(Context ctx, IObjectPK cancelReferCUPK, IObjectPK dataBaseDPK) throws BOSException, EASBizException {
        this.checkBizReference(ctx, dataBaseDPK, cancelReferCUPK);
        IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
        iDataBaseDAssign.delete(cancelReferCUPK, dataBaseDPK);
        SelectorItemCollection tempSIC = new SelectorItemCollection();
        tempSIC.add(new SelectorItemInfo("CU.id"));
        DataBaseDInfo tempDataBaseDInfo = (DataBaseDInfo)super._getValue(ctx, dataBaseDPK, tempSIC);
        ObjectUuidPK CUID = new ObjectUuidPK(tempDataBaseDInfo.getCU().getId().toString());
        this.unassignBizOrgRelatedInfosOfTypeD3(ctx, dataBaseDPK, (IObjectPK)CUID, cancelReferCUPK);
    }

    private void checkBizReference(Context ctx, IObjectPK dataBaseDPK, IObjectPK cancelReferCUPK) throws BOSException, EASBizException {
        BOSUuid dataID = BOSUuid.read((String)dataBaseDPK.toString());
        RefChkFilterSet fcfs = new RefChkFilterSet();
        HashSet<String> hs = new HashSet<String>();
        hs.add(cancelReferCUPK.toString());
        fcfs.add(new RefChkFilter(RefChkFilterItemEnum.IncludedCUIDList, hs));
        try {
            boolean isReferenced = ReferenceDAO.isReferenced((Context)ctx, (BOSUuid)dataID, (RefChkFilterSet)fcfs);
            if (isReferenced) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("name"));
                String dataName = "[" + this.getValue(ctx, dataBaseDPK, sic).get("name").toString() + "]";
                String cuName = "[" + CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo(cancelReferCUPK, sic).getName() + "]";
                throw new DataBaseDException(DataBaseDException.DATA_USED_IN_CU, new String[]{dataName, cuName});
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                Throwable t = e.getCause();
                Exception e1 = (Exception)t;
                if (e1 instanceof EASBizException) {
                    throw (EASBizException)((Object)e1);
                }
            }
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            logger.info((Object)("DataBaseDControllerBean checkBizReference err!" + e));
        }
    }

    @Override
    protected void _batchAssign(Context ctx, String cuid, String[] diddata, String[] cuiddata) throws BOSException, EASBizException {
        if (this.useOptimizedBatchAssginAndUnassign()) {
            DataBaseDNewImpl dbdnew = this.getDataBaseDNewImpl();
            dbdnew.setAssignTableName(this.getAssignTableName());
            dbdnew.batchAssign(this.getBOSType().toString(), this.getConnection(ctx), diddata, cuiddata);
            return;
        }
        String[][] data = this.cuAndDids(cuiddata, diddata);
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            this.assign(ctx, (IObjectPK)new ObjectUuidPK(cuid), (IObjectPK)new ObjectUuidPK(data[i][1]), (IObjectPK)new ObjectUuidPK(data[i][0]));
        }
    }

    private String[] parsePairOfCUIDAndDataID(String cuid, String dataid) {
        String[] aPair = new String[]{cuid, dataid};
        return aPair;
    }

    private String[][] cuAndDids(String[] cuiddata, String[] diddata) {
        int size = diddata.length;
        int cuSize = cuiddata.length;
        String[][] data = new String[size * cuSize][2];
        for (int i = 0; i < cuSize; ++i) {
            for (int j = 0; j < size; ++j) {
                data[i * size + j] = this.parsePairOfCUIDAndDataID(cuiddata[i].toString(), diddata[j].toString());
            }
        }
        return data;
    }

    @Override
    protected void _batchAssign(Context ctx, String cuid, String sql, HashSet basedata, HashSet cuData) throws BOSException, EASBizException {
        if (this.useOptimizedBatchAssginAndUnassign()) {
            DataBaseDNewImpl newImp = this.getDataBaseDNewImpl();
            newImp.setAssignTableName(this.getAssignTableName());
            newImp.batchAssign(this.getBOSType().toString(), ctx, sql, basedata, cuData);
            return;
        }
        RowSet rs = null;
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
            String dataid = "";
            String cuid2 = "";
            Object[] cuDataArray = cuData.toArray();
            while (rs.next()) {
                dataid = rs.getString("ID");
                if (basedata.contains(dataid)) continue;
                for (int i = 0; i < cuDataArray.length; ++i) {
                    this.assign(ctx, (IObjectPK)new ObjectUuidPK(cuid), (IObjectPK)new ObjectUuidPK(dataid), (IObjectPK)new ObjectUuidPK(cuDataArray[i].toString()));
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)cn);
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)cn);
        SQLUtils.cleanup((ResultSet)rs);
    }

    @Override
    protected void _batchUnAssign(Context ctx, String[] diddata, String[] cuiddata) throws BOSException, EASBizException {
        String[][] data = this.cuAndDids(cuiddata, diddata);
        if (this.useOptimizedBatchAssginAndUnassign()) {
            DataBaseDNewImpl dbdnew = this.getDataBaseDNewImpl();
            dbdnew.setAssignTableName(this.getAssignTableName());
            dbdnew.batchUnAssign(ctx, this.getBOSType(), data);
            HashMap map = dbdnew.getReferencedMap();
            return;
        }
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            this.deleteDataBaseDInfo(ctx, (IObjectPK)new ObjectUuidPK(data[i][0]), (IObjectPK)new ObjectUuidPK(data[i][1]));
        }
    }

    protected DataBaseDNewImpl getDataBaseDNewImpl() {
        return new DataBaseDNewImpl();
    }

    @Override
    protected void _batchUnAssign(Context ctx, String sql, HashSet basedata, HashSet cuData) throws BOSException, EASBizException {
        if (this.useOptimizedBatchAssginAndUnassign()) {
            DataBaseDNewImpl newImp = this.getDataBaseDNewImpl();
            newImp.setAssignTableName(this.getAssignTableName());
            newImp.batchUnAssign(ctx, this.getBOSType(), sql, basedata, cuData);
            return;
        }
        RowSet rs = null;
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
            String cuid2 = "";
            String dataid = "";
            Object[] cuDataArray = cuData.toArray();
            while (rs.next()) {
                dataid = rs.getString("ID");
                if (basedata.contains(dataid)) continue;
                for (int i = 0; i < cuDataArray.length; ++i) {
                    this.deleteDataBaseDInfo(ctx, (IObjectPK)new ObjectUuidPK(cuDataArray[i].toString()), (IObjectPK)new ObjectUuidPK(dataid));
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)cn);
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)cn);
        SQLUtils.cleanup((ResultSet)rs);
    }

    @Override
    protected void _upgrade(Context ctx, IObjectPK dataPK, IObjectPK subordinateCUPK, IObjectPK superiorCUPK) throws BOSException, EASBizException {
        BOSUuid dataID = BOSUuid.read((String)dataPK.toString());
        CtrlUnitInfo assignCU = new CtrlUnitInfo();
        assignCU.setId(BOSUuid.read((String)subordinateCUPK.toString()));
        String bosType = dataID.getType().toString();
        IDataBaseDAssign idbda = DataBaseDAssignFactory.getLocalInstance(ctx);
        DataBaseDAssignInfo dbdai = new DataBaseDAssignInfo();
        dbdai.setDataBaseDID(dataID);
        dbdai.setAssignCU(assignCU);
        dbdai.setBosObjectType(bosType);
        idbda.addnew((CoreBaseInfo)dbdai);
        DataBaseDInfo dataInfo = (DataBaseDInfo)this._getValue(ctx, dataPK);
        CtrlUnitInfo CU = dataInfo.getCU();
        CtrlUnitInfo CUCopy = (CtrlUnitInfo)CU.clone();
        CUCopy.setId(BOSUuid.read((String)superiorCUPK.toString()));
        dataInfo.setAdminCU(CUCopy);
        dataInfo.setCU(CUCopy);
        super._update(ctx, dataPK, (IObjectValue)dataInfo);
    }

    protected boolean useOptimizedBatchAssginAndUnassign() {
        return false;
    }

    @Override
    protected Set _getReferenced(Context ctx, IObjectPK referenceCUPK, List databaseDPKList) throws BOSException, EASBizException {
        BDReferenceDAO rdao = new BDReferenceDAO();
        RefChkFilterSet fcfs = new RefChkFilterSet();
        HashSet<String> hs = new HashSet<String>();
        hs.add(referenceCUPK.toString());
        fcfs.add(new RefChkFilter(RefChkFilterItemEnum.IncludedCUIDList, hs));
        return rdao.isReferenced(ctx, databaseDPKList, fcfs, true, 1);
    }

    @Override
    protected DatabaseDCanInfo _allCan(Context ctx, BOSObjectType bosObjectType, IObjectPK ctrlUnitPK) throws BOSException, EASBizException {
        DatabaseDCanInfo info = new DatabaseDCanInfo();
        CtrlUnitInfo curCtrl = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo(ctrlUnitPK);
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(bosObjectType.toString(), ctrlUnitPK.toString());
        info.setCanAssign(this._canBeAssigned(ctx, bosObjectType, ctrlUnitPK));
        info.setCanRefer(controlInfo == null ? false : controlInfo.getDispatchPattern().equals((Object)CUBDDispatchPattern.REFERENCE) || controlInfo.getDispatchPattern().equals((Object)CUBDDispatchPattern.DISPATCH_REFERENCE));
        info.setCanUpgrade(controlInfo == null ? false : controlInfo.isIsSubordinateUpgradable());
        info.setCurCtrlUnit(curCtrl);
        return info;
    }

    @Override
    protected Map _batchUnAssignReturnFail(Context ctx, String sql, HashSet basedata, HashSet cuData) throws BOSException, EASBizException {
        Map map;
        Map unAssignFail = new HashMap();
        if (this.useOptimizedBatchAssginAndUnassign()) {
            logger.info((Object)"=====\u4e3b\u6570\u636e\u53cd\u5206\u914d\u3010\u7ba1\u7406\u5355\u5143+\u5168\u9009\u3011 \u5f00\u59cb=====");
            DataBaseDNewImpl newImpl = this.getDataBaseDNewImpl();
            long beginTime = System.currentTimeMillis();
            newImpl.setAssignTableName(this.getAssignTableName());
            unAssignFail = newImpl.batchUnAssignReturnFail(ctx, this.getBOSType(), sql, basedata, cuData);
            long endTime = System.currentTimeMillis();
            logger.info((Object)("-----\u4e3b\u6570\u636e\u53cd\u5206\u914d\uff0c\u6d88\u8017\u65f6\u95f4\uff1a" + (endTime - beginTime) + "\u6beb\u79d2"));
            logger.info((Object)"=====\u4e3b\u6570\u636e\u53cd\u5206\u914d\u3010\u7ba1\u7406\u5355\u5143+\u5168\u9009\u3011 \u7ed3\u675f=====");
            logger.info((Object)"");
            return unAssignFail;
        }
        RowSet rs = null;
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
            String cuid2 = "";
            String dataid = "";
            Object[] cuDataArray = cuData.toArray();
            while (rs.next()) {
                dataid = rs.getString("ID");
                if (basedata.contains(dataid)) continue;
                for (int i = 0; i < cuDataArray.length; ++i) {
                    this.deleteDataBaseDInfo(ctx, (IObjectPK)new ObjectUuidPK(cuDataArray[i].toString()), (IObjectPK)new ObjectUuidPK(dataid));
                }
            }
            map = unAssignFail;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)cn);
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)cn);
        SQLUtils.cleanup((ResultSet)rs);
        return map;
    }

    @Override
    protected Map _batchUnAssignReturnFail(Context ctx, String[] diddata, String[] cuiddata) throws BOSException, EASBizException {
        Map unAssignFail = new HashMap();
        String[][] data = this.cuAndDids(cuiddata, diddata);
        if (this.useOptimizedBatchAssginAndUnassign()) {
            logger.info((Object)"=====\u4e3b\u6570\u636e\u53cd\u5206\u914d\u3010\u7ba1\u7406\u5355\u5143+\u975e\u5168\u9009\u3011 \u5f00\u59cb=====");
            DataBaseDNewImpl newImpl = this.getDataBaseDNewImpl();
            newImpl.setAssignTableName(this.getAssignTableName());
            long beginTime = System.currentTimeMillis();
            unAssignFail = newImpl.batchUnAssignReturnFail(ctx, this.getBOSType(), data);
            long endTime = System.currentTimeMillis();
            logger.info((Object)("-----\u4e3b\u6570\u636e\u53cd\u5206\u914d\uff0c\u6d88\u8017\u65f6\u95f4\uff1a" + (endTime - beginTime) + "\u6beb\u79d2"));
            logger.info((Object)"=====\u4e3b\u6570\u636e\u53cd\u5206\u914d\u3010\u7ba1\u7406\u5355\u5143+\u975e\u5168\u9009\u3011 \u7ed3\u675f=====");
            logger.info((Object)"");
            return unAssignFail;
        }
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            this.deleteDataBaseDInfo(ctx, (IObjectPK)new ObjectUuidPK(data[i][0]), (IObjectPK)new ObjectUuidPK(data[i][1]));
        }
        return unAssignFail;
    }

    @Override
    protected Map _getDispalyInfoCollectin(Context ctx, Set idList) throws BOSException, EASBizException {
        HashMap<BOSUuid, DisplayInfo> map = new HashMap<BOSUuid, DisplayInfo>();
        boolean flag = false;
        if (flag) {
            if (idList == null || idList.size() == 0) {
                return map;
            }
            Iterator it = idList.iterator();
            BOSObjectType type = BOSUuid.read((String)it.next().toString()).getType();
            ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)type);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idList, CompareType.INCLUDE));
            view.setFilter(filter);
            CoreBaseCollection col = coreBase.getCollection(view);
            for (int i = 0; i < col.size(); ++i) {
                DataBaseDInfo databaseDInfo = (DataBaseDInfo)col.get(i);
                DisplayInfo info = new DisplayInfo();
                info.setName(databaseDInfo.getName());
                info.setNumber(databaseDInfo.getNumber());
                map.put(col.get(i).getId(), info);
            }
        }
        return map;
    }

    protected void _referBaseAndAssist(Context ctx, IObjectPK ctrlUnitPK, IObjectPK dataBaseDPK, IObjectPK assignCUPK) throws BOSException, EASBizException {
        this._refer(ctx, ctrlUnitPK, dataBaseDPK, assignCUPK);
    }

    @Override
    protected void _batchRefer(Context ctx, IObjectPK ctrlUnitPK, String[] dataIds, IObjectPK assignCUPK) throws BOSException, EASBizException {
        for (int i = 0; i < dataIds.length; ++i) {
            this.refer(ctx, ctrlUnitPK, (IObjectPK)new ObjectUuidPK(dataIds[i]), assignCUPK);
        }
    }

    @Override
    protected void _batchReferBaseAndAssist(Context ctx, IObjectPK ctrlUnitPK, String[] dataIds, IObjectPK assignCUPK) throws BOSException, EASBizException {
        for (int i = 0; i < dataIds.length; ++i) {
            this.refer(ctx, ctrlUnitPK, (IObjectPK)new ObjectUuidPK(dataIds[i]), assignCUPK);
        }
        this.batchReferAssist(ctx, ctrlUnitPK, dataIds, assignCUPK);
    }

    protected void batchReferAssist(Context ctx, IObjectPK ctrlUnitPK, String[] dataIds, IObjectPK assignCUPK) throws BOSException, EASBizException {
    }

    @Override
    protected boolean _batchCancelRefer(Context ctx, IObjectPK ctrlUnitPK, String[] dataIds, IObjectPK assignCUPK) throws BOSException, EASBizException {
        return true;
    }

    protected FilterInfo _getDatabaseDFilter(Context ctx, IObjectPK ctrlUnitPK) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        String bdTableName = BDUtil.getTableName(ctx, this.getBOSType().toString());
        if ("00000000-0000-0000-0000-000000000000CCE7AED4".endsWith(ctrlUnitPK.toString())) {
            StringBuffer sql = new StringBuffer(200);
            sql.append(this.getVisibleOrgIDsSql(ctx, this.getBOSType(), ctrlUnitPK));
            sql.append(" union all(");
            sql.append("select '").append(ctrlUnitPK.toString()).append("'");
            sql.append(")");
            filterInfo.getFilterItems().add(new FilterItemInfo("cu.id", (Object)sql.toString(), CompareType.INNER));
            return filterInfo;
        }
        StringBuffer sql = new StringBuffer(200);
        sql.append("select fid from ").append(bdTableName);
        sql.append(" where  fcontrolunitid in (").append(this.getVisibleOrgIDsSql(ctx, this.getBOSType(), ctrlUnitPK)).append(")");
        sql.append(" union all(");
        sql.append("SELECT FDataBaseDID FROM ").append(this.getAssignTableName()).append(" WHERE FBOSObjectType = '").append(this.getBOSType()).append("' ").append(" AND FAssignCUID = '").append(ctrlUnitPK.toString()).append("'");
        sql.append(")");
        sql.append(" union all(");
        sql.append("select fid from ").append(bdTableName);
        sql.append(" where fcontrolunitid ='").append(ctrlUnitPK.toString()).append("'");
        sql.append(")");
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        return filterInfo;
    }

    protected String getVisibleOrgIDsSql(Context ctx, BOSObjectType objectType, IObjectPK ctrlUnitPK) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("longNumber"));
        CtrlUnitInfo cui = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo(ctrlUnitPK, sic);
        String longNumber = cui.getLongNumber();
        StringBuffer sql = new StringBuffer(500);
        sql.append("select cu.FID from T_ORG_CtrlUnit cu inner join T_ORG_CUBDControl ctrl ");
        sql.append("on ctrl.FControlUnitID=cu.FID ");
        sql.append("where ctrl.FIsSuperiorViewable=1 and cu.FLongNumber like '").append(longNumber).append("!%'");
        sql.append("and ctrl.FBDBOSType='").append(objectType.toString()).append("'");
        return sql.toString();
    }

    protected String getAssignTableName() {
        return "t_bd_databasedassign";
    }

    @Override
    protected int _batchAssignPart(Context ctx, String tblBD, String tblCU, int insertBDOneTime) throws BOSException, EASBizException {
        return this.getAssignImp().batchAssignPart(ctx, tblCU, tblBD, insertBDOneTime, this.getBOSType().toString());
    }

    @Override
    protected Map _getRemoteResultBatch(Context ctx, String bdSql, Set basedata, Set cudata) throws BOSException, EASBizException {
        return this.getAssignImp().getRemoteResultBatch(ctx, bdSql, basedata, cudata);
    }

    @Override
    protected void _createIndex(Context ctx, String idxName, String idxFieldList) throws BOSException, EASBizException {
        this.getAssignImp().createIndex(ctx, idxName, idxFieldList);
    }

    @Override
    protected void _dropIndex(Context ctx, String idxName) throws BOSException, EASBizException {
        this.getAssignImp().dropIndex(ctx, idxName);
    }

    @Override
    protected String _copyBDTable(Context ctx, String srcTblName) throws BOSException, EASBizException {
        return this.getAssignImp().copyBDTable(ctx, srcTblName);
    }

    @Override
    protected Map _getRemoteBatch4Assign2(Context ctx, String bdSql, Set basedata, Set cudata) throws BOSException, EASBizException {
        return this.getAssignImp().getRemoteBatch4Assign2(ctx, bdSql, basedata, cudata);
    }

    protected AssignImp getAssignImp() {
        AssignImp assignImp = new AssignImp();
        assignImp.setAssignTableName(this.getAssignTableName());
        return assignImp;
    }

    @Override
    protected int _batchAssign2Part(Context ctx, String srcOrgId, Set tarOrgIds, String tblBD, Set assitData, int insertBDOneTime) throws BOSException, EASBizException {
        throw new BOSException("Not support yet!");
    }

    private void addAssignInfo(Context ctx, String cuid, String dataid) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.createStatement();
            StringBuffer insertSql = new StringBuffer(100);
            insertSql.append("insert into ").append(this.getAssignTableName());
            insertSql.append("(fassigncuid,fdatabasedid) ");
            insertSql.append(" values('").append(cuid).append("','").append(dataid).append("')");
            stmt.executeUpdate(insertSql.toString());
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    @Override
    protected Map _onloadBatchCaller(Context ctx, String key, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (key.equals("DataBaseDTreeDetailListUI")) {
            CtrlUnitInfo currentCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            CUBDControlInfo ctrlInfo = CUBDControlFactory.getLocalInstance((Context)ctx).getBDCtrlInfo(this.getBOSType().toString(), currentCU.getId().toString());
            result.put("ctrlInfo", ctrlInfo);
            DatabaseDCanInfo canInfo = this.allCan(ctx, this.getBOSType(), (IObjectPK)new ObjectUuidPK(currentCU.getId()));
            result.put("canInfo", canInfo);
            FilterInfo databaseDFilter = this.getDatabaseDFilter(ctx, (IObjectPK)new ObjectUuidPK(currentCU.getId()), "id", "CU.id");
            result.put("databaseDFilter", databaseDFilter);
        }
        return result;
    }

    @Override
    protected FailInfo _batchReferReturnFail(Context ctx, IObjectPK ctrlUnitPK, String[] dataIds, IObjectPK assignCUPK, boolean isRefAsst) throws BOSException, EASBizException {
        if (!isRefAsst) {
            this._batchRefer(ctx, ctrlUnitPK, dataIds, assignCUPK);
        } else {
            this._batchReferBaseAndAssist(ctx, ctrlUnitPK, dataIds, assignCUPK);
        }
        return null;
    }

    private String geTableName(String bosType) throws BOSException {
        String tableName = "";
        if ("37C67DFC".equalsIgnoreCase(bosType)) {
            tableName = "t_bd_supplier";
        } else if ("BF0C040E".equalsIgnoreCase(bosType)) {
            tableName = "t_bd_customer";
        } else if ("4409E7F0".equalsIgnoreCase(bosType)) {
            tableName = "t_bd_material";
        } else {
            logger.error((Object)("BOSTYPE NOT CORRECT ,bosType : " + bosType));
            throw new BOSException("BOSTYPE NOT CORRECT");
        }
        return tableName;
    }

    @Override
    protected void _batchUpdateField(Context ctx, String[] bdPKs, String bosType, Object field, Object toValue) throws BOSException {
        String tableName = this.geTableName(bosType);
        StringBuffer ids = new StringBuffer();
        ids.append("''");
        for (int i = 0; i < bdPKs.length; ++i) {
            ids.append(",'").append(bdPKs[i].toString()).append("'");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("update ").append(tableName).append(" set ");
        sb.append(field).append(" = ? ").append("where fid in ( ").append(ids.toString()).append(")");
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{toValue});
    }

    @Override
    protected void _batchUpdateField(Context ctx, String sql, String bosType, Object field, Object toValue) throws BOSException {
        String selSql = "select /*+ first_rows(100) */ v.id " + sql.substring(sql.indexOf("from"));
        String destTableName = this.geTableName(bosType);
        String tbl = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName("TblForAssign");
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("CREATE TABLE ");
        createTableSql.append(tbl);
        createTableSql.append("\t(");
        createTableSql.append("fid varchar(44)");
        createTableSql.append(")");
        TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(createTableSql.toString());
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ").append(tbl).append(" ").append(selSql);
        DbUtil.execute((Context)ctx, (String)sb.toString());
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update ").append(destTableName).append(" set flastUpdateTime = ?").append(" where fid in (select fid from ").append(tbl).append(")");
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{toValue});
        TableManagerFacadeFactory.getLocalInstance((Context)ctx).releaseTableName(tbl);
    }

    @Override
    protected String _genTempTable(Context ctx, List orgids) throws BOSException, EASBizException {
        String tbl = null;
        try {
            tbl = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName("databasedassinassist");
            StringBuffer createTableSql = new StringBuffer();
            createTableSql.append("CREATE TABLE ");
            createTableSql.append(tbl);
            createTableSql.append("\t(");
            createTableSql.append("fid\tvarchar(44)");
            createTableSql.append(")");
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(createTableSql.toString());
            Connection cn = null;
            Statement stmt = null;
            String indexSql = "CREATE INDEX IX_BD_" + tbl.substring(tbl.length() - 8, tbl.length()) + " ON " + tbl + "(fid)";
            DbUtil.execute((Context)ctx, (String)indexSql);
            try {
                cn = EJBFactory.getConnection((Context)ctx);
                stmt = cn.createStatement();
                for (int i = 0; i < orgids.size(); ++i) {
                    stmt.addBatch("insert into " + tbl + " values ('" + orgids.get(i) + "')");
                }
                stmt.executeBatch();
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e);
                    throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)e));
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt, (Connection)cn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return tbl;
    }
}

