/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class ParallelSqlExecutor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.framework.app.ParallelSqlExecutor");
    List sqlList = new ArrayList();
    ExecutorService pool = null;
    List errorList = new ArrayList();

    public ParallelSqlExecutor(ExecutorService pool) {
        this.pool = pool;
    }

    public ParallelSqlExecutor() {
    }

    public List getSqlList() {
        return this.sqlList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(Context ctx) throws EASBizException, BOSException {
        CountDownLatch c = new CountDownLatch(this.getSqlList().size());
        if (this.sqlList.size() == 0) {
            return;
        }
        boolean isInnerPool = false;
        if (this.pool == null) {
            this.pool = Executors.newFixedThreadPool(this.sqlList.size());
            isInnerPool = true;
        }
        for (int i = 0; i < this.sqlList.size(); ++i) {
            this.pool.submit(new SqlExecutorTask(ctx, this.sqlList.get(i).toString(), c));
        }
        try {
            c.await();
            if (isInnerPool) {
                this.pool.shutdown();
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
        }
        finally {
            this.sqlList.clear();
        }
    }

    private void executeSingle(Context ctx, String sql) throws BOSException {
        Connection cn = null;
        Statement stmt = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.createStatement();
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    public List getErrorList() {
        return this.errorList;
    }

    class SqlExecutorTask
    implements Runnable {
        Context ctx;
        String sql;
        CountDownLatch c;

        public SqlExecutorTask(Context ctx, String sql, CountDownLatch c) {
            this.ctx = ctx;
            this.sql = sql;
            this.c = c;
        }

        @Override
        public void run() {
            try {
                ParallelSqlExecutor.this.executeSingle(this.ctx, this.sql);
            }
            catch (BOSException e) {
                ParallelSqlExecutor.this.errorList.add(e);
            }
            finally {
                this.c.countDown();
            }
        }
    }
}

