/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.app.ControlTypeUtil;
import com.kingdee.eas.basedata.framework.app.DEditServerControlStrategy;
import com.kingdee.eas.basedata.framework.app.DListServerControlStrategy;
import com.kingdee.eas.basedata.framework.app.DataBaseIServerControlStrategy;
import com.kingdee.eas.basedata.framework.app.IServerControlStrategy;
import com.kingdee.eas.basedata.framework.app.S1ServerControlStrategy;
import com.kingdee.eas.basedata.framework.app.S2ServerControlStrategy;
import com.kingdee.eas.basedata.framework.app.S3ServerControlStrategy;
import com.kingdee.eas.basedata.framework.app.S4ServerControlStrategy;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;

public abstract class ServerControlStrategy
implements IServerControlStrategy {
    public static final String ACTION_ADDNEW = "ACTION_ADDNEW";
    public static final String ACTION_DELETE = "ACTION_DELETE";
    public static final String ACTION_MODIFY = "ACTION_MODIFY";
    protected static final String CONTROLTYPE_S1 = "S1";
    protected static final String CONTROLTYPE_S2 = "S2";
    protected static final String CONTROLTYPE_S3 = "S3";
    protected static final String CONTROLTYPE_S4 = "S4";
    protected static final String CONTROLTYPE_I = "I";
    protected static final String CONTROLTYPE_D = "D";
    protected static final String FILTERFIELD_CUID = "CU.id";
    protected static final String FILTERFIELD_CULONGNUMBER = "CU.longNumber";
    private String currentCUID = null;
    private BOSObjectType bizType;

    @Override
    public BOSObjectType getBizType() {
        return this.bizType;
    }

    @Override
    public void setBizType(BOSObjectType bizType) {
        this.bizType = bizType;
    }

    public static IServerControlStrategy create(Context ctx, BOSObjectType bizType) throws BOSException {
        String type = ControlTypeUtil.getControlType(ctx, bizType);
        ServerControlStrategy stategy = ServerControlStrategy.create(ctx, type);
        if (stategy != null) {
            stategy.setBizType(bizType);
        }
        return stategy;
    }

    public static ServerControlStrategy create(Context ctx, String controlType) {
        ServerControlStrategy ccStrategy = null;
        if (controlType.equals(CONTROLTYPE_I)) {
            ccStrategy = new DataBaseIServerControlStrategy();
        } else if (controlType.equals(CONTROLTYPE_S1)) {
            ccStrategy = new S1ServerControlStrategy();
        } else if (controlType.equals(CONTROLTYPE_S2)) {
            ccStrategy = new S2ServerControlStrategy();
        } else if (controlType.equals(CONTROLTYPE_S3)) {
            ccStrategy = new S3ServerControlStrategy();
        } else if (controlType.equals(CONTROLTYPE_S4)) {
            ccStrategy = new S4ServerControlStrategy();
        } else if (controlType.equals(CONTROLTYPE_D)) {
            ccStrategy = new DListServerControlStrategy();
            ccStrategy = new DEditServerControlStrategy();
        }
        return ccStrategy;
    }

    public abstract void checkCanAdd(Context var1, IObjectPK var2, BOSObjectType var3) throws Exception;

    public abstract void checkCanUpdate(Context var1, DataBaseInfo var2, IObjectPK var3) throws Exception;

    public void checkCanDelete(String sltedKeyValue) throws Exception {
    }

    public abstract String getControlType();

    public void checkPermission(Context ctx, String action, String bizObjCUID) throws Exception {
        if (this.getControlType().equalsIgnoreCase(CONTROLTYPE_S1)) {
            if (!this.getCurrentCUID(ctx).equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                this.throwsExceptionForNoPermission(action);
            }
        } else if ((this.getControlType().equalsIgnoreCase(CONTROLTYPE_S3) || this.getControlType().equalsIgnoreCase(CONTROLTYPE_S4)) && !action.equals(ACTION_ADDNEW) && !this.getCurrentCUID(ctx).equals(bizObjCUID)) {
            this.throwsExceptionForNoPermission(action);
        }
    }

    protected String getCurrentCUID(Context ctx) {
        if (this.currentCUID == null) {
            this.currentCUID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        }
        return this.currentCUID;
    }

    private void throwsExceptionForNoPermission(String action) throws Exception {
        if (action.equals(ACTION_ADDNEW)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADD);
        }
        if (action.equals(ACTION_DELETE)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE);
        }
        if (action.equals(ACTION_MODIFY)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
    }

    @Override
    public abstract FilterInfo getDefaultFilterForControlType(Context var1, IObjectPK var2);
}

