/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.ICUIDGetterFacade;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.HashSet;

public class EntityControlTypeUtil {
    private static final String CONTROL_TYPE_NAME = "controlType";
    private static final String FILTERFIELD_CUID = "CU.id";
    private static final String FILTERFIELD_CULONGNUMBER = "CU.longNumber";
    public static final String CONTROLTYPE_S1 = "S1";
    public static final String CONTROLTYPE_S2 = "S2";
    public static final String CONTROLTYPE_S3 = "S3";
    public static final String CONTROLTYPE_S4 = "S4";
    public static final String CONTROLTYPE_I = "I";
    public static final String ACTION_ADDNEW_TREE = "ACTION_ADDNEW_TREE";
    public static final String ACTION_DELETE_TREE = "ACTION_DELETE_TREE";
    public static final String ACTION_MODIFY_TREE = "ACTION_MODIFY_TREE";
    public static final String ACTION_MOVE_TREE = "ACTION_MOVE_TREE";
    private static final String ACTION_ADDNEW = "ACTION_ADDNEW";
    private static final String ACTION_DELETE = "ACTION_DELETE";
    private static final String ACTION_MODIFY = "ACTION_MODIFY";

    private static String getCtrlUnitIDFromBizobject(String treeNodeBizobjectID) {
        String cuid = "";
        try {
            ICUIDGetterFacade icgf = CUIDGetterFacadeFactory.getRemoteInstance();
            cuid = icgf.getCUID(treeNodeBizobjectID);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return cuid;
    }

    public static boolean hasPermissionToMaintainTree(String controlType, String currentCtrlUnitID, String treeNodeBizobjectID, String actionIdentifier) {
        boolean rtv = true;
        if (controlType.equalsIgnoreCase(CONTROLTYPE_S1)) {
            if (!currentCtrlUnitID.equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                rtv = false;
            }
        } else if (!(!controlType.equalsIgnoreCase(CONTROLTYPE_S3) && !controlType.equalsIgnoreCase(CONTROLTYPE_S4) || actionIdentifier.equals(ACTION_ADDNEW_TREE) || treeNodeBizobjectID.equals("") || currentCtrlUnitID.equals(EntityControlTypeUtil.getCtrlUnitIDFromBizobject(treeNodeBizobjectID)))) {
            rtv = false;
        }
        return rtv;
    }

    public static void checkCanAddnew(String controlType, String currentCUID) throws Exception {
        EntityControlTypeUtil.checkPermission(ACTION_ADDNEW, controlType, currentCUID, "");
    }

    public static void checkCanRemove(String controlType, String currentCUID, String dataCUID) throws Exception {
        EntityControlTypeUtil.checkPermission(ACTION_DELETE, controlType, currentCUID, dataCUID);
    }

    public static void checkCanEdit(String controlType, String currentCUID, String dataCUID) throws Exception {
        EntityControlTypeUtil.checkPermission(ACTION_MODIFY, controlType, currentCUID, dataCUID);
    }

    private static void checkPermission(String action, String controlType, String currentCUID, String dataCUID) throws Exception {
        if (controlType.equalsIgnoreCase(CONTROLTYPE_S1)) {
            if (!currentCUID.equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                EntityControlTypeUtil.throwsExceptionForNoPermission(action);
            }
        } else if ((controlType.equalsIgnoreCase(CONTROLTYPE_S3) || controlType.equalsIgnoreCase(CONTROLTYPE_S4)) && !action.equals(ACTION_ADDNEW) && !currentCUID.equals(dataCUID)) {
            EntityControlTypeUtil.throwsExceptionForNoPermission(action);
        }
    }

    private static void throwsExceptionForNoPermission(String action) throws Exception {
        if (action.equals(ACTION_ADDNEW)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADD);
        }
        if (action.equals(ACTION_DELETE)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE);
        }
        if (action.equals(ACTION_MODIFY)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
    }

    public static FilterInfo getFilterInfoForControlTypeS4(String currentCUID, String currentCULongNumber) {
        return EntityControlTypeUtil.getDefaultFilterForControlTypeS4(currentCUID, currentCULongNumber);
    }

    private static FilterInfo getDefaultFilterForControlTypeS4(String currentCUID, String currentCULongNumber) {
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo(FILTERFIELD_CUID, (Object)currentCUID));
        String ln = currentCULongNumber;
        String[] lnSecs = ln.split("!");
        int size = lnSecs.length;
        HashSet<String> lnUps = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size - 1; ++i) {
            if (i != 0) {
                sb.append("!");
            }
            sb.append(lnSecs[i]);
            lnUps.add(sb.toString());
        }
        if (lnUps.size() != 0) {
            fic.add(new FilterItemInfo(FILTERFIELD_CULONGNUMBER, lnUps, CompareType.INCLUDE));
            fi.setMaskString("#0 or #1");
        }
        return fi;
    }

    public static FilterInfo getFilterInfoForControlTypeS4New(String currentCUID, String currentCULongNumber) {
        return EntityControlTypeUtil.getDefaultFilterForControlTypeS4New(currentCUID, currentCULongNumber);
    }

    private static FilterInfo getDefaultFilterForControlTypeS4New(String currentCUID, String currentCULongNumber) {
        FilterInfo fi = new FilterInfo();
        String ln = currentCULongNumber;
        if (null == ln || "".equals(ln)) {
            return fi;
        }
        String[] numbers = ln.split("!");
        StringBuffer inSql = new StringBuffer(200);
        inSql.append("select fid from t_org_ctrlunit where fnumber in (");
        for (int i = 0; i < numbers.length; ++i) {
            inSql.append("'").append(numbers[i]).append("'");
            if (i == numbers.length - 1) continue;
            inSql.append(",");
        }
        inSql.append(")");
        fi.getFilterItems().add(new FilterItemInfo(FILTERFIELD_CUID, (Object)inSql.toString(), CompareType.INNER));
        return fi;
    }

    public void checkCanAddnewForTypeD(Context ctx, BOSObjectType dataBOSType, BOSUuid currentCUID) throws Exception {
        boolean flag;
        ICUBDControl iCUBDControl = null;
        iCUBDControl = ctx != null ? CUBDControlFactory.getLocalInstance((Context)ctx) : CUBDControlFactory.getRemoteInstance();
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(dataBOSType.toString(), currentCUID.toString());
        boolean bl = flag = controlInfo == null ? false : controlInfo.isIsSubordinateAddnewable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADD);
        }
    }

    public void checkCanDeleteForTypeD(Context ctx, BOSObjectType dataBOSType, BOSUuid currentCUID) throws Exception {
        boolean flag;
        ICUBDControl iCUBDControl = null;
        iCUBDControl = ctx != null ? CUBDControlFactory.getLocalInstance((Context)ctx) : CUBDControlFactory.getRemoteInstance();
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(dataBOSType.toString(), currentCUID.toString());
        boolean bl = flag = controlInfo == null ? false : controlInfo.isIsSubordinateDeletable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE);
        }
    }

    public void checkCanUpdateForTypeD(Context ctx, BOSObjectType dataBOSType, BOSUuid currentCUID) throws Exception {
        boolean flag;
        ICUBDControl iCUBDControl = null;
        iCUBDControl = ctx != null ? CUBDControlFactory.getLocalInstance((Context)ctx) : CUBDControlFactory.getRemoteInstance();
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(dataBOSType.toString(), currentCUID.toString());
        boolean bl = flag = controlInfo == null ? false : controlInfo.isIsSubordinateEditable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
    }

    public static void checkNumberDupForS4Tree(Context ctx, String currentCUID, String currentCULongNumber, ICoreBase icb, IObjectValue iov) throws BOSException, EASBizException {
        EntityControlTypeUtil.checkNumberForDupForS4TreeInnerly(currentCUID, currentCULongNumber, icb, iov);
        ICtrlUnit icu = null;
        icu = ctx == null ? CtrlUnitFactory.getRemoteInstance() : CtrlUnitFactory.getLocalInstance((Context)ctx);
        StringBuffer oql = new StringBuffer(50);
        oql.append("where longNumber like '").append(currentCULongNumber).append("!%'");
        CtrlUnitCollection cuc = icu.getCtrlUnitCollection(oql.toString());
        String subCUID = null;
        String subCULongNumber = null;
        CtrlUnitInfo subCU = null;
        int n = cuc.size();
        for (int i = 0; i < n; ++i) {
            subCU = cuc.get(i);
            subCUID = subCU.getId().toString();
            subCULongNumber = subCU.getLongNumber().toString();
            EntityControlTypeUtil.checkNumberForDupForS4TreeInnerly(subCUID, subCULongNumber, icb, iov);
        }
    }

    private static void checkNumberForDupForS4TreeInnerly(String currentCUID, String currentCULongNumber, ICoreBase icb, IObjectValue iov) throws BOSException, EASBizException {
        FilterInfo fiS4 = EntityControlTypeUtil.getFilterInfoForControlTypeS4(currentCUID, currentCULongNumber);
        TreeBaseInfo tbi = (TreeBaseInfo)iov;
        String selfID = tbi.getId() == null ? null : tbi.getId().toString();
        String parentID = tbi.innerGetParent() == null ? null : tbi.innerGetParent().getId().toString();
        String number = tbi.getNumber();
        FilterInfo fiEx = new FilterInfo();
        FilterItemCollection ficEx = fiEx.getFilterItems();
        ficEx.add(new FilterItemInfo("number", (Object)number));
        ficEx.add(new FilterItemInfo("parent.id", (Object)parentID));
        ficEx.add(new FilterItemInfo("id", (Object)selfID, CompareType.NOTEQUALS));
        fiEx.mergeFilter(fiS4, "and");
        if (icb.exists(fiEx)) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, (Object[])new String[]{number});
        }
    }
}

