/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.util;

import java.util.ArrayList;
import java.util.HashSet;

public class INClauseOptimizer {
    public static final String IN = "in";
    public static final String NOT_IN = "not in";

    public static String getSQL(String fieldName, ArrayList values, String operator) {
        return INClauseOptimizer.getSQLForValues(values, fieldName, operator);
    }

    public static String getSQL(String fieldName, HashSet values, String operator) {
        return INClauseOptimizer.getSQLForValues(new ArrayList(values), fieldName, operator);
    }

    private static String getSQLForValues(ArrayList values, String fieldName, String operator) {
        if (values.size() == 0) {
            return "";
        }
        String relation = operator.equals(IN) ? "or" : "and";
        StringBuffer oql = new StringBuffer();
        int groupCount = 50;
        ArrayList idGroup = new ArrayList();
        boolean handledAGroup = false;
        boolean firstGroup = true;
        int n = values.size();
        for (int i = 0; i < n; ++i) {
            handledAGroup = false;
            idGroup.add(values.get(i));
            if (i == 0 || i % 50 != 0) continue;
            if (!firstGroup) {
                oql.append(" ").append(relation).append(" ");
            }
            oql.append(INClauseOptimizer.getGroupSQL(idGroup, fieldName, operator));
            handledAGroup = true;
            firstGroup = false;
            idGroup.clear();
        }
        if (!handledAGroup) {
            if (!firstGroup) {
                oql.append(" ").append(relation).append(" ");
            }
            oql.append(INClauseOptimizer.getGroupSQL(idGroup, fieldName, operator));
        }
        return oql.toString();
    }

    private static String getGroupSQL(ArrayList idGroup, String fieldName, String operator) {
        StringBuffer oql = new StringBuffer();
        oql.append(fieldName);
        oql.append(" ").append(operator).append(" ('").append(idGroup.get(0).toString()).append("'");
        int n = idGroup.size();
        for (int i = 1; i < n; ++i) {
            oql.append(",'").append(idGroup.get(i).toString()).append("'");
        }
        oql.append(")");
        return oql.toString();
    }
}

