/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.hraux.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.hraux.BasicItemInfo;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.basedata.hraux.app.AbstractBasicItemControllerBean;
import com.kingdee.eas.basedata.hraux.util.HRBaseDBUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class BasicItemControllerBean
extends AbstractBasicItemControllerBean {
    protected void verifyData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super._checkNameBlank(ctx, model);
        if (!model.getBOSType().toString().equals("40CD5A95")) {
            super._checkNameDup(ctx, model);
        }
        super._checkNumberBlank(ctx, model);
        super._checkNumberDup(ctx, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BasicItemInfo info = (BasicItemInfo)model;
        CtrlUnitInfo cu = new CtrlUnitInfo();
        cu.setId(BOSUuid.read((String)"11111111-1111-1111-1111-111111111111CCE7AED4"));
        info.setCU(cu);
        this.verifyData(ctx, (IObjectValue)info);
        super._addnew(ctx, pk, (IObjectValue)info);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BasicItemInfo info = (BasicItemInfo)model;
        if (info.getCU() == null || info.getCU().getId() == null) {
            CtrlUnitInfo cu = new CtrlUnitInfo();
            cu.setId(BOSUuid.read((String)"11111111-1111-1111-1111-111111111111CCE7AED4"));
            info.setCU(cu);
        }
        this.verifyData(ctx, (IObjectValue)info);
        if (info.getState() == null) {
            info.setState(StateEnum.ENABLE);
        }
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.verifyData(ctx, model);
        BasicItemInfo info = (BasicItemInfo)model;
        if (info.getState() == null) {
            info.setState(StateEnum.ENABLE);
        }
        super._update(ctx, pk, model);
    }

    @Override
    protected void _sort(Context ctx, String[] ids, int[] orders) throws BOSException, EASBizException {
        IMetaDataLoader metaData = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        String tableName = metaData.getEntity(this.getBOSType()).getTable().getName();
        String sql = "UPDATE " + tableName + " SET FIndex=? WHERE FID=?";
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = this.getConnection(ctx);
            pstmt = con.prepareStatement(sql);
            for (int i = 0; i < ids.length; ++i) {
                pstmt.setInt(1, orders[i]);
                pstmt.setString(2, ids[i]);
                pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)con);
    }

    @Override
    protected void _enable(Context ctx, String id) throws BOSException {
        HRBaseDBUtil.updateInfoState(ctx, id, "FState", 1);
    }

    @Override
    protected void _disable(Context ctx, String id) throws BOSException {
        HRBaseDBUtil.updateInfoState(ctx, id, "FState", 2);
    }
}

