/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CostItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.ICostItem;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialCost;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialCostCollection;
import com.kingdee.eas.basedata.master.material.MaterialCostFactory;
import com.kingdee.eas.basedata.master.material.MaterialCostInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.master.material.StoreType;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.ncm.ExpenseCollection;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.IExpense;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DataImportMaterialCost
extends AbstractDataTransmission {
    private Set PerminsionCheckedCuIds = new HashSet();
    Map cacheCompanyOrgUnit = new HashMap();
    Map cacheOrg = new HashMap();
    Map cacheCostItem = new HashMap();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MaterialCostFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            return this.innerTransmit(hsData, ctx);
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private CoreBaseInfo innerTransmit(Hashtable hsData, Context ctx) throws TaskExternalException, Exception {
        boolean flag;
        MaterialInfo materialInfo;
        Object data = ((DataToken)hsData.get((Object)"FOrgUnit")).data;
        if (data == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"GetBizOrgUnitFailed", (Context)ctx));
        }
        CompanyOrgUnitInfo companyOrgUnitInfo = this.getCompanyOrgByNumber(ctx, data.toString());
        if (companyOrgUnitInfo == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"GetBizOrgUnitFailed", (Context)ctx));
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (!PerminsionUtil.isUserBizOrgRange((Context)ctx, (String)userId, (String)companyOrgUnitInfo.getId().toString())) {
            throw new TaskExternalException(new MaterialBaseException(MaterialBaseException.OUT_BIZ_ORG, new Object[]{companyOrgUnitInfo.getName()}).getMessage());
        }
        String CuId = companyOrgUnitInfo.getCU().getId().toString();
        if (!this.PerminsionCheckedCuIds.contains(CuId)) {
            try {
                PerminsionUtil.checkCUPerminsion((Context)ctx, (String)CuId, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), (String)"bd_materialCost_import");
            }
            catch (EASBizException ee) {
                throw new TaskExternalException(ee.getMessage(), (Throwable)ee);
            }
            this.PerminsionCheckedCuIds.add(CuId);
        }
        if (!DataImportTools.isMaterialAssignForOrg((Context)ctx, (String)(materialInfo = DataImportTools.getMaterialInfo((Context)ctx, (CtrlUnitInfo)companyOrgUnitInfo.getCU(), (String)this.getDataString(hsData, "FNumber"))).getId().toString(), (CtrlUnitInfo)companyOrgUnitInfo.getCU())) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"NoAssignRelBetweenOrgAndMaterial", (Context)ctx));
        }
        MaterialCostInfo info = new MaterialCostInfo();
        if (this.isSltImportUpdate()) {
            FilterInfo filter = new FilterInfo();
            DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"orgUnit.id", (Object)companyOrgUnitInfo.getId().toString());
            DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"material.number", (Object)this.getDataString(hsData, "FNumber"));
            filter.setMaskString("#0 and #1");
            IMaterialCost iProperty = MaterialCostFactory.getLocalInstance(ctx);
            MaterialCostCollection proCollection = iProperty.getMaterialCostCollection(DataImportTools.getViewInfo((FilterInfo)filter));
            if (proCollection != null && proCollection.size() > 0) {
                info.setId(proCollection.get(0).getId());
                info.setCU(proCollection.get(0).getCU());
            }
        }
        ExpenseInfo expenseInfo = DataImportMaterialCost.getExpenseInfo(ctx, this.getDataString(hsData, "FExpense"));
        info.setExpense(expenseInfo);
        if (expenseInfo != null && companyOrgUnitInfo.castToFullOrgUnitInfo() != null && !expenseInfo.getCU().equalsPK((IObjectValue)companyOrgUnitInfo.castToFullOrgUnitInfo().getCU()) && (flag = DataImportMaterialCost.getExpenseInfo(ctx, expenseInfo, companyOrgUnitInfo.castToFullOrgUnitInfo().getCU()))) {
            throw new MaterialBaseException(MaterialBaseException.DATAIMPORT_MATERIALEXPENSE_ORG_ERROR, new Object[]{expenseInfo.getName(), companyOrgUnitInfo.getName()});
        }
        info.setMaterial(materialInfo);
        info.setOrgUnit(companyOrgUnitInfo.castToFullOrgUnitInfo());
        info.setCU(companyOrgUnitInfo.getCU());
        this.handleInfo(hsData, ctx, companyOrgUnitInfo.getCU().getId().toString(), info);
        return info;
    }

    private CompanyOrgUnitInfo getCompanyOrgByNumber(Context ctx, String number) throws BOSException {
        if (number == null || "".equals(number)) {
            return null;
        }
        Object result = this.cacheCompanyOrgUnit.get(number);
        if (result == null) {
            result = DataImportTools.getCompanyOrgUnitInfoFromNumber((Context)ctx, (String)number);
            this.cacheCompanyOrgUnit.put(number, result);
        }
        return (CompanyOrgUnitInfo)result;
    }

    private OrgUnitInfo getOrgByNumber(Context ctx, String number) throws TaskExternalException {
        if (number == null || "".equals(number)) {
            return null;
        }
        Object result = this.cacheOrg.get(number);
        if (result == null) {
            result = DataImportTools.getOrgUnitInfo((Context)ctx, (String)number);
            this.cacheOrg.put(number, result);
        }
        return (OrgUnitInfo)result;
    }

    private CostItemInfo getCostItemInfo(Context ctx, String cu, String number) throws Exception {
        if (cu == null || cu.equals("")) {
            return null;
        }
        if (number == null || number.equals("")) {
            return null;
        }
        String key = cu + "!" + number;
        Object result = this.cacheCostItem.get(key);
        if (result == null) {
            String sql;
            ICostItem iCostItem = CostItemFactory.getLocalInstance((Context)ctx);
            CostItemCollection costCollection = iCostItem.getCostItemCollection(sql = "where number = '" + number + "' and (cu = '" + cu + "' or id in(SELECT FDataBaseDID FROM T_BD_DataBaseDAssign where FBOSObjectType = '548C5A91' and FAssignCUID = '" + cu + "'))");
            if (costCollection == null || costCollection.size() <= 0) {
                throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"DataImport_CostItem_Error", (Locale)ctx.getLocale()));
            }
            result = costCollection.get(0);
            this.cacheCostItem.put(key, result);
        }
        return (CostItemInfo)result;
    }

    private void handleInfo(Hashtable hsData, Context ctx, String orgUnitId, MaterialCostInfo info) throws Exception {
        info.setStoreType(DataImportTools.getStoreTypeEnum((String)this.getDataString(hsData, "FStoreType"), (Context)ctx));
        info.setIsParticipateReduct(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsParticipateReduct"));
        info.setDefaultCostItem(this.getCostItemInfo(ctx, orgUnitId, this.getDataString(hsData, "FDefaultCostItem")));
        OrgUnitInfo ou = this.getOrgByNumber(ctx, this.getDataString(hsData, "FFreezeOrgUnit"));
        info.setStatus(DataImportTools.getStatusEnum((String)this.getDataString(hsData, "FStatus"), (Context)ctx));
        if (ou != null) {
            info.setFreezeOrgUnit(ou.castToFullOrgUnitInfo());
        } else if (info.getStatus() == UsedStatusEnum.FREEZED) {
            info.setFreezeOrgUnit(ContextUtil.getCurrentOrgUnit((Context)ctx).castToFullOrgUnitInfo());
        } else {
            info.setFreezeOrgUnit(null);
        }
        info.setEffectedStatus(2);
    }

    private String getDataString(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataString((Hashtable)hsData, (String)fieldName);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            this.putTable(result, "FStoreType", StoreType.getEnum((int)rs.getInt("AssitInfo.storeType")).getAlias(ctx.getLocale()));
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FMaterialName", rs.getString("name"));
            this.putTable(result, "FOrgUnit", rs.getString("orgUnit.number"));
            result.put("FIsParticipateReduct", DataImportUtils.transformValue((Object)rs.getString("AssitInfo.isParticipateReduct")));
            this.putTable(result, "FDefaultCostItem", rs.getString("costitem.number"));
            this.putTable(result, "FFreezeOrgUnit", rs.getString("freezeOrgUnit.number"));
            this.putTable(result, "FStatus", UsedStatusEnum.getEnum((int)rs.getInt("AssitInfo.status")).getAlias(ctx.getLocale()));
            this.putTable(result, "FExpense", rs.getString("expense.number"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        ObjectUuidPK pk = null;
        try {
            IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
            pk = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
            filterInfo = iMaterial.getDatabaseDFilter((IObjectPK)pk, "id", "adminCU.id");
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.material.app.DataImpExpCostQuery";
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    public static ExpenseInfo getExpenseInfo(Context ctx, String number) throws TaskExternalException {
        IExpense iExpense = null;
        ExpenseCollection expenseCollection = null;
        if (number == null || number.length() <= 0) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"number", (Object)number);
        filter.setMaskString("#0");
        try {
            iExpense = ExpenseFactory.getLocalInstance((Context)ctx);
            EntityViewInfo entityViewInfo = DataImportTools.getViewInfo((FilterInfo)filter);
            expenseCollection = iExpense.getExpenseCollection(entityViewInfo);
            if (expenseCollection == null || expenseCollection.size() <= 0) {
                throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"DataImport_MaterialExpense_Error", (Locale)ctx.getLocale()));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return expenseCollection.get(0);
    }

    public static boolean getExpenseInfo(Context ctx, ExpenseInfo expenseInfo, CtrlUnitInfo cuInfo) throws TaskExternalException {
        boolean rsFlag = false;
        IExpense iExpense = null;
        ExpenseCollection expenseCollection = null;
        FilterInfo filter = new FilterInfo();
        String sql = "select FDATABASEDID from t_bd_databasedassign WHERE FBOSOBJECTTYPE = '" + expenseInfo.getBOSType().toString() + "' and FDATABASEDID = '" + expenseInfo.getId().toString() + "' AND FASSIGNCUID = '" + cuInfo.getId().toString() + "'";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        filter.setMaskString("#0");
        try {
            iExpense = ExpenseFactory.getLocalInstance((Context)ctx);
            EntityViewInfo entityViewInfo = DataImportTools.getViewInfo((FilterInfo)filter);
            expenseCollection = iExpense.getExpenseCollection(entityViewInfo);
            if (expenseCollection == null || expenseCollection.size() <= 0) {
                rsFlag = true;
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return rsFlag;
    }
}

