/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialCost;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialCostFactory;
import com.kingdee.eas.basedata.master.material.MaterialCostInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPropertyBaseInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.AbstractMaterialCostControllerBean;
import com.kingdee.eas.basedata.master.material.app.MaterialSrvUtils;
import com.kingdee.eas.basedata.master.material.util.MaterialUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class MaterialCostControllerBean
extends AbstractMaterialCostControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.material.app.MaterialCostControllerBean");

    protected void _freeze(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialCost iproperty = MaterialCostFactory.getLocalInstance(ctx);
        MaterialCostInfo info = iproperty.getMaterialCostInfo(pk);
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU((Context)ctx, (String)info.getCU().getId().toString());
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTAPPROVE);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        info.setStatus(UsedStatusEnum.FREEZED);
        info.setFreezeOrgUnit(ContextUtil.getCurrentOrgUnit((Context)ctx).castToFullOrgUnitInfo());
        iproperty.update(pk, (CoreBaseInfo)info);
    }

    protected void _unFreeze(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialCost iproperty = MaterialCostFactory.getLocalInstance(ctx);
        MaterialCostInfo info = iproperty.getMaterialCostInfo(pk);
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU((Context)ctx, (String)info.getCU().getId().toString());
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTAPPROVE);
        }
        if (info.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTFREEZED);
        }
        info.setStatus(UsedStatusEnum.APPROVED);
        info.setFreezeOrgUnit(null);
        iproperty.update(pk, (CoreBaseInfo)info);
    }

    protected void _approve(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MaterialCostInfo info = this.getMaterialCostInfo(ctx, pk);
        this._approve(ctx, info);
    }

    protected void _approve(Context ctx, MaterialPropertyBaseInfo info) throws BOSException, EASBizException {
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU((Context)ctx, (String)info.getCU().getId().toString());
        IMaterial ima = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialInfo mainfo = ima.getMaterialInfo((IObjectPK)new ObjectUuidPK(info.getMaterial().getId()));
        if (mainfo.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTAPPROVE);
        }
        if (mainfo.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.BASEINFO_FREEZED);
        }
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_APPROVED);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        StringBuffer updatesql = new StringBuffer();
        Connection conn = null;
        Statement statement = null;
        try {
            conn = super.getConnection(ctx);
            statement = conn.createStatement();
            updatesql.append(" update T_BD_MaterialCost set FStatus = ").append(String.valueOf(1)).append("  where fid = '").append(info.getId().toString()).append("'");
            statement.execute(updatesql.toString());
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + updatesql.toString(), (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)conn);
    }

    protected void _unApprove(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialCost iproperty = MaterialCostFactory.getLocalInstance(ctx);
        MaterialCostInfo info = iproperty.getMaterialCostInfo(pk);
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU((Context)ctx, (String)info.getCU().getId().toString());
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTAPPROVE);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        info.setStatus(UsedStatusEnum.UNAPPROVE);
        iproperty.update(pk, (CoreBaseInfo)info);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkOrgDup(ctx, model);
        MaterialCostInfo info = (MaterialCostInfo)model;
        if (info.getOrgUnit().getCU() != null) {
            info.setCU(info.getOrgUnit().getCU());
        }
        info.put("MaterialNumber", MaterialSrvUtils.getMaterialLogInfo((Context)ctx, (String)info.getMaterial().getId().toString()));
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    private void _checkOrgDup(Context ctx, IObjectValue model) throws MaterialBaseException, EASBizException, BOSException {
        MaterialPropertyBaseInfo info = (MaterialPropertyBaseInfo)model;
        String orgID = info.getOrgUnit().getId().toString();
        String materialID = info.getMaterial().getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID, CompareType.EQUALS));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.setMaskString("#0 and #1");
        }
        if (this.exists(ctx, filter)) {
            throw new MaterialBaseException(MaterialBaseException.EXIST_COSTINFO);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaterialCostInfo info = (MaterialCostInfo)model;
        Object oldCompany = null;
        if (info.getOrgUnit() != null && info.getOrgUnit().getCU() != null) {
            info.setCU(info.getOrgUnit().getCU());
        }
        boolean isUpdate = false;
        if (info.getId() != null) {
            IMaterialCost iMaterialCost = MaterialCostFactory.getLocalInstance(ctx);
            MaterialCostInfo oldInfo = iMaterialCost.getMaterialCostInfo((IObjectPK)new ObjectUuidPK(info.getId()), this.getSelectors());
            this.checkHasReference(ctx, oldInfo, info);
            isUpdate = true;
        }
        IObjectPK iObjectPK = super._submit(ctx, (IObjectValue)info);
        return iObjectPK;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialCost iinfo = MaterialCostFactory.getLocalInstance(ctx);
        MaterialCostInfo Info = iinfo.getMaterialCostInfo(pk, this.getSelectors());
        if (Info.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_APPROVED);
        }
        if (Info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        Throwable e = this.checkReference(ctx, Info.getId());
        String companyID = Info.getOrgUnit().getId().toString().toString();
        String materialNumber = Info.getMaterial().getNumber();
        ICostObject iCostObject = CostObjectFactory.getLocalInstance((Context)ctx);
        boolean isCostObjectRef = iCostObject.checkMaterialUsed(companyID, materialNumber, 0);
        if (e != null || isCostObjectRef) {
            throw new MaterialBaseException(MaterialBaseException.REF_NOT_DELETECOST, e);
        }
        this.checkAccountType(ctx, Info.getMaterial().getId().toString(), Info.getOrgUnit().getId().toString());
        super._delete(ctx, pk);
    }

    private void checkAccountType(Context ctx, String materialId, String companyid) throws BOSException, EASBizException {
        ICompanyOrgUnit company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        String companyName = company.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid)).getName();
        ICostObject iCostObject = CostObjectFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("relatedID", (Object)materialId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)companyid, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        int error = 0;
        view.setFilter(filterInfo);
        CostObjectCollection coCollection = iCostObject.getCostObjectCollection(view);
        if (coCollection != null) {
            int n = coCollection.size();
            for (int i = 0; i < n; ++i) {
                CostObjectInfo coInfo = coCollection.get(i);
                if (coInfo == null) continue;
                try {
                    iCostObject.delete((IObjectPK)new ObjectStringPK(coInfo.getId().toString()));
                    continue;
                }
                catch (Exception e) {
                    ++error;
                }
            }
        }
        if (error != 0) {
            throw new MaterialBaseException(MaterialBaseException.COSTOBJECT_NOTDELETE, new Object[]{companyName});
        }
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        return sic;
    }

    private Throwable checkReference(Context ctx, BOSUuid id) {
        Exception e = null;
        try {
            this._isReferenced(ctx, (IObjectPK)new ObjectUuidPK(id));
            BizCheckerUtil.isReferenced((Context)ctx, (BOSUuid)id);
        }
        catch (Exception er) {
            e = er;
        }
        return e;
    }

    private void checkHasReference(Context ctx, MaterialCostInfo oldVO, MaterialCostInfo updateVO) throws EASBizException, BOSException {
        Throwable e = this.checkReference(ctx, updateVO.getId());
        String companyID = oldVO.getOrgUnit().getId().toString().toString();
        String materialNumber = oldVO.getMaterial().getNumber();
        ICostObject iCostObject = CostObjectFactory.getLocalInstance((Context)ctx);
        boolean isCostObjectRef = iCostObject.checkMaterialUsed(companyID, materialNumber, 0);
        if (e != null || isCostObjectRef) {
            if (oldVO.getStoreType().getValue() != updateVO.getStoreType().getValue()) {
                throw new MaterialBaseException(MaterialBaseException.REF_NOT_REDUCE_STORETYPE, e);
            }
            if (!companyID.equals(updateVO.getOrgUnit().getId().toString().toString())) {
                throw new MaterialBaseException(MaterialBaseException.REF_NOT_REDUCE_COMPANY, e);
            }
        }
    }

    private void autoGenerateCostObject(Context ctx, MaterialCostInfo info, FullOrgUnitInfo oldCompany) throws EASBizException, BOSException {
        String orgUnitId;
        String materialId = info.getMaterial().getId().toString();
        boolean notGencostObject = MaterialCostInfo.isNotGenCostObject(ctx, materialId, orgUnitId = info.getOrgUnit().getId().toString());
        if (notGencostObject) {
            return;
        }
    }

    @Override
    protected void _updateCheck(Context ctx, IObjectPK pk, MaterialCostInfo newInfo) throws BOSException, EASBizException {
        String name = "";
        name = newInfo.getMaterial().getName(ctx.getLocale());
        if (newInfo.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.APPROVE_INVALID, new Object[]{name});
        }
        if (newInfo.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.FREEZED_INVALID, new Object[]{name});
        }
        MaterialCostInfo oldInfo = this.getMaterialCostInfo(ctx, pk);
        this.checkHasReference(ctx, oldInfo, newInfo);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = this.getSelectors();
        sic.add(new SelectorItemInfo("material.name"));
        MaterialCostInfo info = this.getMaterialCostInfo(ctx, pk, sic);
        MaterialInfo matInfo = (MaterialInfo)info.get("material");
        if (matInfo != null) {
            return matInfo.getNumber() + "  " + matInfo.getName(ctx.getLocale());
        }
        return pk.toString();
    }
}

