/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.master.material.IMaterialCost;
import com.kingdee.eas.basedata.master.material.MaterialCostCollection;
import com.kingdee.eas.basedata.master.material.MaterialCostFactory;
import com.kingdee.eas.basedata.master.material.MaterialCostInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.StoreType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionResults;

public class CheckAccountTypeProcessor
extends AbstractBusinessProcessor {
    public CheckAccountTypeProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchResults.getObjCollection().size() == 0) {
            return;
        }
        CoreBaseInfo info = (CoreBaseInfo)batchResults.getObjCollection().getObject(0);
        this.checkAccountType(this.ctx, info);
    }

    private void checkAccountType(Context ctx, CoreBaseInfo info) throws BOSException, EASBizException {
        MaterialInfo materialInfo = (MaterialInfo)info.get("mateial");
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)info.get("company");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialInfo.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)companyInfo.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        IMaterialCost imc = MaterialCostFactory.getLocalInstance(ctx);
        MaterialCostCollection mcColl = imc.getMaterialCostCollection(view);
        if (mcColl.size() != 0) {
            MaterialCostInfo costinfo = mcColl.get(0);
            costinfo.setStoreType(StoreType.SOURCE_MATERIAL);
            imc.update((IObjectPK)new ObjectUuidPK(costinfo.getId().toString()), (CoreBaseInfo)costinfo);
        }
        ICostObject iCostObject = CostObjectFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("relatedID", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)companyInfo.getId().toString(), CompareType.EQUALS));
        view = new EntityViewInfo();
        view.setFilter(filterInfo);
        CostObjectCollection coCollection = iCostObject.getCostObjectCollection(view);
        if (coCollection != null) {
            int n = coCollection.size();
            for (int i = 0; i < n; ++i) {
                CostObjectInfo coInfo = coCollection.get(i);
                if (coInfo == null) continue;
                iCostObject.delete((IObjectPK)new ObjectStringPK(coInfo.getId().toString()));
            }
        }
    }
}

