/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.basedata.master.material.IMaterialCost;
import com.kingdee.eas.basedata.master.material.MaterialCostFactory;
import com.kingdee.eas.basedata.master.material.MaterialCostInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.StoreType;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import java.util.HashMap;

public class MaterialCostAutoCreateProcessor
extends AbstractBusinessProcessor {
    public MaterialCostAutoCreateProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        ApplicationContext ac = this.getExecuteContext().getApplicationContext();
        MaterialInfo matInfo = (MaterialInfo)ac.getData("matInfo");
        CompanyOrgUnitInfo comOrgInfo = (CompanyOrgUnitInfo)ac.getData("comOrgInfo");
        HashMap errors = (HashMap)ac.getData("errors");
        IMaterialCost imatCost = MaterialCostFactory.getLocalInstance(this.ctx);
        MaterialCostInfo costInfo = new MaterialCostInfo();
        costInfo.setMaterial(matInfo);
        costInfo.setStatus(UsedStatusEnum.UNAPPROVE);
        costInfo.setEffectedStatus(2);
        costInfo.setOrgUnit(comOrgInfo.castToFullOrgUnitInfo());
        costInfo.setStoreType(StoreType.SOURCE_MATERIAL);
        try {
            ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
            imatCost.addnew((CoreBaseInfo)costInfo);
        }
        catch (PermissionException e2) {
            errors.put("cost", e2);
        }
    }
}

