/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialCost;
import com.kingdee.eas.basedata.master.material.MaterialCostCollection;
import com.kingdee.eas.basedata.master.material.MaterialCostFactory;
import com.kingdee.eas.basedata.master.material.MaterialCostInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPropertyBaseInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.MaterialControllerBean;
import com.kingdee.eas.basedata.master.material.app.processor.AbstractMaterialMultiApproveProcessor;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MaterialCostMultiApproveProcessor
extends AbstractMaterialMultiApproveProcessor {
    private Logger logger = Logger.getLogger(MaterialCostMultiApproveProcessor.class);

    public MaterialCostMultiApproveProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        String ouID = (String)this.getExecuteContext().getApplicationContext().getData("ouID");
        ArrayList idList = (ArrayList)this.getExecuteContext().getApplicationContext().getData("idList");
        ResponseContext response = new ResponseContext();
        int result = 0;
        String symbol = (String)this.getExecuteContext().getApplicationContext().getData("symbol");
        if (symbol.startsWith("mulAppr.")) {
            result = this._mulApproveCost(this.ctx, ouID, idList);
        } else if (symbol.startsWith("mulUnappr")) {
            result = this._mulUnApproveCost(this.ctx, ouID, idList);
        }
        response.put((Object)"result", (Object)result);
        batchResults.setResponse(response);
    }

    protected int _mulApproveCost(Context ctx, String ouID, ArrayList idList) throws BOSException, EASBizException {
        this.checkFunctionPermission(ctx, ouID, "bd_materialCost_approve");
        int count = 0;
        IMaterialCost iProperty = MaterialCostFactory.getLocalInstance(ctx);
        ArrayList<MaterialPropertyBaseInfo> baselist = null;
        ArrayList lst = MaterialControllerBean.getidsWhere((ArrayList)idList, (String)"material.id");
        for (int j = 0; j < lst.size(); ++j) {
            String swhere = (String)lst.get(j);
            baselist = new ArrayList<MaterialPropertyBaseInfo>();
            String datapermSql = this.getDataPermissionSql(ctx, ouID, "bd_materialCost_approve");
            MaterialCostCollection coll = null;
            coll = datapermSql != null && datapermSql.equals("1 = 1") ? iProperty.getMaterialCostCollection("select *, material.id, material.status, material.baseUnit.*  where  status = 0 and orgUnit.id = '" + ouID + "' and " + swhere) : iProperty.getMaterialCostCollection("select *, material.id, material.status, material.baseUnit.* where  status = 0 and orgUnit.id = '" + ouID + "' and " + swhere + " and " + datapermSql);
            if (coll == null) continue;
            for (int i = 0; i < coll.size(); ++i) {
                MaterialCostInfo info = coll.get(i);
                baselist.add(info);
            }
            count += this.multiAssitantCostApprove(ctx, baselist, "T_BD_MaterialCost");
        }
        return count;
    }

    protected int _mulUnApproveCost(Context ctx, String ouID, ArrayList idList) throws BOSException, EASBizException {
        this.checkFunctionPermission(ctx, ouID, "bd_materialCost_unApprove");
        int count = 0;
        IMaterialCost iProperty = MaterialCostFactory.getLocalInstance(ctx);
        ArrayList<MaterialCostInfo> baselist = null;
        ArrayList lst = MaterialControllerBean.getidsWhere((ArrayList)idList, (String)"material.id");
        for (int j = 0; j < lst.size(); ++j) {
            String swhere = (String)lst.get(j);
            baselist = new ArrayList<MaterialCostInfo>();
            String datapermSql = this.getDataPermissionSql(ctx, ouID, "bd_materialCost_unApprove");
            MaterialCostCollection coll = null;
            coll = datapermSql != null && datapermSql.equals("1 = 1") ? iProperty.getMaterialCostCollection("where  status = 1 and orgUnit.id = '" + ouID + "' and " + swhere) : iProperty.getMaterialCostCollection("where  status = 1 and orgUnit.id = '" + ouID + "' and " + swhere + " and " + datapermSql);
            if (coll == null) continue;
            for (int i = 0; i < coll.size(); ++i) {
                MaterialCostInfo info = coll.get(i);
                baselist.add(info);
            }
            count += this.multiUnApprove(ctx, baselist, "T_BD_MaterialCost");
        }
        return count;
    }

    private int multiAssitantCostApprove(Context ctx, List<MaterialPropertyBaseInfo> baselist, String tableName) throws BOSException, EASBizException {
        int count = 0;
        if (baselist != null && !baselist.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>();
            IMaterial ima = MaterialFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < baselist.size(); ++i) {
                MaterialInfo mainfo;
                MaterialPropertyBaseInfo info = baselist.get(i);
                if (info == null || (mainfo = ima.getMaterialInfo((IObjectPK)new ObjectUuidPK(info.getMaterial().getId()))) == null || mainfo.getStatus() == UsedStatusEnum.UNAPPROVE || mainfo.getStatus() == UsedStatusEnum.FREEZED || info.getEffectedStatus() != 2 || info.getStatus() != UsedStatusEnum.UNAPPROVE) continue;
                list.add(info.getId().toString());
            }
            count = list.size();
            if (list != null && !list.isEmpty()) {
                this.multiAssitantApproveSql(ctx, list, tableName);
            }
        }
        return count;
    }
}

