/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.ABCEnum;
import com.kingdee.eas.basedata.master.material.BatchPolicyEnum;
import com.kingdee.eas.basedata.master.material.CloseDateCalculateModeEnum;
import com.kingdee.eas.basedata.master.material.EquipmentPropertyEnum;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.IssuePriorityEnum;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.master.material.PlanningModeEnum;
import com.kingdee.eas.basedata.master.material.TimeUnitEnum;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DataImportMaterialInventory
extends AbstractDataTransmission {
    private IMultiMeasureUnit iMultiMeasureUnit = null;
    private Set PerminsionCheckedCuIds = new HashSet();
    private Map<String, Boolean> userBizOrgRangeMap = new HashMap<String, Boolean>();
    Map cacheStorageOrgUnit = new HashMap();
    Map cacheOrg = new HashMap();
    Map cachePerson = new HashMap();
    Map cacheWarehouse = new HashMap();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MaterialInventoryFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            return this.innerTransmit(hsData, ctx);
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private CoreBaseInfo innerTransmit(Hashtable hsData, Context ctx) throws Exception, Exception {
        String creatorNumber;
        Object data = ((DataToken)hsData.get((Object)"FOrgUnit")).data;
        if (data == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"GetInventoryOrgUnitFailed", (Context)ctx));
        }
        StorageOrgUnitInfo storageOrgUnit = this.getStorageOrgByNumber(ctx, data.toString());
        if (storageOrgUnit == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"GetInventoryOrgUnitFailed", (Context)ctx));
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        boolean isUserBizOrgRange = false;
        if (this.userBizOrgRangeMap.containsKey(userId + storageOrgUnit.getId().toString())) {
            isUserBizOrgRange = this.userBizOrgRangeMap.get(userId + storageOrgUnit.getId().toString());
        } else {
            isUserBizOrgRange = PerminsionUtil.isUserBizOrgRange((Context)ctx, (String)userId, (String)storageOrgUnit.getId().toString());
            this.userBizOrgRangeMap.put(userId + storageOrgUnit.getId().toString(), isUserBizOrgRange);
        }
        if (!isUserBizOrgRange) {
            throw new TaskExternalException(new MaterialBaseException(MaterialBaseException.OUT_BIZ_ORG, new Object[]{storageOrgUnit.getName()}).getMessage());
        }
        String CuId = storageOrgUnit.getCU().getId().toString();
        if (!this.PerminsionCheckedCuIds.contains(CuId)) {
            try {
                PerminsionUtil.checkCUPerminsion((Context)ctx, (String)CuId, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), (String)"bd_materialInv_import");
            }
            catch (EASBizException ee) {
                throw new TaskExternalException(ee.getMessage(), (Throwable)ee);
            }
            this.PerminsionCheckedCuIds.add(CuId);
        }
        MaterialInfo materialInfo = DataImportTools.getMaterialInfo((Context)ctx, (CtrlUnitInfo)storageOrgUnit.getCU(), (String)this.getDataString(hsData, "FNumber"));
        MaterialInventoryInfo info = new MaterialInventoryInfo();
        if (this.isSltImportUpdate()) {
            FilterInfo filter = new FilterInfo();
            DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"orgUnit.id", (Object)storageOrgUnit.getId().toString());
            DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"material.number", (Object)this.getDataString(hsData, "FNumber"));
            filter.setMaskString("#0 and #1");
            IMaterialInventory iProperty = MaterialInventoryFactory.getLocalInstance(ctx);
            MaterialInventoryCollection proCollection = iProperty.getMaterialInventoryCollection(DataImportTools.getViewInfo((FilterInfo)filter));
            if (proCollection != null && proCollection.size() > 0) {
                info.setId(proCollection.get(0).getId());
                info.setCU(proCollection.get(0).getCU());
            }
        }
        info.setMaterial(materialInfo);
        Object closeDateCalMode = hsData.get("FCloseDateCalMode");
        if ("0".equals(closeDateCalMode.toString()) || CloseDateCalculateModeEnum.DATEADDEXPDATE.toString().equals(closeDateCalMode.toString())) {
            info.setCloseDateCalMode(CloseDateCalculateModeEnum.DATEADDEXPDATE);
        } else if ("1".equals(closeDateCalMode.toString()) || CloseDateCalculateModeEnum.ADDEXPDATESUBONE.toString().equals(closeDateCalMode.toString())) {
            info.setCloseDateCalMode(CloseDateCalculateModeEnum.ADDEXPDATESUBONE);
        } else if ("2".equals(closeDateCalMode.toString()) || CloseDateCalculateModeEnum.ADDEXPDATELASTMON.toString().equals(closeDateCalMode.toString())) {
            info.setCloseDateCalMode(CloseDateCalculateModeEnum.ADDEXPDATELASTMON);
        }
        info.setOrgUnit(storageOrgUnit.castToFullOrgUnitInfo());
        info.setCU(storageOrgUnit.getCU());
        this.handleInfo(hsData, ctx, info, materialInfo.getId().toString());
        String isLotNumber = hsData.get("FIsLotNumber").toString();
        String isPeriodValid = hsData.get("FIsPeriodValid").toString();
        if (("Y".equals(isPeriodValid) || "true".equals(isPeriodValid)) && ("N".equals(isLotNumber) || "false".equals(isLotNumber))) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"IsPeriodValidCheck", (Context)ctx));
        }
        String createdate = hsData.get("FCreateTime").toString();
        if (createdate != null && createdate.length() > 0) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                Object createTime = df.parseObject(createdate);
                info.setCreateTime(new Timestamp(((Date)createTime).getTime()));
            }
            catch (ParseException df) {
                // empty catch block
            }
        }
        if (info.getCreateTime() == null) {
            Date date = new Date();
            info.setCreateTime(new Timestamp(date.getTime()));
        }
        if ((creatorNumber = hsData.get("FCreatorNumber").toString()) != null && creatorNumber.trim().length() > 0) {
            UserInfo userInfo;
            IUser iUser = UserFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)creatorNumber, CompareType.EQUALS));
            viewInfo.setFilter(filter);
            UserCollection collection = iUser.getUserCollection(viewInfo);
            if (collection != null && collection.size() > 0 && (userInfo = collection.get(0)) != null) {
                info.setCreator(userInfo);
            }
        }
        if (info.getCreator() == null) {
            UserInfo userinfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            info.setCreator(userinfo);
        }
        return info;
    }

    private StorageOrgUnitInfo getStorageOrgByNumber(Context ctx, String number) throws BOSException {
        if (number == null || "".equals(number)) {
            return null;
        }
        Object result = this.cacheStorageOrgUnit.get(number);
        if (result == null) {
            result = DataImportTools.getStorageOrgUnitInfoFromNumber((Context)ctx, (String)number);
            this.cacheStorageOrgUnit.put(number, result);
        }
        return (StorageOrgUnitInfo)result;
    }

    private OrgUnitInfo getOrgByNumber(Context ctx, String number) throws TaskExternalException {
        if (number == null || "".equals(number)) {
            return null;
        }
        Object result = this.cacheOrg.get(number);
        if (result == null) {
            result = DataImportTools.getOrgUnitInfo((Context)ctx, (String)number);
            this.cacheOrg.put(number, result);
        }
        return (OrgUnitInfo)result;
    }

    private PersonInfo getPersonByNumber(Context ctx, String number) throws TaskExternalException {
        if (number == null || "".equals(number)) {
            return null;
        }
        Object result = this.cachePerson.get(number);
        if (result == null) {
            result = DataImportTools.getPersonInfo((Context)ctx, (String)number);
            this.cachePerson.put(number, result);
        }
        return (PersonInfo)result;
    }

    private WarehouseInfo getWarehouseByNumber(Context ctx, String number, String storageOrgId) throws Exception {
        if (number == null || "".equals(number)) {
            return null;
        }
        if (storageOrgId == null || "".equals(storageOrgId)) {
            return null;
        }
        String key = storageOrgId + "&&" + number;
        Object result = this.cacheWarehouse.get(key);
        if (result == null) {
            result = this.getWarehouseInfo(ctx, number, storageOrgId);
            this.cacheWarehouse.put(key, result);
        }
        return (WarehouseInfo)result;
    }

    private WarehouseInfo getWarehouseInfo(Context ctx, String number, String storageOrgId) throws Exception {
        SQLUtil sb = new SQLUtil();
        sb.appendSql("select WAREHOUSE.FID warehouseID from T_DB_WAREHOUSE WAREHOUSE,T_DB_SOAccreditWH SOAccreditWH ");
        sb.appendSql(" where WAREHOUSE.FID = SOAccreditWH.FWarehouseID");
        sb.appendSql(" and WAREHOUSE.Fnumber = '").appendSql(number).appendSql("' ");
        sb.appendSql(" and SOAccreditWH.FStorageOrgID ='").appendSql(storageOrgId).appendSql("' ");
        ResultSet rs = sb.exeQuery(ctx);
        try {
            if (rs.next()) {
                WarehouseInfo warehouseInfo = new WarehouseInfo();
                BOSUuid id = BOSUuid.read((String)rs.getString("warehouseID"));
                warehouseInfo.setId(id);
                return warehouseInfo;
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        if (number != null && number.length() > 0) {
            throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"WarehouseNotExist", (Locale)ctx.getLocale()));
        }
        return null;
    }

    private void handleInfo(Hashtable hsData, Context ctx, MaterialInventoryInfo info, String materialID) throws Exception {
        info.setIsControl(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsControl"));
        info.setIsNegative(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsNegative"));
        info.setIsBatchNo(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsBatchNo"));
        info.setIsSequenceNo(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsSequenceNo"));
        info.setIsLotNumber(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsLotNumber"));
        info.setIsBarcode(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsBarcode"));
        info.setIsCheck(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsCheck"));
        BigDecimal qtySafety = this.getDataBigDecimal(hsData, "FQtySafety");
        BigDecimal qtyMin = this.getDataBigDecimal(hsData, "FQtyMin");
        BigDecimal qtyMax = this.getDataBigDecimal(hsData, "FQtyMax");
        BigDecimal zero = new BigDecimal("0.00");
        if (qtySafety != null && qtySafety.compareTo(zero) <= 0) {
            qtySafety = null;
        }
        if (qtyMax != null && qtyMax.compareTo(zero) <= 0) {
            qtyMax = null;
        }
        if (qtyMin != null && qtyMin.compareTo(zero) <= 0) {
            qtyMin = null;
        }
        if (qtySafety != null && qtyMax != null && qtySafety.compareTo(qtyMax) > 0) {
            throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"MaxInvQty_Less_SafeQty", (Locale)ctx.getLocale()));
        }
        if (qtyMin != null && qtyMin.compareTo(zero) > 0) {
            if (qtySafety != null && qtyMin.compareTo(qtySafety) > 0) {
                throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"SafeQty_Less_MinQty", (Locale)ctx.getLocale()));
            }
            if (qtyMax != null && qtyMin.compareTo(qtyMax) > 0) {
                throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"MaxQty_Less_MinQty", (Locale)ctx.getLocale()));
            }
        }
        PersonInfo invPlanner = null;
        if (hsData.get("FInvPlanner") != null) {
            invPlanner = this.getPersonByNumber(ctx, this.getDataString(hsData, "FInvPlanner"));
        }
        if ((qtySafety != null || qtyMax != null || qtyMin != null) && invPlanner == null) {
            throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"InvPlanner_Is_Null", (Locale)ctx.getLocale()));
        }
        info.setInvPlanner(invPlanner);
        info.setQtySafety(qtySafety);
        info.setQtyMin(qtyMin);
        info.setQtyMax(qtyMax);
        info.setDaysBottom(DataImportTools.getDataint((Hashtable)hsData, (String)"FDaysBottom"));
        info.setDaysTop(DataImportTools.getDataint((Hashtable)hsData, (String)"FDaysTop"));
        info.setDaysTurnover(DataImportTools.getDataint((Hashtable)hsData, (String)"FDaysTurnover"));
        info.setQtyMinPackage(this.getDataBigDecimal(hsData, "FQtyMinPackage"));
        info.setAbcType(DataImportTools.getABCEnum((String)this.getDataString(hsData, "FABCType"), (Context)ctx));
        info.setIsCompages(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsCompages"));
        info.setIssuePriorityMode(DataImportTools.getIssuePriorityEnum((String)this.getDataString(hsData, "FIssuePriorityMode"), (Context)ctx));
        info.setUnit(DataImportTools.getMultiMeasureUnitInfo((Context)ctx, (String)this.getDataString(hsData, "FUnitID"), (String)materialID));
        if (info.getUnit() == null) {
            throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"DataImport_MeasureUnit_Error", (Locale)ctx.getLocale()));
        }
        QualityOrgUnitInfo qualityOrg = null;
        OrgUnitInfo ou = this.getOrgByNumber(ctx, this.getDataString(hsData, "FqualityOrg"));
        if (ou != null) {
            if (!ou.isIsQualityOrgUnit()) {
                throw new TaskExternalException(this.getDataString(hsData, "FqualityOrg") + "," + ResourceBase.getString((String)"com.kingdee.eas.basedata.master.material.MATERIALAutoGenerateResource", (String)"4_DataImportMaterialInventory", (Locale)ctx.getLocale()));
            }
            qualityOrg = new QualityOrgUnitInfo();
            qualityOrg.setId(ou.getId());
        }
        info.setQualityOrg(qualityOrg);
        ou = this.getOrgByNumber(ctx, this.getDataString(hsData, "FFreezeOrgUnit"));
        if (ou != null) {
            info.setFreezeOrgUnit(ou.castToFullOrgUnitInfo());
        } else {
            info.setFreezeOrgUnit(null);
        }
        WarehouseInfo warehouseInfo = this.getWarehouseByNumber(ctx, this.getDataString(hsData, "FDefaultWarehouse"), info.getOrgUnit().getId().toString());
        info.setDefaultWarehouse(warehouseInfo);
        info.setDaysPlanTurnover(this.getDataBigDecimal(hsData, "FDaysPlanTurnover"));
        info.setStatus(DataImportTools.getStatusEnum((String)this.getDataString(hsData, "FStatus"), (Context)ctx));
        ou = this.getOrgByNumber(ctx, this.getDataString(hsData, "FFreezeOrgUnit"));
        if (ou != null) {
            info.setFreezeOrgUnit(ou.castToFullOrgUnitInfo());
        } else if (info.getStatus() == UsedStatusEnum.FREEZED) {
            info.setFreezeOrgUnit(ContextUtil.getCurrentOrgUnit((Context)ctx).castToFullOrgUnitInfo());
        } else {
            info.setFreezeOrgUnit(null);
        }
        info.setEffectedStatus(2);
        info.setIsPeriodValid(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsPeriodValid"));
        int temp = DataImportTools.getDataint((Hashtable)hsData, (String)"FPeriodValid");
        if (temp < 1) {
            temp = 0;
        }
        info.setPeriodValid(temp);
        info.setPeriodValidUnit(DataImportTools.getTimeUnitEnum((String)this.getDataString(hsData, "FPeriodValidUnit"), (Context)ctx, (String)"DataImport_TimeUnit_Error"));
        temp = DataImportTools.getDataint((Hashtable)hsData, (String)"FInWarehsAhead");
        if (temp < 1) {
            temp = 0;
        }
        info.setInWarehsAhead(temp);
        temp = DataImportTools.getDataint((Hashtable)hsData, (String)"FOutWarehsAhead");
        if (temp < 1) {
            temp = 0;
        }
        info.setOutWarehsAhead(temp);
        temp = DataImportTools.getDataint((Hashtable)hsData, (String)"FPrepWarnAhead");
        if (temp < 1) {
            temp = 0;
        }
        info.setPrepWarnAhead(temp);
        info.setAheadUnit(DataImportTools.getTimeUnitEnum((String)this.getDataString(hsData, "FAheadUnit"), (Context)ctx, (String)"DataImport_TimeUnit2_Error"));
        info.setCheapRate(this.getDataBigDecimal(hsData, "FCheapRate"));
        info.setPlanningMode(DataImportTools.getPlanModeEnum((String)this.getDataString(hsData, "FPlanningMode"), (Context)ctx));
        MaterialInfo materialInfo = info.getMaterial();
        BigDecimal toolRate = null;
        if (EquipmentPropertyEnum.TOOL.equals((Object)materialInfo.getEquipProperty()) && (toolRate = this.getDataBigDecimal(hsData, "FToolRate")) != null && (toolRate.compareTo(zero) < 0 || toolRate.compareTo(new BigDecimal("1000000000000")) >= 0)) {
            toolRate = null;
        }
        info.setToolRate(toolRate);
        BigDecimal rebookQty = null;
        if (info.getPlanningMode().equals((Object)PlanningModeEnum.REBOOKPOINT)) {
            if (this.iMultiMeasureUnit == null) {
                try {
                    this.iMultiMeasureUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
                }
                catch (BOSException e) {
                    throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"UnitCalculateError", (Locale)ctx.getLocale()));
                }
            }
            MultiMeasureUnitInfo multUnit = null;
            try {
                multUnit = this.iMultiMeasureUnit.getMultiUnit(info.getMaterial().getId().toString(), info.getUnit().getId().toString());
            }
            catch (EASBizException e) {
                throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"UnitCalculateError", (Locale)ctx.getLocale()));
            }
            catch (BOSException e) {
                throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"UnitCalculateError", (Locale)ctx.getLocale()));
            }
            if (multUnit == null) {
                throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"UnitCalculateError", (Locale)ctx.getLocale()));
            }
            int qtyPrecision = multUnit.getQtyPrecision();
            temp = DataImportTools.getDataint((Hashtable)hsData, (String)"FPurchasingAheadDate");
            if (temp < 1) {
                temp = 0;
            }
            info.setPurchasingAheadDate(temp);
            info.setBatchPolicy(DataImportTools.getBatchPolicyEnum((String)this.getDataString(hsData, "FBatchPolicy"), (Context)ctx));
            if (info.getQtySafety() == null) {
                throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"WarnSafeQtyCheckWhenRebook", (Locale)ctx.getLocale()));
            }
            if (this.getDataBigDecimal(hsData, "FConsumeSpeed") == null) {
                throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"WarnConsumeSpCheck", (Locale)ctx.getLocale()));
            }
            info.setConsumeSpeed(this.getDataBigDecimal(hsData, "FConsumeSpeed").setScale(qtyPrecision, 4));
            if (info.getBatchPolicy() == null) {
                throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"WarnBatchPolicyCheck", (Locale)ctx.getLocale()));
            }
            if (info.getBatchPolicy().equals((Object)BatchPolicyEnum.FIXATIONBATCH)) {
                if (this.getDataBigDecimal(hsData, "FFixationBatchQty") == null) {
                    throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"WarnFixBatchCheck", (Locale)ctx.getLocale()));
                }
                info.setFixationBatchQty(this.getDataBigDecimal(hsData, "FFixationBatchQty").setScale(qtyPrecision, 4));
            }
            rebookQty = info.getConsumeSpeed().multiply(new BigDecimal(info.getPurchasingAheadDate())).add(info.getQtySafety());
            info.setReBookQty(rebookQty);
        } else {
            info.setReBookQty(zero);
            info.setConsumeSpeed(zero);
            info.setPurchasingAheadDate(0);
            info.setFixationBatchQty(zero);
            info.setBatchPolicy(BatchPolicyEnum.FIXATIONBATCH);
        }
        info.setIsReservation(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsReservation"));
        info.setReservationDate(DataImportTools.getDataint((Hashtable)hsData, (String)"FReservationDate"));
    }

    private String getDataString(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataString((Hashtable)hsData, (String)fieldName);
    }

    private BigDecimal getDataBigDecimal(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)fieldName);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FMaterialName", rs.getString("name"));
            this.putTable(result, "FOrgUnit", rs.getString("orgUnit.number"));
            this.putTable(result, "FIsControl", DataImportTools.boolToString((boolean)rs.getBoolean("Inventory.isControl")));
            this.putTable(result, "FQtySafety", rs.getString("Inventory.qtySafety"));
            this.putTable(result, "FQtyMin", rs.getString("Inventory.qtyMin"));
            this.putTable(result, "FQtyMax", rs.getString("Inventory.qtyMax"));
            this.putTable(result, "FDaysBottom", rs.getString("Inventory.daysBottom"));
            this.putTable(result, "FDaysTop", rs.getString("Inventory.daysTop"));
            this.putTable(result, "FDaysTurnover", rs.getString("Inventory.daysTurnover"));
            this.putTable(result, "FIsNegative", DataImportTools.boolToString((boolean)rs.getBoolean("Inventory.isNegative")));
            this.putTable(result, "FIsBatchNo", DataImportTools.boolToString((boolean)rs.getBoolean("Inventory.isBatchNo")));
            this.putTable(result, "FIsSequenceNo", DataImportTools.boolToString((boolean)rs.getBoolean("Inventory.isSequenceNo")));
            this.putTable(result, "FIsLotNumber", DataImportTools.boolToString((boolean)rs.getBoolean("Inventory.isLotNumber")));
            this.putTable(result, "FIsBarcode", DataImportTools.boolToString((boolean)rs.getBoolean("Inventory.isBarcode")));
            this.putTable(result, "FQtyMinPackage", rs.getString("Inventory.qtyMinPackage"));
            ABCEnum abcEnum = ABCEnum.getEnum((int)rs.getInt("Inventory.abcType"));
            this.putTable(result, "FABCType", abcEnum == null ? "" : abcEnum.getAlias(ctx.getLocale()));
            this.putTable(result, "FIsCompages", DataImportTools.boolToString((boolean)rs.getBoolean("Inventory.isCompages")));
            IssuePriorityEnum issuePriorityEnum = IssuePriorityEnum.getEnum((int)rs.getInt("Inventory.issuePriorityMode"));
            this.putTable(result, "FIssuePriorityMode", issuePriorityEnum == null ? "" : issuePriorityEnum.getAlias(ctx.getLocale()));
            this.putTable(result, "FUnitID", rs.getString("invUnit.number"));
            this.putTable(result, "FIsPeriodValid", DataImportTools.boolToString((boolean)rs.getBoolean("Inventory.isPeriodValid")));
            this.putTable(result, "FPeriodValid", rs.getString("Inventory.periodValid"));
            TimeUnitEnum timeUnitEnum = TimeUnitEnum.getEnum((int)rs.getInt("Inventory.periodValidUnit"));
            this.putTable(result, "FPeriodValidUnit", timeUnitEnum == null ? "" : timeUnitEnum.getAlias(ctx.getLocale()));
            this.putTable(result, "FInWarehsAhead", rs.getString("Inventory.inWarehsAhead"));
            this.putTable(result, "FOutWarehsAhead", rs.getString("Inventory.outWarehsAhead"));
            this.putTable(result, "FPrepWarnAhead", rs.getString("Inventory.prepWarnAhead"));
            TimeUnitEnum aheadUnitTimeEnum = TimeUnitEnum.getEnum((int)rs.getInt("Inventory.aheadUnit"));
            this.putTable(result, "FAheadUnit", aheadUnitTimeEnum == null ? "" : aheadUnitTimeEnum.getAlias(ctx.getLocale()));
            this.putTable(result, "FInvPlanner", rs.getString("invPlanner.number"));
            this.putTable(result, "FIsCheck", rs.getString("Inventory.isCheck"));
            this.putTable(result, "FqualityOrg", rs.getString("qualityOrg.number"));
            this.putTable(result, "FCheapRate", rs.getString("Inventory.cheapRate"));
            this.putTable(result, "FCloseDateCalMode", CloseDateCalculateModeEnum.getEnum(rs.getInt("Inventory.closeDateCalMode")).getAlias(ctx.getLocale()));
            this.putTable(result, "FFreezeOrgUnit", rs.getString("freezeOrgUnit.number"));
            UsedStatusEnum usedStatusEnum = UsedStatusEnum.getEnum((int)rs.getInt("Inventory.status"));
            this.putTable(result, "FStatus", usedStatusEnum == null ? "" : usedStatusEnum.getAlias(ctx.getLocale()));
            PlanningModeEnum planningModeEnum = PlanningModeEnum.getEnum((int)rs.getInt("Inventory.planningMode"));
            this.putTable(result, "FPlanningMode", planningModeEnum == null ? "" : planningModeEnum.getAlias(ctx.getLocale()));
            this.putTable(result, "FReBookQty", rs.getBigDecimal("Inventory.reBookQty"));
            this.putTable(result, "FConsumeSpeed", rs.getBigDecimal("Inventory.consumeSpeed"));
            this.putTable(result, "FPurchasingAheadDate", rs.getString("Inventory.purchasingAheadDate"));
            int batchPolicy = rs.getInt("Inventory.batchPolicy");
            if (batchPolicy == 0) {
                this.putTable(result, "FBatchPolicy", BatchPolicyEnum.getEnum((int)1).getAlias(ctx.getLocale()));
            } else {
                this.putTable(result, "FBatchPolicy", BatchPolicyEnum.getEnum((int)batchPolicy).getAlias(ctx.getLocale()));
            }
            this.putTable(result, "FFixationBatchQty", rs.getBigDecimal("Inventory.fixationBatchQty"));
            this.putTable(result, "FDefaultWarehouse", rs.getString("defaultWarehouse.number"));
            this.putTable(result, "FDaysPlanTurnover", rs.getBigDecimal("Inventory.daysPlanTurnover"));
            this.putTable(result, "FToolRate", rs.getBigDecimal("Inventory.toolRate"));
            this.putTable(result, "FIsReservation", DataImportTools.boolToString((boolean)rs.getBoolean("Inventory.isReservation")));
            this.putTable(result, "FReservationDate", rs.getString("Inventory.reservationDate"));
            this.putTable(result, "FCreateTime", rs.getString("Inventory.createTime"));
            this.putTable(result, "FCreatorNumber", rs.getString("createUser.number"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        ObjectUuidPK pk = null;
        try {
            IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
            pk = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
            filterInfo = iMaterial.getDatabaseDFilter((IObjectPK)pk, "id", "adminCU.id");
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.material.app.DataImpExpInvQuery";
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }
}

