/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.app.AbstractMaterialBatchUpdateStrategy;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class MaterialInventoryBatchUpdateStrategy
extends AbstractMaterialBatchUpdateStrategy {
    protected void validate(Context ctx, Object[] pks, Map params) throws BOSException, EASBizException {
        int i;
        String unitId = this.getUnitId(params);
        if (StringUtils.isEmpty((String)unitId)) {
            throw new MaterialBaseException(MaterialBaseException.ORG_NOTNULL_INV);
        }
        if (this.properties == null || this.properties.length == 0 || pks.length == 0) {
            return;
        }
        HashSet<String> pkset = new HashSet<String>(0);
        for (int j = 0; j < pks.length; ++j) {
            String pk = (String)pks[j];
            pkset.add(pk.trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", pkset, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)unitId, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        view.setFilter(filter);
        view.getSelector().add("*");
        view.getSelector().add(new SelectorItemInfo("material.number"));
        view.getSelector().add(new SelectorItemInfo("material.name"));
        IMaterialInventory ie = MaterialInventoryFactory.getLocalInstance(ctx);
        MaterialInventoryCollection ls = ie.getMaterialInventoryCollection(view);
        ArrayList<String> materialCom = new ArrayList<String>();
        for (i = 0; i < ls.size(); ++i) {
            materialCom.add(ls.get(i).getMaterial().getId().toString());
        }
        this._checkHasSubInfo(ctx, materialCom, pks, MaterialBaseException.MATERIAL_NO_SUCH_INVINFO);
        if (ls != null && ls.size() != 0) {
            for (i = 0; i < ls.size(); ++i) {
                MaterialInventoryInfo info = ls.get(i);
                this.setInfoNewValue((CoreBaseInfo)info, this.values, this.properties, params);
                try {
                    ie.updateCheck((IObjectPK)new ObjectStringPK(info.getId().toString()), info);
                    this.uptIdList.add(info.getId().toString());
                    continue;
                }
                catch (Exception ex) {
                    MaterialBaseException mex = new MaterialBaseException(MaterialBaseException.MATERIAL_BATCH_FAILD, (Object[])new String[]{info.getMaterial().getNumber()});
                    this.log.addException(mex.getMessage(), (Throwable)ex);
                }
            }
        }
        ls = null;
    }

    protected void executeUpdate(Context ctx) throws BOSException {
        super.executeUpdate(ctx);
        if (this.uptIdList == null || this.uptIdList.size() == 0) {
            return;
        }
        if (this.values == null || !(this.values instanceof Map)) {
            return;
        }
        if (this.entity == null) {
            return;
        }
        Map map = (Map)this.values;
        ArrayList ls = new ArrayList();
        int size = this.uptIdList.size();
        String[] keys = new String[]{"isLotNumber", "isPeriodValid"};
        StringBuffer sql = new StringBuffer();
        if (map.containsKey(keys[0]) && "0".equals((String)map.get(keys[0]))) {
            sql.append("update T_BD_MaterialInventory set FIsPeriodValid = 0 ");
        } else if (map.containsKey(keys[1]) && "1".equals((String)map.get(keys[1]))) {
            sql.append("update T_BD_MaterialInventory set FIsLotNumber = 1 ");
        }
        if (sql.length() > 0) {
            sql.append("where fid in ");
            sql.append("(");
            for (int i = 0; i < size; ++i) {
                sql.append("?,");
                ls.add(this.uptIdList.get(i));
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(")");
            super.execute(ctx, sql.toString(), ls.toArray());
        }
    }
}

