/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.BatchPolicyEnum;
import com.kingdee.eas.basedata.master.material.EquipmentPropertyEnum;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.IMaterialPropertyBase;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPropertyBaseCollection;
import com.kingdee.eas.basedata.master.material.MaterialPropertyBaseInfo;
import com.kingdee.eas.basedata.master.material.MaterialUtil;
import com.kingdee.eas.basedata.master.material.PlanningModeEnum;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.AbstractMaterialInventoryControllerBean;
import com.kingdee.eas.basedata.master.material.app.MaterialControllerBean;
import com.kingdee.eas.basedata.master.material.app.MaterialSrvUtils;
import com.kingdee.eas.basedata.master.material.app.builder.CheckNegativeInventoryBuilder;
import com.kingdee.eas.basedata.master.material.util.MaterialUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.ILocationListFacade;
import com.kingdee.eas.basedata.scm.im.inv.LocationListFacadeFactory;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.DynamicBusinessProcessHelper;
import com.kingdee.eas.dynbusiness.app.IBusinessProcessorBuilder;
import com.kingdee.eas.dynbusiness.app.processor.BillsExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityInfo;
import com.kingdee.eas.scm.im.inv.IDateOfMinDurability;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.IntEnum;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class MaterialInventoryControllerBean
extends AbstractMaterialInventoryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.material.app.MaterialInventoryControllerBean");
    private static final int HALF_UP = 4;

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkOrgDup(ctx, model);
        MaterialInventoryInfo info = (MaterialInventoryInfo)model;
        if (info.getOrgUnit().getCU() != null) {
            info.setCU(info.getOrgUnit().getCU());
        }
        this.commonCheck(info);
        info.put("MaterialNumber", MaterialSrvUtils.getMaterialLogInfo((Context)ctx, (String)info.getMaterial().getId().toString()));
        IObjectPK pk = super._addnew(ctx, model);
        this.updatePlanInfo(ctx, info);
        this.updatePlanInfo2(ctx, info);
        if (info.getStatus() == UsedStatusEnum.APPROVED) {
            IMaterial ima = MaterialFactory.getLocalInstance((Context)ctx);
            MaterialInfo mainfo = ima.getMaterialInfo((IObjectPK)new ObjectUuidPK(info.getMaterial().getId()));
            ILocationListFacade iLocationListFacade = LocationListFacadeFactory.getLocalInstance((Context)ctx);
            StorageOrgUnitInfo sInfo = new StorageOrgUnitInfo();
            sInfo.setId(info.getOrgUnit().getId());
            iLocationListFacade.addMaterialStorageAssign(mainfo, sInfo, info.getDefaultWarehouse());
        }
        return pk;
    }

    private void commonCheck(MaterialInventoryInfo info) throws EASBizException, BOSException {
        info.verify();
    }

    private void _checkOrgDup(Context ctx, IObjectValue model) throws MaterialBaseException, EASBizException, BOSException {
        MaterialPropertyBaseInfo info = (MaterialPropertyBaseInfo)model;
        String orgID = info.getOrgUnit().getId().toString();
        String materialID = info.getMaterial().getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID, CompareType.EQUALS));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.setMaskString("#0 and #1");
        }
        if (this.exists(ctx, filter)) {
            throw new MaterialBaseException(MaterialBaseException.EXIST_INVINFO);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        MaterialInventoryInfo oldInfo = this.getMaterialInventoryInfo(ctx, pk);
        MaterialInventoryInfo info = (MaterialInventoryInfo)model;
        if (info.getOrgUnit() != null && info.getOrgUnit().getCU() != null) {
            info.setCU(info.getOrgUnit().getCU());
        }
        boolean isToolMaterial = this.isToolMaterial(ctx, info);
        try {
            this.checkCanUpdate(ctx, oldInfo, info, isToolMaterial);
        }
        catch (EASBizException e) {
            this.writeLog(ctx, info, pk, false);
            throw e;
        }
        super._update(ctx, pk, (IObjectValue)info);
        this.updatePlanInfo(ctx, info);
        this.updatePlanInfo2(ctx, info);
        if (oldInfo.isIsPeriodValid() != info.isIsPeriodValid()) {
            this.updateDateOfMinDurability(ctx, info);
        }
        if (info.getStatus() == UsedStatusEnum.APPROVED) {
            IMaterial ima = MaterialFactory.getLocalInstance((Context)ctx);
            MaterialInfo mainfo = ima.getMaterialInfo((IObjectPK)new ObjectUuidPK(info.getMaterial().getId()));
            ILocationListFacade iLocationListFacade = LocationListFacadeFactory.getLocalInstance((Context)ctx);
            StorageOrgUnitInfo sInfo = new StorageOrgUnitInfo();
            sInfo.setId(info.getOrgUnit().getId());
            iLocationListFacade.addMaterialStorageAssign(mainfo, sInfo, info.getDefaultWarehouse());
        }
        this.writeLog(ctx, info, pk, true);
    }

    protected void updateDateOfMinDurability(Context ctx, MaterialInventoryInfo info) throws BOSException, EASBizException {
        DateOfMinDurabilityInfo dateOfMinDurabilityInfo = null;
        String materialID = info.getMaterial().getId().toString();
        String fullOrgUnitID = info.getOrgUnit().getId().toString();
        StringBuffer selectsql = new StringBuffer();
        IDateOfMinDurability iDateOfMinDurability = DateOfMinDurabilityFactory.getLocalInstance((Context)ctx);
        BOSUuid fid = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)fullOrgUnitID, CompareType.EQUALS));
        view.setSelector(sic);
        view.setFilter(filterInfo);
        CoreBaseCollection collection = DateOfMinDurabilityFactory.getLocalInstance((Context)ctx).getCollection(view);
        for (int i = 0; i < collection.size(); ++i) {
            dateOfMinDurabilityInfo = (DateOfMinDurabilityInfo)collection.get(i);
            fid = dateOfMinDurabilityInfo.getId();
            iDateOfMinDurability.delete((IObjectPK)new ObjectUuidPK(fid));
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MaterialInventoryInfo info = this.getMaterialInventoryInfo(ctx, pk);
        if (info.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_APPROVED);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        this.checkHasReference(ctx, pk);
        super._delete(ctx, pk);
    }

    private void checkHasReference(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        BizCheckResult rs = BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        if (rs.isFound()) {
            if (rs.getException() != null) {
                throw rs.getException();
            }
            if (rs.getDetailMap() != null) {
                throw new MaterialBaseException(MaterialBaseException.REF_NOT_DELETE_INV);
            }
        }
    }

    private boolean isToolMaterial(Context ctx, MaterialInventoryInfo materialInventoryInfo) throws BOSException, EASBizException {
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK materialPK = new ObjectUuidPK(materialInventoryInfo.getMaterial().getId());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("equipProperty");
        MaterialInfo materialInfo = iMaterial.getMaterialInfo((IObjectPK)materialPK, selector);
        EquipmentPropertyEnum equipmentPropertyEnum = materialInfo.getEquipProperty();
        return EquipmentPropertyEnum.TOOL.equals((Object)equipmentPropertyEnum);
    }

    private void checkCanUpdate(Context ctx, MaterialInventoryInfo oldVO, MaterialInventoryInfo updateVO, boolean isToolMaterial) throws EASBizException, BOSException {
        BigDecimal toolRateBigDecimal = updateVO.getToolRate();
        if (toolRateBigDecimal != null) {
            if (new BigDecimal("0").compareTo(toolRateBigDecimal) > 0) {
                throw new MaterialBaseException(MaterialBaseException.INVTOOLRATEINVALID);
            }
            if (isToolMaterial && new BigDecimal("1000000000000.00000000").compareTo(toolRateBigDecimal) <= 0) {
                throw new MaterialBaseException(MaterialBaseException.INVTOOLRATEINVALID);
            }
            if (!isToolMaterial && new BigDecimal("0").compareTo(toolRateBigDecimal) < 0) {
                throw new MaterialBaseException(MaterialBaseException.TOOLRATENOTMATCHEQUIPMENTPROPERTY);
            }
        }
        this.checkCloseDate(ctx, oldVO, updateVO);
        this.checkReservation(ctx, oldVO, updateVO);
        this.checkCanUpdate(ctx, oldVO, updateVO);
    }

    private void checkCloseDate(Context ctx, MaterialInventoryInfo oldVO, MaterialInventoryInfo updateVO) throws EASBizException, BOSException {
        if (oldVO.getReservationDate() != updateVO.getReservationDate() && !oldVO.isIsReservation()) {
            throw new MaterialBaseException(MaterialBaseException.NOT_RESERVATION);
        }
    }

    private void checkReservation(Context ctx, MaterialInventoryInfo oldVO, MaterialInventoryInfo updateVO) throws EASBizException, BOSException {
        if (oldVO.getCloseDateCalMode().getValue() != updateVO.getCloseDateCalMode().getValue() && !oldVO.isIsPeriodValid()) {
            throw new MaterialBaseException(MaterialBaseException.NOT_PERIODVAILD);
        }
    }

    private void checkCanUpdate(Context ctx, MaterialInventoryInfo oldVO, MaterialInventoryInfo updateVO) throws EASBizException, BOSException {
        CheckNegativeInventoryBuilder builder;
        BillsExecuteContext executeContext;
        BatchActionResults results;
        boolean newIsNeg;
        boolean oldIsNeg;
        BizCheckResult rs = null;
        updateVO.verify();
        if (updateVO.isIsSequenceNo()) {
            String checkSql = "select 1 from t_bd_material where fid='" + updateVO.getMaterial().getId().toString() + "' and FSeqUnitID is null";
            Connection cn = this.getConnection(ctx);
            Statement stmt = null;
            try {
                stmt = cn.createStatement();
                ResultSet r = stmt.executeQuery(checkSql);
                if (r.next()) {
                    throw new MaterialBaseException(MaterialBaseException.SEQ_INVALID);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Statement)stmt);
                SQLUtils.cleanup((Connection)cn);
            }
        }
        if ((oldIsNeg = oldVO.isIsNegative()) && !(newIsNeg = updateVO.isIsNegative()) && (results = DynamicBusinessProcessHelper.batchExecute((ExecuteContext)(executeContext = new BillsExecuteContext(ctx, this.getBOSType(), BatchActionEnum.SAVE, null, new Object[]{updateVO})), (IBusinessProcessorBuilder)(builder = new CheckNegativeInventoryBuilder((ExecuteContext)executeContext)))).hasException((EASBizException)new MaterialBaseException(MaterialBaseException.REF_NOT_UPDATE_NEGATIVE))) {
            throw new MaterialBaseException(MaterialBaseException.REF_NOT_UPDATE_NEGATIVE);
        }
        if (!(oldVO.isIsBatchNo() == updateVO.isIsBatchNo() && oldVO.isIsLotNumber() == updateVO.isIsLotNumber() && oldVO.isIsPeriodValid() == updateVO.isIsPeriodValid() || !(rs = BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)updateVO.getId())).isFound() && this.isMaterialInventoryZeroInStorage(ctx, updateVO))) {
            if (rs.getException() != null) {
                throw rs.getException();
            }
            if (rs.getDetailMap() != null) {
                throw new MaterialBaseException(MaterialBaseException.REF_NOT_UPDATE_INV);
            }
        }
    }

    private void checkCanUpdateIsLotNumber(Context ctx, MaterialInventoryInfo updateVO) {
    }

    private boolean isMaterialInventoryZeroInStorage(Context ctx, MaterialInventoryInfo materialInventory) throws EASBizException, BOSException {
        if (materialInventory != null && materialInventory.getMaterial() != null && materialInventory.getMaterial().getId() != null && materialInventory.getOrgUnit() != null && materialInventory.getOrgUnit().getId() != null) {
            String materialID = materialInventory.getMaterial().getId().toString();
            String orgUnitID = materialInventory.getOrgUnit().getId().toString();
            return MaterialInventoryControllerBean.hasInventoryQty(ctx, materialID, orgUnitID);
        }
        return false;
    }

    public static boolean hasInventoryQty(Context ctx, String materialID, String orgUnitID) throws BOSException {
        boolean bl;
        ResultSet rs;
        Statement stmt;
        Connection conn;
        block6: {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append(" select fid from T_IM_Inventory where ( FCurStoreQty <> 0 or FBaseQty <> 0 ) ");
            sqlBuffer.append(" and FMaterialID = '" + materialID + "'");
            if (orgUnitID != null) {
                sqlBuffer.append(" and FStorageOrgUnitID = '" + orgUnitID + "'");
            }
            conn = null;
            stmt = null;
            rs = null;
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sqlBuffer.toString());
            if (!rs.next()) break block6;
            boolean bl2 = false;
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return bl2;
        }
        try {
            bl = true;
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return bl;
    }

    public static List getInventoryQtyOrgs(Context ctx, String materialID) throws BOSException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" select distinct  unit.fname_l2  fname from T_IM_Inventory inv ,t_org_baseunit unit ");
        sqlBuffer.append(" where inv.FStorageOrgUnitID= unit.fid and  ( inv.FCurStoreQty <> 0 or inv.FBaseQty <> 0 )");
        sqlBuffer.append(" and inv.FMaterialID = '" + materialID + "'");
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sqlBuffer.toString());
            while (rs.next()) {
                list.add(rs.getString("fname"));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return list;
    }

    @Override
    protected MaterialInventoryInfo _first(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected MaterialInventoryInfo _previous(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected MaterialInventoryInfo _next(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected MaterialInventoryInfo _last(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    protected void _freeze(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialInventory iproperty = MaterialInventoryFactory.getLocalInstance(ctx);
        MaterialInventoryInfo info = iproperty.getMaterialInventoryInfo(pk);
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU((Context)ctx, (String)info.getCU().getId().toString());
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTAPPROVE);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        info.setStatus(UsedStatusEnum.FREEZED);
        info.setFreezeOrgUnit(ContextUtil.getCurrentOrgUnit((Context)ctx).castToFullOrgUnitInfo());
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _unFreeze(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialInventory iproperty = MaterialInventoryFactory.getLocalInstance(ctx);
        MaterialInventoryInfo info = iproperty.getMaterialInventoryInfo(pk);
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU((Context)ctx, (String)info.getCU().getId().toString());
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTAPPROVE);
        }
        if (info.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTFREEZED);
        }
        info.setStatus(UsedStatusEnum.APPROVED);
        info.setFreezeOrgUnit(null);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _approve(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MaterialInventoryInfo info = this.getMaterialInventoryInfo(ctx, pk);
        this._approve(ctx, info);
    }

    protected void _approve(Context ctx, MaterialPropertyBaseInfo info) throws BOSException, EASBizException {
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU((Context)ctx, (String)info.getCU().getId().toString());
        IMaterial ima = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialInfo mainfo = ima.getMaterialInfo((IObjectPK)new ObjectUuidPK(info.getMaterial().getId()));
        if (mainfo.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTAPPROVE);
        }
        if (mainfo.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.BASEINFO_FREEZED);
        }
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_APPROVED);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        MaterialUtil.checkMeasureUnit((MaterialInfo)mainfo, (MeasureUnitInfo)((MaterialInventoryInfo)info).getUnit(), MaterialBaseException.class, (NumericExceptionSubItem)MaterialBaseException.UNIT_PRECISION_ERROR4, (Context)ctx);
        StringBuffer updatesql = new StringBuffer();
        Connection conn = null;
        Statement statement = null;
        try {
            conn = super.getConnection(ctx);
            statement = conn.createStatement();
            updatesql.append(" update T_BD_MaterialInventory set FStatus = ").append(String.valueOf(1)).append("  where fid = '").append(info.getId().toString()).append("'");
            statement.execute(updatesql.toString());
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + updatesql.toString(), (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)conn);
        ILocationListFacade iLocationListFacade = LocationListFacadeFactory.getLocalInstance((Context)ctx);
        StorageOrgUnitInfo sInfo = new StorageOrgUnitInfo();
        sInfo.setId(info.getOrgUnit().getId());
        iLocationListFacade.addMaterialStorageAssign(mainfo, sInfo, ((MaterialInventoryInfo)info).getDefaultWarehouse());
    }

    protected void _unApprove(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialInventory iproperty = MaterialInventoryFactory.getLocalInstance(ctx);
        MaterialInventoryInfo info = iproperty.getMaterialInventoryInfo(pk);
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU((Context)ctx, (String)info.getCU().getId().toString());
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTAPPROVE);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        info.setStatus(UsedStatusEnum.UNAPPROVE);
        super._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _updateCheck(Context ctx, IObjectPK pk, MaterialInventoryInfo newInfo) throws BOSException, EASBizException {
        String name = "";
        name = newInfo.getMaterial().getName(ctx.getLocale());
        if (newInfo.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.APPROVE_INVALID, new Object[]{name});
        }
        if (newInfo.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.FREEZED_INVALID, new Object[]{name});
        }
        boolean isToolMaterial = this.isToolMaterial(ctx, newInfo);
        if (!isToolMaterial && newInfo.getToolRate() != null && new BigDecimal("0").compareTo(newInfo.getToolRate()) != 0) {
            throw new MaterialBaseException(MaterialBaseException.TOOLRATENOTMATCHEQUIPMENTPROPERTY);
        }
        MaterialInventoryInfo oldInfo = this.getMaterialInventoryInfo(ctx, pk);
        this.checkCanUpdate(ctx, oldInfo, newInfo, isToolMaterial);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MaterialInventoryInfo info = this.getMaterialInventoryInfo(ctx, pk, this.getSelectors());
        MaterialInfo matInfo = (MaterialInfo)info.get("material");
        if (matInfo != null) {
            return matInfo.getNumber() + "  " + matInfo.getName(ctx.getLocale());
        }
        return pk.toString();
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        return sic;
    }

    protected void updatePlanInfo(Context ctx, MaterialInventoryInfo info) throws BOSException, EASBizException {
        if (info == null || info.getPlanningMode() != PlanningModeEnum.REBOOKPOINT) {
            return;
        }
        SQLUtil sb = new SQLUtil();
        sb.appendSql(" update T_BD_MATERIALPLAN ");
        sb.appendSql(" set FPlanningMode = ").appendSql(this.intEnumToString((IntEnum)info.getPlanningMode()));
        sb.appendSql("    ,FManufactureStrategyID = '' ");
        sb.appendSql("    ,FBatchPolicy = ").appendSql(this.intEnumToString((IntEnum)info.getBatchPolicy()));
        if (info.getBatchPolicy() == BatchPolicyEnum.FIXATIONBATCH) {
            sb.appendSql("    ,FFixationBatchQty= ").appendSql(this.BigDecimalToString(info.getFixationBatchQty()));
        } else {
            sb.appendSql("    ,FFixationBatchQty = 0 ");
        }
        sb.appendSql("    ,FReBookQty= ").appendSql(this.BigDecimalToString(info.getReBookQty()));
        sb.appendSql("    ,FConsumeSpeed= ").appendSql(this.BigDecimalToString(info.getConsumeSpeed()));
        sb.appendSql("    ,FProduceLeadTime= ").appendSql(String.valueOf(info.getPurchasingAheadDate()));
        sb.appendSql(" where FMaterialID='").appendSql(info.getMaterial().getId().toString()).appendSql("'");
        sb.appendSql("  and  FOrgUnit='").appendSql(info.getOrgUnit().getId().toString()).appendSql("'");
        sb.execute(ctx);
    }

    protected void updatePlanInfo2(Context ctx, MaterialInventoryInfo info) throws BOSException, EASBizException {
        if (info == null || info.getOrgUnit() == null) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)info.getMaterial().getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)info.getOrgUnit().getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection selectors = viewInfo.getSelector();
        selectors.add(new SelectorItemInfo("*"));
        selectors.add(new SelectorItemInfo("manufactureStrategy.number"));
        IMaterialPropertyBase iMaterialPropertyBase = (IMaterialPropertyBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)"C463FD06"));
        MaterialPropertyBaseCollection collection = iMaterialPropertyBase.getMaterialPropertyBaseCollection(viewInfo);
        if (collection.get(0) == null) {
            return;
        }
        MaterialPropertyBaseInfo planInfo = collection.get(0);
        SQLUtil sb = new SQLUtil();
        sb.appendSql(" update T_BD_MATERIALINVENTORY ");
        if (planInfo.get("manufactureStrategy") == null || ((ManufactureStrategyInfo)planInfo.get("manufactureStrategy")).getNumber() == null) {
            sb.appendSql(" set FisTrackingNumber = 0 ,FisProjectNumber = 0 ");
        } else {
            String mfs = ((ManufactureStrategyInfo)planInfo.get("manufactureStrategy")).getNumber();
            IsolatedRuleEnum ir = IsolatedRuleEnum.getEnum((String)planInfo.getString("isolatedRule"));
            if (mfs.equals("MTO20") || mfs.equals("ATO20")) {
                sb.appendSql(" set FisTrackingNumber = 1 ,FisProjectNumber = 0");
            } else if (mfs.equals("ETO20") && ir.equals((Object)IsolatedRuleEnum.ITEM)) {
                sb.appendSql(" set FisTrackingNumber = 0,FisProjectNumber = 1 ");
            } else if (mfs.equals("ETO20") && ir.equals((Object)IsolatedRuleEnum.ITEM_TRACKNO)) {
                sb.appendSql(" set FisTrackingNumber = 1,FisProjectNumber = 1 ");
            } else {
                sb.appendSql(" set FisTrackingNumber = 0 ,FisProjectNumber = 0 ");
            }
        }
        if (sb.getSql().equalsIgnoreCase(" update T_BD_MATERIALINVENTORY ")) {
            return;
        }
        FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)planInfo.get("orgUnit");
        MaterialInfo materialInfo = (MaterialInfo)planInfo.get("material");
        sb.appendSql(" where T_BD_MATERIALINVENTORY.FOrgUnit = '").appendSql(orgUnitInfo.getId().toString()).appendSql("'");
        sb.appendSql(" and T_BD_MATERIALINVENTORY.FMaterialID='").appendSql(materialInfo.getId().toString()).appendSql("'");
        sb.execute(ctx);
    }

    private String intEnumToString(IntEnum intEnum) {
        if (intEnum == null) {
            return "0";
        }
        return String.valueOf(intEnum.getValue());
    }

    private String BigDecimalToString(BigDecimal value) {
        if (value == null) {
            return "0";
        }
        if (value.compareTo(new BigDecimal(0)) == 0) {
            return "0";
        }
        return String.valueOf(value);
    }

    @Override
    protected List _getMaterialsExistInvInfo(Context ctx, String[] materialIDs, String inventoryID) throws BOSException {
        StringBuffer sqlStringBuffer = new StringBuffer();
        int size = materialIDs.length;
        if (size < 1) {
            return null;
        }
        HashSet<String> materialIdSet = new HashSet<String>();
        for (int i = 0; i < materialIDs.length; ++i) {
            materialIdSet.add(materialIDs[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)inventoryID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material.id", materialIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        IMaterialInventory iMaterialInventory = MaterialInventoryFactory.getLocalInstance(ctx);
        MaterialInventoryCollection collection = iMaterialInventory.getMaterialInventoryCollection(view);
        ArrayList<String> arrayList = new ArrayList<String>();
        int collectionSize = collection.size();
        for (int i = 0; i < collectionSize; ++i) {
            arrayList.add(collection.get(i).getMaterial().getId().toString());
        }
        return arrayList;
    }

    @Override
    protected MaterialInventoryInfo _getInventoryInfo(Context ctx, String matid, String ouid) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterinfo = MaterialControllerBean.getFilterOUMaterial((Context)ctx, (String)"orgUnit.id", (String)ouid, (String)"material.id", (String)matid);
        viewInfo.setFilter(filterinfo);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultWarehouse.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultWarehouse.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultWarehouse.hasLocation"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultWarehouse.whman.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultWarehouse.whman.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultWarehouse.whman.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultWarehouse.whState"));
        this.getInventorySelectors(viewInfo.getSelector());
        MaterialInventoryCollection con = MaterialInventoryFactory.getLocalInstance(ctx).getMaterialInventoryCollection(viewInfo);
        if (con != null && con.size() >= 1) {
            for (int i = 0; i < con.size(); ++i) {
                MaterialInventoryInfo info = con.get(i);
                if (!info.getOrgUnit().getId().toString().equals(ouid)) continue;
                return info;
            }
            return con.get(0);
        }
        MaterialInventoryInfo info = null;
        return info;
    }

    private SelectorItemCollection getInventorySelectors(SelectorItemCollection sic) {
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("material.longNumber"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.shortName"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("freezeOrgUnit.name"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("isControl"));
        sic.add(new SelectorItemInfo("qtySafety"));
        sic.add(new SelectorItemInfo("qtyMin"));
        sic.add(new SelectorItemInfo("qtyMax"));
        sic.add(new SelectorItemInfo("daysBottom"));
        sic.add(new SelectorItemInfo("daysTop"));
        sic.add(new SelectorItemInfo("daysTurnover"));
        sic.add(new SelectorItemInfo("isNegative"));
        sic.add(new SelectorItemInfo("isBatchNo"));
        sic.add(new SelectorItemInfo("isSequenceNo"));
        sic.add(new SelectorItemInfo("isLotNumber"));
        sic.add(new SelectorItemInfo("isBarcode"));
        sic.add(new SelectorItemInfo("qtyMinPackage"));
        sic.add(new SelectorItemInfo("abcType"));
        sic.add(new SelectorItemInfo("isCompages"));
        sic.add(new SelectorItemInfo("issuePriorityMode"));
        sic.add(new SelectorItemInfo("isPeriodValid"));
        sic.add(new SelectorItemInfo("periodValid"));
        sic.add(new SelectorItemInfo("periodValidUnit"));
        sic.add(new SelectorItemInfo("inWarehsAhead"));
        sic.add(new SelectorItemInfo("outWarehsAhead"));
        sic.add(new SelectorItemInfo("prepWarnAhead"));
        sic.add(new SelectorItemInfo("aheadUnit"));
        return sic;
    }

    @Override
    protected HashMap _verifyMaterialInvInfos(Context ctx, HashMap hashMap) throws BOSException {
        HashMap<String, List> resultMap = new HashMap<String, List>();
        if (hashMap != null) {
            Set keySet = hashMap.keySet();
            Object[] keyArray = keySet.toArray();
            int size = keyArray.length;
            for (int index = 0; index < size; ++index) {
                String storageID = (String)keyArray[index];
                List materialIDList = (List)hashMap.get(storageID);
                List resultList = null;
                if (materialIDList == null || (resultList = this._getMaterialsExistInvInfo(ctx, materialIDList.toArray(new String[materialIDList.size()]), storageID)) == null) continue;
                resultMap.put(storageID, resultList);
            }
        }
        return resultMap;
    }

    private void writeLog(Context ctx, MaterialInventoryInfo info, IObjectPK pk, boolean isSuccesse) throws EASBizException, BOSException {
        String resource = "com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource";
        String resourceKey = ResourceBase.getString((String)resource, (String)"IsNegative", (Locale)ctx.getLocale(), (Object[])new Object[]{info.isIsNegative()});
        String companyId = info.getOrgUnit().getId().toString();
        String insDetail = info.getMaterial().getNumber() + "  " + info.getMaterial().getName() + "  " + resourceKey;
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_update", (BOSObjectType)info.getBOSType(), (IObjectPK)pk, (String)insDetail, (String)"bd_materialInventory_update", (String)companyId, null);
        if (isSuccesse) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
    }
}

