/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.basedata.master.material.ABCEnum;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.IssuePriorityEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.TimeUnitEnum;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import java.util.HashMap;

public class MaterialInvAutoCreateProcessor
extends AbstractBusinessProcessor {
    public MaterialInvAutoCreateProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        ApplicationContext ac = this.getExecuteContext().getApplicationContext();
        MaterialInfo matInfo = (MaterialInfo)ac.getData("matInfo");
        HashMap errors = (HashMap)ac.getData("errors");
        FullOrgUnitInfo ouInfo = (FullOrgUnitInfo)ac.getData("ouInfo");
        IMaterialInventory imatInv = MaterialInventoryFactory.getLocalInstance(this.ctx);
        MaterialInventoryInfo invInfo = new MaterialInventoryInfo();
        invInfo.setMaterial(matInfo);
        invInfo.setStatus(UsedStatusEnum.UNAPPROVE);
        invInfo.setEffectedStatus(2);
        invInfo.setOrgUnit(ouInfo);
        invInfo.setUnit(matInfo.getBaseUnit());
        invInfo.setAbcType(ABCEnum.NOTSELECT);
        invInfo.setIssuePriorityMode(IssuePriorityEnum.NOTSELECT);
        invInfo.setAbcType(ABCEnum.NOTSELECT);
        invInfo.setIsControl(true);
        invInfo.setIsNegative(false);
        invInfo.setIsBatchNo(false);
        invInfo.setIsLotNumber(false);
        invInfo.setIsBarcode(false);
        invInfo.setIsSequenceNo(false);
        invInfo.setIsCompages(false);
        invInfo.setIsPeriodValid(false);
        invInfo.setPeriodValid(1);
        invInfo.setPeriodValidUnit(TimeUnitEnum.DAY);
        invInfo.setInWarehsAhead(1);
        invInfo.setOutWarehsAhead(1);
        invInfo.setPrepWarnAhead(1);
        invInfo.setAheadUnit(TimeUnitEnum.DAY);
        try {
            ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
            imatInv.addnew((CoreBaseInfo)invInfo);
        }
        catch (PermissionException e5) {
            errors.put("inv", e5);
        }
    }
}

