/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CopyDataStatusEnum;
import com.kingdee.eas.basedata.master.cssp.UserParamInfo;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialUtil;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionResults;

public class MaterialInvCopyProcessor
extends AbstractBusinessProcessor {
    public MaterialInvCopyProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        ApplicationContext ac = this.getExecuteContext().getApplicationContext();
        MaterialInfo newMaterial = (MaterialInfo)ac.getData("newMaterial");
        EntityViewInfo viewInfo = (EntityViewInfo)ac.getData("viewInfo");
        MeasureUnitInfo newBaseUnit = (MeasureUnitInfo)ac.getData("newBaseUnit");
        boolean isModify = (Boolean)ac.getData("isModify");
        UserParamInfo userParam = (UserParamInfo)ac.getData("userParam");
        IMaterialInventory iMaterialInv = MaterialInventoryFactory.getLocalInstance(this.ctx);
        MaterialInventoryCollection materialInventoryColl = iMaterialInv.getMaterialInventoryCollection(viewInfo);
        int size = materialInventoryColl.size();
        MaterialInventoryInfo materialInventoryInfo = null;
        for (int index = 0; index < size; ++index) {
            CopyDataStatusEnum copyBaseDataStaus;
            UsedStatusEnum destStatus;
            materialInventoryInfo = materialInventoryColl.get(index);
            materialInventoryInfo.setId(null);
            materialInventoryInfo.setMaterial(newMaterial);
            materialInventoryInfo.setCreator(newMaterial.getCreator());
            materialInventoryInfo.setCreateTime(newMaterial.getCreateTime());
            materialInventoryInfo.setLastUpdateUser(newMaterial.getLastUpdateUser());
            materialInventoryInfo.setLastUpdateTime(newMaterial.getLastUpdateTime());
            if (isModify) {
                materialInventoryInfo.setUnit(newBaseUnit);
            }
            if ((destStatus = MaterialUtil.getMaterialCopyStatus((CopyDataStatusEnum)(copyBaseDataStaus = userParam.getCopyInvDataStaus()), (UsedStatusEnum)materialInventoryInfo.getStatus())) == UsedStatusEnum.APPROVED) {
                try {
                    MaterialUtil.checkFunctionPermission((Context)this.ctx, (String)newMaterial.getCU().getId().toString(), (String)"bd_materialInv_approve");
                }
                catch (PermissionException e) {
                    destStatus = UsedStatusEnum.UNAPPROVE;
                }
            }
            materialInventoryInfo.setStatus(destStatus);
            iMaterialInv.addnew((CoreBaseInfo)materialInventoryInfo);
        }
    }
}

