/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.BatchPolicyEnum;
import com.kingdee.eas.basedata.master.material.BatchPolicyPartitionTypeEnum;
import com.kingdee.eas.basedata.master.material.IManufactureStrategy;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyFactory;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialCharEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialLeadTimeTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialOffsetEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialScrapRateExpressionEnum;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.master.material.PlanningModeEnum;
import com.kingdee.eas.basedata.master.material.ReplaceModeEnum;
import com.kingdee.eas.basedata.master.material.ThrowModeEnum;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.BatchPolicyDataCheck;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.IProductTransactionType;
import com.kingdee.eas.mm.basedata.ProductLineCollection;
import com.kingdee.eas.mm.basedata.ProductLineFactory;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeCollection;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeFactory;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeInfo;
import com.kingdee.eas.mm.planning.IRequirementUniteRule;
import com.kingdee.eas.mm.planning.RequirementUniteRuleCollection;
import com.kingdee.eas.mm.planning.RequirementUniteRuleFactory;
import com.kingdee.eas.mm.planning.RequirementUniteRuleInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DataImportMaterialManufacture
extends AbstractDataTransmission {
    private Set PerminsionCheckedCuIds = new HashSet();
    Map cacheAssignCU = new HashMap();
    Map cacheManufactureStrategy = new HashMap();
    Map cacheOrg = new HashMap();
    Map cachePerson = new HashMap();
    Map cacheStorageOrgUnit = new HashMap();
    Map cacheWarehouse = new HashMap();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MaterialPlanFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            return this.innerTransmit(hsData, ctx);
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (EASBizException ee) {
            throw new TaskExternalException(ee.getMessage());
        }
        catch (Exception ex) {
            throw new TaskExternalException(ExceptionUtil.getExcLinkStackTrace((Throwable)ex));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CoreBaseInfo innerTransmit(Hashtable hsData, Context ctx) throws Exception {
        String productTranTypeNum;
        MaterialInfo materialInfo;
        Object data = ((DataToken)hsData.get((Object)"FOrgUnit")).data;
        if (data == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"GetInventoryOrgUnitFailed", (Context)ctx));
        }
        StorageOrgUnitInfo storageOrgUnit = this.getStorageOrgByNumber(ctx, data.toString());
        if (storageOrgUnit == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"GetInventoryOrgUnitFailed", (Context)ctx));
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (!PerminsionUtil.isUserBizOrgRange((Context)ctx, (String)userId, (String)storageOrgUnit.getId().toString())) {
            throw new TaskExternalException(new MaterialBaseException(MaterialBaseException.OUT_BIZ_ORG, new Object[]{storageOrgUnit.getName()}).getMessage());
        }
        String CuId = storageOrgUnit.getCU().getId().toString();
        if (!this.PerminsionCheckedCuIds.contains(CuId)) {
            try {
                PerminsionUtil.checkCUPerminsion((Context)ctx, (String)CuId, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), (String)"bd_materialPlan_import");
            }
            catch (EASBizException ee) {
                throw new TaskExternalException(ee.getMessage(), (Throwable)ee);
            }
            this.PerminsionCheckedCuIds.add(CuId);
        }
        if (!this.isMaterialAssignToCU(ctx, (materialInfo = DataImportTools.getMaterialInfo((Context)ctx, (String)this.getDataString(hsData, "FNumber"))).getId().toString(), storageOrgUnit.getCU().getId().toString())) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"NoAssignRelBetweenOrgAndMaterial", (Context)ctx));
        }
        MaterialPlanInfo info = new MaterialPlanInfo();
        if (this.isSltImportUpdate()) {
            FilterInfo filter = new FilterInfo();
            DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"orgUnit.id", (Object)storageOrgUnit.getId().toString());
            DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"material.number", (Object)this.getDataString(hsData, "FNumber"));
            filter.setMaskString("#0 and #1");
            IMaterialPlan iProperty = MaterialPlanFactory.getLocalInstance(ctx);
            MaterialPlanCollection proCollection = iProperty.getMaterialPlanCollection(DataImportTools.getViewInfo((FilterInfo)filter));
            if (proCollection != null && proCollection.size() > 0) {
                info.setId(proCollection.get(0).getId());
                info.setCU(proCollection.get(0).getCU());
                info.setManufactureStrategy(proCollection.get(0).getManufactureStrategy());
            }
        }
        if ((productTranTypeNum = this.getDataString(hsData, "FProductTranType")) != null && productTranTypeNum.trim().length() > 0) {
            ProductTransactionTypeInfo productTranTypeInfo = DataImportMaterialManufacture.getProductTransactionTypeInfoByNumber(ctx, storageOrgUnit, productTranTypeNum);
            if (productTranTypeInfo == null) {
                throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"invalidProductTranType", (Context)ctx));
            }
            info.setProductTranType(productTranTypeInfo);
        } else {
            info.setProductTranType(null);
        }
        info.setChangeLeadTime(DataImportTools.getDataint((Hashtable)hsData, (String)"FChangeLeadTime"));
        info.setIsComReqConsume(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsComReqConsume"));
        boolean isMergeSign = DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsMergeSign");
        String reqUniteRuleNumber = this.getDataString(hsData, "FMergeRuler");
        if (isMergeSign) {
            if (reqUniteRuleNumber == null || reqUniteRuleNumber.trim().length() <= 0) throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"ReqnuiteruleNotNull", (Context)ctx));
            RequirementUniteRuleInfo requirementUniteRuleInfo = DataImportMaterialManufacture.getRequirementUniteRuleInfoByNumber(ctx, storageOrgUnit, reqUniteRuleNumber);
            if (requirementUniteRuleInfo == null) {
                throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"ReqnuiteruleInvalidWarn", (Context)ctx));
            }
            info.setReqUniteRule(requirementUniteRuleInfo);
        } else {
            info.setReqUniteRule(null);
        }
        info.setMaterial(materialInfo);
        info.setOrgUnit(storageOrgUnit.castToFullOrgUnitInfo());
        this.handleInfo(hsData, ctx, info, materialInfo.getId().toString());
        this.checkPlanner(ctx, info);
        return info;
    }

    private boolean isMaterialAssignToCU(Context ctx, String materialId, String cuId) throws BOSException {
        if (materialId == null || cuId == null) {
            return false;
        }
        String key = materialId + "&&" + cuId;
        Boolean result = (Boolean)this.cacheAssignCU.get(key);
        if (result == null) {
            boolean isAssigned = DataImportTools.isMaterialAssignForOrg((Context)ctx, (String)materialId, (String)cuId);
            result = isAssigned;
            this.cacheAssignCU.put(key, result);
        }
        return result;
    }

    private void checkPlanner(Context ctx, MaterialPlanInfo infoVO) throws EASBizException, BOSException {
        IOrgUnitRelation iUtilRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUtilRel.getToUnit(infoVO.getOrgUnit().getId().toString(), 4, 0);
        AdminOrgUnitInfo dutyDepartment = infoVO.getDutyDepartment();
        boolean isDutyDepartmentOrg = false;
        boolean isPlannerDepartment = false;
        if (dutyDepartment != null) {
            for (int j = 0; j < orgCol.size(); ++j) {
                AdminOrgUnitInfo orgInfo = (AdminOrgUnitInfo)orgCol.get(j);
                if (!orgInfo.equalsPK((IObjectValue)dutyDepartment)) continue;
                isDutyDepartmentOrg = true;
                break;
            }
            if (!isDutyDepartmentOrg) {
                throw new MaterialBaseException(MaterialBaseException.DUTYDEPARTMENT_NOT_IN_ORG);
            }
        }
        if (infoVO.getPlanner() != null) {
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            AdminOrgUnitCollection adminOrgUnitCollection = iPerson.getAllAdminOrgUnit(infoVO.getPlanner().getId());
            for (int i = 0; i < adminOrgUnitCollection.size(); ++i) {
                AdminOrgUnitInfo adminOrg = adminOrgUnitCollection.get(i);
                for (int j = 0; j < orgCol.size(); ++j) {
                    AdminOrgUnitInfo orgInfo = (AdminOrgUnitInfo)orgCol.get(j);
                    if (!adminOrg.equalsPK((IObjectValue)orgInfo)) continue;
                    isPlannerDepartment = true;
                    break;
                }
                if (isPlannerDepartment) break;
            }
            if (!isPlannerDepartment) {
                throw new MaterialBaseException(MaterialBaseException.PLANNER_NOT_IN_DEP);
            }
        }
    }

    private void handleInfo(Hashtable hsData, Context ctx, MaterialPlanInfo info, String materialID) throws Exception {
        info.setStatus(DataImportTools.getStatusEnum((String)this.getDataString(hsData, "FStatus"), (Context)ctx));
        info.setEffectedStatus(2);
        info.setProductUnit(DataImportTools.getMultiMeasureUnitInfo((Context)ctx, (String)this.getDataString(hsData, "FProductUnitID"), (String)materialID));
        AdminOrgUnitInfo dutyDept = null;
        if (!StringUtils.isEmpty((String)this.getDataString(hsData, "FDutyDepartment"))) {
            OrgUnitInfo org = null;
            try {
                org = this.getOrgByNumber(ctx, this.getDataString(hsData, "FDutyDepartment"));
            }
            catch (TaskExternalException e) {
                throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"DataImport_DepartmentNumber_Error", (Locale)ctx.getLocale()));
            }
            if (org != null) {
                dutyDept = new AdminOrgUnitInfo();
                dutyDept.setId(org.getId());
            }
        } else if (MaterialAttributeEnum.getEnum((int)10030).getAlias(ctx.getLocale()).equals(this.getDataString(hsData, "FMaterialAttr"))) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"MaterialAttr_FABRICATEDPART_prmtDepartment_NOTNULL", (Context)ctx));
        }
        info.setDutyDepartment(dutyDept);
        StorageOrgUnitInfo supplyOrgUnit = null;
        if (hsData.get("FSupplyOrgUnit") != null) {
            OrgUnitInfo org = null;
            try {
                org = this.getOrgByNumber(ctx, this.getDataString(hsData, "FSupplyOrgUnit"));
            }
            catch (TaskExternalException e) {
                throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"DataImport_SupplyOrgUnitNumber_Error", (Locale)ctx.getLocale()));
            }
            if (org != null) {
                supplyOrgUnit = new StorageOrgUnitInfo();
                supplyOrgUnit.setId(org.getId());
            }
        }
        info.setSupplyOrgUnit(supplyOrgUnit);
        StorageOrgUnitInfo fromInvOrg = null;
        if (hsData.get("FFromInvOrg") != null && !hsData.get("FFromInvOrg").equals("")) {
            OrgUnitInfo org = null;
            try {
                org = this.getOrgByNumber(ctx, this.getDataString(hsData, "FFromInvOrg"));
            }
            catch (TaskExternalException e) {
                throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"DataImport_FromInvOrgNumber_Error", (Locale)ctx.getLocale()));
            }
            if (org != null) {
                fromInvOrg = new StorageOrgUnitInfo();
                fromInvOrg.setId(org.getId());
            }
        }
        info.setFromInvOrg(fromInvOrg);
        WarehouseInfo warehouseInfo = null;
        if (info.getFromInvOrg() == null && !this.getDataString(hsData, "FFromWareHouse").equals("")) {
            throw new MaterialBaseException(MaterialBaseException.MATERIALPLAN_FROMHOUSEWARE_ILLEGAL3);
        }
        if (info.getFromInvOrg() != null && !this.getDataString(hsData, "FFromWareHouse").equals("")) {
            warehouseInfo = this.getWarehouseByNumber(ctx, this.getDataString(hsData, "FFromWareHouse"), info.getFromInvOrg().getId().toString());
        }
        info.setFromWarehouse(warehouseInfo);
        PurchaseOrgUnitInfo purOrg = null;
        if (hsData.get("FPurOrg") != null && !hsData.get("FPurOrg").equals("")) {
            OrgUnitInfo org = null;
            try {
                org = this.getOrgByNumber(ctx, this.getDataString(hsData, "FPurOrg"));
            }
            catch (TaskExternalException e) {
                throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"DataImport_PurOrgNumber_Error", (Locale)ctx.getLocale()));
            }
            if (org != null) {
                purOrg = new PurchaseOrgUnitInfo();
                purOrg.setId(org.getId());
            }
        }
        info.setPurOrg(purOrg);
        info.setIsConfigable(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsConfigable"));
        info.setIsCentralizedPar(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsCentralizedPar"));
        ManufactureStrategyInfo manufactureStrategy = this.getManufactureStrategyByNumber(ctx, this.getDataString(hsData, "FManufactureStrategy"));
        this.updateInvByStrategy(ctx, info, manufactureStrategy);
        info.setManufactureStrategy(manufactureStrategy);
        info.setMaterialAttr(DataImportTools.getMaterialAttributeEnum((String)this.getDataString(hsData, "FMaterialAttr"), (Context)ctx, (String)"DataImport_MaterialAttr_Error"));
        info.setMaterialChar(DataImportTools.getMaterialCharEnum((String)this.getDataString(hsData, "FMaterialChar"), (Context)ctx, (String)"DataImport_MaterialChar_Error"));
        info.setIsDemandAssign(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsDemandAssign"));
        info.setIssMode(DataImportTools.getMaterialIssueModeEnum((String)this.getDataString(hsData, "FIssMode"), (Context)ctx, (String)"DataImport_IssMode_Error"));
        info.setProvideType(DataImportTools.getMaterialProvideTypeEnum((String)this.getDataString(hsData, "FProvideType"), (Context)ctx, (String)"DataImport_ProvideType_Error"));
        if (info.getProvideType() != null) {
            if (MaterialProvideTypeEnum.CURRENTORGPROVIDE.equals((Object)info.getProvideType()) || MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE.equals((Object)info.getProvideType())) {
                if (MaterialIssueModeEnum.PRODUCEISSMODE.equals((Object)info.getIssMode())) {
                    info.setIsStockAllot(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsStockAllot"));
                    info.setIsBackFlush(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsBackFlush"));
                } else {
                    info.setIsStockAllot(false);
                    info.setIsBackFlush(false);
                }
            } else {
                info.setIsStockAllot(false);
                info.setIsBackFlush(false);
            }
        } else {
            info.setIsStockAllot(false);
            info.setIsBackFlush(false);
        }
        if (!info.isIsStockAllot()) {
            info.setFromInvOrg(null);
            info.setFromWarehouse(null);
        }
        info.setPlanningMode(DataImportTools.getPlanModeEnum((String)this.getDataString(hsData, "FPlanningMode"), (Context)ctx));
        info.setOffsetMode(DataImportTools.getMaterialOffsetEnum((String)this.getDataString(hsData, "FOffsetMode"), (Context)ctx, (String)"DataImport_OffsetMode_Error"));
        info.setBackwardDaysOffset(DataImportTools.getDataint((Hashtable)hsData, (String)"FBackwardDaysOffset"));
        info.setForwardDaysOffset(DataImportTools.getDataint((Hashtable)hsData, (String)"FForwardDaysOffset"));
        info.setIsolatedRule(DataImportTools.getIsolatedRuleEnum((String)this.getDataString(hsData, "FIsolatedRule"), (Context)ctx));
        info.setIsMergeSign(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsMergeSign"));
        info.setIsProductLinePlan(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsProductLinePlan"));
        info.setProduceLeadTime(DataImportTools.getDataint((Hashtable)hsData, (String)"FProduceLeadTime"));
        MaterialLeadTimeTypeEnum materialLeadTimeType = DataImportTools.getMaterialLeadTimeTypeEnum((String)this.getDataString(hsData, "FLeadTimeType"), (Context)ctx, (String)"DataImport_LeadTimeType_Error");
        int changeBatch = DataImportTools.getDataint((Hashtable)hsData, (String)"FChangeBatch");
        if (materialLeadTimeType == MaterialLeadTimeTypeEnum.CHANGEBATCHTYPE && changeBatch == 0) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"ChangeBatch_NOT_ZERO", (Context)ctx));
        }
        info.setChangeBatch(changeBatch);
        info.setLeadTimeType(materialLeadTimeType);
        info.setRecevingLeadTime(DataImportTools.getDataint((Hashtable)hsData, (String)"FRecevingLeadTime"));
        info.setForwardProcessTime(DataImportTools.getDataint((Hashtable)hsData, (String)"FForwardProcessTime"));
        info.setBackwardProcessTime(DataImportTools.getDataint((Hashtable)hsData, (String)"FBackwardProcessTime"));
        info.setYield(this.getDataBigDecimal(hsData, "FYield"));
        info.setScrapRate(this.getDataBigDecimal(hsData, "FScrapRate"));
        info.setScrapRateExpression(DataImportTools.getMaterialScrapRateExpressionEnum((String)this.getDataString(hsData, "FScrapRateExpression"), (Context)ctx, (String)"invalidScrapRateExpression"));
        info.setReBookQty(this.getDataBigDecimal(hsData, "FReBookQty"));
        info.setConsumeSpeed(this.getDataBigDecimal(hsData, "FConsumeSpeed"));
        BatchPolicyEnum batchPolicy = DataImportTools.getBatchPolicyEnum((String)this.getDataString(hsData, "FBatchPolicy"), (Context)ctx);
        if (batchPolicy == null) {
            throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"WarnBatchPolicyCheck", (Locale)ctx.getLocale()));
        }
        HashSet<String> strategySet = new HashSet<String>();
        strategySet.add("fpPxtypCS/ihJ30GjB/UJtg0uEU=");
        strategySet.add("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=");
        strategySet.add("GE2FIa4GQ6uhdx0RDGuibtg0uEU=");
        strategySet.add("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=");
        strategySet.add("qAYbemEdG9ngQKjAYj0V1dg0uEU=");
        strategySet.add("qAYfaBzTrmLgQKjAYj0f3dg0uEU=");
        ManufactureStrategyInfo ms = info.getManufactureStrategy();
        if (ms != null && strategySet.contains(ms.getId().toString()) && !BatchPolicyEnum.FIXATIONBATCH.equals((Object)batchPolicy) && !BatchPolicyEnum.STRAIGHTBATCH.equals((Object)batchPolicy)) {
            throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"batchPolicyNotForStrategy", (Locale)ctx.getLocale()));
        }
        info.setBatchPolicy(batchPolicy);
        info.setFixationBatchQty(this.getDataBigDecimal(hsData, "FFixationBatchQty"));
        info.setIsMaxBatchMethod(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsMaxBatchMethod"));
        info.setBatchCycle(DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)"FBatchCycle"));
        info.setMaxBatchQty(DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)"FMaxBatchQty"));
        info.setMinBatchQty(DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)"FMinBatchQty"));
        info.setRoundUpMulitpleQty(DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)"FRoundUpMulitpleQty"));
        info.setInterval(DataImportTools.getDataint((Hashtable)hsData, (String)"FInterval"));
        info.setIsMinBatchMethod(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsMinBatchMethod"));
        info.setIsRoundUpMultiple(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsRoundUpMultiple"));
        info.setPartitionType(DataImportTools.getBatchPolicyPartitionTypeEnum((String)this.getDataString(hsData, "FPartitionType"), (Context)ctx));
        info.setPartitionDays(DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)"FPartitionDays"));
        info.setIsBatchIncMethod(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsBatchIncMethod"));
        info.setBatchIncQty(DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)"FBatchIncQty"));
        try {
            BatchPolicyDataCheck.submitCheckBatchPolicy(info);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        info.setOutputType(DataImportTools.getMaterialProductEnum((String)this.getDataString(hsData, "FOutputType"), (Context)ctx, (String)"DataImport_OutputType_Error"));
        info.setIsQuotaControl(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsQuotaControl"));
        info.setIssueLeadTime(DataImportTools.getDataint((Hashtable)hsData, (String)"FIssueLeadTime"));
        info.setIsStorageLimit(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsStorageLimit"));
        info.setIsReportingLimit(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsReportingLimit"));
        info.setIssInHightLimit(DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)"FISSInHightLimit"));
        if (!info.isIsQuotaControl()) {
            info.setIssInHightLimit(new BigDecimal("0"));
        }
        info.setIssInLowLimit(DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)"FISSInLowLimit"));
        info.setRptInHightLimit(DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)"FRPTInHightLimit"));
        if (!info.isIsReportingLimit()) {
            info.setRptInHightLimit(new BigDecimal("0"));
        }
        info.setRptInLowLimit(DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)"FRPTInLowLimit"));
        info.setRcvInHightLimit(DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)"FRCVInHightLimit"));
        if (!info.isIsStorageLimit()) {
            info.setRcvInHightLimit(new BigDecimal("0"));
        }
        info.setRcvInLowLimit(DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)"FRCVInLowLimit"));
        PersonInfo invPlanner = null;
        if (hsData.get("FPlanner") != null) {
            invPlanner = this.getPersonByNumber(ctx, this.getDataString(hsData, "FPlanner"));
        }
        info.setIsCheck(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FCheck"));
        info.setIsKeyPart(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FKeyPart"));
        info.setIsFirstCheck(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FFirstCheck"));
        info.setRemainTimeNoPlan(DataImportTools.getDataint((Hashtable)hsData, (String)"FRemainTimeNoPlan"));
        info.setTransferBatch(DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)"FTransferBatch"));
        info.setReplaceMode(DataImportTools.getReplaceModeEnum((String)this.getDataString(hsData, "FRepalceMode"), (Context)ctx));
        info.setThrowMode(DataImportTools.getThrowModeEnum((String)this.getDataString(hsData, "FThrowMode"), (Context)ctx));
        if (info.getThrowMode() == ThrowModeEnum.FLOW) {
            String number = this.getDataString(hsData, "FProductLine");
            ProductLineInfo productLineInfo = this.getProductLine(ctx, number);
            if (productLineInfo != null && info.getOrgUnit() != null && !productLineInfo.getStorageOrgUnit().getId().equals((Object)info.getOrgUnit().getId())) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.basedata.master.material.MATERIALAutoGenerateResource", (String)"5_DataImportMaterialManufacture", (Locale)ctx.getLocale()));
            }
            info.setProductLine(productLineInfo);
        }
        QualityOrgUnitInfo qualityOrg = null;
        OrgUnitInfo ou = null;
        try {
            ou = this.getOrgByNumber(ctx, this.getDataString(hsData, "FqualityOrg"));
        }
        catch (TaskExternalException e) {
            throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"DataImport_QualityOrgNumber_Error", (Locale)ctx.getLocale()));
        }
        if (ou != null) {
            if (!ou.isIsQualityOrgUnit()) {
                throw new TaskExternalException(this.getDataString(hsData, "FqualityOrg") + "," + ResourceBase.getString((String)"com.kingdee.eas.basedata.master.material.MATERIALAutoGenerateResource", (String)"4_DataImportMaterialInventory", (Locale)ctx.getLocale()));
            }
            qualityOrg = new QualityOrgUnitInfo();
            qualityOrg.setId(ou.getId());
        }
        info.setQualityOrg(qualityOrg);
        info.setPlanner(invPlanner);
        try {
            ou = this.getOrgByNumber(ctx, this.getDataString(hsData, "FFreezeOrgUnit"));
        }
        catch (TaskExternalException e) {
            throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"DataImport_FreezeOrgUnitNumber_Error", (Locale)ctx.getLocale()));
        }
        if (ou != null) {
            info.setFreezeOrgUnit(ou.castToFullOrgUnitInfo());
        } else if (info.getStatus() == UsedStatusEnum.FREEZED) {
            info.setFreezeOrgUnit(ContextUtil.getCurrentOrgUnit((Context)ctx).castToFullOrgUnitInfo());
        } else {
            info.setFreezeOrgUnit(null);
        }
    }

    private void updateInvByStrategy(Context ctx, MaterialPlanInfo m, ManufactureStrategyInfo s) throws Exception {
        if (null == s || null == s.getId()) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)m.getOrgUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)m.getMaterial().getId().toString()));
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        coll.add(new SelectorItemInfo("isProjectNumber"));
        coll.add(new SelectorItemInfo("isTrackingNumber"));
        view.setSelector(coll);
        view.setFilter(filter);
        CoreBaseInfo invert = null;
        Class<?> materialInventoryFactory = Class.forName("com.kingdee.eas.basedata.master.material.MaterialInventoryFactory");
        Method method = materialInventoryFactory.getMethod("getLocalInstance", Context.class);
        Object o = method.invoke(null, ctx);
        Class<?> iMaterialInventory = Class.forName("com.kingdee.eas.basedata.master.material.IMaterialInventory");
        method = iMaterialInventory.getMethod("getCollection", EntityViewInfo.class);
        CoreBaseCollection invents = (CoreBaseCollection)method.invoke(o, view);
        if (invents.size() <= 0) {
            return;
        }
        invert = invents.get(0);
        boolean isProject = false;
        boolean isTrack = false;
        String straId = s.getId().toString();
        if (straId.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) {
            isProject = true;
            isTrack = true;
        } else if (straId.equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || straId.equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=")) {
            isTrack = true;
        } else if (straId.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) {
            isProject = true;
        }
        if (invert.getBoolean("isProjectNumber") != isProject || invert.getBoolean("isTrackingNumber") != isTrack) {
            coll.clear();
            coll.add(new SelectorItemInfo("isProjectNumber"));
            coll.add(new SelectorItemInfo("isTrackingNumber"));
            invert.setBoolean("isProjectNumber", isProject);
            invert.setBoolean("isTrackingNumber", isTrack);
            method = iMaterialInventory.getMethod("updatePartial", CoreBaseInfo.class, SelectorItemCollection.class);
            method.invoke(o, invert, coll);
        }
    }

    private void checkMStrategy(Context ctx, MaterialPlanInfo m, ManufactureStrategyInfo s) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)m.getOrgUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)m.getMaterial().getId().toString()));
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("isProjectNumber"));
        coll.add(new SelectorItemInfo("isTrackingNumber"));
        coll.add(new SelectorItemInfo("id"));
        coll.add(new SelectorItemInfo("orgUnit"));
        coll.add(new SelectorItemInfo("material"));
        view.setSelector(coll);
        view.setFilter(filter);
        CoreBaseInfo invert = null;
        Class<?> materialInventoryFactory = Class.forName("com.kingdee.eas.basedata.master.material.MaterialInventoryFactory");
        Method method = materialInventoryFactory.getMethod("getLocalInstance", Context.class);
        Object o = method.invoke(null, ctx);
        Class<?> iMaterialInventory = Class.forName("com.kingdee.eas.basedata.master.material.IMaterialInventory");
        method = iMaterialInventory.getMethod("getCollection", EntityViewInfo.class);
        CoreBaseCollection invents = (CoreBaseCollection)method.invoke(o, view);
        if (invents.size() <= 0) {
            return;
        }
        invert = invents.get(0);
        EntityViewInfo planView = new EntityViewInfo();
        FilterInfo planFilter = new FilterInfo();
        planFilter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)m.getOrgUnit().getId().toString()));
        planFilter.getFilterItems().add(new FilterItemInfo("material", (Object)m.getMaterial().getId().toString()));
        SelectorItemCollection planSic = new SelectorItemCollection();
        planSic.add(new SelectorItemInfo("id"));
        planSic.add(new SelectorItemInfo("orgUnit"));
        planSic.add(new SelectorItemInfo("manufactureStrategy.number"));
        planView.setSelector(planSic);
        planView.setFilter(planFilter);
        CoreBaseInfo plan = null;
        String msi = null;
        CoreBaseCollection plans = MaterialPlanFactory.getLocalInstance(ctx).getCollection(planView);
        if (plans.size() > 0) {
            plan = plans.get(0);
            if ((ManufactureStrategyInfo)plan.get("manufactureStrategy") != null) {
                msi = ((ManufactureStrategyInfo)plan.get("manufactureStrategy")).getNumber().toString();
            }
        } else {
            return;
        }
        Class<?> calManufactureStrategyFacadeFactory = Class.forName("com.kingdee.eas.scm.cal.CalManufactureStrategyFacadeFactory");
        method = calManufactureStrategyFacadeFactory.getMethod("getLocalInstance", Context.class);
        o = method.invoke(null, ctx);
        Class<?> iCalManufactureStrategyFacade = Class.forName("com.kingdee.eas.scm.cal.ICalManufactureStrategyFacade");
        Method m1 = iCalManufactureStrategyFacade.getMethod("canChangeManufactureStrategy", String.class, String.class);
        boolean isNotRef = (Boolean)m1.invoke(o, m.getOrgUnit().getId().toString(), m.getMaterial().getId().toString());
        if (this.isSltImportUpdate() && !isNotRef) {
            HashSet<String> set = new HashSet<String>();
            if (!invert.getBoolean("isProjectNumber") && !invert.getBoolean("isTrackingNumber")) {
                set.add("NUnM+gEcEADgAA3cwKgL09g0uEU=");
                set.add("NUnM+gEcEADgAA3ewKgL09g0uEU=");
                set.add("NUnM+gEcEADgAA3gwKgL09g0uEU=");
                set.add("fpPxtypCS/ihJ30GjB/UJtg0uEU=");
                set.add("qAYbemEdG9ngQKjAYj0V1dg0uEU=");
                set.add("qAYfaBzUrmLgQKjAYj0f3dg0uEU=");
                set.add("GE2FIa4GQ6uhdx0RDGuibtg0uEU=");
            } else if (invert.getBoolean("isProjectNumber") && invert.getBoolean("isTrackingNumber")) {
                set.add("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=");
            } else if (!invert.getBoolean("isProjectNumber") && invert.getBoolean("isTrackingNumber")) {
                set.add("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=");
                set.add("qAYfaBzTrmLgQKjAYj0f3dg0uEU=");
            } else if (invert.getBoolean("isProjectNumber") && !invert.getBoolean("isTrackingNumber")) {
                set.add("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=");
            }
            if (msi == null && s != null || msi != null && s == null || s != null && !set.contains(s.getId().toString())) {
                throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"ManufactureStrategyInvalid", (Locale)ctx.getLocale()));
            }
        }
    }

    private ProductLineInfo getProductLine(Context ctx, String number) throws Exception {
        if (number == null || number.trim().length() == 0) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        viewInfo.setFilter(filterInfo);
        ProductLineCollection collection = ProductLineFactory.getLocalInstance((Context)ctx).getProductLineCollection(viewInfo);
        if (collection.size() > 0) {
            return collection.get(0);
        }
        throw new MaterialBaseException(MaterialBaseException.PRODUCTLINE_ERROR);
    }

    private ManufactureStrategyInfo getManufactureStrategyByNumber(Context ctx, String number) {
        if (number == null || "".equals(number)) {
            return null;
        }
        Object result = this.cacheManufactureStrategy.get(number);
        if (result == null) {
            try {
                IManufactureStrategy iManufactureStrategy = ManufactureStrategyFactory.getLocalInstance((Context)ctx);
                CoreBaseCollection collection = iManufactureStrategy.getCollection("where number = '" + number + "'");
                if (collection.size() > 0) {
                    result = collection.get(0);
                    this.cacheManufactureStrategy.put(number, result);
                }
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
        }
        return (ManufactureStrategyInfo)result;
    }

    private OrgUnitInfo getOrgByNumber(Context ctx, String number) throws TaskExternalException {
        if (number == null || "".equals(number)) {
            return null;
        }
        Object result = this.cacheOrg.get(number);
        if (result == null) {
            result = DataImportTools.getOrgUnitInfo((Context)ctx, (String)number);
            this.cacheOrg.put(number, result);
        }
        return (OrgUnitInfo)result;
    }

    private PersonInfo getPersonByNumber(Context ctx, String number) throws TaskExternalException {
        if (number == null || "".equals(number)) {
            return null;
        }
        Object result = this.cachePerson.get(number);
        if (result == null) {
            result = DataImportTools.getPersonInfo((Context)ctx, (String)number);
            this.cachePerson.put(number, result);
        }
        return (PersonInfo)result;
    }

    private StorageOrgUnitInfo getStorageOrgByNumber(Context ctx, String number) throws BOSException {
        if (number == null || "".equals(number)) {
            return null;
        }
        Object result = this.cacheStorageOrgUnit.get(number);
        if (result == null) {
            result = DataImportTools.getStorageOrgUnitInfoFromNumber((Context)ctx, (String)number);
            this.cacheStorageOrgUnit.put(number, result);
        }
        return (StorageOrgUnitInfo)result;
    }

    private String getDataString(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataString((Hashtable)hsData, (String)fieldName);
    }

    private BigDecimal getDataBigDecimal(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)fieldName);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FMaterialName", rs.getString("name"));
            this.putTable(result, "FOrgUnit", rs.getString("orgUnit.number"));
            this.putTable(result, "FStatus", UsedStatusEnum.getEnum((int)rs.getInt("materialPlan.status")).getAlias(ctx.getLocale()));
            this.putTable(result, "FProductUnitID", rs.getString("measureUnit.number"));
            this.putTable(result, "FDutyDepartment", rs.getString("deptOrg.number"));
            int i = rs.getInt("materialPlan.MaterialAttr");
            MaterialAttributeEnum maEnum = MaterialAttributeEnum.getEnum((int)i);
            if (maEnum != null) {
                this.putTable(result, "FMaterialAttr", maEnum.getAlias(ctx.getLocale()));
            } else {
                this.putTable(result, "FMaterialAttr", "");
            }
            MaterialCharEnum mcEnum = MaterialCharEnum.getEnum((int)rs.getInt("materialPlan.MaterialChar"));
            if (mcEnum != null) {
                this.putTable(result, "FMaterialChar", mcEnum.getAlias(ctx.getLocale()));
            }
            if (PlanningModeEnum.getEnum((int)rs.getInt("materialPlan.PlanningMode")) != null) {
                this.putTable(result, "FPlanningMode", PlanningModeEnum.getEnum((int)rs.getInt("materialPlan.PlanningMode")).getAlias(ctx.getLocale()));
            } else {
                this.putTable(result, "FPlanningMode", "");
            }
            this.putTable(result, "FIsDemandAssign", DataImportTools.boolToString((boolean)rs.getBoolean("materialPlan.isDemandAssign")));
            if (MaterialProvideTypeEnum.getEnum((int)rs.getInt("materialPlan.ProvideType")) != null) {
                this.putTable(result, "FProvideType", MaterialProvideTypeEnum.getEnum((int)rs.getInt("materialPlan.ProvideType")).getAlias(ctx.getLocale()));
            } else {
                this.putTable(result, "FProvideType", "");
            }
            this.putTable(result, "FSupplyOrgUnit", rs.getString("supplyOrgUnit.number"));
            this.putTable(result, "FFromInvOrg", rs.getString("fromInvOrg.number"));
            this.putTable(result, "FFromWareHouse", rs.getString("fromWareHouse.number"));
            this.putTable(result, "FIsStockAllot", DataImportTools.boolToString((boolean)rs.getBoolean("materialPlan.isStockAllot")));
            this.putTable(result, "FIsCentralizedPar", DataImportTools.boolToString((boolean)rs.getBoolean("materialPlan.isCentralizedPar")));
            this.putTable(result, "FIsConfigable", DataImportTools.boolToString((boolean)rs.getBoolean("materialPlan.isConfigable")));
            this.putTable(result, "FManufactureStrategy", rs.getString("manufactureStrategy.number"));
            MaterialOffsetEnum materialOffset = MaterialOffsetEnum.getEnum((int)rs.getInt("materialPlan.OffsetMode"));
            if (materialOffset != null) {
                this.putTable(result, "FOffsetMode", materialOffset.getAlias(ctx.getLocale()));
            }
            this.putTable(result, "FForwardDaysOffset", rs.getString("materialPlan.ForwardDaysOffset"));
            this.putTable(result, "FBackwardDaysOffset", rs.getString("materialPlan.BackwardDaysOffset"));
            this.putTable(result, "FIsMergeSign", DataImportTools.boolToString((boolean)rs.getBoolean("materialPlan.IsMergeSign")));
            this.putTable(result, "FMergeRuler", rs.getString("reqUniteRule.number"));
            this.putTable(result, "FIsProductLinePlan", DataImportTools.boolToString((boolean)rs.getBoolean("materialPlan.IsProductLinePlan")));
            this.putTable(result, "FProduceLeadTime", rs.getString("materialPlan.ProduceLeadTime"));
            if (rs.getInt("materialPlan.leadTimeType") == 0) {
                this.putTable(result, "FLeadTimeType", "");
            } else {
                this.putTable(result, "FLeadTimeType", MaterialLeadTimeTypeEnum.getEnum((int)rs.getInt("materialPlan.leadTimeType")).getAlias(ctx.getLocale()));
            }
            this.putTable(result, "FRecevingLeadTime", rs.getString("materialPlan.RecevingLeadTime"));
            this.putTable(result, "FForwardProcessTime", rs.getString("materialPlan.ForwardProcessTime"));
            this.putTable(result, "FBackwardProcessTime", rs.getString("materialPlan.BackwardProcessTime"));
            this.putTable(result, "FYield", rs.getBigDecimal("materialPlan.Yield"));
            this.putTable(result, "FScrapRate", rs.getBigDecimal("materialPlan.ScrapRate"));
            if (rs.getInt("materialPlan.scrapRateExpression") == 0) {
                this.putTable(result, "FScrapRateExpression", "");
            } else {
                this.putTable(result, "FScrapRateExpression", MaterialScrapRateExpressionEnum.getEnum((int)rs.getInt("materialPlan.scrapRateExpression")).getAlias(ctx.getLocale()));
            }
            this.putTable(result, "FReBookQty", rs.getBigDecimal("materialPlan.ReBookQty"));
            this.putTable(result, "FConsumeSpeed", rs.getBigDecimal("materialPlan.ConsumeSpeed"));
            if (rs.getInt("materialPlan.BatchPolicy") == 0) {
                this.putTable(result, "FBatchPolicy", "");
            } else {
                this.putTable(result, "FBatchPolicy", BatchPolicyEnum.getEnum((int)rs.getInt("materialPlan.BatchPolicy")).getAlias(ctx.getLocale()));
            }
            this.putTable(result, "FFixationBatchQty", rs.getBigDecimal("materialPlan.FixationBatchQty"));
            this.putTable(result, "FIsMaxBatchMethod", DataImportTools.boolToString((boolean)rs.getBoolean("materialPlan.IsMaxBatchMethod")));
            this.putTable(result, "FBatchCycle", rs.getBigDecimal("materialPlan.batchCycle"));
            this.putTable(result, "FMaxBatchQty", rs.getBigDecimal("materialPlan.MaxBatchQty"));
            this.putTable(result, "FInterval", rs.getString("materialPlan.interval"));
            this.putTable(result, "FIsMinBatchMethod", DataImportTools.boolToString((boolean)rs.getBoolean("materialPlan.IsMinBatchMethod")));
            this.putTable(result, "FMinBatchQty", rs.getBigDecimal("materialPlan.MinBatchQty"));
            this.putTable(result, "FIsRoundUpMultiple", DataImportTools.boolToString((boolean)rs.getBoolean("materialPlan.IsRoundUpMultiple")));
            this.putTable(result, "FRoundUpMulitpleQty", rs.getBigDecimal("materialPlan.roundUpMulitpleQty"));
            if (BatchPolicyPartitionTypeEnum.getEnum(rs.getInt("materialPlan.partitionType")) != null) {
                this.putTable(result, "FPartitionType", BatchPolicyPartitionTypeEnum.getEnum(rs.getInt("materialPlan.partitionType")).getAlias(ctx.getLocale()));
            } else {
                this.putTable(result, "FPartitionType", "");
            }
            this.putTable(result, "FPartitionDays", rs.getBigDecimal("materialPlan.partitionDays"));
            this.putTable(result, "FIsBatchIncMethod", DataImportTools.boolToString((boolean)rs.getBoolean("materialPlan.IsBatchIncMethod")));
            this.putTable(result, "FBatchIncQty", rs.getBigDecimal("materialPlan.BatchIncQty"));
            if (rs.getInt("materialPlan.OutputType") == 0) {
                this.putTable(result, "FOutputType", "");
            } else {
                this.putTable(result, "FOutputType", MaterialProductEnum.getEnum((int)rs.getInt("materialPlan.OutputType")).getAlias(ctx.getLocale()));
            }
            this.putTable(result, "FIsBackFlush", DataImportTools.boolToString((boolean)rs.getBoolean("materialPlan.IsBackFlush")));
            this.putTable(result, "FIsQuotaControl", DataImportTools.boolToString((boolean)rs.getBoolean("materialPlan.IsQuotaControl")));
            this.putTable(result, "FIssueLeadTime", rs.getString("materialPlan.issueLeadTime"));
            MaterialIssueModeEnum isModeEnum = MaterialIssueModeEnum.getEnum((int)rs.getInt("materialPlan.IssMode"));
            if (isModeEnum == null) {
                this.putTable(result, "FIssMode", "");
            } else {
                this.putTable(result, "FIssMode", isModeEnum.getAlias(ctx.getLocale()));
            }
            this.putTable(result, "FIsStorageLimit", DataImportTools.boolToString((boolean)rs.getBoolean("materialPlan.isStorageLimit")));
            this.putTable(result, "FIsReportingLimit", DataImportTools.boolToString((boolean)rs.getBoolean("materialPlan.isReportingLimit")));
            BigDecimal qty = null;
            qty = rs.getBigDecimal("materialPlan.ISSInHightLimit");
            this.putTable(result, "FISSInHightLimit", qty);
            qty = rs.getBigDecimal("materialPlan.ISSInLowLimit");
            this.putTable(result, "FISSInLowLimit", qty);
            qty = rs.getBigDecimal("materialPlan.RPTInHightLimit");
            this.putTable(result, "FRPTInHightLimit", qty);
            qty = rs.getBigDecimal("materialPlan.RPTInLowLimit");
            this.putTable(result, "FRPTInLowLimit", qty);
            this.putTable(result, "FRCVInHightLimit", rs.getBigDecimal("materialPlan.RCVInHightLimit"));
            qty = rs.getBigDecimal("materialPlan.RCVInLowLimit");
            this.putTable(result, "FRCVInLowLimit", qty);
            this.putTable(result, "FPlanner", rs.getString("planner.number"));
            this.putTable(result, "FFreezeOrgUnit", rs.getString("freezeOrgUnit.number"));
            this.putTable(result, "FCheck", DataImportTools.boolToString((boolean)rs.getBoolean("materialPlan.isCheck")));
            this.putTable(result, "FKeyPart", DataImportTools.boolToString((boolean)rs.getBoolean("materialPlan.isKeyPart")));
            this.putTable(result, "FFirstCheck", DataImportTools.boolToString((boolean)rs.getBoolean("materialPlan.isFirstCheck")));
            this.putTable(result, "FqualityOrg", rs.getString("qualityOrg.number"));
            if (ReplaceModeEnum.getEnum((int)rs.getInt("materialPlan.replaceMode")) != null) {
                this.putTable(result, "FRepalceMode", ReplaceModeEnum.getEnum((int)rs.getInt("materialPlan.replaceMode")).getAlias(ctx.getLocale()));
            } else {
                this.putTable(result, "FRepalceMode", "");
            }
            if (ThrowModeEnum.getEnum((int)rs.getInt("materialPlan.throwMode")) != null) {
                this.putTable(result, "FThrowMode", ThrowModeEnum.getEnum((int)rs.getInt("materialPlan.throwMode")).getAlias(ctx.getLocale()));
            } else {
                this.putTable(result, "FThrowMode", "");
            }
            this.putTable(result, "FProductLine", rs.getString("productLine.number"));
            this.putTable(result, "FRemainTimeNoPlan", rs.getString("materialPlan.remainTimeNoPlan"));
            this.putTable(result, "FTransferBatch", rs.getString("materialPlan.transferBatch"));
            this.putTable(result, "FPurOrg", rs.getString("purOrg.number"));
            this.putTable(result, "FProductTranType", rs.getString("productTranType.number"));
            this.putTable(result, "FChangeLeadTime", rs.getString("materialPlan.changeLeadTime"));
            this.putTable(result, "FChangeBatch", rs.getString("materialPlan.changeBatch"));
            this.putTable(result, "FIsComReqConsume", rs.getBoolean("materialPlan.isComReqConsume"));
        }
        catch (Exception e) {
            throw new TaskExternalException(ExceptionUtil.getExcLinkStackTrace((Throwable)e), (Throwable)e);
        }
        return result;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    private WarehouseInfo getWarehouseByNumber(Context ctx, String number, String storageOrgId) throws Exception {
        if (number == null || "".equals(number)) {
            return null;
        }
        if (storageOrgId == null || "".equals(storageOrgId)) {
            return null;
        }
        String key = storageOrgId + "&&" + number;
        Object result = this.cacheWarehouse.get(key);
        if (result == null) {
            result = this.getWarehouseInfo(ctx, number, storageOrgId);
            this.cacheWarehouse.put(key, result);
        }
        return (WarehouseInfo)result;
    }

    private WarehouseInfo getWarehouseInfo(Context ctx, String number, String storageOrgId) throws Exception {
        SQLUtil sb = new SQLUtil();
        sb.appendSql("select WAREHOUSE.FID warehouseID from T_DB_WAREHOUSE WAREHOUSE,T_DB_SOAccreditWH SOAccreditWH ");
        sb.appendSql(" where WAREHOUSE.FID = SOAccreditWH.FWarehouseID");
        sb.appendSql(" and WAREHOUSE.Fnumber = '").appendSql(number).appendSql("' ");
        sb.appendSql(" and SOAccreditWH.FStorageOrgID ='").appendSql(storageOrgId).appendSql("' ");
        ResultSet rs = sb.exeQuery(ctx);
        try {
            if (rs.next()) {
                WarehouseInfo warehouseInfo = new WarehouseInfo();
                BOSUuid id = BOSUuid.read((String)rs.getString("warehouseID"));
                warehouseInfo.setId(id);
                return warehouseInfo;
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        if (number != null && number.length() > 0) {
            throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"WarehouseNotExist", (Locale)ctx.getLocale()));
        }
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.material.app.DataImpExpPlanQuery";
    }

    public static RequirementUniteRuleInfo getRequirementUniteRuleInfoByNumber(Context ctx, StorageOrgUnitInfo org, String number) throws BOSException {
        RequirementUniteRuleInfo requirementUniteRuleInfo = null;
        if (org != null) {
            IRequirementUniteRule iRequirementUniteRule = RequirementUniteRuleFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)org.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20)));
            viewInfo.setFilter(filterInfo);
            RequirementUniteRuleCollection requirementUniteRuleCollection = iRequirementUniteRule.getRequirementUniteRuleCollection(viewInfo);
            if (requirementUniteRuleCollection != null && requirementUniteRuleCollection.size() > 0) {
                requirementUniteRuleInfo = requirementUniteRuleCollection.get(0);
            }
        }
        return requirementUniteRuleInfo;
    }

    public static ProductTransactionTypeInfo getProductTransactionTypeInfoByNumber(Context ctx, StorageOrgUnitInfo org, String number) throws BOSException {
        ProductTransactionTypeInfo info = null;
        if (org != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            filterInfo.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)"vGXRx5fFSsCYz9Zv7CzzgyQHQ1w=", CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20)));
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)org.getId().toString()));
            filterInfo.setMaskString("#0 AND #1 AND #2 AND #3");
            viewInfo.setFilter(filterInfo);
            IProductTransactionType productTransactionType = ProductTransactionTypeFactory.getLocalInstance((Context)ctx);
            ProductTransactionTypeCollection productTransactionTypeCollection = productTransactionType.getProductTransactionTypeCollection(viewInfo);
            if (productTransactionTypeCollection != null && productTransactionTypeCollection.size() > 0) {
                info = productTransactionTypeCollection.get(0);
            }
        }
        return info;
    }
}

