/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.BatchPolicyEnum;
import com.kingdee.eas.basedata.master.material.IManufactureStrategy;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.IMaterialPropertyBase;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyFactory;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialPropertyBaseInfo;
import com.kingdee.eas.basedata.master.material.MaterialUtil;
import com.kingdee.eas.basedata.master.material.PlanningModeEnum;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.AbstractMaterialPlanControllerBean;
import com.kingdee.eas.basedata.master.material.app.BatchPolicyDataCheck;
import com.kingdee.eas.basedata.master.material.app.MaterialControllerBean;
import com.kingdee.eas.basedata.master.material.app.MaterialSrvUtils;
import com.kingdee.eas.basedata.master.material.util.MaterialUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.IntEnum;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class MaterialPlanControllerBean
extends AbstractMaterialPlanControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.material.app.MaterialPlanControllerBean");
    public static String IS_USE_MARGIN_ID = "INhK3FkLTZOWv9kumNY6pO0ql5o=";
    public static String IS_USE_SCHEDULEPART_ID = "INhK3FkLTZOWv9kumNY6pO0ql5o=";

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaterialPlanInfo info = (MaterialPlanInfo)model;
        this.addNewcheck(ctx, info);
        info.put("MaterialNumber", MaterialSrvUtils.getMaterialLogInfo((Context)ctx, (String)info.getMaterial().getId().toString()));
        IObjectPK pk = super._addnew(ctx, model);
        this.handlePlanInvInfo(ctx, (CoreBaseInfo)info);
        return pk;
    }

    private void addNewcheck(Context ctx, MaterialPlanInfo infoVO) throws EASBizException, BOSException {
        this._checkOrgDup(ctx, (IObjectValue)infoVO);
        this.addAndUpdateVerity(ctx, infoVO);
        this.checkPlanner(ctx, infoVO);
    }

    private void checkPlanner(Context ctx, MaterialPlanInfo infoVO) throws EASBizException, BOSException {
        IOrgUnitRelation iUtilRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUtilRel.getToUnit(infoVO.getOrgUnit().getId().toString(), 4, 0);
        boolean isPlannerDepartment = false;
        if (infoVO.getPlanner() != null) {
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            AdminOrgUnitCollection adminOrgUnitCollection = iPerson.getAllAdminOrgUnit(infoVO.getPlanner().getId());
            for (int i = 0; i < adminOrgUnitCollection.size(); ++i) {
                AdminOrgUnitInfo adminOrg = adminOrgUnitCollection.get(i);
                for (int j = 0; j < orgCol.size(); ++j) {
                    AdminOrgUnitInfo orgInfo = (AdminOrgUnitInfo)orgCol.get(j);
                    if (!adminOrg.equalsPK((IObjectValue)orgInfo)) continue;
                    isPlannerDepartment = true;
                    break;
                }
                if (isPlannerDepartment) break;
            }
            if (!isPlannerDepartment) {
                throw new MaterialBaseException(MaterialBaseException.PLANNER_NOT_IN_DEP);
            }
        }
    }

    private void _checkOrgDup(Context ctx, IObjectValue model) throws MaterialBaseException, EASBizException, BOSException {
        MaterialPropertyBaseInfo info = (MaterialPropertyBaseInfo)model;
        String orgID = info.getOrgUnit().getId().toString();
        String materialID = info.getMaterial().getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID, CompareType.EQUALS));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.setMaskString("#0 and #1");
        }
        if (this.exists(ctx, filter)) {
            throw new MaterialBaseException(MaterialBaseException.PLAN_ORG_DUP);
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        MaterialPlanInfo oldInfo = this.getMaterialPlanInfo(ctx, pk);
        MaterialPlanInfo updateInfo = (MaterialPlanInfo)model;
        this.updateVerity(ctx, oldInfo, updateInfo);
        super._update(ctx, pk, model);
        this.handlePlanInvInfo(ctx, (CoreBaseInfo)updateInfo);
    }

    private void updateVerity(Context ctx, MaterialPlanInfo oldVO, MaterialPlanInfo updateVO) throws EASBizException, BOSException {
        this.addAndUpdateVerity(ctx, updateVO);
        this.checkCanUpdate(ctx, oldVO, updateVO);
        if (!(oldVO.getDutyDepartment() == null || updateVO.getDutyDepartment() == null || oldVO.getPlanner() == null || updateVO.getPlanner() == null || oldVO.getDutyDepartment().equalsPK((IObjectValue)updateVO.getDutyDepartment()) && oldVO.getPlanner().equalsPK((IObjectValue)updateVO.getPlanner()))) {
            this.checkPlanner(ctx, updateVO);
        }
    }

    protected CoreBaseInfo getInvInfo(Context ctx, MaterialPlanInfo planInfo) throws BOSException, EASBizException {
        IMaterialPropertyBase iMaterialPropertyBase = (IMaterialPropertyBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)"557E499F"));
        StringBuffer oql = new StringBuffer(100);
        oql.append("select * where material.id='").append(planInfo.getMaterial().getId().toString()).append("'");
        oql.append(" and orgunit.id='").append(planInfo.getOrgUnit().getId().toString()).append("'");
        CoreBaseInfo materialInvInfo = null;
        try {
            materialInvInfo = iMaterialPropertyBase.getValue(oql.toString());
        }
        catch (ObjectNotFoundException e) {
            materialInvInfo = null;
        }
        return materialInvInfo;
    }

    protected void handlePlanInvInfo(Context ctx, CoreBaseInfo planInfo) throws BOSException, EASBizException {
        this._handlePlanInvInfo(ctx, planInfo, this.getInvInfo(ctx, (MaterialPlanInfo)planInfo));
    }

    @Override
    protected void _handlePlanInvInfo(Context ctx, CoreBaseInfo planInfo, CoreBaseInfo invInfo) throws BOSException, EASBizException {
        this.checkPlanInvInfo(ctx, (MaterialPlanInfo)planInfo, invInfo);
        this.updateInvInfo(ctx, (MaterialPlanInfo)planInfo);
        this.updateInvInfo2(ctx, (MaterialPlanInfo)planInfo);
    }

    protected void updateInvInfo(Context ctx, MaterialPlanInfo info) throws BOSException, EASBizException {
        if (info == null || info.getPlanningMode() != PlanningModeEnum.REBOOKPOINT) {
            return;
        }
        SQLUtil sb = new SQLUtil();
        sb.appendSql(" update T_BD_MATERIALINVENTORY ");
        sb.appendSql(" set FPlanningMode = ").appendSql(this.intEnumToString((IntEnum)info.getPlanningMode()));
        if (info.getPlanningMode() == PlanningModeEnum.REBOOKPOINT) {
            sb.appendSql("    ,FBatchPolicy = ").appendSql(this.intEnumToString((IntEnum)info.getBatchPolicy()));
            if (info.getBatchPolicy() == BatchPolicyEnum.FIXATIONBATCH) {
                sb.appendSql("    ,FFixationBatchQty= ").appendSql(this.BigDecimalToString(info.getFixationBatchQty()));
            } else {
                sb.appendSql("    ,FFixationBatchQty = 0 ");
            }
            sb.appendSql("    ,FReBookQty= ").appendSql(this.BigDecimalToString(info.getReBookQty()));
            sb.appendSql("    ,FConsumeSpeed= ").appendSql(this.BigDecimalToString(info.getConsumeSpeed()));
            sb.appendSql("    ,FPurchasingAheadDate= ").appendSql(String.valueOf(info.getProduceLeadTime()));
        }
        sb.appendSql(" where FMaterialID='").appendSql(info.getMaterial().getId().toString()).appendSql("'");
        sb.appendSql("  and  FOrgUnit='").appendSql(info.getOrgUnit().getId().toString()).appendSql("'");
        sb.execute(ctx);
    }

    protected void updateInvInfo2(Context ctx, MaterialPlanInfo info) throws BOSException, EASBizException {
        if (info == null || info.getOrgUnit() == null) {
            return;
        }
        SQLUtil sb = new SQLUtil();
        sb.appendSql(" update T_BD_MATERIALINVENTORY ");
        if (info.getManufactureStrategy() != null) {
            String mfs = info.getManufactureStrategy().getNumber();
            if (mfs == null) {
                SelectorItemCollection seletors = new SelectorItemCollection();
                seletors.add(new SelectorItemInfo("number"));
                IManufactureStrategy iManufactureStrategy = ManufactureStrategyFactory.getLocalInstance((Context)ctx);
                ManufactureStrategyInfo manufactureStrategyInfo = (ManufactureStrategyInfo)iManufactureStrategy.getDataBaseInfo((IObjectPK)new ObjectUuidPK(info.getManufactureStrategy().getId()), seletors);
                mfs = manufactureStrategyInfo.getNumber();
            }
            IsolatedRuleEnum ir = info.getIsolatedRule();
            if (mfs.equals("MTO20") || mfs.equals("ATO20")) {
                sb.appendSql(" set FisTrackingNumber = 1 ,FisProjectNumber = 0");
            } else if (mfs.equals("ETO20") && ir.equals((Object)IsolatedRuleEnum.ITEM)) {
                sb.appendSql(" set FisTrackingNumber = 0 ,FisProjectNumber = 1 ");
            } else if (mfs.equals("ETO20") && ir.equals((Object)IsolatedRuleEnum.ITEM_TRACKNO)) {
                sb.appendSql(" set FisTrackingNumber = 1,FisProjectNumber = 1 ");
            } else {
                sb.appendSql(" set FisTrackingNumber = 0 ,FisProjectNumber = 0 ");
            }
        } else {
            sb.appendSql(" set FisTrackingNumber = 0 ,FisProjectNumber = 0 ");
        }
        if (sb.getSql().equalsIgnoreCase(" update T_BD_MATERIALINVENTORY ")) {
            return;
        }
        sb.appendSql(" where T_BD_MATERIALINVENTORY.FOrgUnit = '").appendSql(info.getOrgUnit().getId().toString()).appendSql("'");
        sb.appendSql(" and T_BD_MATERIALINVENTORY.FMaterialID='").appendSql(info.getMaterial().getId().toString()).appendSql("'");
        sb.execute(ctx);
    }

    private void checkPlanInvInfo(Context ctx, MaterialPlanInfo planInfo, CoreBaseInfo invInfo) throws BOSException, EASBizException {
        if (planInfo == null || invInfo == null) {
            return;
        }
        if (planInfo.getMaterialAttr() == MaterialAttributeEnum.OTHER && Boolean.valueOf(invInfo.getBoolean("isControl")).booleanValue()) {
            throw new MaterialBaseException(MaterialBaseException.PLAN_ATTR_INV_CONTROL);
        }
    }

    private String intEnumToString(IntEnum intEnum) {
        if (intEnum == null) {
            return "0";
        }
        return String.valueOf(intEnum.getValue());
    }

    private String BigDecimalToString(BigDecimal value) {
        if (value == null) {
            return "0";
        }
        if (value.compareTo(new BigDecimal(0)) == 0) {
            return "0";
        }
        return String.valueOf(value);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MaterialPlanInfo mpi = this.getMaterialPlanInfo(ctx, pk);
        if (mpi.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_APPROVED);
        }
        if (mpi.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        this.checkHasReference(ctx, pk);
        super._delete(ctx, pk);
    }

    private void checkHasReference(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        BizCheckResult rs = BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        if (rs.isFound()) {
            if (rs.getException() != null) {
                throw rs.getException();
            }
            if (rs.getDetailMap() != null) {
                throw new MaterialBaseException(MaterialBaseException.REF_NOT_DELETE_INV);
            }
        }
    }

    protected void _freeze(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialPlan iproperty = MaterialPlanFactory.getLocalInstance(ctx);
        MaterialPlanInfo info = iproperty.getMaterialPlanInfo(pk);
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU((Context)ctx, (String)info.getCU().getId().toString());
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTAPPROVE);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        info.setStatus(UsedStatusEnum.FREEZED);
        info.setFreezeOrgUnit(ContextUtil.getCurrentOrgUnit((Context)ctx).castToFullOrgUnitInfo());
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _unFreeze(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialPlan iproperty = MaterialPlanFactory.getLocalInstance(ctx);
        MaterialPlanInfo info = iproperty.getMaterialPlanInfo(pk);
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU((Context)ctx, (String)info.getCU().getId().toString());
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTAPPROVE);
        }
        if (info.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTFREEZED);
        }
        info.setStatus(UsedStatusEnum.APPROVED);
        info.setFreezeOrgUnit(null);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _approve(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MaterialPlanInfo info = this.getMaterialPlanInfo(ctx, pk);
        this._approve(ctx, info);
    }

    protected void _approve(Context ctx, MaterialPropertyBaseInfo info) throws BOSException, EASBizException {
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU((Context)ctx, (String)info.getCU().getId().toString());
        IMaterial ima = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialInfo mainfo = ima.getMaterialInfo((IObjectPK)new ObjectUuidPK(info.getMaterial().getId()));
        if (mainfo.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTAPPROVE);
        }
        if (mainfo.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.BASEINFO_FREEZED);
        }
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_APPROVED);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        MaterialUtil.checkMeasureUnit((MaterialInfo)mainfo, (MeasureUnitInfo)((MaterialPlanInfo)info).getProductUnit(), MaterialBaseException.class, (NumericExceptionSubItem)MaterialBaseException.UNIT_PRECISION_ERROR5, (Context)ctx);
        StringBuffer updatesql = new StringBuffer();
        Connection conn = null;
        Statement statement = null;
        try {
            conn = super.getConnection(ctx);
            statement = conn.createStatement();
            updatesql.append(" update T_BD_MaterialPlan set FStatus = ").append(String.valueOf(1)).append("  where fid = '").append(info.getId().toString()).append("'");
            statement.execute(updatesql.toString());
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + updatesql.toString(), (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)conn);
    }

    protected void _unApprove(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialPlan iproperty = MaterialPlanFactory.getLocalInstance(ctx);
        MaterialPlanInfo info = iproperty.getMaterialPlanInfo(pk);
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU((Context)ctx, (String)info.getCU().getId().toString());
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTAPPROVE);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        info.setStatus(UsedStatusEnum.UNAPPROVE);
        super._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _updateCheck(Context ctx, IObjectPK pk, MaterialPlanInfo newInfo) throws BOSException, EASBizException {
        String name = "";
        name = newInfo.getMaterial().getName(ctx.getLocale());
        if (newInfo.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.APPROVE_INVALID, new Object[]{name});
        }
        if (newInfo.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.FREEZED_INVALID, new Object[]{name});
        }
        MaterialPlanInfo oldInfo = this.getMaterialPlanInfo(ctx, pk);
        this.addAndUpdateVerity(ctx, newInfo);
        this.checkCanUpdate(ctx, oldInfo, newInfo);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MaterialPlanInfo info = this.getMaterialPlanInfo(ctx, pk, this.getSelectors());
        return info.getLogInfo();
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        return sic;
    }

    private void addAndUpdateVerity(Context ctx, MaterialPlanInfo infoVO) throws EASBizException, BOSException {
        infoVO.verify(ctx);
    }

    private void checkCanUpdate(Context ctx, MaterialPlanInfo oldVO, MaterialPlanInfo updateVO) throws EASBizException, BOSException {
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaterialPlanInfo info = (MaterialPlanInfo)model;
        BatchPolicyDataCheck.submitCheckBatchPolicy(info);
        if (info.getOrgUnit() != null && info.getOrgUnit().getCU() != null) {
            info.setCU(info.getOrgUnit().getCU());
        }
        return super._submit(ctx, model);
    }

    @Override
    protected MaterialPlanInfo _getPlanInfo(Context ctx, String matid, String ouid) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterinfo = MaterialControllerBean.getFilterOUMaterial((Context)ctx, (String)"orgUnit.id", (String)ouid, (String)"material.id", (String)matid);
        viewInfo.setFilter(filterinfo);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("productUnit.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("productUnit.name"));
        this.getPlanSelectors(viewInfo.getSelector());
        MaterialPlanCollection con = MaterialPlanFactory.getLocalInstance(ctx).getMaterialPlanCollection(viewInfo);
        if (con != null && con.size() >= 1) {
            for (int i = 0; i < con.size(); ++i) {
                MaterialPlanInfo info = con.get(i);
                if (!info.getOrgUnit().getId().toString().equals(ouid)) continue;
                return info;
            }
            return con.get(0);
        }
        MaterialPlanInfo info = null;
        return info;
    }

    private SelectorItemCollection getPlanSelectors(SelectorItemCollection sic) {
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("material.longNumber"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.shortName"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("freezeOrgUnit.name"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        return sic;
    }

    @Override
    protected boolean _isUseMargin(Context ctx) throws BOSException {
        boolean result = false;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID FROM T_BAS_PARAMITEM WHERE FID = '");
        sql.append(IS_USE_MARGIN_ID);
        sql.append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet.size() > 0) {
            result = true;
        }
        return result;
    }

    @Override
    protected boolean _isUseSchedulePart(Context ctx) throws BOSException {
        boolean result = false;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID FROM T_BAS_PARAMITEM WHERE FID = '");
        sql.append(IS_USE_SCHEDULEPART_ID);
        sql.append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet.size() > 0) {
            result = true;
        }
        return result;
    }
}

