/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CopyDataStatusEnum;
import com.kingdee.eas.basedata.master.cssp.UserParamInfo;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialUtil;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.framework.batchaction.BatchActionResults;

public class MaterialPlanCopyProcessor
extends AbstractBusinessProcessor {
    public MaterialPlanCopyProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        ApplicationContext ac = this.getExecuteContext().getApplicationContext();
        MaterialInfo newMaterial = (MaterialInfo)ac.getData("newMaterial");
        EntityViewInfo viewInfo = (EntityViewInfo)ac.getData("viewInfo");
        MeasureUnitInfo newBaseUnit = (MeasureUnitInfo)ac.getData("newBaseUnit");
        boolean isModify = ac.getData("isModify") == null ? false : (Boolean)ac.getData("isModify");
        UserParamInfo userParam = (UserParamInfo)ac.getData("userParam");
        IMaterialPlan iMaterialPlan = MaterialPlanFactory.getLocalInstance(this.ctx);
        MaterialPlanCollection materialPlanColl = iMaterialPlan.getMaterialPlanCollection(viewInfo);
        int size = materialPlanColl.size();
        MaterialPlanInfo materialPlanInfo = null;
        for (int index = 0; index < size; ++index) {
            materialPlanInfo = materialPlanColl.get(index);
            materialPlanInfo.setId(null);
            materialPlanInfo.setMaterial(newMaterial);
            materialPlanInfo.setCreator(newMaterial.getCreator());
            materialPlanInfo.setCreateTime(newMaterial.getCreateTime());
            materialPlanInfo.setLastUpdateUser(newMaterial.getLastUpdateUser());
            materialPlanInfo.setLastUpdateTime(newMaterial.getLastUpdateTime());
            if (isModify) {
                materialPlanInfo.setProductUnit(newBaseUnit);
            }
            CopyDataStatusEnum copyBaseDataStaus = userParam.getCopyPlanDataStaus();
            UsedStatusEnum destStatus = MaterialUtil.getMaterialCopyStatus((CopyDataStatusEnum)copyBaseDataStaus, (UsedStatusEnum)materialPlanInfo.getStatus());
            materialPlanInfo.setStatus(destStatus);
            if (!this.verifyStorageOrgUnit(this.ctx, materialPlanInfo.getSupplyOrgUnit(), 1)) continue;
            if (materialPlanInfo.getFromInvOrg() != null && materialPlanInfo.getFromInvOrg().getId() != null) {
                if (!this.verifyStorageOrgUnit(this.ctx, materialPlanInfo.getFromInvOrg(), 2)) continue;
                iMaterialPlan.addnew(materialPlanInfo);
                continue;
            }
            iMaterialPlan.addnew(materialPlanInfo);
        }
    }

    private boolean verifyStorageOrgUnit(Context ctx, StorageOrgUnitInfo storageOrgUnitInfo, int storageOrgUnitType) throws BOSException, EASBizException {
        boolean rsFlag = false;
        if (storageOrgUnitInfo != null && storageOrgUnitInfo.getId() != null) {
            IStorageOrgUnit iStorageOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)storageOrgUnitInfo.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
            viewInfo.setFilter(filterInfo);
            StorageOrgUnitCollection storageOrgUnitCollection = iStorageOrgUnit.getStorageOrgUnitCollection(viewInfo);
            if (storageOrgUnitCollection.size() > 0) {
                rsFlag = true;
            }
        }
        return rsFlag;
    }
}

