/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.eas.basedata.master.cssp.CSSPUtils;
import com.kingdee.eas.basedata.master.material.AbstractMaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.util.MaterialStringUtils;
import com.kingdee.eas.common.EASBizException;
import java.io.Serializable;
import java.math.BigDecimal;

public class MaterialPurchasingInfo
extends AbstractMaterialPurchasingInfo
implements Serializable {
    public MaterialPurchasingInfo() {
    }

    protected MaterialPurchasingInfo(String pkField) {
        super(pkField);
    }

    public String getLogInfo() {
        return this.getMaterial().getNumber() + "  " + this.getMaterial().getName();
    }

    public void verify() throws EASBizException, BOSException {
        this.verify(null);
    }

    public void verify(Context ctx) throws EASBizException, BOSException {
        if (this.getPrice() != null && this.getPrice().doubleValue() < 0.0 || this.getPriceTop() != null && this.getPriceTop().doubleValue() < 0.0 || this.getReceiveTopRatio() < 0 || this.getReceiveBottomRatio() < 0 || this.getDaydAhead() < 0 || this.getDaysDelay() < 0) {
            throw new MaterialBaseException(MaterialBaseException.MATPURRANGEVALID);
        }
        if (this.getPrice() != null && this.getPrice().doubleValue() >= 1.0E12) {
            throw new MaterialBaseException(MaterialBaseException.MATPURPRICEINVALID);
        }
        if (this.isIsPurchaseCheck() && this.getQualityOrg() == null) {
            String propName = CSSPUtils.getPropertyAlias((Context)ctx, (AbstractObjectValue)this, (String)"qualityOrg");
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{propName});
        }
        BigDecimal changePriceProportion = this.getChangePriceProportion();
        if (changePriceProportion != null) {
            if (changePriceProportion.compareTo(MaterialStringUtils.MINVAL_BigDecimal_ChangePriceProportion) == -1) {
                throw new MaterialBaseException(MaterialBaseException.MATREIALPURCHASING_CHANGEPRICEPROPORTION_MIN);
            }
            if (changePriceProportion.compareTo(MaterialStringUtils.MAXVAL_BigDecimal_ChangePriceProportion) > 0) {
                throw new MaterialBaseException(MaterialBaseException.MATREIALPURCHASING_CHANGEPRICEPROPORTION_MAX);
            }
            changePriceProportion = changePriceProportion.setScale(4, 4);
            this.setChangePriceProportion(changePriceProportion);
        }
    }
}

