/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialPurchasing;
import com.kingdee.eas.basedata.master.material.IQuotaPolicy;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.master.material.QuotaPeriodEnum;
import com.kingdee.eas.basedata.master.material.QuotaPolicyCollection;
import com.kingdee.eas.basedata.master.material.QuotaPolicyFactory;
import com.kingdee.eas.basedata.master.material.QuotaPolicyInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.master.material.util.MaterialStringUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.sm.pur.IPurchaseGroup;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupCollection;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupFactory;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.adv.chain.StringUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DataImportMaterialPurchasing
extends AbstractDataTransmission {
    private Set PerminsionCheckedCuIds = new HashSet();
    private static final String RES = "com.kingdee.eas.basedata.master.material.MaterialPurchasingResource";
    private boolean needUpdate = true;
    private Map<String, Boolean> userBizOrgRangeMap = new HashMap<String, Boolean>();
    private Set noCUPerminsionSet = new HashSet();
    Map cachePurchaseOrg = new HashMap();
    Map cachePurchaseGroup = new HashMap();
    Map cacheOrgUnit = new HashMap();
    Map cachePerson = new HashMap();
    Map cacheSupplier = new HashMap();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MaterialPurchasingFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else if (this.needUpdate) {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            return this.innerTransmit(hsData, ctx);
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private CoreBaseInfo innerTransmit(Hashtable hsData, Context ctx) throws TaskExternalException, Exception {
        String number;
        Object data = ((DataToken)hsData.get((Object)"FOrgUnit")).data;
        if (data == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"GetBizOrgUnitFailed", (Context)ctx));
        }
        PurchaseOrgUnitInfo purOrgUnit = this.getPurchaseOrgByNumber(ctx, data.toString());
        if (purOrgUnit == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"GetBizOrgUnitFailed", (Context)ctx));
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        boolean isUserBizOrgRange = false;
        if (this.userBizOrgRangeMap.containsKey(userId + purOrgUnit.getId().toString())) {
            isUserBizOrgRange = this.userBizOrgRangeMap.get(userId + purOrgUnit.getId().toString());
        } else {
            isUserBizOrgRange = PerminsionUtil.isUserBizOrgRange((Context)ctx, (String)userId, (String)purOrgUnit.getId().toString());
            this.userBizOrgRangeMap.put(userId + purOrgUnit.getId().toString(), isUserBizOrgRange);
        }
        if (!isUserBizOrgRange) {
            throw new TaskExternalException(new MaterialBaseException(MaterialBaseException.OUT_BIZ_ORG, new Object[]{purOrgUnit.getName()}).getMessage());
        }
        String CuId = purOrgUnit.getCU().getId().toString();
        if (!this.PerminsionCheckedCuIds.contains(CuId)) {
            try {
                PerminsionUtil.checkCUPerminsion((Context)ctx, (String)CuId, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), (String)"bd_materialPur_import");
            }
            catch (EASBizException ee) {
                throw new TaskExternalException(ee.getMessage(), (Throwable)ee);
            }
            this.PerminsionCheckedCuIds.add(CuId);
        }
        MaterialInfo materialInfo = DataImportTools.getMaterialInfo((Context)ctx, (CtrlUnitInfo)purOrgUnit.getCU(), (String)this.getDataString(hsData, "FNumber"));
        PurchaseGroupInfo purchaseGroupInfo = null;
        data = ((DataToken)hsData.get((Object)"FPurGroup")).data;
        if (data != null && (number = data.toString()) != null && !"".equals(number)) {
            purchaseGroupInfo = this.getPurGroupByNumber(ctx, data.toString());
            if (purchaseGroupInfo == null) {
                throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"PurGroupNumberIsNotExist", (Context)ctx));
            }
            if (!purchaseGroupInfo.getPurOrg().getId().toString().equals(purOrgUnit.getId().toString())) {
                throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"PurGroupNotInPurOrg", (Context)ctx));
            }
        }
        MaterialPurchasingInfo info = new MaterialPurchasingInfo();
        MaterialPurchasingInfo oldInfoClone = null;
        MaterialPurchasingInfo infoClone = null;
        if (this.isSltImportUpdate()) {
            FilterInfo filter = new FilterInfo();
            DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"orgUnit.id", (Object)purOrgUnit.getId().toString());
            DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"material.number", (Object)this.getDataString(hsData, "FNumber"));
            filter.setMaskString("#0 and #1");
            IMaterialPurchasing iProperty = MaterialPurchasingFactory.getLocalInstance(ctx);
            MaterialPurchasingCollection proCollection = iProperty.getMaterialPurchasingCollection(DataImportTools.getViewInfo((FilterInfo)filter));
            if (proCollection != null && proCollection.size() > 0) {
                oldInfoClone = proCollection.get(0);
                info.setId(proCollection.get(0).getId());
                info.setCU(proCollection.get(0).getCU());
            }
        }
        info.setMaterial(materialInfo);
        info.setOrgUnit(purOrgUnit.castToFullOrgUnitInfo());
        info.setCU(purOrgUnit.getCU());
        info.setPurGroup(purchaseGroupInfo);
        this.handleInfo(ctx, hsData, info, materialInfo.getId().toString());
        if (oldInfoClone != null) {
            infoClone = (MaterialPurchasingInfo)info.clone();
            this.excludeSomePorperties(infoClone, oldInfoClone);
            this.needUpdate = !ObjectValueUtil.objectValueEquals((Context)ctx, oldInfoClone, (AbstractObjectValue)infoClone);
        }
        return info;
    }

    private void excludeSomePorperties(MaterialPurchasingInfo infoClone, MaterialPurchasingInfo oldInfoClone) {
        infoClone.setCreator(null);
        infoClone.setCreateTime(null);
        infoClone.setLastUpdateUser(null);
        infoClone.setLastUpdateTime(null);
        oldInfoClone.setCreator(null);
        oldInfoClone.setCreateTime(null);
        oldInfoClone.setLastUpdateUser(null);
        oldInfoClone.setLastUpdateTime(null);
    }

    private PurchaseOrgUnitInfo getPurchaseOrgByNumber(Context ctx, String number) throws Exception {
        if (number == null || "".equals(number)) {
            return null;
        }
        Object result = this.cachePurchaseOrg.get(number);
        if (result == null) {
            result = DataImportTools.getPurchaseOrgUnitInfoFromNumber((Context)ctx, (String)number);
            this.cachePurchaseOrg.put(number, result);
        }
        return (PurchaseOrgUnitInfo)result;
    }

    private PurchaseGroupInfo getPurGroupByNumber(Context ctx, String number) throws Exception {
        if (number == null || "".equals(number)) {
            return null;
        }
        Object result = this.cachePurchaseGroup.get(number);
        if (result == null) {
            result = DataImportMaterialPurchasing.getPurGroupInfoFromNumber(ctx, number);
            this.cachePurchaseGroup.put(number, result);
        }
        return (PurchaseGroupInfo)result;
    }

    private OrgUnitInfo getOrgUnitByNumber(Context ctx, String number) throws TaskExternalException {
        if (number == null || "".equals(number)) {
            return null;
        }
        Object result = this.cacheOrgUnit.get(number);
        if (result == null) {
            result = DataImportTools.getOrgUnitInfo((Context)ctx, (String)number);
            this.cacheOrgUnit.put(number, result);
        }
        return (OrgUnitInfo)result;
    }

    private PersonInfo getPersonInfo(Context ctx, String number) throws Exception {
        if (number == null || number.equals("")) {
            return null;
        }
        Object result = this.cachePerson.get(number);
        if (result == null) {
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            PersonCollection personCollection = iPerson.getPersonCollection("where number = '" + number + "'");
            if (personCollection == null || personCollection.size() <= 0) {
                throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"DataImport_PurPerson_Error", (Locale)ctx.getLocale()));
            }
            result = personCollection.get(0);
            this.cachePerson.put(number, result);
        }
        return (PersonInfo)result;
    }

    private SupplierInfo getSupplierInfo(Context ctx, String number) throws Exception {
        if (number == null || number.equals("")) {
            return null;
        }
        Object result = this.cacheSupplier.get(number);
        if (result == null) {
            ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
            SupplierCollection supplierCollection = iSupplier.getSupplierCollection("where number = '" + number + "'");
            if (supplierCollection == null || supplierCollection.size() <= 0) {
                throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"DataImport_PurSupp_Error", (Locale)ctx.getLocale()));
            }
            result = supplierCollection.get(0);
            if (this.cacheSupplier.size() < 1000) {
                this.cacheSupplier.put(number, result);
            }
        }
        return (SupplierInfo)result;
    }

    private void handleInfo(Context ctx, Hashtable hsData, MaterialPurchasingInfo info, String materialID) throws TaskExternalException, Exception {
        BigDecimal bDec;
        String str;
        info.setPurPerson(this.getPersonInfo(ctx, this.getDataString(hsData, "FPurPerson")));
        info.setSupplier(this.getSupplierInfo(ctx, this.getDataString(hsData, "FSupplier")));
        info.setProducingArea(this.getDataString(hsData, "FProducingArea"));
        info.setProduceFactory(this.getDataString(hsData, "FProduceFactory"));
        info.setPurchaseStrategy(this.getDataString(hsData, "FPurchaseStrategy"));
        info.setUnit(DataImportTools.getMultiMeasureUnitInfo((Context)ctx, (String)this.getDataString(hsData, "FUnitID"), (String)materialID));
        if (info.getUnit() == null) {
            throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"DataImport_MeasureUnit_Error", (Locale)ctx.getLocale()));
        }
        info.setPrice(this.getDataBigDecimal(ctx, hsData, "FPrice"));
        info.setPriceTop(this.getDataBigDecimal(ctx, hsData, "FPriceTop"));
        info.setReceiveTopRatio(DataImportTools.getDataint((Hashtable)hsData, (String)"FReceiveTopRatio"));
        info.setReceiveBottomRatio(DataImportTools.getDataint((Hashtable)hsData, (String)"FReceiveBottomRatio"));
        info.setDaydAhead(DataImportTools.getDataint((Hashtable)hsData, (String)"FDaydAhead"));
        info.setDaysDelay(DataImportTools.getDataint((Hashtable)hsData, (String)"FDaysDelay"));
        info.setIsReturn(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsReturn"));
        info.setIsPurchaseCheck(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsPurchaseCheck"));
        info.setFineQualityFairPrice(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FFineQualityFairPrice"));
        info.setIsNotControlQty(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsNotControlQty", (boolean)false));
        info.setIsNotControlTime(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsNotControlTime", (boolean)false));
        if (info.isIsNotControlQty()) {
            info.setReceiveTopRatio(0);
            info.setReceiveBottomRatio(0);
        }
        if (info.isIsNotControlTime()) {
            info.setDaydAhead(0);
            info.setDaysDelay(0);
        }
        info.setUseSupplyList(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FUseSupplyList", (boolean)false));
        OrgUnitInfo purAppOU = this.getOrgUnitByNumber(ctx, this.getDataString(hsData, "FAppointPurOrgUnit"));
        if (purAppOU != null) {
            purAppOU = (PurchaseOrgUnitInfo)purAppOU.cast(PurchaseOrgUnitInfo.class);
            info.setAppointPurOrgUnit((PurchaseOrgUnitInfo)purAppOU);
        }
        QualityOrgUnitInfo qualityOrg = null;
        OrgUnitInfo ou = this.getOrgUnitByNumber(ctx, this.getDataString(hsData, "FqualityOrg"));
        if (ou != null) {
            if (!ou.isIsQualityOrgUnit()) {
                throw new TaskExternalException(this.getDataString(hsData, "FqualityOrg") + "," + ResourceBase.getString((String)"com.kingdee.eas.basedata.master.material.MATERIALAutoGenerateResource", (String)"4_DataImportMaterialInventory", (Locale)ctx.getLocale()));
            }
            qualityOrg = new QualityOrgUnitInfo();
            qualityOrg.setId(ou.getId());
        }
        info.setQualityOrg(qualityOrg);
        ou = this.getOrgUnitByNumber(ctx, this.getDataString(hsData, "FFreezeOrgUnit"));
        info.setStatus(DataImportTools.getStatusEnum((String)this.getDataString(hsData, "FStatus"), (Context)ctx));
        if (ou != null) {
            info.setFreezeOrgUnit(ou.castToFullOrgUnitInfo());
        } else if (info.getStatus() == UsedStatusEnum.FREEZED) {
            info.setFreezeOrgUnit(ContextUtil.getCurrentOrgUnit((Context)ctx).castToFullOrgUnitInfo());
        } else {
            info.setFreezeOrgUnit(null);
        }
        info.setEffectedStatus(2);
        BigDecimal changePriceProportion = null;
        String changePriceProportionStr = this.getDataString(hsData, "FChangePriceProportion");
        if (changePriceProportionStr != null && changePriceProportionStr.length() > 0) {
            changePriceProportion = new BigDecimal(changePriceProportionStr);
            if (changePriceProportion.compareTo(MaterialStringUtils.MINVAL_BigDecimal_ChangePriceProportion) == -1 || changePriceProportion.compareTo(MaterialStringUtils.MAXVAL_BigDecimal_ChangePriceProportion) > 0) {
                if (info.getId() == null) {
                    info.setChangePriceProportion(null);
                }
            } else {
                info.setChangePriceProportion(changePriceProportion);
            }
        } else {
            info.setChangePriceProportion(null);
        }
        if (StringUtil.isEmpty((String)(str = this.getDataString(hsData, "FQuotaPolicy")))) {
            throw new TaskExternalException(DataImportTools.getResString((String)RES, (String)"QuotaPolicyNotNull", (Locale)ctx.getLocale()));
        }
        info.setQuotaPolicy(this.getQuotaPolicyByName(ctx, str));
        try {
            bDec = this.getDataBigDecimalWithoutCatchException(ctx, hsData, "FMinDivisionQty");
        }
        catch (NumberFormatException e) {
            bDec = BigDecimal.ZERO;
        }
        if (bDec == null || BigDecimal.ZERO.compareTo(bDec) > 0) {
            bDec = BigDecimal.ZERO;
        }
        info.setMinDivisionQty(bDec);
        str = this.getDataString(hsData, "FQuotaPeriod");
        if ("002".equals(info.getQuotaPolicy().get("number"))) {
            if (StringUtil.isEmpty((String)str)) {
                throw new TaskExternalException(DataImportTools.getResString((String)RES, (String)"QuotaPeriodNotNullWhen002", (Locale)ctx.getLocale()));
            }
            info.setQuotaPeriod(this.getQuotaPeriodByName(ctx, str));
        } else {
            info.setQuotaPeriod(QuotaPeriodEnum.season);
        }
    }

    private String getDataString(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataString((Hashtable)hsData, (String)fieldName);
    }

    private BigDecimal getDataBigDecimal(Context ctx, Hashtable hsData, String fieldName) throws TaskExternalException {
        try {
            BigDecimal bd = DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)fieldName);
            return bd;
        }
        catch (NumberFormatException e) {
            throw new TaskExternalException(DataImportTools.getResString((String)RES, (String)"InvalidNumberFormat", (Locale)ctx.getLocale()));
        }
    }

    private BigDecimal getDataBigDecimalWithoutCatchException(Context ctx, Hashtable hsData, String fieldName) throws NumberFormatException {
        BigDecimal bd = DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)fieldName);
        return bd;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            String number = rs.getString("orgUnit.number");
            PurchaseOrgUnitInfo purOrgUnitInfo = this.getPurchaseOrgByNumber(ctx, number);
            String CuId = purOrgUnitInfo.getCU().getId().toString();
            if (!this.noCUPerminsionSet.contains(CuId) && !this.PerminsionCheckedCuIds.contains(CuId)) {
                this.PerminsionCheckedCuIds.add(CuId);
                try {
                    PerminsionUtil.checkCUPerminsion((Context)ctx, (String)CuId, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), (String)"bd_materialPur_export");
                }
                catch (EASBizException ee) {
                    this.noCUPerminsionSet.add(CuId);
                    throw new TaskExternalException(ee.getMessage(), (Throwable)ee);
                }
            }
            if (this.noCUPerminsionSet.contains(CuId)) {
                return result;
            }
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FMaterialName", rs.getString("name"));
            this.putTable(result, "FOrgUnit", rs.getString("orgUnit.number"));
            this.putTable(result, "FPurPerson", rs.getString("person.number"));
            this.putTable(result, "FSupplier", rs.getString("supplier.number"));
            this.putTable(result, "FProducingArea", rs.getString("Purchasing.producingArea"));
            this.putTable(result, "FProduceFactory", rs.getString("Purchasing.produceFactory"));
            this.putTable(result, "FPurchaseStrategy", rs.getString("Purchasing.purchaseStrategy"));
            this.putTable(result, "FUnitID", rs.getString("purUnit.number"));
            this.putTable(result, "FPrice", rs.getString("Purchasing.price"));
            this.putTable(result, "FPriceTop", rs.getString("Purchasing.priceTop"));
            this.putTable(result, "FReceiveTopRatio", rs.getString("Purchasing.receiveTopRatio"));
            this.putTable(result, "FReceiveBottomRatio", rs.getString("Purchasing.receiveBottomRatio"));
            this.putTable(result, "FDaydAhead", rs.getString("Purchasing.daydAhead"));
            this.putTable(result, "FDaysDelay", rs.getString("Purchasing.daysDelay"));
            this.putTable(result, "FIsReturn", DataImportTools.boolToString((boolean)rs.getBoolean("Purchasing.isReturn")));
            this.putTable(result, "FAppointPurOrgUnit", rs.getString("purOrgUnit.number"));
            this.putTable(result, "FIsPurchaseCheck", DataImportTools.boolToString((boolean)rs.getBoolean("Purchasing.isPurchaseCheck")));
            this.putTable(result, "FqualityOrg", rs.getString("qualityOrg.number"));
            this.putTable(result, "FFineQualityFairPrice", rs.getString("Purchasing.fineQualityFairPrice"));
            this.putTable(result, "FIsNotControlTime", DataImportTools.boolToString((boolean)rs.getBoolean("Purchasing.isNotControlTime")));
            this.putTable(result, "FIsNotControlQty", DataImportTools.boolToString((boolean)rs.getBoolean("Purchasing.isNotControlQty")));
            this.putTable(result, "FUseSupplyList", DataImportTools.boolToString((boolean)rs.getBoolean("Purchasing.useSupplyList")));
            this.putTable(result, "FFreezeOrgUnit", rs.getString("freezeOrgUnit.number"));
            this.putTable(result, "FStatus", UsedStatusEnum.getEnum((int)rs.getInt("Purchasing.status")).getAlias(ctx.getLocale()));
            this.putTable(result, "FPurGroup", rs.getString("purGroup.number"));
            this.putTable(result, "FChangePriceProportion", rs.getString("Purchasing.changePriceProportion"));
            this.putTable(result, "FQuotaPolicy", rs.getString("quotaPolicy.name"));
            this.putTable(result, "FMinDivisionQty", rs.getBigDecimal("AssitInfo.minDivisionQty"));
            this.putTable(result, "FQuotaPeriod", this.getQuotaPeriodString(rs.getInt("AssitInfo.quotaPeriod")));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        ObjectUuidPK pk = null;
        try {
            IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
            pk = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
            filterInfo = iMaterial.getDatabaseDFilter((IObjectPK)pk, "id", "adminCU.id");
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.material.app.DataImpExpPurQuery";
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    public static PurchaseGroupInfo getPurGroupInfoFromNumber(Context ctx, String number) throws BOSException {
        IPurchaseGroup iPurGroup;
        PurchaseGroupCollection collection;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("purOrg.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        PurchaseGroupInfo purGroupInfo = null;
        if (number != null && number.trim().length() > 0 && (collection = (iPurGroup = PurchaseGroupFactory.getLocalInstance((Context)ctx)).getPurchaseGroupCollection(viewInfo)) != null && collection.size() > 0) {
            purGroupInfo = collection.get(0);
        }
        return purGroupInfo;
    }

    private String getQuotaPeriodString(int value) {
        switch (value) {
            case 0: {
                return QuotaPeriodEnum.year.getAlias();
            }
            case 1: {
                return QuotaPeriodEnum.season.getAlias();
            }
            case 2: {
                return QuotaPeriodEnum.month.getAlias();
            }
        }
        return null;
    }

    private QuotaPeriodEnum getQuotaPeriodByName(Context ctx, String name) throws TaskExternalException {
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        QuotaPeriodEnum value = null;
        QuotaPeriodEnum temp = null;
        Iterator iter = QuotaPeriodEnum.iterator();
        while (iter.hasNext()) {
            temp = (QuotaPeriodEnum)((Object)iter.next());
            if (!name.equals(temp.getAlias())) continue;
            value = temp;
            break;
        }
        if (value == null) {
            throw new TaskExternalException(DataImportTools.getResString((String)RES, (String)"invalidQuotaPeriodImportData", (Locale)ctx.getLocale()));
        }
        return value;
    }

    private QuotaPolicyInfo getQuotaPolicyByName(Context ctx, String name) throws TaskExternalException {
        QuotaPolicyInfo info = null;
        try {
            IQuotaPolicy iqp = QuotaPolicyFactory.getLocalInstance(ctx);
            QuotaPolicyCollection qpc = iqp.getQuotaPolicyCollection("where name='" + name + "'");
            if (qpc == null || qpc.size() <= 0) {
                throw new TaskExternalException(DataImportTools.getResString((String)RES, (String)"invalidQuotaPolicyImportData", (Locale)ctx.getLocale()));
            }
            info = qpc.get(0);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
        return info;
    }
}

