/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.IMaterialPurchasing;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.app.AbstractMaterialBatchUpdateStrategy;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MaterialPurchaseBatchUpdateStrategy
extends AbstractMaterialBatchUpdateStrategy {
    protected void validate(Context ctx, Object[] pks, Map params) throws BOSException, EASBizException {
        int i;
        String unitId = this.getUnitId(params);
        List list = (List)params.get("orgIdList");
        if (StringUtils.isEmpty((String)unitId) && null == list) {
            throw new MaterialBaseException(MaterialBaseException.ORG_NOTNULL_PUR);
        }
        HashSet<String> orgIdSet = new HashSet<String>();
        if (list != null && list.size() > 0) {
            for (Object obj : list) {
                orgIdSet.add(String.valueOf(obj));
            }
        } else {
            orgIdSet.add(unitId);
        }
        if (this.properties == null || this.properties.length == 0 || pks.length == 0) {
            return;
        }
        String[] propertiesToCheck = new String[]{"producingArea", "produceFactory", "purchaseStrategy"};
        this.checkLength(this.properties, propertiesToCheck, 80);
        HashSet<String> pkset = new HashSet<String>(0);
        for (int j = 0; j < pks.length; ++j) {
            String pk = (String)pks[j];
            pkset.add(pk.trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", pkset, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", orgIdSet, CompareType.INCLUDE));
        filter.setMaskString("#0 and #1");
        view.setFilter(filter);
        view.getSelector().add("*");
        view.getSelector().add(new SelectorItemInfo("material.number"));
        view.getSelector().add(new SelectorItemInfo("material.name"));
        IMaterialPurchasing ie = MaterialPurchasingFactory.getLocalInstance(ctx);
        MaterialPurchasingCollection ls = ie.getMaterialPurchasingCollection(view);
        ArrayList<String> materialCom = new ArrayList<String>();
        for (i = 0; i < ls.size(); ++i) {
            materialCom.add(ls.get(i).getMaterial().getId().toString());
        }
        this._checkHasSubInfo(ctx, materialCom, pks, MaterialBaseException.MATERIAL_NO_SUCH_PURINFO);
        if (ls != null && ls.size() != 0) {
            for (i = 0; i < ls.size(); ++i) {
                MaterialPurchasingInfo info = ls.get(i);
                this.setInfoNewValue((CoreBaseInfo)info, this.values, this.properties, params);
                try {
                    ie.updateCheck((IObjectPK)new ObjectStringPK(info.getId().toString()), info);
                    this.checkIsNotControl(info, this.properties);
                    this.uptIdList.add(info.getId().toString());
                    continue;
                }
                catch (Exception ex) {
                    MaterialBaseException mex = new MaterialBaseException(MaterialBaseException.MATERIAL_BATCH_FAILD, (Object[])new String[]{info.getMaterial().getNumber()});
                    this.log.addException(mex.getMessage(), (Throwable)ex);
                }
            }
        }
        ls = null;
    }

    protected void checkLength(Object[] properties, String[] propertiesToCheck, int length) throws MaterialBaseException {
        if (this.isCheckLengthError(propertiesToCheck, length)) {
            throw new MaterialBaseException(MaterialBaseException.VALUETOOLARGE);
        }
    }

    protected void checkIsNotControl(MaterialPurchasingInfo info, Object[] fields) throws MaterialBaseException {
        if (fields == null || fields.length <= 0) {
            return;
        }
        String field = null;
        boolean isNotControlQty = info.isIsNotControlQty();
        boolean isNotControlTime = info.isIsNotControlTime();
        int size = fields.length;
        for (int i = 0; i < size; ++i) {
            field = fields[i].toString();
            if (isNotControlQty && ("receiveTopRatio".equalsIgnoreCase(field) || "receiveBottomRatio".equalsIgnoreCase(field))) {
                throw new MaterialBaseException(MaterialBaseException.MATER_PUR_NOTCTRLQTY);
            }
            if (!isNotControlTime || !"daydAhead".equalsIgnoreCase(field) && !"daysDelay".equalsIgnoreCase(field)) continue;
            throw new MaterialBaseException(MaterialBaseException.MATER_PUR_NOTCTRLTIME);
        }
    }
}

